// functions shared between the 3 version of MVStringEditor

// REMIND: is this ok; was window.
mvIgnoreFocus = false;


// Optionally the mved can show an order button
// This method is called when the order button is pressed.
function mvShowOrderDlg(mvse)
{
   if(mvse.m_disabled==true)
   {
      alert(rc_widgeDisabled);
      return;
   }

   var items = getValuesAsArray(mvse);
   var packList = pack(items);

   var leftPos = (screen.availWidth-350)/2;
   var topPos =  (screen.availHeight-265)/3;
   var url = "webacc?taskId=dev.Empty&merge=fw.MVStringEditorOrderDlg&mved="+mvse.m_name + "&pack=" + packList;
   window.open(url,"","HEIGHT=320,WIDTH=350,resizable,scrollbars,left="+leftPos+",top="+topPos);
}

// Uses rules to check if val is a valid value for this mved
// Should always be called before adding a value to the list
function mvIsValidValue(mvse, val)
{
   if((typeof val != "string") || (val.length < 1))
   {
      mvMessage(mvse, window.rc_noEmptyValues);
      return false;
   }

	if(mvse.m_numbersOnly==true && isNaN(Number(val)))
	{
		mvMessage(mvse, window.rc_onlyNumbersAllowed);
		return false;
	}

   if(!isNaN(mvse.m_upperBound) && !isNaN(mvse.m_lowerBound))
   {
      mvse.m_ignoreBlur = true;
      var isValid = validateInteger(val, mvse.m_lowerBound, mvse.m_upperBound);
      mvse.m_ignoreBlur = false;

      if(!isValid) return false;
   }

   if(!isNaN(mvse.m_minLength) && !isNaN(mvse.m_maxLength))
   {
      mvse.m_ignoreBlur = true;
      var isValid = validateLength(val, mvse.m_minLength, mvse.m_maxLength);
      mvse.m_ignoreBlur = false;

      if(!isValid) return false;
   }

   if(mvse.m_regExpression != null)
   {
      var matches = val.match(mvse.m_regExpression);
      if(matches == null || matches[0]!=val)
      {
         mvMessage(mvse, mvse.m_regExpressionMsg);
         return false;
      }
   }

   return true;
}

// Shows an error message to the user.
// Has special blur handling for IE
function mvMessage(mvse, s)
{
   mvse.m_ignoreBlur = true;
   alert(s);
   mvse.m_ignoreBlur = false;
}

// compares to strings; handles ignorecase
function mvStrcmp(s1, s2, ignoreCase)
{
   return (ignoreCase ? s1.toLowerCase()==s2.toLowerCase() : s1==s2);
}


// public api - returns the values in the mved as array
function mvGetValuesAsArray(name)
{
   var mvse=eval("window.mv"+name);
   return getValuesAsArray(mvse);
}

// private - returns the values in the mved as array
function getValuesAsArray(mvse)
{
   if(mvse.m_mode=="mvie")
      return mvse.m_list;
   else if(mvse.m_mode=="mvtxt")
      return getMvtxt(mvse.m_name)
   else if(mvse.m_mode == "mvsel")
   {
      var opts = mvse.m_sel.options;
      var list = new Array();
      for(var i=0; i<opts.length; i++){
         //alert(opts[i].value.length);
         list[i] = mvedtrim.trim(opts[i].value);
      }
      return list;
   }
   else alert("Invalid MVStringEditor");
}

// returns the number of items in the list
function mvGetValueCount(name)
{
   var mvse=eval("window.mv"+name);
   var list = getValuesAsArray(mvse);
   return list.length;
}

// This is called to test if an item is valid; A option on the mved is to force unique entries
// pass selectedRow:-1 when not in edit mode
function mvIsDuplicate(mvse, val, selectedRow)
{
   if(mvse.m_hash && mvse.m_hash!=null)
   {
      var key = (mvse.m_ignoreCase ? val.toLowerCase() : val);
      return (mvse.m_hash[key] == 1);
   }
   else
   {
      var list = getValuesAsArray(mvse);

       for(var i=0; i<list.length; i++)
       {
          var isDuplicate = mvStrcmp(val, list[i], mvse.m_ignoreCase);
          if(isDuplicate && (!mvse.m_isEditing || selectedRow!=i))
          {
             if(mvse.m_mode=="mvie")
               mvse.m_tb.value="";
             alert(window.rc_uniqueMsg);
             return true;
          }
       }
       return false;
    }
}

// public api - creates xml for the values
function mvGetValuesAsXml(name)
{
   var mvse=eval("window.mv"+name);
   var list = getValuesAsArray(mvse);
   var mode = eval("document.forms[0]." + name + "_mode");
   var modeStr = (mode ? " mode='" + mode.value + "'" : "");

   var str = "<mvstring" + modeStr + ">";
   for(var i=0; i<list.length; i++)
      str += "<value>" + xmlEncode(list[i]) + "</value>";
   str += "</mvstring>";
   return str;
}

// public api - returns the items as a packed string
function mvGetValuesAsPack(name)
{
   var mvse = eval("window.mv" + name);
   var list = getValuesAsArray(mvse);
   return pack(list);
}

// public api
function mvFocus(name)
{
   var mvse = eval("window.mv" + name);
   if(mvse.m_mode=="mvie")
   {
      window.mvIgnoreFocus = oreFocus = true;
      document.getElementById(name+"FocusImage").focus();
   }
   else if(mvse.m_mode == "mvsel")
      mvse.m_sel.focus();
}

// public api - Sets the values from a packed string
function mvLoadFromPack(name, pack)
{
   var mvse = eval("window.mv"+name);
   eval(mvse.m_mode + "LoadFromPack(name, pack)");
}

// public api - loads the values from XML
function mvLoadFromXml(name, xml)
{
   var mvse = eval("window.mv"+name);
   eval(mvse.m_mode + "LoadFromXml(name, xml)");
}

// public api - allows the user to add/remove/edit the list
function mvEnable(name)
{
   var mvse = eval("window.mv"+name);
   eval(mvse.m_mode + "Enable(name)");
}

// public api - disallows the user to add/remove/edit the list
function mvDisable(name)
{
   var mvse = eval("window.mv"+name);
   eval(mvse.m_mode + "Disable(name)");
}

// Callback called by ObjectSelector to see if browse allowed
function mvIsOSAllowed(controlName)
{
   var mvse = eval("window.mv" + controlName);

   if(mvse.m_disabled)
   {
      alert(rc_widgeDisabled);
   }

   return !mvse.m_disabled;
}

// shouldn't be in this file.
function initMooMode(name, xmlStr)
{
   if(xmlStr==null || xmlStr.length<1)
      return;

   // set mode
   var modeControl = eval("document.forms[0]." + name + "_mode");
   var s = xmlStr.indexOf("mode='");
   if(modeControl && s!=-1)
   {
      s+=6;
      var e = xmlStr.indexOf("'", s);
      var mode = xmlStr.substring(s,e);

      var i=0;
      if(mode=="set") i=1;
      else if(mode=="add") i=2;
      else if(mode=="remove") i=3;
      modeControl.selectedIndex = i;
   }
}

// If the developer has registered to be notified when
// this list changes, invoke the callback method
function mvCallOnChange(mvse)
{
   if(typeof mvse.m_onChangeCallback == "function")
   {
      mvse.m_onChangeCallback(mvse.m_name);
   }
}

// public api - programtically add value to the list
function mvAddValue(name, value)
{
   var mvse = eval("window.mv"+name);

   if(mvse.m_mode=="mvie")
   {
      mvieAddValueAtFirst(mvse, value);
      mvse.m_tb.focus();
   }
   else if(mvse.m_mode=="mvtxt")
   {
      var l=getMvtxt(name);
      if(value && value.length>0)
         l[l.length] = value;
      setMvtxt(name,l);
      mvtxtUpdateTextbox(name);
   }
   else if(mvse.m_mode == "mvsel")
   {
      mvselAdd(mvse,value);
   }
   else alert("Invalid MVStringEditor");
}

function toggleTooltip(tipID)
{
	tObject = document.getElementById(tipID+"_tooltip");
	selObject = document.getElementById("mvid_"+tipID);
	if(tObject.style.display.toLowerCase() == "block")
	{
		closeTooltip(tipID);
	}
	else
	{
		openTooltip(tipID);
	}
}

function closeTooltip(tipID)
{
	tObject = document.getElementById(tipID+"_tooltip");
	selObject = document.getElementById("mvid_"+tipID);
	tObject.style.display = "none";
	selObject.style.display = "block";
}

function openTooltip(tipID)
{
	tObject = document.getElementById(tipID+"_tooltip");
	selObject = document.getElementById("mvid_"+tipID);
	tObject.style.display = "block";
	selObject.style.display = "none";
}

var mvedtrim = new mvedtrim();
function mvedtrim()
{
   //remove leading spaces from a string
   function trimLeft(s)
   {
      if (s==null || s.length==0) {return "";}
      var i = 0;
      while (i<s.length && s.charAt(i)==" ") {i++;}
      if (i==s.length) {return s;}
      s = s.substr(i);
      return s;
   }
   
   //remove trailing spaces from a string
   function trimRight(s)
   {
      if (s==null || s.length==0) {return "";}
      var i = s.length-1;
      while (i>-1 && s.charAt(i)==" ") {i--;}
      s = ((i==-1)?"":s.substr(0,i+1)); 
      return s;
   }
   
   //remove leading and trailing spaces from a string
    function trim(s)
   {
      if (s==null || s.length==0) {return "";}
      var t = s;
      s = trimLeft(s);
      s = trimRight(s);
      if(t.length>0 && s.length==0)
      	return t;
      else      
        return s;
   }
   
   this.trimLeft = trimLeft;
   this.trimRight = trimRight;
   this.trim = trim;
}

