


function validateWholeIntegerField(field, lowerBound, upperBound)
{
   var success = validateIntegerField(field, lowerBound, upperBound);
   if(success)
   {
      return validateNumericString(field, window.rc_mustBeWholeNumber)
   }
   else
   {
      return false;
   }
}


// if no lowerBound or upperBound, will still verify is number
function validateInteger(intStr, lowerBound, upperBound)
{
   // allow textfields to be empty
   if(intStr=="")
   {
      return true;
   }

   var val = Number(intStr);
   var top = (typeof upperBound == "number" ? upperBound : 99999999999);
   var bottom = (typeof lowerBound == "number" ? lowerBound : -99999999999);

   if (intStr == "")
   {
      alert(formatMessage(window.rc_invalidNumberMsg, [bottom, top]));
      return false;
   }

   if(isNaN(val) || val>top || val<bottom)
   {
      alert(formatMessage(window.rc_invalidNumberMsg, [bottom, top]));
      return false;
   }

   return true;
}

function validateIntegerField(field, low, high)
{
   if(!validateInteger(field.value, low, high))
   {
      field.focus();
      field.value=low;
      return false;
   }
   return true;
}

function validateNumericString(field, msg)
{
   var val = field.value;
   var valid = "0123456789 "

   for (var i=0; i<val.length; i++)
   {
      temp = "" + val.substring(i, i+1);
      if(valid.indexOf(temp)=="-1")
      {
         alert(msg);
         field.value = val.substring(0, i);
         field.focus();
         field.select();
         return false;
      }
   }
   return true;
}


function validateASN1IDString(field, msg)
{
   var val = field.value;
   var valid = "0123456789."

   for (var i=0; i<val.length; i++)
   {
      temp = "" + val.substring(i, i+1);
      if(valid.indexOf(temp)=="-1")
      {
         alert(msg);
         field.value = val.substring(0, i);
         field.focus();
         field.select();
         return false;
      }
   }
   return true;
}


function validateLength(val, low, high)
{
   // allow textfields to be empty
   if(val=="")
   {
      return true;
   }

   if(val.length<low || val.length>high)
   {
      if (low == high)
      {
         if (low != null)
         {
            alert(formatMessage(window.rc_invalidExactStringLengthMsg, [low] ));
         }
         else
         {
            return true;
         }
      }
      else
      {
         alert(formatMessage(window.rc_invalidStringLengthMsg, [low,high] ));
      }
      return false;
   }
   return true;
}

function validateLengthField(field, low, high)
{
   return validateLength(field.value, low, high);
}
