<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="Portal.ResourcePath" select="/PortalData/SessionInfo/WebAppInfo/ResourcePath"/>
   <xsl:variable name="Portal.Servlet.Normal" select="/PortalData/SessionInfo/WebAppInfo/Servlets/Normal"/>

	<xsl:template name="NetworkAddressScripts">
	   <SCRIPT language="JavaScript" src="/nps/javascripts/dev/MVNetworkAddr.js"></SCRIPT>
	   <SCRIPT language="JavaScript" src="/nps/javascripts/dev/ValidateHex.js"></SCRIPT>
   </xsl:template>









	<xsl:template name="MVNetworkAddressEditor">
	   <xsl:param name="MVNetworkAddressEditor.formName">forms[0]</xsl:param>
	   <xsl:param name="MVNetworkAddressEditor.width">{$dev.UI.textboxPixel} - 2}</xsl:param>
	   <xsl:param name="MVNetworkAddressEditor.bgColor">white</xsl:param>
	   <xsl:param name="MVNetworkAddressEditor.mode"/>
	   <xsl:param name="MVNetworkAddressEditor.horizontal"/>
	   <xsl:param name="MVNetworkAddressEditor.readonly"/>
      <xsl:param name="MVNetworkAddressEditor.name"/>

		  <TABLE bgcolor="{$MVNetworkAddressEditor.bgColor}">
			  <TR>
				  <TD>
					  <xsl:when test="$MVNetworkAddressEditor.mode='SINGLE'">
						  <select name="{$MVNetworkAddressEditor.name}" width="{$MVNetworkAddressEditor.width}" height="200" style="width:{$MVNetworkAddressEditor.width}" size="{$MVNetworkAddressEditor.width}"></select>
					  </xsl:when>

					  <xsl:otherwise>
						  <xsl:when test="$MVNetworkAddressEditor.readonly='true'">
							  <input type="text" name="{$MVNetworkAddressEditor.name}" width="{$MVNetworkAddressEditor.width}" height="200" style="width:{$MVNetworkAddressEditor.width}" DISABLED/>
						  </xsl:when>
						  <xsl:otherwise>
							  <input type="text" name="{$MVNetworkAddressEditor.name}" width="{$MVNetworkAddressEditor.width}" height="200" style="width:{$MVNetworkAddressEditor.width}"/>
						  </xsl:otherwise>
					  </xsl:otherwise>
				  </TD>

				  <xsl:when test="$MVNetworkAddressEditor.readonly!='true'">
				     <TD valign="top">
						  <xsl:when test="$MVNetworkAddressEditor.mode!='SINGLE'">
							  <a href="javascript:AddAddress('document.{$MVNetworkAddressEditor.formName}.{$MVNetworkAddressEditor.name}');"><img src="/nps/portal/modules/dev/images/iconadd.gif" border="0"/></a>
						  </xsl:when>
						  <xsl:otherwise>
							  <a href="javascript:AddAddress('document.{$MVNetworkAddressEditor.formName}.{$MVNetworkAddressEditor.name}');"><img src="/nps/portal/modules/dev/images/iconedit.gif" border="0"/></a>
						  </xsl:otherwise>

						  <xsl:when test="$MVNetworkAddressEditor.horizontal=''">
					  </TD>
					  <TD valign="top">
					     </xsl:when>
						  <xsl:when test="$MVNetworkAddressEditor.mode!='SINGLE'">
							  <a href="javascript:MVNetRemove(document.{$MVNetworkAddressEditor.formName}.{$MVNetworkAddressEditor.name});"><img src="/nps/portal/modules/dev/images/iconremove.gif" border="0"/></a>
						  </xsl:when>
					  </TD>
				  </xsl:when>
			  </TR>
		  </TABLE>
   </xsl:template>









	<xsl:template name="NetworkAddress">
		  <HTML>
		  <HEAD>
		  <TITLE>{$fw.NetworkAddrUiHandleName}</TITLE>
		  <link rel='stylesheet' href='/nps/portal/modules/dev/hf_style.css'>
		  <xsl:call-template name="eMFrameScripts"/>
		  <xsl:call-template name="ValidateIntegerScripts"/>

		  <SCRIPT LANGUAGE="JavaScript">

		  // globals
		  var addressString = null;

		  function showAddr(sel)
		  {
			  toggleDivAddr('IPXDiv', 'none');
			  toggleDivAddr('IPDiv', 'none');
			  toggleDivAddr('SDLCDiv', 'none');
			  toggleDivAddr('ETHDiv', 'none');
			  toggleDivAddr('OSIDiv', 'none');
			  toggleDivAddr('APPLEDiv', 'none');
			  toggleDivAddr('UDPDiv', 'none');
			  toggleDivAddr('TCPDiv', 'none');

			  if (sel.selectedIndex == 0)
			  {
				  toggleDivAddr('IPXDiv', 'block');
			  }
			  else if (sel.selectedIndex == 1)
			  {
				  toggleDivAddr('IPDiv', 'block');
			  }
			  else if (sel.selectedIndex == 2)
			  {
				  toggleDivAddr('SDLCDiv', 'block');
			  }
			  else if (sel.selectedIndex == 3)
			  {
				  toggleDivAddr('ETHDiv', 'block');
			  }
			  else if (sel.selectedIndex == 4)
			  {
				  toggleDivAddr('OSIDiv', 'block');
			  }
			  else if (sel.selectedIndex == 5)
			  {
				  toggleDivAddr('APPLEDiv', 'block');
			  }
			  else if (sel.selectedIndex == 6)
			  {
				  toggleDivAddr('UDPDiv', 'block');
			  }
			  else if (sel.selectedIndex == 7)
			  {
				  toggleDivAddr('TCPDiv', 'block');
			  }
		  }

		  function toggleDivAddr(id, hideOrShow)
		  {
			  var el = getElementStyle(id);
			  el.display = hideOrShow;
		  }

		  function buildTheAddress(sel)
		  {
			  if (sel.selectedIndex == 0)
			  {
				  addressString = buildIPX();
			  }
			  else if (sel.selectedIndex == 1)
			  {
				  addressString = buildIP();
			  }
			  else if (sel.selectedIndex == 2)
			  {
				  addressString = buildSDLC();
			  }
			  else if (sel.selectedIndex == 3)
			  {
				  addressString = buildETH();
			  }
			  else if (sel.selectedIndex == 4)
			  {
				  addressString = buildOSI();
			  }
			  else if (sel.selectedIndex == 5)
			  {
				  addressString = buildAPPLE();
			  }
			  else if (sel.selectedIndex == 6)
			  {
				  addressString = buildUDP();
			  }
			  else if (sel.selectedIndex == 7)
			  {
				  addressString = buildTCP();
			  }

		  }

		  function setFocusToFormElement()
		  {
			  document.addrform.selbox.options[0].focus();
		  }

		  function addStringAndClose(sel)
		  {
			  buildTheAddress(sel);
		  ->	top.opener.MVNetAdd('{VAR control}', addressString);
			  window.close();
		  }


		  function pad(control, length)
		  {
				var value = control.value;
			  var tmpone = "";
			  for (var i= 0; i < (length - value.length); i++)
			  {
				  tmpone += "0";
			  }
			  tmpone = tmpone + value;
			  control.value = tmpone;
		  }

		  function buildIPX()
		  {
			  if (document.addrform.IPXfield1.value == "")
			  {
				  pad(document.addrform.IPXfield1, 8);
			  }
			  if (document.addrform.IPXfield2.value == "")
			  {
				  pad(document.addrform.IPXfield2, 12);
			  }
			  if (document.addrform.IPXfield3.value == "")
			  {
				  pad(document.addrform.IPXfield3, 4);
			  }
			  var addr = " IPX:" + document.addrform.IPXfield1.value + ":" + document.addrform.IPXfield2.value + ":" + document.addrform.IPXfield3.value;
			  return addr;
		  }

		  function buildIP()
		  {
			  if (document.addrform.IPfield1.value == "")
			  {
				  pad(document.addrform.IPfield1, 1);
			  }
			  if (document.addrform.IPfield2.value == "")
			  {
				  pad(document.addrform.IPfield2, 1);
			  }
			  if (document.addrform.IPfield3.value == "")
			  {
				  pad(document.addrform.IPfield3, 1);
			  }
			  if (document.addrform.IPfield4.value == "")
			  {
				  pad(document.addrform.IPfield4, 1);
			  }
			  var addr = "IP: " + document.addrform.IPfield1.value + "." + document.addrform.IPfield2.value + "." + document.addrform.IPfield3.value + "." + document.addrform.IPfield4.value;
			  return addr;
		  }

		  function buildSDLC()
		  {
			  if (document.addrform.SDLCfield1.value == "")
			  {
				  pad(document.addrform.SDLCfield1, 1);
			  }
			  if (document.addrform.SDLCfield2.value == "")
			  {
				  pad(document.addrform.SDLCfield2, 1);
			  }
			  if (document.addrform.SDLCfield3.value == "")
			  {
				  pad(document.addrform.SDLCfield3, 1);
			  }
			  var addr = "SDLC: " + document.addrform.SDLCfield1.value + ":" + document.addrform.SDLCfield2.value + ":" + document.addrform.SDLCfield3.value;
			  return addr;
		  }

		  function buildETH()
		  {
			  if (document.addrform.ETHfield1.value == "")
			  {
				  pad(document.addrform.ETHfield1, 1);
			  }
			  if (document.addrform.ETHfield2.value == "")
			  {
				  pad(document.addrform.ETHfield2, 1);
			  }
			  if (document.addrform.ETHfield3.value == "")
			  {
				  pad(document.addrform.ETHfield3, 1);
			  }
			  var addr = "ETHERNET/TOKENRING: " + document.addrform.ETHfield1.value + ":" + document.addrform.ETHfield2.value + ":" + document.addrform.ETHfield3.value;
			  return addr;
		  }

		  function buildOSI()
		  {
			  if (document.addrform.OSIfield1.value == "")
			  {
				  pad(document.addrform.OSIfield1, 1);
			  }
			  var addr = "OSI: " + document.addrform.OSIfield1.value;
			  return addr;
		  }

		  function buildAPPLE()
		  {
			  if (document.addrform.APPLEfield1.value == "")
			  {
				  pad(document.addrform.APPLEfield1, 4);
			  }
			  if (document.addrform.APPLEfield2.value == "")
			  {
				  pad(document.addrform.APPLEfield2, 4);
			  }
			  if (document.addrform.APPLEfield3.value == "")
			  {
				  pad(document.addrform.APPLEfield3, 12);
			  }
			  var tmp = document.addrform.HType.selectedIndex + 3;
			  var type = "";
			  type += "0" + tmp;

			  var addr = "APPLETALK: " + "03" + document.addrform.APPLEfield1.value + document.addrform.APPLEfield2.value + type + "06" + document.addrform.APPLEfield3.value;
			  return addr;
		  }
		  function buildUDP()
		  {
			  if (document.addrform.UDPfield0.value == "")
			  {
				  pad(document.addrform.UDPfield0, 1);
			  }
			  if (document.addrform.UDPfield1.value == "")
			  {
				  pad(document.addrform.UDPfield1, 1);
			  }
			  if (document.addrform.UDPfield2.value == "")
			  {
				  pad(document.addrform.UDPfield2, 1);
			  }
			  if (document.addrform.UDPfield3.value == "")
			  {
				  pad(document.addrform.UDPfield3, 1);
			  }
			  if (document.addrform.UDPfield4.value == "")
			  {
				  pad(document.addrform.UDPfield4, 1);
			  }
			  var addr = "UDP: " + document.addrform.UDPfield1.value + "." + document.addrform.UDPfield2.value + "." + document.addrform.UDPfield3.value + "." + document.addrform.UDPfield4.value + ":" + document.addrform.UDPfield0.value;
			  return addr;
		  }

		  function buildTCP()
		  {
			  if (document.addrform.TCPfield0.value == "")
			  {
				  pad(document.addrform.TCPfield0, 1);
			  }
			  if (document.addrform.TCPfield1.value == "")
			  {
				  pad(document.addrform.TCPfield1, 1);
			  }
			  if (document.addrform.TCPfield2.value == "")
			  {
				  pad(document.addrform.TCPfield2, 1);
			  }
			  if (document.addrform.TCPfield3.value == "")
			  {
				  pad(document.addrform.TCPfield3, 1);
			  }
			  if (document.addrform.TCPfield4.value == "")
			  {
				  pad(document.addrform.TCPfield4, 1);
			  }
			  var addr = "TCP: " + document.addrform.TCPfield1.value + "." + document.addrform.TCPfield2.value + "." + document.addrform.TCPfield3.value + "." + document.addrform.TCPfield4.value + ":" + document.addrform.TCPfield0.value;
			  return addr;
		  }

		  </SCRIPT>
		  </HEAD>

		  <BODY TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" bgcolor="#FFFFFF" onLoad="setFocusToFormElement();">
		  <table width="90%" border="0" cellspacing="0" cellpadding="3">
			 <tr>
				<td width="96%" height="13" class="head3b">{$fw.NetAddrUIHandler.NetworkAddress}</td>
			 </tr>
		  </table>
		  <br>

		  <left>
		  <form name="addrform"  method="post" action="{$Portal.Servlet.Normal}" onSubmit= >
		  	  <INPUT type="hidden" name="NPService" value="{../@id}"/>
			  <input type="hidden" name="merge" value="dev.GenConf"/>
			  <input type="hidden" name="error" value="dev.GenErr"/>
		     <input type="hidden" name="addressString" value=""/>
			  <input type="hidden" name="control" value=""/>
			  <br/>
			  <table cellspacing="0" cellpadding="2" border="0">
			  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.Addresstype}</td></tr>
			  <tr><td class="mediumtext">
				  <select name="selbox" size="1" onChange='showAddr(this.form.selbox);'>
					  <option class="mediumtext" value="IPX">IPX
					  <option class="mediumtext" value="IP">IP
					  <option class="mediumtext" value="SDLC">SDLC
					  <option class="mediumtext" value="Ethernet/Tokenring">Ethernet/Tokenring
					  <option class="mediumtext" value="OSI">OSI
					  <option class="mediumtext" value="AppleTalk">AppleTalk
					  <option class="mediumtext" value="UDP">UDP
					  <option class="mediumtext" value="TCP">TCP
				  </select>
			  </td></tr>
			  </table>
		  <div align="left" id="IPXDiv" style="background-color: White; margin-top: 45; text-indent: 20; display:block; width:470; height:220;" title="{$fw.NetAddrUIHandler.IPXNetworkAddress}">
			  <table cellspacing="0" cellpadding="2" border="0">
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.Network4bytes}</td></tr>
				  <tr><td><input type="text" name="IPXfield1" value="" size="{$dev.UI.textboxSize}" maxlength='8' onChange='pad(this.form.IPXfield1, 8); validateHex(this.form.IPXfield1, "{$fw.UIHandler.OnlyHex}");'></td></tr>
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.Node6bytes}</td></tr>
				  <tr><td><input type="text" name="IPXfield2" value="" size="{$dev.UI.textboxSize}" maxlength='12' onChange='pad(this.form.IPXfield2, 12); validateHex(this.form.IPXfield2, "{$fw.UIHandler.OnlyHex}");'></td></tr>
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.Socket2bytes}</td></tr>
				  <tr><td><input type="text" name="IPXfield3" value="" size="{$dev.UI.textboxSize}" maxlength='4' onChange='pad(this.form.IPXfield3, 4); validateHex(this.form.IPXfield3, "{$fw.UIHandler.OnlyHex}");'></td></tr>
			  </table>
		  </div>

		  <div align="left" id="IPDiv" style="background-color: White; margin-top: 45; text-indent: 20; display:none; width:470; height:220;" title="{$fw.NetAddrUIHandler.IPNetworkAddress}">
			  <table cellspacing="0" cellpadding="2" border="0">
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.IPaddress}</td></tr>
				  <tr><td><input type="text" name="IPfield1" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.IPfield1, 0, 255);'>&nbsp;.&nbsp;<input type="text" name="IPfield2" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.IPfield2, 0, 255);'>&nbsp;.&nbsp;<input type="text" name="IPfield3" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.IPfield3, 0, 255);'>&nbsp;.&nbsp;<input type="text" name="IPfield4" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.IPfield4, 0, 255);'></td></tr>
			  </table>
		  </div>

		  <div align="left" id="SDLCDiv" style="background-color: White; margin-top: 45; text-indent: 20; display:none; width:470; height:220;" title="{$fw.NetAddrUIHandler.SDLCNetworkAddress}">
			  <table cellspacing="0" cellpadding="2" border="0">
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.CUA2bytes}</td></tr>
				  <tr><td><input type="text" name="SDLCfield1" value="" size="{$dev.UI.textboxSize}" maxlength='4' onChange='pad(this.form.SDLCfield1, 4); validateHex(this.form.SDLCfield1, "{$fw.UIHandler.OnlyHex}");'></td></tr>
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.BlockID3bytes}</td></tr>
				  <tr><td><input type="text" name="SDLCfield2" value="" size="{$dev.UI.textboxSize}" maxlength='6' onChange='pad(this.form.SDLCfield2, 6); validateHex(this.form.SDLCfield2, "{$fw.UIHandler.OnlyHex}");'></td></tr>
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.PUID5bytes}</td></tr>
				  <tr><td><input type="text" name="SDLCfield3" value="" size="{$dev.UI.textboxSize}" maxlength='10' onChange='pad(this.form.SDLCfield3, 10); validateHex(this.form.SDLCfield3, "{$fw.UIHandler.OnlyHex}");'></td></tr>
			  </table>
		  </div>

		  <div align="left" id="ETHDiv" style="background-color: White; margin-top: 45; text-indent: 20; display:none; width:470; height:220;" title="{$fw.NetAddrUIHandler.EthernetTokenRingNetworkAddress}">
			  <table cellspacing="0" cellpadding="2" border="0">
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.SAP2bytes}</td></tr>
				  <tr><td><input type="text" name="ETHfield1" value="" size="{$dev.UI.textboxSize}" maxlength='4' onChange='pad(this.form.ETHfield1, 4); validateHex(this.form.ETHfield1, "{$fw.UIHandler.OnlyHex}");'></td></tr>
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.BlockID3bytes}</td></tr>
				  <tr><td><input type="text" name="ETHfield2" value="" size="{$dev.UI.textboxSize}" maxlength='6' onChange='pad(this.form.ETHfield2, 6); validateHex(this.form.ETHfield2, "{$fw.UIHandler.OnlyHex}");'></td></tr>
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.PUID5bytes}</td></tr>
				  <tr><td><input type="text" name="ETHfield3" value="" size="{$dev.UI.textboxSize}" maxlength='10' onChange='pad(this.form.ETHfield3, 10); validateHex(this.form.ETHfield3, "{$fw.UIHandler.OnlyHex}");'></td></tr>
			  </table>
		  </div>

		  <div align="left" id="OSIDiv" style="background-color: White; margin-top: 45; text-indent: 20; display:none; width:470; height:220;" title="{$fw.NetAddrUIHandler.OSINetworkAddress}">
			  <table cellspacing="0" cellpadding="2" border="0">
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.HEXaddress}</td></tr>
				  <tr><td><input type="text" name="OSIfield1" value="" size="50" maxlength='256' onChange='validateHex(this.form.OSIfield1, "{$fw.UIHandler.OnlyHex}");'></td></tr>
			  </table>
		  </div>

		  <div align="left" id="APPLEDiv" style="background-color: White; margin-top: 45; text-indent: 20; display:none; width:470; height:220;" title="{$fw.NetAddrUIHandler.AppleTalkNetworkAddress}">
			  <table cellspacing="0" cellpadding="2" border="0">
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.Networkbegin}</td></tr>
				  <tr><td><input type="text" name="APPLEfield1" value="" size="{$dev.UI.textboxSize}" maxlength='5' onChange='validateIntegerField(this.form.APPLEfield1, 0, 65535); this.form.APPLEfield1.value=convertDecToHex(this.form.APPLEfield1.value); pad(this.form.APPLEfield1, 4);'><BR></td></tr>
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.Networkend}</td></tr>
				  <tr><td><input type="text" name="APPLEfield2" value="" size="{$dev.UI.textboxSize}" maxlength='5' onChange='validateIntegerField(this.form.APPLEfield2, 0, 65535); this.form.APPLEfield2.value=convertDecToHex(this.form.APPLEfield2.value); pad(this.form.APPLEfield2, 4);'><BR></td></tr>
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.Hardwareaddress}</td></tr>
				  <tr><td><input type="text" name="APPLEfield3" value="" size="{$dev.UI.textboxSize}" maxlength='12' onChange='validateHex(this.form.APPLEfield3, "{$fw.UIHandler.OnlyHex}"); pad(this.form.APPLEfield3, 12);'><BR></td></tr>
				  <tr><td class="mediumtext">{$fw.NetAddrUIHandler.Hardwaretype}</td></tr>
				  <tr><td>
					  <select name="HType" size="1">
						  <option align="left" class="mediumtext" value="Type3" SELECTED>{$fw.NetAddrUIHandler.Type3}</option>
						  <option align="left" class="mediumtext" value="Type4">{$fw.NetAddrUIHandler.Type4}</option>
						  <option align="left" class="mediumtext" value="Type5">{$fw.NetAddrUIHandler.Type5}</option>
						  <option align="left" class="mediumtext" value="Type6">{$fw.NetAddrUIHandler.Type6}</option>
					  </select></td>
				  </tr>
			  </table>
		  </div>

		  <div align="left" id="UDPDiv" style="background-color: White; margin-top: 45; text-indent: 20; display:none; width:470; height:220;" title="{$fw.NetAddrUIHandler.UDPNetworkAddress}">
			  <table cellspacing="0" cellpadding="2" border="0">
				  <tr>
					  <td class="mediumtext">{$fw.NetAddrUIHandler.Portnumber}</td><tr><td><input type="text" name="UDPfield0" value="" size="5" maxlength='5' onChange='validateIntegerField(this.form.UDPfield0, 0, 65535);'></td>
				  </tr>
				  <tr>
					  <td class="mediumtext">{$fw.NetAddrUIHandler.IPaddress}</td><tr><td><input type="text" name="UDPfield1" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.UDPfield1, 0, 255);'>&nbsp;.&nbsp;<input type="text" name="UDPfield2" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.UDPfield2, 0, 255);'>&nbsp;.&nbsp;<input type="text" name="UDPfield3" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.UDPfield3, 0, 255);'>&nbsp;.&nbsp;<input type="text" name="UDPfield4" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.UDPfield4, 0, 255);'></td>
				  </tr>
			  </table>
		  </div>

		  <div align="left" id="TCPDiv" style="background-color: White; margin-top: 45; text-indent: 20; display:none; width:470; height:220;" title="{$fw.NetAddrUIHandler.TCPNetworkAddress}">
			  <table cellspacing="0" cellpadding="2" border="0">
				  <tr>
					  <td class="mediumtext">{$fw.NetAddrUIHandler.Portnumber}</td><tr><td><input type="text" name="TCPfield0" value="" size="5" maxlength='5' onChange='validateIntegerField(this.form.TCPfield0, 0, 65535);'></td>
				  </tr>
				  <tr>
					  <td class="mediumtext">{$fw.NetAddrUIHandler.IPaddress}</td><tr><td><input type="text" name="TCPfield1" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.TCPfield1, 0, 255);'>&nbsp;.&nbsp;<input type="text" name="TCPfield2" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.TCPfield2, 0, 255);'>&nbsp;.&nbsp;<input type="text" name="TCPfield3" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.TCPfield3, 0, 255);'>&nbsp;.&nbsp;<input type="text" name="TCPfield4" value="" size="5" maxlength='3' onChange='validateIntegerField(this.form.TCPfield4, 0, 255);'><BR></td>
				  </tr>
			  </table>
		  </div>

		  <xsl:call-template name="Bar"/>
		  <a href="#" onClick="javascript:addStringAndClose(addrform.selbox);return false">
		  <img src="/nps/portal/modules/dev/images/{$dev.Button.Add.image}" alt="{$dev.Button.Add.alt}" title="{$dev.Button.Add.alt}" border="0"></a>
		  &nbsp;
		  <a href="#" onClick="javascript:	window.close();return false">
		  <img src="/nps/portal/modules/dev/images/{$dev.Button.Cancel.image}" alt="{$dev.Button.Cancel.alt}" title="{$dev.Button.Cancel.alt}" border="0"></a>

		  </form>
		  </left>
		  </BODY>
		  </HTML>

	</xsl:template>

</xsl:stylesheet>