<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   
   <xsl:template name="OS">
      <xsl:param name="OS.Control" />
      <xsl:param name="OS.CallBack" />
      <xsl:param name="OS.AdvancedSelection" />
      <xsl:param name="OS.AdvSelCriteria" />
      <xsl:param name="OS.AdvSelCriteriaCallBack" />
      <xsl:param name="OS.InitialContext" />
      <xsl:param name="OS.IsOSAllowed" />
      <xsl:param name="OS.Mode" />
      <xsl:param name="OS.MultiSelect" />
      <xsl:param name="OS.NameFilter" />
      <xsl:param name="OS.ResultsPerPage" />
      <xsl:param name="OS.SearchSubContainers" />
      <xsl:param name="OS.SearchOnStartup" />
      <xsl:param name="OS.ShowSubClasses" />
      <xsl:param name="OS.TypeFilter" />
      <xsl:param name="OS.TypeFilterCallBack" />
      <xsl:param name="OS.AltText"></xsl:param>
      <xsl:param name="OS.IconName"></xsl:param>
      <xsl:param name="OS.History">false</xsl:param>
   
   <!-- browser os button code (xsl) -->
   <!-- String altTitle = ( (c.var("OS.AltText").length()==0) ? c.toDisplay(c.string("Button.OS.alt")) : c.toDisplay(c.var("OS.AltText")) );
        String src = c.getModulesUrl() + ( (c.var("OS.IconName").length()==0) ? "/dev/images/" + c.toDisplay(c.string("Button.OS.image")) : "/" + c.toDisplay(c.var("OS.IconName")) );-->
      <xsl:variable name="altTitle">
         <xsl:choose>
            <xsl:when test="string-length(OS.AltText)=0">
               <xsl:value-of select="$dev.Button.OS.alt"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$OS.AltText"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      
      <xsl:variable name="src">
         <xsl:value-of select="$Portal.ResourcePath"/>/modules<xsl:text></xsl:text>
         <xsl:choose>
            <xsl:when test="string-length(OS.IconName)=0">/dev/images/<xsl:value-of select="$dev.Button.OS.image"/>
            </xsl:when>
            <xsl:otherwise>/<xsl:value-of select="$OS.IconName"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      
      <!--<a href="#" onClick="javascript:doOS('browser','<%= c.toDisplay(c.toScript(c.var("OS.Control"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.CallBack"))) %>','<%= c.var("OS.AdvancedSelection") %>','<%= c.toDisplay(c.toScript(c.var("OS.InitialContext"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.IsOSAllowed"))) %>','<%= c.var("OS.Mode") %>','<%= c.var("OS.MultiSelect") %>','<%= c.toDisplay(c.toScript(c.var("OS.NameFilter"))) %>','<%= c.var("OS.ResultsPerPage") %>','<%= c.var("OS.SearchSubContainers") %>','<%= c.var("OS.SearchOnStartup") %>','<%= c.var("OS.ShowSubClasses") %>','<%= c.toDisplay(c.toScript(c.var("OS.TypeFilter"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.TypeFilterCallBack"))) %>'); return false">
      <img alt="<%= altTitle %>" title="<%= altTitle %>" src="<%= src %>" border=0 align="absmiddle" ></a>-->
      <xsl:text> </xsl:text><a href="#" onClick="javascript:doOS('browser-xsl', '{$OS.Control}', '{$OS.CallBack}', '{$OS.AdvancedSelection}','{$OS.AdvSelCriteria}','{$OS.AdvSelCriteriaCallBack}', '{$OS.InitialContext}', '{$OS.IsOSAllowed}', '{$OS.Mode}', '{$OS.MultiSelect}', '{$OS.NameFilter}', '{$OS.ResultsPerPage}', '{$OS.SearchSubContainers}', '{$OS.SearchOnStartup}', '{$OS.ShowSubClasses}', '{$OS.TypeFilter}', '{$OS.TypeFilterCallBack}');return false">
      <img alt="{$altTitle}" title="{$altTitle}" src="{$src}" border="0" align="absmiddle" /></a>
      <!-- end browser os button code (xsl) -->
      
      <!-- browser history button code (xsl) -->
      <xsl:variable name="hsrc">
         <xsl:value-of select="$Portal.ResourcePath"/>/modules/dev/images/<xsl:value-of select="$dev.Button.Hist.image"/>
      </xsl:variable>
      
      <xsl:if test="$OS.History='true'">
         <!--<a href="#" onClick="javascript:doHist(this,'<%= c.toDisplay(c.toScript(c.var("OS.Control"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.TypeFilter"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.CallBack"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.IsOSAllowed"))) %>'); return false">
         <img alt="<%= c.string("Button.Hist.alt") %>" title="<%= c.string("Button.Hist.alt") %>" src="<%= c.getModulesUrl() %>/dev/images/<%= c.string("Button.Hist.image") %>" border=0 align="absmiddle" ></a>-->
         <xsl:text> </xsl:text><a href="#" onClick="javascript:doHist(this,'{$OS.Control}','{$OS.TypeFilter}','{$OS.CallBack}','{$OS.IsOSAllowed}'); return false">
         <img alt="{$dev.Button.Hist.alt}" title="{$dev.Button.Hist.alt}" src="{$hsrc}" border="0" align="absmiddle" /></a>
         <IFRAME src="/nps/Empty.html" style="visibility: hidden" name="exchangerFrame" id="exchangerFrame" width="0" height="0" marginwidth="0" marginheight="0"></IFRAME>
      </xsl:if>
      <!-- end browser history button code (xsl) -->
      
   </xsl:template>

</xsl:stylesheet>