   // This file contains PRIVATE functions that implement the dynamic GUI in the Object Selector widget.
   // They are not intended for use by anyone else and are subject to change without notice.
   
   //------------ getType functions -----------------
   
   //returns a string with all types (enabled, disabled, advanced, simple)
   function getAllAvailableTypes()
   {
      var ret="";
      for (var i=0; i<m_types.length; i++)
      {
         if (m_types[i][1]!=null)
         {
            ret = addType(ret,m_types[i][1]);
         }
      }
      for (var i=0; i<m_pseudoTypes.length; i++)
      {
         if (m_pseudoTypes[i][1]!=null)
         {
            ret = addType(ret,m_pseudoTypes[i][1]);
         }
      }
      //alert("getAllAvailableTypes: ret="+ret);    
      return ret;
   }
   
   function getSelectedTypes(bAdvanced)
   {
      var ret="";
      for (var i=0; i<m_types.length; i++)
      {
         if (m_types[i][0] && m_types[i][1]!=null)
         {
            //type is enabled
            //add all enabled types if not in advanced mode
            //or all enabled types that no not have advance criterion in advanced mode
            if ( (!bAdvanced) || 
                 (bAdvanced && (m_types[i][2]==null || m_types[i][2].length==0)) )
            {
               //add type to list
               ret = addType(ret,m_types[i][1]);
            }
         }
      }
      for (var i=0; i<m_pseudoTypes.length; i++)
      {
         if (m_pseudoTypes[i][0] && m_pseudoTypes[i][1]!=null)
         {
            ret = addType(ret,m_pseudoTypes[i][1]);
         }
      }
      //alert("getSelectedTypes: ret="+ret);    
      return ret;
   }
   
   function addType(s,type)
   {
      if (s==null) s="";
      if (type!=null)
      {
         if (s.length>0)
         {
            s+=( (type.charAt(0)==",") ? ",," : ",");
         }
         s+=type;
      }
      return s;
   }
   
   //------------ doSearch functions ----------------
   function doSearch()
   {
      if (isAdvSelMode()) 
      {
         self.Query.doAdvancedSearch();
      }
      else 
      {
         self.Query.doGenericSearch();
      }
   }
   
   //------------ process Next/Previous button click -------
   function processDisplayCountKeyPress(keyCode, nextEnabled, prevEnabled)
   {
      if (keyCode==13)   //enter key?
      {
         try
         {
            if (nextEnabled)        self.ResultButtons.document.Next.click();                 //click next button
            else if (prevEnabled)   self.ResultButtons.document.Previous.click();             //click previous button
            else                    self.Query.document.getElementById("doSearch").click();   //click apply/search button
         }
         catch (e)
         {
         }
      }
   }
   
   function refreshTV(strURL)
   {
   		iman.debug("m_mode="+m_mode);
   		if(m_mode=="tree")
   		{
   			iman.debug("window.name="+window.name);
   			top.Mainscreen.Content.refreshTVC(strURL);
//   			alert("Refreshing Window");
   		}else{
   			iman.debug("not refreshing since m_mode !=tree");
   		}
   			
   }
   
   function processResultsButton(strURL)
   {
      processDisplayCountChange();

      //update Results frame   
      var strHTML = '<input type=hidden name="Search.ContextId" value="'+toTag(self.m_searchContextId)+'">\n';
      var strRPP = '&OV.ResultsPerPage='+m_resultsPerPage;
      //alert("processResultsButton: strURL="+strURL);
      //alert("processResultsButton: strHTML="+strHTML);
      self.ResultButtons.document.PostData.action=strURL+strRPP;
      self.ResultButtons.document.getElementById("FormData").innerHTML = strHTML;
      self.ResultButtons.document.PostData.target="Results";
      if(MS55){
       var resultsFrameDoc=self.frames['Results'].document;
//       var formInResultsFrame = resultsFrameDoc.createElement('<FORM ID=\"SearchForm\" action=\"'+strURL+strRPP+'\" />');
       var formInResultsFrame = resultsFrameDoc.forms('PostData');
       formInResultsFrame.action=strURL+strRPP;
       //resultsFrameDoc.body.appendChild(formInResultsFrame);
       formInResultsFrame.innerHTML = strHTML;
       //alert(resultsFrameDoc.body.forms[0]);
       formInResultsFrame.submit();
      }else{
       self.ResultButtons.document.PostData.submit();
      }
   }
   
   function processDisplayCountChange()
   {
      try
      {
         var adjusted=false;
         var cnt = self.ResultButtons.document.getElementById("ResultsPerPage").value;
         if (cnt == null || cnt.length==0) return;
         else if (cnt<1) { adjusted=true; cnt=1; }
         else if (cnt>500) {adjusted=true; cnt=500;}
         if (adjusted) self.ResultButtons.document.getElementById("ResultsPerPage").value=cnt;
         m_resultsPerPage=cnt;
      }
      catch (e)
      {
      }
   }
   
   //------------ Advanced Selection ----------------
   function doMyAS(type)
   {
      AS=new Object();
      AS.types=type;
      AS.controlCallBack="saveCriterion";
      AS.initialCriterionCallBack="getCriterion";
      doDynamicAS(m_userContext,AS);
   }
  
   function getCriterion(typeName)
   {
      var ret="";
      if (typeName!=null && typeName.length>0)
      {
         var i = getTypeIdx(typeName);
         if (i!=-1)
         {
            ret=m_types[i][2];    //return type criterion
         }
      }
      return ret;
   }
    
   function saveCriterion(controlName, typeNames, xmlCriterion)
   {
      //alert("saveCriterion: \ncontrolName="+controlName+"\ntypeNames="+typeNames+"\ncriterion="+xmlCriterion);
      //convert comma-separated name into array and call saveCriterionArray()
      var types = iman.commaSplit(typeNames);
      saveCriterionArray(types, xmlCriterion);
   }
   
   function saveCriterionArray(types, xmlCriterion)
   {
      var typeName = types[0];  //only user first type for now
      //alert("saveCriterionArray: types = "+types+" typeof "+typeof types+"\ntypeName = "+typeName+"\nxmlCriterion = ["+xmlCriterion+"]");
      if (typeName!=null && typeName.length>0)
      {
         if (xmlCriterion==null || xmlCriterion.length==0)
         {
            //clear criterion for this type
            clearCriterion(typeName);
         }
         else
         {
            //remember criterion for this type
            var i = getTypeIdx(typeName);
            if (i!=-1)
            {
               //save criterion
               //alert("setting criterion for "+typeName+"["+i+"] = "+xmlCriterion);
               m_types[i][2] = xmlCriterion;
               setAdvSelMode('true');
               
               //update GUI
               configureTypeGUI();
               configureNameGUI();
               configureLoadSave();
            }
         }
      }
   }
   
   //----------------- GUI utility functions ---------------------
   function getTypeIdx(typeName)
   {
      var id=-1;
      if (typeName!=null && typeName.length>0)
      {
         for (var i=0; i<m_types.length; i++)
         {
            if (m_types[i][1]==typeName)
            {
               id=i;
               break;
            }
         }
      }
      return id;
   }
   
   function isAdvSelMode()
   {
      return (m_advSel=="true");
   }
   
   function setAdvSelMode(newMode)
   {
      //newMode should be the "true" or "false" string
      if (typeof newMode=="string")
      {
         m_advSel = newMode.toLowerCase();  //should be the string "true" or "false"
      }
      else
      {
         //assume boolean
         m_advSel = ((newMode)?"true":"false");
      }
   }
   
   //------------------Dynamic GUI functions---------------------
  
   function clearCriterion(typeName)
   {
      if (typeName!=null && typeName.length>0)
      {
         var i = getTypeIdx(typeName);
         if (i!=-1)
         {
            //clear criterion for this type
            m_types[i][2]=null;
         }
      }
   }
   
   function clearAllCriterion()
   {
      for (var i=0; i<m_types.length; i++)
      {
         //clear criterion for this type
         m_types[i][2]=null;
         setAdvSelMode('false');
      }
   }
   
   function enableJustOneType(typeName)
   {
      //enables just the specified type -- all others are disabled
      for (var i=0; i<m_types.length; i++)
      {
         m_types[i][0] = (m_types[i][1]==typeName);
      }
      for (var i=0; i<m_pseudoTypes.length; i++)
      {
         m_pseudoTypes[i][0] = (m_pseudoTypes[i][1]==typeName);
      }
   }
   
   function setEnableModeAllTypes(enableMode)
   {
      for (var i=0; i<m_types.length; i++)
      {
         m_types[i][0] = enableMode;
      }
      for (var i=0; i<m_pseudoTypes.length; i++)
      {
         m_pseudoTypes[i][0] = enableMode;
      }
   }
   
   function processTypeSelection()
   {
      //get new selected type
      m_selectedType = self.Query.document.getElementById("typesel").value;
      
      //clear out any previous criterion
      clearAllCriterion();
      
      //set simple selection mode
      setAdvSelMode('false');   //move to simple selection mode
      
      //enable appropriate types
      if (self.Query.isAllTypesMode())
		{
		   //enable all types
		   setEnableModeAllTypes(true);
		}
		else
		{
		   //all types disabled but the new selection
		   enableJustOneType(m_selectedType);
		}
		
		//reconfigure GUI
		configureTypeGUI();
		configureNameGUI();
		configureLoadSave();
   }
   
   function configureTypeGUI()
   {
		if (self.Query.isAllTypesMode())
		{
		   //all types selected
		   self.Query.document.getElementById("plus").style.display="none";
		   self.Query.document.getElementById("minus").style.display="none";
		   self.Query.document.getElementById("typesel").style.width="96%";
		}
		else
		{
		   //individual type selected
		   var i = getTypeIdx(m_selectedType);
         if (i==-1)
         {
            //selected type not found -- should never happen
            self.Query.document.getElementById("plus").style.display="none";
            self.Query.document.getElementById("minus").style.display="none";
            self.Query.document.getElementById("typesel").style.width="96%";
         }
         else if (m_types[i][2]==null || m_types[i][2].length==0)
         {
            //no valid criterion -- just plus
            self.Query.document.getElementById("plus").style.display="inline";
            self.Query.document.getElementById("minus").style.display="none";
            self.Query.document.getElementById("typesel").style.width="85%";
         }
         else
         {
            //valid criterion -- plus and minus
            self.Query.document.getElementById("plus").style.display="inline";
            self.Query.document.getElementById("minus").style.display="inline";
		      self.Query.document.getElementById("typesel").style.width="80%";
		   }
		}
   }
   
   function configureNameGUI()
   {
      if (isAdvSelMode())
      {
         //disable name filter entry well
         if (NN6)
         {
            self.Query.document.getElementById("SimpleCriterionLabel").style.fontSize="0";
            self.Query.document.getElementById("SimpleCriterion").style.display="none";
         }
         else
            self.Query.document.getElementById("SimpleCriterion").style.display="none";
      }
      else
      {
         //enable name filter entry well
         if (NN6)
         {
            self.Query.document.getElementById("SimpleCriterionLabel").style.fontSize="12";
            self.Query.document.getElementById("SimpleCriterion").style.display="inline";
         }
         else
            self.Query.document.getElementById("SimpleCriterion").style.display="inline";
      }
   }
   
	function configureLoadSave()
   	{
   		if(m_mode=="browse")
   		{
			if (self.Query.isAllTypesMode())
			{
		   		//all types selected
		   		self.Query.document.getElementById("load").style.display="inline";
		   		self.Query.document.getElementById("save").style.display="inline";
		   		self.Query.document.getElementById("plus").style.display="none";
		   		self.Query.document.getElementById("typesel").style.width="96%";
		   		self.Title.document.getElementById("searchGif").style.display="inline";		   		
			  	self.Title.document.getElementById("browseGif").style.display="inline";
			  	self.Title.document.getElementById("browseGifFile").style.display="none";
			}
			else
			{
				if((m_selectedType == "Directory") || (m_selectedType == "File"))
				{
			   		//File or Diretory selected
			   		self.Query.document.getElementById("load").style.display="none";
			   		self.Query.document.getElementById("save").style.display="none";
		   			self.Query.document.getElementById("plus").style.display="none";
		   			self.Query.document.getElementById("typesel").style.width="96%";
		   			self.Title.document.getElementById("searchGif").style.display="none";		   		
			  	   	//self.Title.document.getElementById("browseGif").style.display="none";
			  	   	//self.Title.document.getElementById("browseGifFile").style.display="inline";
			    }
			    else
			    {
			   		self.Query.document.getElementById("load").style.display="inline";
		   			self.Query.document.getElementById("save").style.display="inline";
		   			self.Query.document.getElementById("plus").style.display="inline";
		   			self.Query.document.getElementById("typesel").style.width="80%";
		   			self.Title.document.getElementById("searchGif").style.display="inline";		   		
			  	   	self.Title.document.getElementById("browseGif").style.display="inline";
			  	   	self.Title.document.getElementById("browseGifFile").style.display="none";
		   			
			    }
			}
		}
	}	
   
   function enterASCriterion()
   {
      doMyAS(m_selectedType);
   }
   
   function clearASCriterion()
   {
      clearCriterion(m_selectedType);
      setAdvSelMode('false');
      configureTypeGUI();
      configureNameGUI();
      configureLoadSave();
   }
   
   //-------------------Task List popup--------------------------
   
   //task window support
   var maxEntries = 15;
   var fontSize = 11;
   var xOffset = 10;
   var yOffset = 20;
   var fontFamily = ((MS55)?"Trebuchet MS, Arial, Helvetica":"Trebuchet MS");
   var padding = 5;
   
   //alert("MS55 = "+MS55);
   if (MS55)
   {
      //define popup for IE
      var taskPopup = window.createPopup();
      var popBody = taskPopup.document.body;
      setBodyProperties(popBody);
      popBody.onclick = selectTask; 
   }
   
   // delete this method in the next release with FwUtils.unpackNoDecode() See FwUtils.unpackNoDecode() for more details.
   function packNoEncode(list)
   {
      if(!list || !list.length || list.length<1)
      {
         return "PP";
      }

      list[0]=replace(list[0], ":",urlEncode(":"));
   
      var s = "P:" + list[0];
      for(var i=1; i<list.length; i++)
      {
      	list[i]=replace(list[i], ":",urlEncode(":"));
         s += ":" + list[i];
      }
   
      return s + "P";
   }

   function doTaskList(refPos, objNames, evt)
   {
      // Must save these because calling new exchanger() in Firefox 1.5 changes values!
      var xpos = evt.screenX;
      var ypos = evt.screenY;

      window.taskListExchanger = new exchanger();
      window.anchor = new Object();
      if (evt != null)
      {
         window.anchor.x=xpos;
         window.anchor.y=ypos;
      }
      else
      {
         window.anchor.x=0;
         window.anchor.y=0;
      }
      window.anchor.obj = refPos;
      window.pObjNames = pack(objNames);
      var cmd = "webacc?taskId=fw.OVTaskList&merge=fw.OV.OVTaskList&OVSelectedObjects=" + urlEncode(window.pObjNames);
      taskListExchanger.sendData(cmd);  //send request for task list from TaskList.java
   }
   
   //called from TaskList.htm onLoad
   function taskListDataReturned(language, title, taskNames, taskIds)
   {
      if (MS55)
         createTaskListIEPopup(language, title, taskNames, taskIds);    // for Microsoft IE
      else
         createTaskListWindow(language, title, taskNames, taskIds);     // for all other browers
   }
   
   function createTaskListIEPopup(language, title, taskNames, taskIds)
   {
      if (taskNames!=null && taskNames.length>0)
      {
         //compute popup height
         var h = ((taskNames.length+1>maxEntries)?maxEntries:taskNames.length+1);
         h = Math.round(h*(fontSize+5)+padding*2+8);
         
         // get length of longest taskName  
         var w=0;
         for (i=0; i<taskNames.length; i++)
         {
            if (taskNames[i].length>w) w=taskNames[i].length;
         }
         
         //compute popup width
         var wFactor = ((language!=null && (language.indexOf("zh")==0 || language.indexOf("ja")==0))?1.3:.55);  
         w = ((w==0)?10:w);
         w = Math.round(w*fontSize*wFactor)+padding*2+2;
         if (taskNames.length+1>maxEntries)
         {
            w += 20;    //add width of scrollbar
         }
         
         // build html content for popup
         var html="\n";
         html += '<table cellpadding=0 cellspacing=0 style="width:100%; border:0; color:#039; font-family:\''+fontFamily+'\';font-size:'+fontSize+'px">\n';
         html += '<tr height=1px bgcolor=gray><td></td></tr>\n';
         html += '<tr bgcolor=#EFEEE9><td align=center><b><font color=gray>'+title+'</font></b></td></tr>\n';
         html += '<tr height=1px bgcolor=gray><td></td></tr>\n';
         html += '<tr height=3px><td></td></tr>\n';
         html += '</table>\n';
         html += '<div style="height:91%;overflow-y:auto">';
         html += '<table cellpadding=0 cellspacing=0 style="width:100%; border:0; color:#039; font-family:\''+fontFamily+'\';font-size:'+fontSize+'px">\n';
         for (i=0; i<taskNames.length; i++)
         {
            html += '<tr><td id="'+taskIds[i]+'" title="'+taskNames[i]+'" style="cursor:pointer"><nobr>&nbsp;'+taskNames[i]+'</nobr></td></tr>\n';
         }
         html += '</table></div>\n';
         
         //create popup window
         //alert("html = "+html);
         popBody.innerHTML = html;
         taskPopup.show(xOffset, yOffset, w, h, window.anchor.obj);
      }
   }
   
   function createTaskListWindow(language, title, taskNames, taskIds)
   {
      if (taskNames!=null && taskNames.length>0)
      {
         //compute popup height
         var h = ((taskNames.length+1>maxEntries)?maxEntries:taskNames.length+1)+1;
         h = Math.round(h*(fontSize+5)+padding*2+8);
         
         // get length of longest taskName  
         var w=0;
         for (var i=0; i<taskNames.length; i++)
         {
            if (taskNames[i].length>w) w=taskNames[i].length;
         }
         
         //compute popup width
         var wFactor = ((language!=null && (language.indexOf("zh")==0 || language.indexOf("ja")==0))?1.3:.55);  
         w = ((w==0)?10:w);
         w = Math.round(w*fontSize*wFactor)+padding*2+2;
         var tblWidth = ((w-25>0)?w-25:w);
         if (taskNames.length+1>maxEntries)
         {
            w += 20;    //add width of scrollbar
         }
         
         // build html content for popup
         var html="\n";
         html += '<table cellpadding=0 cellspacing=0 style="width:'+tblWidth+'px; border:0; color:#039; font-family:\''+fontFamily+'\';font-size:'+fontSize+'px">\n';
         html += '<tr height=1px bgcolor=gray><td></td></tr>\n';
         html += '<tr bgcolor=#EFEEE9><td align=center><b><font color=gray>'+title+'</font></b></td></tr>\n';
         html += '<tr height=1px bgcolor=gray><td></td></tr>\n';
         html += '<tr height=3px><td></td></tr>\n';
         html += '</table>\n';
         html += '<div>';
         html += '<table cellpadding=0 cellspacing=0 style="width:100%; border:0; color:#039; font-family:\''+fontFamily+'\';font-size:'+fontSize+'px">\n';
         for (i=0; i<taskNames.length; i++)
         {
            html += '<tr><td id="'+taskIds[i]+'" title="'+taskNames[i]+'" style="cursor:pointer"><nobr>&nbsp;'+taskNames[i]+'</nobr></td></tr>\n';
         }
         html += '</table></div>\n';
         
         //create task list window
         //alert("trying to open a window...");
         var xPos = window.anchor.x;
         var yPos = window.anchor.y;
         var winopts = "dependent=yes,toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,titlebar=no,width="+w+",height="+h+",screenX="+xPos+",left="+xPos+",screenY="+yPos+",top="+yPos;
         var win = window.open("webacc?taskId=dev.Empty&merge=fw.Empty","TaskList", winopts);
         window.w = win;
         win.document.write('<html><head></head><body onClick="opener.selectTask(event);" onUnload="opener.focus();">');
         
         //alert("html="+html);
         win.document.write(html);
         win.document.writeln('</body></html>');
         win.document.close();
         
         //set window properties 
         setBodyProperties(win.document.body);
      }
   }
   
   function setBodyProperties(body)
   {
      body.style.padding = padding;
      body.style.cursor = "default";
      body.style.backgroundColor = "#FFFFFF";
      body.style.border = "1 solid gray";
   }
   
   
   function getTD(el)
   {
      while (el!=null)
      {
         if (el.tagName=="TD") return el;
         el = el.parentNode;
      }
      return null;
   }
   
   function selectTaskForId(taskId, packedObjectNames)
   {
	   var url = "webacc?NPService=fw.LaunchService&NPAction=Delegate&delegate="+taskId+"&launcher=fw.HomePage&lifecycle=Recreate&targetNames="+urlEncode(packedObjectNames)+"";
	   // Cause a "Repeat Task" button to appear for these tasks.
	   if (taskId=="base.CreateUser" || taskId=="base.ExtendObjects")
	   {
	      url += "&repeatable=true";
	   }
	   if (url.length<1024)
	   {
	      //start the task using a "get" operation
	      //alert("loc = "+url);
	      top.Mainscreen.Content.location=url;
	   }
	   else
	   {
	      //start the task using a "post" operation
	      var tmp = url.split("?");
	      var parms = tmp[1].split("&");
	      var html = '<html>\n<head></head>\n<body>\n<form name="OVStartTaskForm" method=post action="'+tmp[0]+'">\n';
	      for (i=0; i<parms.length; i++)
	      {
	         var parm = parms[i].split("=");
	         html += '<input type=hidden name="'+parm[0]+'" value="'+urlDecode(parm[1])+'">\n';
	      }
	      html += "</form></body></html>";
	      //alert("html = "+html);
	      top.Mainscreen.Content.document.open();
	      top.Mainscreen.Content.document.writeln(html);
	      top.Mainscreen.Content.document.close();
	      top.Mainscreen.Content.document.forms[0].submit();   
	   }
   }
   
   function selectTask(ev)
   {
      var el = null;
      if (MS55)
      {
         //get ie event
         ev = this.document.parentWindow.event;
         el = getTD(ev.srcElement);
      }
      else
      {
         //get netscape event
         el = getTD(ev.target);
      }
      if (el!=null)
      {
         var taskId = el.id;
	      if (taskId!=null && taskId.length>0)
	      {
         	selectTaskForId(taskId, window.pObjNames); // call the selectTask method
	         if (MS55)
	         {
	            taskPopup.hide();
	         }
	         else
	         {
	            w.close();
	         }
         }
      }
   }   
   
