<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8"
   import="com.novell.webaccess.common.JSPConduit,
           com.novell.emframe.dev.eMFrameUtils,
           com.novell.emframe.dev.eMFrameFactory,
           java.util.ArrayList,
           com.novell.emframe.dev.MContext,
           com.novell.application.console.snapin.ObjectEntry,
           com.novell.emframe.fw.RBSUtil" %>

<%
   JSPConduit c = JSPConduit.getJSPConduit(request);
   MContext context = eMFrameFactory.getMContext(request);
   ObjectEntry treeOE = RBSUtil.getTreeOE(context);
   boolean isNVDS = treeOE.getAdminNamespace().isSupported("NVDS");

   c.stringTable("DevResources");
   c.stringTable("FwResources");
%>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>
<iman:stringtable bundle="DevResources"/>
<iman:stringtable bundle="FwResources"/>

<%
   String mode = eMFrameUtils.getAccessMode(eMFrameFactory.getMContext(request));
   String modeWithAccess = "";
   if (mode.equals("Unrestricted"))
   {
      mode = c.toDisplay(c.string("HomePage.UnrestrictedAccess"));
      modeWithAccess = c.toDisplay(c.string("HomePage.UnrestrictedAccessWithAccess"));
   }
   else if (mode.equals("CollectionOwner"))
   {
      mode = c.toDisplay(c.string("HomePage.CollectionOwnerAccess"));
      modeWithAccess = c.toDisplay(c.string("HomePage.CollectionOwnerAccessWithAccess"));
   }
   else if (mode.equals("Assigned"))
   {
      mode = c.toDisplay(c.string("HomePage.AssignedAccess"));
      modeWithAccess = c.toDisplay(c.string("HomePage.AssignedAccessWithAccess"));
   }
   else if (mode.equals("TreeDown"))
   {
      mode = c.toDisplay(c.string("HomePage.TreeDownAccess"));
      modeWithAccess = c.toDisplay(c.string("HomePage.TreeDownAccessWithAccess"));
   }
%>


<HTML>
<HEAD>
   <iman:eMFrameScripts/>
   <iman:dataTableScripts/>
   <iman:stylesheet/>

   <SCRIPT>

      /*******************
       * FUNCTION HEADER *
       *******************/
       function extendRBSSchema()
       {
         var extendSchema = "false";

         if((document.CollectionMain.isRBSInstalled.value == "false") ||
            (document.CollectionMain.isRBSSchemaValid.value == "false"))
         {
            <%if(isNVDS == false){%>
               if(confirm("<%= c.string("RBS.ExtendTheSchema") %>") == true)
               {
                  extendSchema = "true";
               }
               else
               {
                  extendSchema = "return";
               }


            <%}else{%>
               alert("<%= c.string("NVDS.RBS.ExtendTheSchema") + "  (" + c.string("RBS.iManagerInstallationGuideURL") + ")"%>");
               extendSchema = "return";
            <%}%>
         }

         return extendSchema;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function collection2LinkActionHandler(column, row, tableData)
      {
         if(column == 1)
         {
            showRoles(tableData[row][column]);
            return;
         }

         var extendSchema = extendRBSSchema();
         if(extendSchema == "return")
         {
            return;
         }

         if(column == 2)
         {
            document.CollectionMain.extendRBSSchema.value = extendSchema;
            document.CollectionMain.nextState.value = "availableModules";
            document.CollectionMain.merge.value = "fw.AvailableModules";
            document.CollectionMain.selectedCollectionName.value = urlEncode(tableData[row][column]);
            document.CollectionMain.submit();
         }
         else if(column == 3)
         {
            document.CollectionMain.extendRBSSchema.value = extendSchema;
            document.CollectionMain.nextState.value = "installedModules";
            document.CollectionMain.merge.value = "fw.InstalledModules";
            document.CollectionMain.selectedCollectionName.value = urlEncode(tableData[row][column]);
            document.CollectionMain.submit();
         }
         else if(column == 4)
         {
            document.CollectionMain.extendRBSSchema.value = extendSchema;
            document.CollectionMain.nextState.value = "outOfDateModules";
            document.CollectionMain.merge.value = "fw.OutOfDateModules";
            document.CollectionMain.selectedCollectionName.value = urlEncode(tableData[row][column]);
            document.CollectionMain.submit();
         }
         else if(column == 5)
         {
            document.CollectionMain.extendRBSSchema.value = extendSchema;
            document.CollectionMain.nextState.value = "notInstalledModules";
            document.CollectionMain.merge.value = "fw.NotInstalledModules";
            document.CollectionMain.selectedCollectionName.value = urlEncode(tableData[row][column]);
            document.CollectionMain.submit();
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function collection2MenuActionHandler(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="ConfigureiManager")
         {
            configureiManager();
         }
         else if(menuItemId=="CollectionNew")
         {
            newCollection();
         }
         else if(menuItemId == "CollectionEdit")
         {
            editCollection(selectedIndices, tableData);
         }
         else if(menuItemId == "CollectionDelete")
         {
            deleteCollection(selectedIndices, tableData);
         }
         else if(menuItemId == "CollectionOwners")
         {
            collectionOwners(selectedIndices, tableData);
         }
         else if(menuItemId == "CollectionDescription")
         {
            descriptionCollection(selectedIndices, tableData);
         }

         return;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function collection1MenuActionHandler(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="Collection1Migrate")
         {
            migrate1Collection(selectedIndices, tableData);
         }
         else if(menuItemId == "Collection1Delete")
         {
            deleteCollection(selectedIndices, tableData);
         }

         return;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function migrate1Collection(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.iManagerConfigurationWizard" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&RBSCollectionOneName=" + urlEncode(tableData[selectedIndices[0]][1]) +
               "&RBSAdmin_TaskDelegate=taskDelegateMigrate";
         }

         return;
      }

       /*******************
       * FUNCTION HEADER *
       *******************/
      function newCollection(selectedItem)
      {
         var extendSchema = extendRBSSchema();
         if(extendSchema == "return")
         {
            return;
         }

         window.location = "frameservice?NPService=fw.LaunchService" +
            "&NPAction=Delegate" +
            "&delegate=fw.Create Collection" +
            "&launcher=<c:out value="${taskId}"/>" +
            "&extendRBSSchema=" + extendSchema +
            "&lifecycle=Recreate";
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function onExit()
      {
         window.location = "webacc?NPService=fw.LaunchService&NPAction=Return&returnID=<c:out value="${GI_ID}"/>";
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function extendSchema()
      {
         window.location = "frameservice?NPService=fw.LaunchService" +
            "&NPAction=Delegate" +
            "&delegate=fw.Extend Schema" +
            "&launcher=<c:out value="${taskId}"/>" +
            "&lifecycle=Recreate";
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function showRoles(cName)
      {
         var extendSchema = extendRBSSchema();
         if(extendSchema == "return")
         {
            return;
         }

         document.CollectionMain.extendRBSSchema.value = extendSchema;
         document.CollectionMain.nextState.value = "collectionSelected";
         document.CollectionMain.merge.value = "fw.RoleMain";
         document.CollectionMain.selectedCollectionName.value = urlEncode(cName);
         document.CollectionMain.selectedCollectionNameEncoded.value = "true";
         document.CollectionMain.submit();
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function deleteCollection(selectedIndices, tableData)
      {
         if(selectedIndices.length > 0)
         {
            if(confirm("<%= c.string("DeleteRBSCollection.DeleteCollectionWarning") %>"))
            {
               var collectionsToDelete = new Array(selectedIndices.length);

               for(var i=0; i < selectedIndices.length; i++)
               {
                  var index = selectedIndices[i];
                  collectionsToDelete[i] = urlEncode(tableData[index][1]);
               }

               window.location = "frameservice?NPService=fw.LaunchService" +
                                    "&NPAction=Delegate" +
                                    "&delegate=fw.Delete Collections" +
                                    "&launcher=<c:out value="${taskId}"/>" +
                                    "&lifecycle=Recreate" +
                                    "&PackedCollectionsToDelete=" + pack(collectionsToDelete) +
                                    "&nextState=initialState";
            }
         }
         else
         {
            alert("<%= c.string("RBS.CheckOneOrMoreObjectsToPerformOperation") %>");
         }

         return;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function collectionOwners(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
                                 "&NPAction=Delegate" +
                                 "&delegate=fw.Modify Collection Owners" +
                                 "&launcher=<c:out value="${taskId}"/>" +
                                 "&lifecycle=Recreate" +
                                 "&merge=fw.RBSCollectionOwnerList" +
                                 "&RBSCollectionName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
                                "&nextState=showCollectionList";
         }

         return;
      }
      
      function urlEncodePack(stringToPack)
      {
      	var encodedStr = urlEncode(stringToPack);
         var packedArray = new Array(1);   
         packedArray[0] =  encodedStr;
         return pack(packedArray);
     }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function editCollection(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            showRoles(tableData[selectedIndices[0]][1]);
         }

         return;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function configureiManager()
      {
         window.location = "frameservice?NPService=fw.LaunchService" +
            "&NPAction=Delegate" +
            "&delegate=fw.iManagerConfigurationWizard" +
            "&launcher=<c:out value="${taskId}"/>" +
            "&lifecycle=Recreate" +
            "&RBSAdmin_TaskDelegate=taskDelegate";
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function descriptionCollection(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
                              "&NPAction=Delegate" +
                              "&delegate=fw.Modify Collection Description" +
                              "&launcher=<c:out value="${taskId}"/>" +
                              "&lifecycle=Recreate" +
                              "&ModifyRBSObjectDescriptionName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
                              "&merge=fw.ModifyRBSObjectDescription" +
                              "&nextState=showModifyForm";
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function onPageLoad()
      {
         top.Branding.setCollectionModeText('<%= modeWithAccess %>');

         var form = document.CollectionMain;
         var element = document.getElementById(form.collectionTab.value);
         if(element != null)
         {
            element.style.display = "block";
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function showHideTabs(div1, div2)
      {
         var form = document.CollectionMain;
         var element1 = document.getElementById(div1);
         var element2 = document.getElementById(div2);

         if(element1.style.display == "none")
         {
            element1.style.display = "block";
            element2.style.display = "none";

            form.collectionTab.value = div1;
            form.nextState.value = "setCollectionTab";
            form.merge.value = "fw.CollectionMain";
            form.submit();
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function objectSortHandler(tableName, column, direction, tableData)
      {
         var form = document.CollectionMain;
         form.nextState.value = "collectionSort";
         if(tableName == "collectionTable2")
         {
            form.sortCollection2Column.value = column;
            form.sortCollection2Direction.value = direction;
         }
         else
         {
            form.sortCollection1Column.value = column;
            form.sortCollection1Direction.value = direction;
         }

         form.merge.value = "fw.CollectionMain";
         form.submit();
      }

   function popup(strUrl)
	{
		var strOptions = "location=yes,toolbar=yes,menubar=yes,status=yes,scrollbars=yes,resizable=yes,top=20,left=20,width=800,height=400;";
		window.open(strUrl, "novell", strOptions);
	}

   </SCRIPT>
</HEAD>

<BODY onload="onPageLoad();">
<FORM name="CollectionMain">
   <INPUT type="hidden" name="nextState">
   <INPUT type="hidden" name="selectedCollectionName">
      <INPUT type="hidden" name="selectedCollectionNameEncoded">
   <INPUT type="hidden" name="taskId" value="<c:out value="${taskId}"/>">
   <INPUT type="hidden" name="merge">
   <INPUT type="hidden" name="error" value="dev.GenErr">
   <INPUT type="hidden" name="PackedCollectionsToDelete">
   <INPUT type="hidden" name="objectTypeName">
   <INPUT type="hidden" name="RBSCollectionName">
   <INPUT type="hidden" name="isRBSInstalled" value="<c:out value="${isRBSInstalled}"/>">
   <INPUT type="hidden" name="isRBSSchemaValid" value="<c:out value="${isRBSSchemaValid}"/>">
   <INPUT type="hidden" name="RBSAdmin_TaskDelegate">
   <INPUT type="hidden" name="extendRBSSchema" value="false">
   <INPUT type="hidden" name="collectionTab" value="<c:out value="${collectionTab}"/>">
   <INPUT type="hidden" name="sortModuleStatusColumn" value="<c:out value="${sortModuleStatusColumn}"/>">
   <INPUT type="hidden" name="sortModuleStatusDirection" value="<c:out value="${sortModuleStatusDirection}"/>">
   <INPUT type="hidden" name="sortCollection1Column" value="<c:out value="${sortCollection1Column}"/>">
   <INPUT type="hidden" name="sortCollection1Direction" value="<c:out value="${sortCollection1Direction}"/>">
   <INPUT type="hidden" name="sortCollection2Column" value="<c:out value="${sortCollection2Column}"/>">
   <INPUT type="hidden" name="sortCollection2Direction" value="<c:out value="${sortCollection2Direction}"/>">

   <iman:taskHeader titleKey="RBS.Configuration" titleBundle="FwResources" iconUrl="dev/bullet_default_16.gif" helpFile="fw/collectionmain.html" /><BR>
   <iman:include page="dev/Messagebar_inc.jsp"/>

    <% if (c.var("isRBSInstalled").equals("false")) { %>
      <table border="0" cellspacing="0" cellpadding="3">
         <tr>
            <td class="head5">
               <img src="/nps/portal/modules/dev/images/notice32.gif" width="32" height="32" align="absmiddle" border="0" alt="<%= c.string("RBS.AltNotice") %>">
               <font color="#666633"><iman:string key="RBS.Notice"/></font>
                     <%       String configStr = c.toDisplay(c.string("RBS.ConfigureiManager"));
                              String hrefStr = "<a href=\"#\" onClick=\"configureiManager()\">" + configStr + "</a>";
                     %>
                     <%= eMFrameUtils.formatMessage(c.string("RBS.NotConfigured"), new String[]{hrefStr})%>
            </td>
         </tr>
      </table>
    <% } else { %>
      <% if (c.var("isRBSSchemaValid").equals("false")) { %>
         <table border="0" cellspacing="0" cellpadding="3">
            <%if(isNVDS == false){%>
               <tr>
                  <td class="head5">
                     <img src="/nps/portal/modules/dev/images/notice32.gif" width="32" height="32" align="absmiddle" border="0" alt="<%= c.string("RBS.AltNotice") %>">
                     <font color="#666633"><iman:string key="RBS.Notice"/></font>
                        <%       String schemaStr = c.toDisplay(c.string("RBS.ExtendSchema"));
                                 String hrefStr = "<a href=\"#\" onClick=\"extendSchema()\">" + schemaStr + "</a>";
                        %>
                        <%= eMFrameUtils.formatMessage(c.string("RBS.SchemaOutOfDate"), new String[]{hrefStr})%>
                  </td>
               </tr>
            <%}else{%>
               <tr>
                  <td class="head5">
                     <img src="/nps/portal/modules/dev/images/notice32.gif" width="32" height="32" align="absmiddle" border="0" alt="<%= c.string("RBS.AltNotice") %>">
                     <font color="#666633"><iman:string key="RBS.Notice"/></font>
                        <%= c.toHTML(c.string("NVDS.RBS.ExtendTheSchema"))%>
                  </td>
               </tr>
               <tr bgcolor="#FFFFFF">
                 <td colspan="3" class="instructions" valign="top"><a href="javascript:;" onmouseover="parent.status='http://<%= c.string("RBS.iManagerInstallationGuideURL") %>';return true;" onclick="popup('http://<%= c.string("RBS.iManagerInstallationGuideURL") %>')"><%= c.toDisplay(c.string("RBS.iManagerInstallationGuideURL")) %></a></td>
               </tr>
            <%}%>
         </table>
      <% } %>
    <% } %>
   <br>

   <div class="formdescriptextml0" style="width: 80%"><iman:string key="RBS.ConfigurationInstructions"/></div>
   <br>
   <!----------- 2.x ----- 2.x ----- 2.x --------------------------------------------------------------------------------->
   <!--------------------------------------------------------------------------------------------------------------------->
   <div id="collection2Tab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="0">
         <iman:tab textKey="RBS.CollectionTwo" onClick="showHideTabs('collection2Tab','collection1Tab')"/>
         <iman:tab textKey="RBS.CollectionOne" onClick="showHideTabs('collection1Tab','collection2Tab')"/>
      </iman:tabSet>
      <iman:dataTable id="collectionTable2" tableData="${tableData}" menuActionHandler="collection2MenuActionHandler" linkActionHandler="collection2LinkActionHandler" sortHandler="objectSortHandler" sortedColumn="${sortCollection2Column}" sortedDirection="${sortCollection2Direction}">

         <iman:menuItem textKey="RBS.New" id="New">
            <iman:menuItem textKey="RBS.Configure" id="ConfigureiManager"/>
            <iman:menuItem textKey="RBS.Collection" id="CollectionNew"/>
         </iman:menuItem>

         <iman:menuItem textKey="RBS.Edit" id="CollectionEdit"/>
         <iman:menuItem textKey="RBS.Delete" id="CollectionDelete"/>

         <iman:menuItem textKey="RBS.Actions" id="Actions">
            <iman:menuItem textKey="RBS.Owners" id="CollectionOwners"/>
            <iman:menuItem textKey="RBS.Description" id="CollectionDescription"/>
         </iman:menuItem>

         <iman:columnHeader textKey="RBS.Type" sortable="false"/>
         <iman:columnHeader textKey="RBS.Name"/>
         <iman:columnHeader textKey="RBS.Modules" sortable="false"/>
         <iman:columnHeader textKey="RBS.Installed" sortable="false"/>
         <iman:columnHeader textKey="RBS.OutOfDate" sortable="false"/>
         <iman:columnHeader textKey="RBS.NotInstalled" sortable="false"/>

      </iman:dataTable>
  </div>

   <!----------- 1.x ----- 1.x ----- 1.x --------------------------------------------------------------------------------->
   <!--------------------------------------------------------------------------------------------------------------------->
   <div id="collection1Tab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="1">
         <iman:tab textKey="RBS.CollectionTwo" onClick="showHideTabs('collection2Tab','collection1Tab')"/>
         <iman:tab textKey="RBS.CollectionOne" onClick="showHideTabs('collection1Tab','collection2Tab')"/>
      </iman:tabSet>
      <iman:dataTable id="collectionTable1" tableData="${tableData}" menuActionHandler="collection1MenuActionHandler" sortHandler="objectSortHandler" sortedColumn="${sortCollection1Column}" sortedDirection="${sortCollection1Direction}">
         <iman:menuItem textKey="RBS.Migrate" id="Collection1Migrate"/>
         <iman:menuItem textKey="RBS.Delete" id="Collection1Delete"/>
         <iman:columnHeader textKey="RBS.Type" sortable="false"/>
         <iman:columnHeader textKey="RBS.Name"/>
      </iman:dataTable>
   </div>

   <iman:bar/>
   <iman:button key="Close" onClick="onExit(); return false;"/>

</FORM>
</BODY>
</HTML>
