<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit,
                  java.util.ResourceBundle,
                  com.novell.emframe.dev.eMFrameUtils,
                  java.util.ArrayList" %>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>

<iman:stringtable bundle="DevResources"/>
<iman:stringtable bundle="FwResources"/>

<HTML>
<HEAD>
   <LINK rel="stylesheet" href="<c:out value="${ContextPath}" />/portal/modules/dev/css/hf_style.css">
   <SCRIPT src="<c:out value="${ContextPath}" />/portal/modules/fw/javascripts/SelectHelpers.js"></SCRIPT>
   <iman:eMFrameScripts/>

   <SCRIPT>

      var iePos;

      function detectBrowser(){
        var appVer = navigator.appVersion;
        iePos = appVer.indexOf('MSIE');
        if (iePos != -1){
            document.form.favorites.attachEvent('ondblclick',moveRight);
            document.form.tasks.attachEvent('ondblclick',moveLeft);
        }
        else{
            var favoritesList = document.form.favorites.options;
            var tasksList = document.form.tasks.options;

            attachFavoriteEvents(favoritesList);
            attachTaskEvents(tasksList);
        }
      }

      function attachFavoriteEvents(x)
      {
        sortedArray = new Array();

        for (var i=0; i<x.length; i++) {
            sortedArray[i] = new Array(x[i].text, x[i].value, false, false);
        }

        for (var i=0; i<x.length; i++) {
            x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
            x[i].addEventListener("dblclick",moveRight, false);
            x[i].selected = sortedArray[i][3];
        }

        return;
      }

      function attachTaskEvents(x)
      {
        sortedArray = new Array();

        for (var i=0; i<x.length; i++) {
            sortedArray[i] = new Array(x[i].text, x[i].value, false, false);
        }

        for (var i=0; i<x.length; i++) {
            x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
            x[i].addEventListener("dblclick",moveLeft, false);
            x[i].selected = sortedArray[i][3];
        }

        return;
      }

      function moveLeft()
      {
         moveOptions(document.form.tasks, document.form.favorites);
         if (iePos == -1)
            attachFavoriteEvents(document.form.favorites.options);
      }

      function moveRight()
      {
         moveOptions(document.form.favorites, document.form.tasks);
         if (iePos == -1)
            attachTaskEvents(document.form.tasks.options);
         sortTasks(document.form.tasks);
      }

      function moveOptions(selA, selB)
      {
       var i=0;
       while(i < selA.options.length)
       {
          if(selA.options[i].selected)
          {
             var length = selB.options.length;
             selB.options[length] = new Option(selA.options[i].text, selA.options[i].value);

             selA.options[i] = null;
          }
          else
          {
             i++;
          }
       }
      }

      function sortTasks(x)
      {
       if (x.length > 1)
       {
          sortedArray = new Array();

          for (var i=0; i < x.length; i++)
          {
             sortedArray[i] = new Array(x[i].text, x[i].value, false, false);
          }

          sortedArray.sort(sortByText);

          for (var i=0; i < x.length; i++)
          {
             x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
             if(iePos==-1)
                x[i].addEventListener("dblclick",moveLeft, false);
             x[i].selected = sortedArray[i][3];
          }
       }
      }

      function onExit()
      {
         document.form.favoriteIds.value = packSelect(document.form.favorites);
         document.form.submit();
      }
   </SCRIPT>
</HEAD>

<BODY onLoad="detectBrowser();">
<FORM name="form">

   <INPUT type="hidden" name="taskId" value="<c:out value="${taskId}"/>">
   <INPUT type="hidden" name="nextState" value="save">
   <INPUT type="hidden" name="favoriteIds">


   <iman:taskHeader titleKey="Favorites.manageFavorites" titleBundle="FwResources" iconUrl="dev/star.gif" /><BR>

   <TABLE>
      <TR>
         <TD><iman:string key="Favorites.favorites"/></TD>
         <TD></TD>
         <TD><iman:string key="Favorites.task"/></TD>
      </TR>
      <TR>
         <TD valign="top">
            <SELECT name="favorites" size="10" style="width:<iman:string key="UI.textboxPixel"/>;height:200px" multiple>
               <c:forEach items="${selectedIds}" var="item" >
                  <OPTION value="<c:out value="${item.taskId}"/>"><c:out value="${item.displayName}"/>
               </c:forEach>
            </SELECT>
         </TD>
         <TD>
           <A href="#" onclick="javascript:moveLeft();"><IMG border="0" src="<c:out value="${ModulesPath}"/>/dev/images/left16.gif" ></A>
           <BR>
           <A href="#" onclick="javascript:moveRight();"><IMG border="0" src="<c:out value="${ModulesPath}"/>/dev/images/right16.gif"></A>
         </TD>
         <TD valign="top">
            <SELECT name="tasks" size="10" style="width:<iman:string key="UI.textboxPixel"/>;height:200px" multiple>
               <c:forEach items="${taskIds}" var="item" >
                  <OPTION value="<c:out value="${item.taskId}"/>"><c:out value="${item.displayName}"/>
               </c:forEach>
            </SELECT>
         </TD>
      </TR>
      <TR>
         <TD>
            <A href="#" onclick="javascript:moveOptionUp(document.form.favorites);"><IMG border="0" src="<c:out value="${ModulesPath}"/>/dev/images/up16.gif"></A>&nbsp;<A href="#" onclick="javascript:moveOptionDown(document.form.favorites);"><IMG border="0" src="<c:out value="${ModulesPath}"/>/dev/images/down16.gif" ></A>
         </TD>
         <TD></TD>
         <TD></TD>
      </TR>
   </TABLE>

   <BR>
   <INPUT type="checkbox" value="true" name="setPrimaryView" <c:if test="${viewSelected=='true'}">checked</c:if>>&nbsp;<iman:string key="Favorites.makeFirstView"/>
   <BR>

   <BR>
   <iman:bar/>
   <iman:button key="OK" onClick="onExit()"/>
   <iman:cancelBtn/>

</FORM>
</BODY>
</HTML>