<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources");
   c.stringTable("FwResources"); 
   c.stringTable("BaseResources");
   %>

<HTML>
<HEAD>
<TITLE><%= c.toHTML(c.string("ModifyMemberAssignedRoles.Title")) %></TITLE>
<LINK href="<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>" rel="styleSheet" type="text/css">
<jsp:include page='<%= c.getPath("dev/eMFrameScripts_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/MVStringEditorScripts_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/OSScripts_inc.jsp") %>' flush="true" />
<SCRIPT language="JavaScript">

   //Global variables
   var deleteItemsArray 			= new Array();
   var modifyScopeArray 			= new Array();
   var inheritanceKeyArray 		= new Array();
   var inheritanceValueArray 		= new Array();
   var combinedInheritanceArray 	= new Array();
   var assignRightsKeyArray 		= new Array();
   var assignRightsValueArray 	= new Array();
   var combinedAssignRightsArray = new Array();
   var myWindow;
   var userInterface 				= "<%= c.var("User.interface") %>";
   var EMPTY_STRING					= "";
   var NEW_LINE						= "\n";

   //===========================================
   // onPageLoad()
   //===========================================
   function onPageLoad()
   {
      setGeneralMsgUrl();
      returnFromOS(); //Set this for the ObjectSelector
      showNotice();
      setFocusToFormElement();
   }

   //===========================================
   // showNotice()
   //===========================================
   function showNotice()
   {
      if (document.ModifyAssociationsForm.elements["modifyMemberTableChangesNotSaved"].value == "true")
      {
        document.getElementById('notice').style.display = 'block';
      }
   }

   //==================================
   // setFocusToFormElement()
   //==================================
   function setFocusToFormElement()
   {
      mvFocus("RoleTextField");
   }

   //==================================
   // setWaitCursor()
   // cursorStyle is either set to 'wait' or 'default'
   //==================================
   function setWaitCursor(cursorStyle)
   {
	   document.body.style.cursor=cursorStyle;
   }

   //===========================================
   // isEmpty()
   //===========================================
   function isEmpty(inputStr)
   {
   	if (inputStr == null || inputStr == EMPTY_STRING)
      {
         return true;
      }
      else
      {
         return false;
      }
   }

   //===========================================
   // checkNullInput()
   //===========================================
   function checkNullInput()
   {
      var elementCount = document.forms[0].elements.length;

      for (var i = 0; i < elementCount; i++)
      {
      	if (document.forms[0].elements[i].type == "checkbox")
        	{
            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
	         {
	            var memberScope	= parseScope(document.forms[0].elements[i].value);

               // Note: add this to the properties file
	            if (memberScope == null || memberScope == EMPTY_STRING || memberScope == "No Scope")
	            {
	               alert("<%= c.toScript(c.string("RBSManagement.MissingScope")) %>");
	               return false;
	            }
            }
         }
      }
      return true;
   }

   //===========================================
   // setGeneralMsgUrl()
   //===========================================
   function setGeneralMsgUrl()
   {
      document.ModifyAssociationsForm.elements["GeneralMsg.Url"].value = "webacc?taskId=<%= c.var("taskId") %>&merge=fw.ModifyMemberAssignedRolesGetNamePage&nextState=initialState&User.context=<%= c.var("User.context") %>";
   }

   //===========================================
   // nameRemoveButtonSelected()
   //===========================================
   function nameRemoveButtonSelected()
   {
      if (rowsAreSelected() == true)
      {
         var count 			= 0;
         var elementCount 	= document.forms[0].elements.length;

         for (var i = 0; i < elementCount; i++)
	      {
	      	if (document.forms[0].elements[i].type == "checkbox")
	        	{
	            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
		         {
		            if (document.forms[0].elements[i].checked)
		            {
	                  var memberName		= parseName(document.forms[0].elements[i].value);
	                  var memberScope	= parseScope(document.forms[0].elements[i].value);

	                  if (memberScope != null && memberScope != EMPTY_STRING)
	                  {
	                     deleteItemsArray[count] = urlEncode(memberName) + ";" + urlEncode(memberScope) + "$";
		                  count++;
	                  }
	                  else
	                  {
                        deleteItemsArray[count] = urlEncode(memberName) + ";" + EMPTY_STRING + "$";
		                  count++;
	                  }
	               }
               }
	         }
	      }

         if (deleteItemsArray != null && deleteItemsArray.length > 0)
         {
            setWaitCursor("wait");

            document.ModifyAssociationsForm.elements["DeleteMemberFromRoleList"].value = deleteItemsArray.join("$");
	         document.ModifyAssociationsForm.elements["DeleteMemberFromRoleListCount"].value = count;
            document.ModifyAssociationsForm.elements["ModifyMemberTableChanged"].value = "true";

	         // make the changes to DS and return
		      document.ModifyAssociationsForm.elements["merge"].value="fw.ModifyMemberAssignedRolesPage";
		      document.ModifyAssociationsForm.elements["nextState"].value="deleteMembersFromTable";
		      document.ModifyAssociationsForm.submit();
         }
      }
      else
      {
      	alert("<%= c.toScript(c.string("RBSManagement.NoObjectsSelected")) %>");
      }
   }

	//===========================================
   // addButtonSelected()
   //===========================================
   function addButtonSelected()
   {
      var newMemberStr 	= cleanupMVPackStrings(mvGetValuesAsPack("RoleTextField"));
      var newScopeStr 	= cleanupMVPackStrings(mvGetValuesAsPack("ScopeTextField"));

      if (!isEmpty(newMemberStr) && !isEmpty(newScopeStr))
      {
      	addRolesAndScopes();
      }
      else if (!isEmpty(newMemberStr))
      {
         addNamesToTable(newMemberStr);
      }
      else if (!isEmpty(newScopeStr))
      {
      	addScopesToTable(newScopeStr);
      }
      else
      {
      	alert("<%= c.toScript(c.string("ModifyMemberAssignedRoles.FieldsEmpty")) %>");
      }
   }

   //===========================================
   // addRolesAndScopes()
   //===========================================
   function addRolesAndScopes()
   {
      var duplicateName 		= false;
      var duplicateScope 		= false;
      var finalArray				= new Array();
      var searchResultsArray 	= new Array();
      var count 					= 0;
      var newMemberString		= EMPTY_STRING;
      var roleArray 				= unpack(mvGetValuesAsPack("RoleTextField"));
      var scopeArray				= unpack(mvGetValuesAsPack("ScopeTextField"));

      if (roleArray != null)
      {
         for (var i = 0; i < roleArray.length; i++)
	      {
            duplicateName = isMemberInTable(roleArray[i]);

            if (duplicateName)
            {
            	for (var j = 0; j < scopeArray.length; j++)
               {
                  duplicateScope = isScopeAssignedToRole(roleArray[i],scopeArray[j])

                  if (duplicateScope == false)
                  {
                  	finalArray[count] = urlEncode(roleArray[i]) + ";" + urlEncode(scopeArray[j]);
            			count++;
                  }
                  else
                  {
                  	// The name and scope are already in the table
                     alert("<%= c.toScript(c.string("ModifyMemberAssignedRoles.MemberAndScopeAlreadyInTable")) %>"
                     	+ NEW_LINE + NEW_LINE + "<%= c.toScript(c.string("ModifyMemberAssignedRoles.RoleColon")) %>"
                        + " " + roleArray[i] + NEW_LINE + "<%= c.toScript(c.string("ModifyMemberAssignedRoles.ScopeColon")) %>"
                        + " " + scopeArray[j]);
                  }
		         }
		      }
            else
            {
               // The member does not exist in the table. Assign all of the selected scopes to the member
               for (var k = 0; k < scopeArray.length; k++)
         		{
               	finalArray[count] = urlEncode(roleArray[i]) + ";" + urlEncode(scopeArray[k]);
         			count++;
		         }
		      }
         }
      }

      if (finalArray != null && finalArray.length > 0)
      {
         if (finalArray.length > 0)
         {
            setWaitCursor("wait");

            document.ModifyAssociationsForm.elements["ModifyMemberTableChanged"].value = "true";
            document.ModifyAssociationsForm.elements["NewMemberAndScope"].value = finalArray.join("$");
            document.ModifyAssociationsForm.elements["merge"].value="fw.ModifyMemberAssignedRolesPage";
			   document.ModifyAssociationsForm.elements["nextState"].value="addRoleAndScopeToTable";
			   document.ModifyAssociationsForm.submit();
         }
      }
   }

   //===========================================
   // addNamesToTable()
   //===========================================
   function addNamesToTable(mvString)
   {
      var resultsArray 			= unpack(mvString);
      var memberExistsArray	= new Array();
      var finalArray				= new Array();
      var duplicateName 		= false;
      var newMemberString		= EMPTY_STRING;
      var count 					= 0;
      var memberExistsCount	= 0;

      if (resultsArray != null)
      {
         for (var j = 0; j < resultsArray.length; j++)
	      {
          	newMemberString = resultsArray[j].toString();

            // Defect 295793 - Added toString() here for 'simple' support.
            var bVal = isRoleNameInTable(resultsArray[j].toString());

            if (bVal == true)
            {
	            memberExistsArray[memberExistsCount++] = newMemberString;
               duplicateName = true;
	         }

	         if (duplicateName == false)
	         {
	            finalArray[count] = urlEncode(resultsArray[j]); // Array values need to be encoded
	            count++;
	         }
	         else
	         {
	         	duplicateName = false; // reset the value
	         }
	      }
      }

      // If there items already in the table notify the user and continue
      if (memberExistsArray != null && memberExistsArray.length > 0)
      {
         var strMemberExists = EMPTY_STRING;

         for (var i = 0; i < memberExistsArray.length; i++)
         {
         	strMemberExists += NEW_LINE + memberExistsArray[i];
         }

         alert("<%= c.toScript(c.string("RBSManagement.NamesAlreadyInTable")) %>" + NEW_LINE + strMemberExists);
      }

      if (finalArray != null && finalArray.length > 0)
      {
         if (finalArray.length > 0)
         {
            setWaitCursor("wait");

            document.ModifyAssociationsForm.elements["ModifyMemberTableChanged"].value = "true";
            document.ModifyAssociationsForm.elements["NewRoleMembers"].value = finalArray.join("$");
	         document.ModifyAssociationsForm.elements["merge"].value="fw.ModifyMemberAssignedRolesPage";
			   document.ModifyAssociationsForm.elements["nextState"].value="addRolesToTable";
			   document.ModifyAssociationsForm.submit();
         }
      }
   }

	//===========================================
   // addScopesToTable()
   //===========================================
   function addScopesToTable(mvScopeString)
   {
      var updateTable 			= false;
      var elementCount 			= document.forms[0].elements.length;
      var count					= 0;
      var scopeAssignedToRole = false;
      var scopeArray 			= unpack(mvScopeString);
      var roleName				= "";

      // Go through the table and check for selected rows to add the scope(s) to.
      if (rowsAreSelected() == true)
      {
         for (var i = 0; i < elementCount; i++)
	      {
	      	if (document.forms[0].elements[i].type == "checkbox")
	        	{
	            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
		         {
               	if (document.forms[0].elements[i].checked)
		            {
                     roleName = parseName(document.forms[0].elements[i].value);

                     for (var j = 0; j < scopeArray.length; j++)
		               {
		               	scopeAssignedToRole = isScopeAssignedToRole(roleName, scopeArray[j])

                        if (scopeAssignedToRole == false)
			               {
			               	modifyScopeArray[count++] = urlEncode(roleName) + ";" + urlEncode(scopeArray[j]) + "$";
			               }
				         }
		            }
               }
	         }
	      }

         if (modifyScopeArray.length > 0)
	      {
            setWaitCursor("wait");

            document.ModifyAssociationsForm.elements["ModifyMemberTableChanged"].value = "true";
            document.ModifyAssociationsForm.elements["ModifyScopeList"].value=modifyScopeArray.join("$");
	         document.ModifyAssociationsForm.elements["merge"].value="fw.ModifyMemberAssignedRolesPage";
			   document.ModifyAssociationsForm.elements["nextState"].value="addScopeToTable";
			   document.ModifyAssociationsForm.submit();
	      }
      }
      else
      {
      	alert("<%= c.toScript(c.string("RBSManagement.NoNamesSelected")) %>");
      }
   }

   //===========================================
   // parseScope()
   //===========================================
   function parseScope(NameAndScope)
   {
      var nameScopeArray = NameAndScope.split(":"); // The name and scope strings are encoded
      var unEncodedScope = urlDecode(nameScopeArray[1]); // Unencode the strings
      return unEncodedScope;
   }

   //===========================================
   // parseName()
   //===========================================
   function parseName(NameAndScope)
   {
      var nameScopeArray 	= NameAndScope.split(":");
      var unEncodedName		= urlDecode(nameScopeArray[0]);
      return unEncodedName;
   }

   //===========================================
   // modifyScopeSelected()
   //===========================================
   function modifyScopeSelected(memberName, scopeName)
   {
      document.ModifyAssociationsForm.elements["ModifyMemberFullName"].value=memberName;
   	document.ModifyAssociationsForm.elements["ModifyMemberOldScope"].value=scopeName;

      if (!myWindow || myWindow.closed)
      {
         myWindow = window.open("webacc?taskId=dev.Empty&merge=fw.ModifyMemberScope&User.context=<%= c.toHTML(c.var("User.context")) %>", EMPTY_STRING, "toolbar=no,location=no,directories=no,menubar=no,scrollbars=yes,resizable=yes,width=520,height=330");
      }
      else
      {
      	myWindow.focus();
      }
   }

	//===========================================
   // AssignRightsCheckBoxChange()
   //===========================================
   function AssignRightsCheckBoxChange(fullName, scopeName, checkedValue, checkboxNumber)
   {
      var stringInArray 			= false;
      var newNameScope 				= urlEncode(fullName) + ";" + urlEncode(scopeName);
      var newAssignRightsValue 	= checkedValue.toString();
		var inheritNumber 			= "InheritanceCheckBox" + checkboxNumber;

      if (assignRightsKeyArray != null) // Global array of Names and scopes used as key
      {
         // Check array for existing memberId
         for (var i = 0; i < assignRightsKeyArray.length; i++)
         {
            var arrayNameScopeString = assignRightsKeyArray[i];

            // Compare new name and scope to existing name and scope key
            if (arrayNameScopeString == urlDecode(newNameScope))
            {
               stringInArray = true;

               // compare
               assignRightsValueArray[i] = newAssignRightsValue;
               break;
            }
         }

         // Not in the array
         if (stringInArray == false)
         {
         	assignRightsKeyArray[assignRightsKeyArray.length] = newNameScope;
            assignRightsValueArray[assignRightsValueArray.length] = newAssignRightsValue;
         }

         for (var j = 0; j < assignRightsKeyArray.length; j++)
         {
            combinedAssignRightsArray[j] = assignRightsKeyArray[j] + ";" + assignRightsValueArray[j];
         }

         document.ModifyAssociationsForm.elements["ModifyMemberTableChanged"].value="true";
         document.ModifyAssociationsForm.elements["MemberAssignRightsChanged"].value="true";
      	document.ModifyAssociationsForm.elements["MemberAssignRightsList"].value=combinedAssignRightsArray.join("$");
      }

      inheritanceScopeChange(fullName, scopeName, checkedValue, checkboxNumber, "true");
      //inheritanceCheckboxChange(fullName, scopeName, checkedValue, checkboxNumber, "true");
      //inheritanceScopeChange(fullName, scopeName, checkedValue, checkboxNumber, "true");
   }

   //===========================================
   // inheritanceCheckboxChange()
   //===========================================
   function inheritanceCheckboxChange(fullName, scopeName, checkedValue, checkboxNumber, assignRightsChanged)
   {
      if(assignRightsChanged == "true")
      {
         var elementCount 	= document.forms[0].elements.length;

         // Set all rowCheckBoxes to true
         for (var i = 0; i < elementCount; i++)
         {
            if (document.forms[0].elements[i].type == "checkbox")
            {
               if (document.forms[0].elements[i].name.search("InheritanceCheckBox" + checkboxNumber) != -1)
               {
                  if(checkedValue == false)
                  {
                     document.forms[0].elements[i].disabled = true;
                     document.forms[0].elements[i].checked = false;
                  }
                  else
                  {
                     document.forms[0].elements[i].disabled = false;
                     document.forms[0].elements[i].checked = true;
                  }

                  break;
               }
            }
         }
      }

      var stringInArray 		= false;
      var newNameScope 			= urlEncode(fullName) + ";" + urlEncode(scopeName);
      var newInheritanceValue = checkedValue.toString();

      if (inheritanceKeyArray != null) // Global array of Names and scopes used as key
      {
         // Check array for existing memberId
         for (var i = 0; i < inheritanceKeyArray.length; i++)
         {
            var arrayNameScopeString = inheritanceKeyArray[i];

            // Compare new name and scope to existing name and scope key
            if (arrayNameScopeString == urlDecode(newNameScope))
            {
               stringInArray = true;
               inheritanceValueArray[i] = newInheritanceValue;
               break;
            }
         }

         // Not in the array
         if (stringInArray == false)
         {
         	inheritanceKeyArray[inheritanceKeyArray.length] = newNameScope;
            inheritanceValueArray[inheritanceValueArray.length] = newInheritanceValue;
         }

         for (var j = 0; j < inheritanceKeyArray.length; j++)
         {
            combinedInheritanceArray[j] = inheritanceKeyArray[j] + ";" + inheritanceValueArray[j];
         }

         document.ModifyAssociationsForm.elements["ModifyMemberTableChanged"].value="true";
         document.ModifyAssociationsForm.elements["MemberInheritanceChanged"].value="true";
      	document.ModifyAssociationsForm.elements["MemberInheritanceList"].value=combinedInheritanceArray.join("$");
         document.getElementById('notice').style.display = 'block';
      }
   }

   /**************************
    * inheritanceScopeChange *
    **************************/
   function inheritanceScopeChange(fullName, scopeName, optionValue, checkboxNumber, assignRightsChanged)
   {
      if (assignRightsChanged == "true")
      {
         var elementCount = document.forms[0].elements.length;
         // Set all select options to wholeSubtree
         for (var i = 0; i < elementCount; i++)
         {
            if (document.forms[0].elements[i].type == "select-one")
            {
               if (document.forms[0].elements[i].name.search("InheritanceScopeBox" + checkboxNumber) != -1)
               {
                  if (optionValue == false)
                  {
                     document.forms[0].elements[i].disabled = true;
                  }
                  else
                  {
                     document.forms[0].elements[i].disabled = false;
                  }
                  break;
               }
            }
         }
      }

      var stringInArray 		= false;
      var newNameScope 			= urlEncode(fullName) + ";" + urlEncode(scopeName);
      var newInheritanceValue = optionValue;

      if (inheritanceKeyArray != null) // Global array of Names and scopes used as key
      {
         // Check array for existing memberId
         for (var i = 0; i < inheritanceKeyArray.length; i++)
         {
            var arrayNameScopeString = inheritanceKeyArray[i];

            // Compare new name and scope to existing name and scope key
            if (arrayNameScopeString == urlDecode(newNameScope))
            {
               stringInArray = true;

               // compare
               inheritanceValueArray[i] = newInheritanceValue;
               break;
            }
         }

         // Not in the array
         if (stringInArray == false)
         {
            inheritanceKeyArray[inheritanceKeyArray.length] = newNameScope;
            var rbsIsnvds = "<%= c.var("rbs_isNVDS") %>";
            if (rbsIsnvds == "false")
            {
               if (newInheritanceValue == "wholeSubtree")
               {
                  newInheritanceValue = "true";
               }
               else
               {
                  newInheritanceValue = "false";
               }
            }
            inheritanceValueArray[inheritanceValueArray.length] = newInheritanceValue;
         }

         for (var j = 0; j < inheritanceKeyArray.length; j++)
         {
            combinedInheritanceArray[j] = inheritanceKeyArray[j] + ";" + inheritanceValueArray[j];
         }

         document.ModifyAssociationsForm.elements["ModifyMemberTableChanged"].value="true";
         document.ModifyAssociationsForm.elements["MemberInheritanceChanged"].value="true";
      	document.ModifyAssociationsForm.elements["MemberInheritanceList"].value=combinedInheritanceArray.join("$");
         document.getElementById('notice').style.display = 'block';
      }
   }

   //===========================================
   // isRoleNameInTable()
   //===========================================
   function isRoleNameInTable(newRoleName)
   {
      var elementCount 	= document.forms[0].elements.length;

      for (var i = 0; i < elementCount; i++)
      {
      	if (document.forms[0].elements[i].type == "checkbox")
        	{
            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
	         {
               var memberName	= parseName(document.forms[0].elements[i].value); // Only need to check role name

               if (newRoleName.toUpperCase() == memberName.toUpperCase())
			      {
		         	//alert("<%= c.toScript(c.string("RBSManagement.MemberAlreadyInTable")) %> " + memberName);
		            return true;
		         }
            }
         }
      }

      return false;
   }

	//===========================================
   // setRowCheckBoxValues()
   //===========================================
	function setRowCheckBoxValues(checkBoxValue)
   {
   	var elementCount 	= document.forms[0].elements.length;

      // Set all rowCheckBoxes to the passed in boolean value
      for (var i = 0; i < elementCount; i++)
      {
      	if (document.forms[0].elements[i].type == "checkbox")
        	{
            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
	         {
		         {
		            document.forms[0].elements[i].checked = checkBoxValue;
		         }
            }
         }
      }
   }

   //===========================================
   // isMemberInTable()
   //===========================================
   function isMemberInTable(member)
   {
	  // Check to see if the scope is assigned to the name
	  var elementCount 	= document.forms[0].elements.length;
      var duplicateName = false;

	   for (var j = 0; j < elementCount; j++)
	   {
	   	if (document.forms[0].elements[j].type == "checkbox")
	     	{
	         if (document.forms[0].elements[j].name.search("RowCheckBox") != -1)
	         {
	            memberName	= parseName(document.forms[0].elements[j].value);
	            memberScope	= parseScope(document.forms[0].elements[j].value);

	            if (member.toUpperCase() == memberName.toUpperCase())
	            {
	               duplicateName = true;
	               break;
               }
	      	}
	      }
	   }
       return duplicateName;
   }

   //===========================================
   // isScopeAssignedToRole()
   //===========================================
   function isScopeAssignedToRole(member, scope)
   {
	   // Check to see if the scope is assigned to the name
	   var elementCount		= document.forms[0].elements.length;
	   var duplicateScope 	= false;

	   for (var j = 0; j < elementCount; j++)
	   {
	   	if (document.forms[0].elements[j].type == "checkbox")
	     	{
	         if (document.forms[0].elements[j].name.search("RowCheckBox") != -1)
	         {
	            memberName	= parseName(document.forms[0].elements[j].value);
	            memberScope	= parseScope(document.forms[0].elements[j].value);

	            if (member.toUpperCase() == memberName.toUpperCase())
	            {
                  if (scope.toUpperCase() == "[ROOT]") //Change scope to treename
                  {
                  	var rbsIsnvds = "<%= c.var("rbs_isNVDS") %>";
                     if (rbsIsnvds == "false")
                     {
                        if (document.ModifyAssociationsForm.elements["ModifyMemberAssignedRoles.TreeName"].value != null)
                        {
                           scope = document.ModifyAssociationsForm.elements["ModifyMemberAssignedRoles.TreeName"].value;
                        }
                     } 
                  }

                  if (scope.toUpperCase() == memberScope.toUpperCase())
	               {
	               	// The name and scope are already in the table
	                  duplicateScope = true;
	                  break;
	               }
	            }
	      	}
	      }
	   }

      return duplicateScope;
   }

 	//===========================================
   // cleanupMVPackStrings()
   //===========================================
   function cleanupMVPackStrings(packString)
   {
      if (packString != null && packString == "PP")
      {
      	return EMPTY_STRING;
      }
      else
      {
      	return packString;
      }
   }

   //===========================================
   // rowsAreSelected()
   // Returns true if any scope checkboxes are checked
   //===========================================
   function rowsAreSelected()
   {
   	var elementCount = document.forms[0].elements.length;

      for (var i = 0; i < elementCount; i++)
      {
      	if (document.forms[0].elements[i].type == "checkbox")
        	{
            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
	         {
	            if (document.forms[0].elements[i].checked)
	            {
	               return true;
	            }
            }
         }
      }

      return false;
   }

   function OKButtonClicked()
   {
      bTableComplete 	= checkNullInput();	// This checks for scopes that are missing from the table.
      var newMemberStr 	= cleanupMVPackStrings(mvGetValuesAsPack("RoleTextField"));
      var newScopeStr 	= cleanupMVPackStrings(mvGetValuesAsPack("ScopeTextField"));

      if (!isEmpty(newMemberStr) || !isEmpty(newScopeStr))
      {
      	var message = "<%= c.toScript(c.string("RBSManagement.DataLeftInTextfields")) %>";

	      if (!confirm(message))
	      {
	         return false;
	      }
      }

      setGeneralMsgUrl();
      setWaitCursor("wait");
      if (bTableComplete == true)
      {
         document.ModifyAssociationsForm.elements["merge"].value="dev.GenConf";
		   document.ModifyAssociationsForm.elements["nextState"].value="updateMemberAssociations";
		   document.ModifyAssociationsForm.submit();
      }
      else
      {
      	setWaitCursor("default");
         return false;
      }
   }
   
	function applySelected()
   {
      bTableComplete 	= checkNullInput();	// This checks for scopes that are missing from the table.
      var newMemberStr 	= cleanupMVPackStrings(mvGetValuesAsPack("RoleTextField"));
      var newScopeStr 	= cleanupMVPackStrings(mvGetValuesAsPack("ScopeTextField"));
      
      
      if (!isEmpty(newMemberStr) || !isEmpty(newScopeStr))
      {
      	var message = "<%= c.toScript(c.string("RBSManagement.DataLeftInTextfieldsApply")) %>";

	      if (!confirm(message))
	      {
	         return false;
	      }
      }
      
      setGeneralMsgUrl();
      setWaitCursor("wait");
      if (bTableComplete == true)
      {
           document.ModifyAssociationsForm.elements["merge"].value="fw.ModifyMemberAssignedRolesPage";
           document.ModifyAssociationsForm.elements["nextState"].value="apply";
		   document.ModifyAssociationsForm.submit();
      }
      else
      {
      	setWaitCursor("default");
         return false;
      }
   }
   
   function refreshSelected(){
	   document.ModifyAssociationsForm.elements["merge"].value="fw.ModifyMemberAssignedRolesPage";
	   document.ModifyAssociationsForm.elements["nextState"].value="refresh";
	   document.ModifyAssociationsForm.submit();
   }
	   

   function popup(strUrl)
	{
		var strOptions = "location=yes,toolbar=yes,menubar=yes,status=yes,scrollbars=yes,resizable=yes,top=20,left=20,width=800,height=400;";
		window.open(strUrl, "novell", strOptions);
	}


</SCRIPT>
</HEAD>
<BODY TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" bgcolor="#FFFFFF" onload="onPageLoad();">
<FORM name="ModifyAssociationsForm" method=post action="webacc" onsubmit="return(checkNullInput())">
   <input type=hidden name="taskId" value="<%= c.var("taskId") %>">
   <input type=hidden name="merge" value="dev.GenConf">
   <input type=hidden name="error" value="dev.MooGenErr">
   <input type=hidden name="User.context" value="<%= c.var("User.context") %>">
   <input type=hidden name="nextState" value="updateMemberAssociations">
   <input type=hidden name="Role.Member.Count" value="<%= c.var("Role.Member.Count") %>">
   <input type=hidden name="DeleteMemberFromRoleList" value="">
   <input type=hidden name="DeleteMemberFromRoleListCount" value="">
   <input type=hidden name="ModifyMemberFullName" value="">
   <input type=hidden name="ModifyMemberDisplayName" value="">
   <input type=hidden name="ModifyMemberOldScope" value="">
   <input type=hidden name="ModifyScopeList" value="">
   <input type=hidden name="ModifyMemberInheritance" value="">
   <input type=hidden name="MemberInheritanceChanged" value="false">
   <input type=hidden name="ModifyMemberTableChanged" value="false">
   <input type=hidden name="MemberInheritanceList" value="">
   <input type=hidden name="MemberAssignRightsChanged" value="false">
   <input type=hidden name="MemberAssignRightsList" value="">
   <input type=hidden name="NewRoleMembers" value="">
   <input type=hidden name="NewMemberAndScope" value="">
   <input type=hidden name="RBSSelectedMember" value="<%= c.toHTML(c.var("RBSSelectedMember")) %>">
   <input type=hidden name="GeneralMsg.Url" value="">
   <input type=hidden name="ModifyMemberAssignedRoles.TreeName" value="<%= c.var("ModifyMemberAssignedRoles.TreeName") %>">
   <input type=hidden name="modifyMemberTableChangesNotSaved" value="<%= c.var("modifyMemberTableChangesNotSaved") %>">
   <!-- End of hidden tags -->

   <% c.set("TaskHeader.title", c.toHTML(c.string("ModifyMemberAssignedRoles.ModifyMemberAssociation")));
      c.set("TaskHeader.helpFile", "base/modifymemberassignedroles.html");
	   c.set("TaskHeader.HelpWindowWidth", "500");
	   c.set("TaskHeader.HelpWindowHeight", "500"); %>
   <jsp:include page='<%= c.getPath("dev/TaskHeader_inc.jsp") %>' flush="true" />
   <BR>
	<TABLE width="100%" border="0" cellspacing="0" cellpadding="3">
   	<TR bgcolor="#FFFFFF">
	      <TD class="mediumtext" colspan="3" nowrap valign="top"><b><%= c.toHTML(c.string("RBSManagement.MemberName")) %></b>&nbsp;<%= c.toHTML(c.var("RBSSelectedMember")) %></TD>
	   </TR>
		<TR bgcolor="#FFFFFF">
	      <TD class="mediumtext" colspan="3" nowrap valign="top"><b><%= c.toHTML(c.string("ModifyRoleAssociations.TypeColon")) %></b>&nbsp;<%= c.toHTML(c.var("ModifyMemberAssignedRoles.Type")) %>
	      <% if (c.var("ModifyMemberAssignedRoles.DynamicGroupAux").equals("true")) { %>
				&nbsp;<%= c.toHTML(c.string("ModifyMemberAssignedRoles.DynamicGroup")) %>
			<% } %>
	      </TD>
	   </TR>
	  <TR bgcolor="#FFFFFF">
	      <TD colspan="3" nowrap valign="top">&nbsp;</TD>
	  </TR>
      <TR bgcolor="#FFFFFF">
	     <TD colspan="3" class="instructions" valign="top"><b><%= c.toHTML(c.string("RBSManagement.SecurityNote")) %></b> <%= c.toHTML(c.string("RBSManagement.SecurityMessage")) %></TD>
      </TR>
      <TR bgcolor="#FFFFFF">
        <TD colspan="3" class="instructions" valign="top"><a href="http://<%= c.string("RBSManagement.SecurityMessageURL") %>" onmouseover="parent.status='http://<%= c.string("RBSManagement.SecurityMessageURL") %>';return true;" onclick="popup('http://<%= c.string("RBSManagement.SecurityMessageURL") %>'); return false;"><%= c.toDisplay(c.string("RBSManagement.SecurityMessageURL")) %></a></TD>
      </TR>
      <TR bgcolor="#FFFFFF">
	      <TD colspan="3" nowrap valign="top">&nbsp;</TD>
	   </TR>
	   <TR bgcolor="#FFFFFF">
	      <TD colspan="3" nowrap valign="top" class="instructions">
				<%= c.toHTML(c.string("RBSManagement.EnterOrBrowse")) %>
				<BR>
			</TD>
	   </TR>
      <TR bgcolor="#FFFFFF">
         <TD colspan="3" nowrap valign="top"><P>&nbsp;</P></TD>
      </TR>
   	<TR bgcolor="#FFFFFF">
      	<TD class="mediumtext" width="5%" nowrap valign="middle"><%= c.toHTML(c.string("RBSManagement.RoleWithColon")) %></TD>
         <TD class="mediumtext" width="60%">
         	<% c.set("MVStringEditor_name", "RoleTextField");
               c.set("MVStringEditor_ignoreCase", "true");
               c.set("MVStringEditor_enforceUnique", "true");
               c.set("MVStringEditor_history", "true");
               c.set("MVStringEditor_objectTypeName", "rbsRole2");
               if (c.var("User.interface").equals("browse")) {
            	   c.set("MVStringEditor_size", "5");
               } %>
            <jsp:include page='<%= c.getPath("dev/MVStringEditor_inc.jsp") %>' flush="true" />
         </TD>
         <TD><P>&nbsp;</P></TD>
      </TR>
      <TR bgcolor="#FFFFFF">
      	<TD class="mediumtext" width="5%" nowrap valign="top"><%= c.toHTML(c.string("ModifyRoleAssociations.ScopeColon")) %></TD>
         <TD width="60%">
            <% c.set("MVStringEditor_name", "ScopeTextField");
               c.set("MVStringEditor_ignoreCase", "true");
               c.set("MVStringEditor_enforceUnique", "true");
               c.set("MVStringEditor_history", "true");
               c.set("MVStringEditor_objectTypeName", "[containers],[root]");
               if (c.var("User.interface").equals("browse")) {
            	   c.set("MVStringEditor_size", "5");
               } %>
            <jsp:include page='<%= c.getPath("dev/MVStringEditor_inc.jsp") %>' flush="true" />
            <a href="#" onClick="javascript:addButtonSelected();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Add.image") %>" alt="<%= c.toHTML(c.string("Button.Add.alt")) %>" title="<%= c.toHTML(c.string("Button.Add.alt")) %>" border=0></a>
			</TD>
         <TD align="left" class="instructions" width="35%"></TD>
		</TR>
      <TR bgcolor="#FFFFFF">
         <TD colspan="3"><P>&nbsp;</P></TD>
      </TR>
	</TABLE>
    <div name="UnsavedNotice" id="notice" style="display: none">
        <div class="head4" style="margin-bottom: 0.5em;">
			<img height="32" width="32" src="<%= c.getModulesUrl() %>/dev/images/notice32.gif" align="absmiddle" border="0"></a> <span class="typegold1"><%= c.string("RBS.Notice") %></span>
            <b><%= c.string("ModifyMemberAssignedRoles.UnsavedWarningPart1") %></b></div>
		<div class="mediumtext" style="margin-left: 2.8em; margin-bottom: 2em; line-height: 1.3em; width: 60%">
			<%= c.string("eDirRights.UnsavedWarningPart2") %></div>
	</div>
 	<TABLE width="100%" border="0" cellspacing="0" cellpadding="3">
    	<TR bgcolor="#FFFFFF">
      	<TD valign="top" colspan="5">
         	<a href="#" onClick="javascript:nameRemoveButtonSelected();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.RemoveSmall.image") %>" alt="<%= c.toHTML(c.string("Button.RemoveSmall.alt")) %>" title="<%= c.toHTML(c.string("Button.RemoveSmall.alt")) %>" border=0></a>
      	</TD>
    	</TR>
      <TR  bgcolor="#DFDDD5" >
      	<TD width="10%" height="24" class="tablecolumnhead1">
        		<DIV align="center"><input type="checkbox" name="NameCheckBox" value="checkbox" onclick="setRowCheckBoxValues(this.checked)"></DIV>
      	</TD>
   		<TD width="35%" height="24" class="tablecolumnhead1">
     			<DIV align="left"><font color="#FFFFFF"><b><font color="#000000"><%= c.toHTML(c.string("ModifyMemberAssignedRoles.Role")) %></font></b></font></DIV>
   		</TD>
   		<TD width="35%" height="24" class="tablecolumnhead1">
     			<DIV align="left"><font color="#FFFFFF"><b><font color="#000000"><%= c.toHTML(c.string("ModifyMemberAssignedRoles.Scope")) %></font></b></font></DIV>
   		</TD>
   		<TD width="10%" height="24" class="tablecolumnhead1">
     			<DIV align="center" nowrap><font color="#FFFFFF"><b><font color="#000000"><%= c.toHTML(c.string("ModifyMemberAssignedRoles.AssignRights")) %></font></b></font></DIV>
   		</TD>
         <TD width="10%" height="24" class="tablecolumnhead1">
     			<DIV align="center"><font color="#FFFFFF"><b><font color="#000000"><%= c.toHTML(c.string("ModifyMemberAssignedRoles.Inheritable")) %></font></b></font></DIV>
   		</TD>
 		</TR>
    	<!-- Load table info -->
      <% c.set("i", "0");
         c.set("color", "#FFFFFF");
   	   c.set("previousName", "");
         while (c.lt(c.var("i"), c.var("Member.Role.Count"))) { %>
      <TR bgcolor=<%= c.var("color") %>>
			<TD class="mediumtext">
				<DIV align="center"><input type="checkbox" name="RowCheckBox<%= c.var("i") %>" width="16" height="16" value="<%= c.urlEncode(c.var("Member.Role."+c.var("i")+ ".FullName")) %>:<%= c.urlEncode(c.var("Member.Role."+c.var("i")+ ".ScopeFullName")) %>"
            	<% if (c.var("Member.Role."+c.var("i")+ ".ScopeFullName").equals("")) { %>
               	checked >
               <% } else { %>
               	>
               <% } %>
          	</DIV>
			</TD>
			<TD class="mediumtext">
         	<% if (c.toLower(c.var("Member.Role."+c.var("i")+ ".FullName")).equals(c.toLower(c.var("previousName")))) { %>
				&nbsp;
            <% } else { %>
				<%= c.toHTML(c.var("Member.Role."+c.var("i")+ ".FullName")) %>
            <% }
               c.set("previousName", c.var("Member.Role."+c.var("i")+ ".FullName")); %>
			</TD>
			<% if (c.var("Member.Role."+c.var("i")+ ".ScopeFullName").equals("") == false) { %>
			<TD class="mediumtext">
           	<% if (c.var("Member.Role."+c.var("i")+ ".roleType").equals("self-provisioning")) { %>
         		<%= c.toHTML(c.string("RBSManagement.SelfManagement")) %>
				<% } else if ((session.getAttribute("DeviceType").equals("browser")) || (session.getAttribute("DeviceType").equals("mozilla"))) { %>
              <a href="#" onClick="javascript:modifyScopeSelected('<%= c.toHTML((c.toScript(c.var("Member.Role."+c.var("i")+ ".FullName")))) %>','<%= c.toHTML((c.toScript(c.var("Member.Role."+c.var("i")+ ".ScopeFullName")))) %>');return false"><%= c.toHTML(c.var("Member.Role."+c.var("i")+ ".ScopeDisplayName")) %></a>
            <% } else { %>
              	<%= c.toHTML(c.var("Member.Role."+c.var("i")+ ".ScopeFullName")) %>
				<% } %>
			</TD>
			<TD class="mediumtext">
				<DIV align="center">
            	<input type="checkbox" name="AssignRightsCheckBox<%= c.var("i") %>" onclick="AssignRightsCheckBoxChange('<%= c.toHTML((c.toScript(c.var("Member.Role."+c.var("i")+ ".FullName")))) %>','<%= c.toHTML((c.toScript(c.var("Member.Role."+c.var("i")+ ".ScopeFullName")))) %>',this.checked,<%= c.var("i") %>)"
               <% if (c.toHTML(c.var("Member.Role."+c.var("i")+ ".AssignRights")).equals("true"))
               	{ %>
                  	CHECKED
               <% } %> width="15%" height="16"
               	>
          	</DIV>
			</TD>
         <TD class="mediumtext">
				<DIV align="center">
            <SELECT name="InheritanceScopeBox<%= c.var("i") %>" size=1 style="WIDTH: 150px" onchange="inheritanceScopeChange('<%= c.toHTML((c.toScript(c.var("Member.Role."+c.var("i")+ ".FullName")))) %>','<%= c.toHTML((c.toScript(c.var("Member.Role."+c.var("i")+ ".ScopeFullName")))) %>',this.value, <%= c.var("i") %>, 'false')"
            <% if (c.var("RBSXMLAttributeDefined").equals("true"))
               {
                  if (c.var("SelfProvisioningRole").equals("true"))
                  { %>
                     disabled>
                <%}
                  else if (c.toHTML(c.var("Member.Role."+c.var("i")+ ".AssignRights")).equals("false"))
                  { %>
                    disabled>
               <% }
                  else
                  { %>
                    >
               <% } %>
            <% }
               else
               { %>
                  disabled >
            <% }
               c.set("j", "0");
               while (c.lt(c.var("j"), c.var("Role.AclScopeValues.Count")))
               { %>
                  <OPTION value="<%= c.var("Role.AclScopeValue"+c.var("j")) %>"
                     <% if (c.toHTML(c.var("Member.Role."+c.var("i")+ ".Inheritable")).equals( c.var("Role.AclScopeValue"+c.var("j"))))
                        { %>
                           selected >
                     <% }
                        else if (c.toHTML(c.var("Member.Role."+c.var("i")+ ".Inheritable")).equals("true") && ( c.var("Role.AclScopeValue"+c.var("j"))).equals("wholeSubtree"))
                        { %>
                           selected >
                     <% }
                        else if (c.toHTML(c.var("Member.Role."+c.var("i")+ ".Inheritable")).equals("false") && ( c.var("Role.AclScopeValue"+c.var("j"))).equals("baseObject"))
                        { %>
                           selected >
                     <% }
                        else
                        { %>
                          >
                     <% } %>
                        <%= c.toHTML(c.string("ModifyRoleAssociations." + c.var("Role.AclScopeValue"+c.var("j")))) %>
                  </OPTION>
                  <% c.inc("j");
               } %>
               </SELECT>
          	</DIV>
			</TD>
			<% } else { %>
           <TD class="mediumtext"><%= c.toHTML(c.string("ModifyRoleAssociations.NoScope")) %></TD>
			  <TD>&nbsp;</TD>
              <TD>&nbsp;</TD>
			<% } %>
	   </TR>
   		<% c.inc("i");
   		   if (c.toLower(c.var("Member.Role."+c.var("i")+ ".FullName")).equals(c.toLower(c.var("previousName"))) == false) {
        		   if (c.var("color").equals("#FFFFFF")) {
	      		   c.set("color", "#EFEEE9");
	      	   } else {
	      		   c.set("color", "#FFFFFF");
	      	   }
     		   }
  		   } %>
	</TABLE>
	<BR>
   <TABLE width="100%" border="0" cellspacing="0" cellpadding="0" align="left">
      <TR>
	      <TD colspan="2">&nbsp;</TD>
	   </TR>
      <TR>
      	<TD align="left" class="ruleabove">
         	<a href="#" onClick="javascript:OKButtonClicked();return false"><IMG name="Ok" alt="<%= c.toHTML(c.string("Button.OK.alt")) %>" title="<%= c.toHTML(c.string("Button.OK.alt")) %>" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.OK.image") %>" border=0></a>
            <jsp:include page='<%= c.getPath("dev/Cancel_inc.jsp") %>' flush="true" />
            <A href="#" onClick="javascript:applySelected(); return false"><img src="<%= c.getModulesUrl() %>/dev/images/<%= c.string("Button.Apply.image") %>" alt="<%= c.string("Button.Apply.alt") %>" border=0 ></a>
            <A href="javascript:refreshSelected();" ><img src="<%= c.getModulesUrl() %>/dev/images/<%= c.string("Button.Refresh.image") %>" alt="<%= c.string("Button.RefreshAll.alt") %>" border="0" ></a>
         </TD>
      </TR>
   </TABLE>
   </FONT>
</FORM>
<jsp:include page='<%= c.getPath("dev/OSFooter_inc.jsp") %>' flush="true" />
</BODY></HTML>
