<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);

   if (c.var("Progress.secondsToRefresh").equals(""))
   {
      c.set("Progress.secondsToRefresh", "5");
   }

   c.stringTable("DevResources");
   c.stringTable("FwResources");
%>

<HTML>
<HEAD>
   <TITLE><%= c.string("ProductName") %></TITLE>
   <LINK rel="stylesheet" href="<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>" type="text/css">
   <SCRIPT language="JavaScript" src="<%= c.getModulesUrl() + "/dev/javascripts/" %>exchanger.js"></SCRIPT>

   <jsp:include page='<%= c.getPath("dev/eMFrameScripts_inc.jsp") %>' flush="true" />

   <STYLE>
      .error1 {border:1px solid #000000; font-size:12px; background-color:#EEEEEE;}
   </STYLE>

   <SCRIPT>
      timeToRefresh = 2500;

      oldCount = 1;
      count = 1;

      d = new Date();
      startTime = d.getTime();
      finished = "false";

      sentMessage = false;

      function updateProgress()
      {
         var hasRead = progress.hasRead();
         var numComplete = Number(progress.retrieveData("progressNumberCompleted"));
         var numTotal = Number(progress.retrieveData("progressTotalNumber"));

         if(typeof numComplete != "number" || isNaN(numComplete) || hasRead)
         {
            setTimeout("updateProgress();", 100);
            return;
         }

         var msgDiv = document.getElementById("progressMessage");
         var estDiv = document.getElementById("estimatedTime");
         msgDiv.innerHTML = formatMessage("<%= c.string("Progress.numberOfObjectsUpdated") %>", [numComplete, numTotal]);
         finished = progress.retrieveData("progressFinished");

         // update progress bar
         count = Math.round(numComplete/numTotal * 20);
         if(count>0)
         {
            for(var i=oldCount; i<=count; i++)
            {
               document.getElementById("progress"+i).style.backgroundColor = "#003399";
            }
            oldCount = count;
         }

         // updateErrorMessages
         errors = progress.retrieveData("errors");
         window.mooErrors = errors;
         if(errors.length >0)
         {
            errorHeader
            var errorDiv = document.getElementById("errorMessages");
            var errorHeaderDiv = document.getElementById("errorHeader");

            var errorHeader = formatMessage("<%= c.string("Progress.errorCount") %>", [errors.length]);
            errorHeaderDiv.innerHTML = errorHeader;
            errorHeaderDiv.style.display = "block";
            errorDiv.style.display = "block";

            var str = "<TABLE cellpadding=4 cellspacing=0>";
            for(var i=0; i < errors.length; i++)
            {
               str += "<TR><TD valign=top class=error1>" + errors[i][0] + "</TD><TD class=error1>" + errors[i][1] + "</TD></TR>"
            }
            str += "</TABLE>";

            errorDiv.innerHTML = str;
         }

         // update time estimation
         if(finished == "true")
         {
            onFinished();
            return;
         }
         else if(numComplete>0)
         {
            d = new Date();
            var currentTime = d.getTime();
            var estimatedTime = (1.0 - numTotal/numComplete) * (currentTime - startTime) * -0.001;

            var minutes = Math.round(estimatedTime/60.0);
            var seconds = Math.round(estimatedTime%60.0);
            if(minutes>0 || seconds>0)
            {
               estDiv.innerHTML = formatMessage("<%= c.string("Progress.estimatedTime") %>", [minutes, seconds]);
            }
         }
         else
         {
            estDiv.innerHTML = "<%= c.string("Progress.calculatingTime") %>";
         }

         // var scale = 1.0 - Math.abs(numTotal*0.6 - numComplete) / (numTotal/2.0); // 0->1->0
         requestUpdateProgress(timeToRefresh);
      }


      // called by updateProgress
      function onFinished()
      {
         var estDiv = document.getElementById("estimatedTime");
         estDiv.innerHTML = "<%= c.string("Progress.complete") %>";

         var buttonAtBottom = document.getElementById("buttonAtBottom");
         buttonAtBottom.src = "<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Close.image") %>";
         buttonAtBottom.alt = "<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Close.alt") %>";
      }

      xButtonPressed=true;

      function onUnloadHandler()
      {
         if(this==top && xButtonPressed)
         {
            closeButtonPressed();
         }
      }

      function closeButtonPressed()
      {
         if(sentMessage)
         {
            return;
         }

         sentMessage = true;


         // MOZILLA_HACK: mozilla points to wrong window
         if(this==top)
         {
            var realOpener = opener;
            if(opener.name == "bookBody")
            {
               realOpener = opener.parent.bookHeader;
            }
         }


         xButtonPressed=false;

         if(finished=="true")
         {
            if(this==top)
            {
               <% if (c.var("Progress.onComplete").equals("refreshPropertyBook")) { %>
                  realOpener.refreshAfterProgress();
               <% } else if (c.var("Progress.onComplete").equals("closeCallingTask")) { %>
                  if(window.mooErrors != null && window.mooErrors.length>0)
                  {
                     realOpener.refreshAfterProgress();
                  }
                  else
                  {
                     realOpener.parent.location = "webacc?taskId=<%= c.var("taskId") %>&taskComplete=true";
                  }
               <% } else if (c.var("taskId").equals("base.ExtendObjects")) { %>
                      realOpener.location = "webacc?taskId=<%= c.var("taskId") %>&merge=fw.ExtendObject&User.context=<%= c.var("User.context") %>&nextState=doShowExtensions&eDir$target=<%= c.urlEncode(c.var("eDir$target"))%>";
               <% } %>


               window.close();
            }
            else
            {
               window.location = "webacc?taskId=<%= c.var("taskId") %>&taskComplete=true";
            }
         }
         else
         {
            // do a cancel

            // try to cancel; show message
            window.location = "webacc?taskId=<%= c.var("taskId") %>&nextState=progress.cancel&merge=dev.GenConf&GeneralMsg.Url=Javascript:window.close()";

            // close or refresh the book
            <% if (c.var("Progress.onComplete").equals("refreshPropertyBook")) { %>
               realOpener.refreshAfterProgress();
            <% } else if (c.var("Progress.onComplete").equals("closeCallingTask")) { %>
               realOpener.parent.location = "webacc?taskId=<%= c.var("taskId") %>&taskComplete=true";
            <% } %>
         }
      }

      function requestUpdateProgress(millsecs)
      {
         progress = new exchanger("exchangerFrame");
         progress.sendData("webacc?taskId=<%= c.var("taskId") %>&merge=dev.Exchanger&nextState=progress");
         setTimeout("updateProgress();", millsecs);
      }
   </SCRIPT>
</HEAD>

<BODY onLoad="requestUpdateProgress(0);" onunload="onUnloadHandler();">

   <IFRAME src="/nps/Empty.html" style="visibility: hidden" name="exchangerFrame" id="exchangerFrame" width="0" height="0" marginwidth="0" marginheight="0"></IFRAME>

   <BR>
   <DIV id=progressMessage><%= c.string("Progress.beginingUpdate") %></DIV>

   <TABLE><TR><TD bgcolor="#000000">
      <TABLE bgcolor="#ffffff">
         <TR>
            <TD id=progress1>&nbsp;&nbsp;</TD>
            <TD id=progress2>&nbsp;&nbsp;</TD>
            <TD id=progress3>&nbsp;&nbsp;</TD>
            <TD id=progress4>&nbsp;&nbsp;</TD>
            <TD id=progress5>&nbsp;&nbsp;</TD>
            <TD id=progress6>&nbsp;&nbsp;</TD>
            <TD id=progress7>&nbsp;&nbsp;</TD>
            <TD id=progress8>&nbsp;&nbsp;</TD>
            <TD id=progress9>&nbsp;&nbsp;</TD>
            <TD id=progress10>&nbsp;&nbsp;</TD>
            <TD id=progress11>&nbsp;&nbsp;</TD>
            <TD id=progress12>&nbsp;&nbsp;</TD>
            <TD id=progress13>&nbsp;&nbsp;</TD>
            <TD id=progress14>&nbsp;&nbsp;</TD>
            <TD id=progress15>&nbsp;&nbsp;</TD>
            <TD id=progress16>&nbsp;&nbsp;</TD>
            <TD id=progress17>&nbsp;&nbsp;</TD>
            <TD id=progress18>&nbsp;&nbsp;</TD>
            <TD id=progress19>&nbsp;&nbsp;</TD>
            <TD id=progress20>&nbsp;&nbsp;</TD>
         </TR>
      </TABLE>
   </TD></TR></TABLE>

   <SPAN id=estimatedTime></SPAN><BR><BR>

   <A href="#" onClick="closeButtonPressed();"><IMG id="buttonAtBottom" alt="<%= c.string("Button.Stop.alt") %>" title="<%= c.string("Button.Stop.alt") %>" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Stop.image") %>" border=0></A><BR><BR>

   <DIV id=errorHeader style="display:none"><BR><BR><%= c.string("Progress.errors") %></DIV>
   <DIV id=errorMessages style="width:95%; display:none"></DIV>
</BODY>
</HTML>
