<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8"
   import="com.novell.webaccess.common.JSPConduit,
           com.novell.emframe.dev.eMFrameUtils,
           com.novell.emframe.dev.MContext,
           com.novell.emframe.dev.eMFrameFactory,
           com.novell.application.console.snapin.ObjectEntry,
           com.novell.emframe.fw.RBSUtil" %>

<%
   JSPConduit c = JSPConduit.getJSPConduit(request);

   MContext context = eMFrameFactory.getMContext(request);
   ObjectEntry treeOE = RBSUtil.getTreeOE(context);
   boolean isNVDS = treeOE.getAdminNamespace().isSupported("NVDS");

   c.stringTable("DevResources");
   c.stringTable("FwResources");
%>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>

<iman:stringtable bundle="FwResources"/>
<iman:stringtable bundle="DevResources"/>


<HTML>
<HEAD>
   <iman:eMFrameScripts/>
   <iman:dataTableScripts/>
   <iman:stylesheet/>

   <SCRIPT>

      /*******************
       * FUNCTION HEADER *
       *******************/
      function onPageLoad()
      {
         var form = document.RoleMain;
         var element = document.getElementById(form.selectedTab.value);
         element.style.display = "block";
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function backToCollectionList()
      {
         var form = document.RoleMain;
         iman.debug("In backToCollectionList()");
         form.nextState.value = "backToCollectionList";
         form.merge.value = "fw.CollectionMain";
         form.taskId.value = "fw.RBS Configuration";
         form.submit();
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function showHideTabs(div1, div2, div3, div4, div5)
      {
         var form = document.RoleMain;
         var element1 = document.getElementById(div1);
         var element2 = document.getElementById(div2);
         var element3 = document.getElementById(div3);
         var element4 = document.getElementById(div4);
         var element5 = document.getElementById(div5);

         if(element1.style.display == "none")
         {
            element1.style.display = "block";
            element2.style.display = "none";
            element3.style.display = "none";
            element4.style.display = "none";
            element5.style.display = "none";

            form.selectedTab.value = div1;
            form.nextState.value = "setSelectedTab";
            form.merge.value = "fw.RoleMain";
            form.submit();
         }
      }

/*-----------------------------------------------------------------------------
       -- ROLE --
------------------------------------------------------------------------------/
      /*******************
       * FUNCTION HEADER *
       *******************/
      function roleLinkActionHandler(column, row, tableData)
      {
         showTasks(tableData[row][column]);
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function roleMenuActionHandler(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="RoleNewiManager")
         {
            newiManagerRole();
         }
         else if(menuItemId == "RoleNeweGuide")
         {
            neweGuideRole();
         }
         else if(menuItemId == "RoleNeweGuideNVDS")
         {
            alert("<%= c.string("RBS.FeatureNotSupportedInNVDS") %>");
         }
         else if(menuItemId == "RoleEdit")
         {
            editRole(selectedIndices, tableData);
         }
         else if(menuItemId == "RoleDelete")
         {
            deleteRole(selectedIndices, tableData);
         }
         else if(menuItemId == "RoleAssociations")
         {
            associationsRole(selectedIndices, tableData);
         }
         else if(menuItemId == "CategoryAssignment")
         {
            categoryAssignmentRole(selectedIndices, tableData);
         }
         else if(menuItemId == "RoleDescription")
         {
            descriptionRole(selectedIndices, tableData);
         }
      }

      function urlEncodePack(stringToPack)
      {
      	var encodedStr = urlEncode(stringToPack);
         var packedArray = new Array(1);   
         packedArray[0] =  encodedStr;
         return pack(packedArray);
     }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function newiManagerRole()
      {
         window.location = "frameservice?NPService=fw.LaunchService" +
            "&NPAction=Delegate" +
            "&delegate=fw.Create eDirectory Role" +
            "&launcher=<c:out value="${taskId}"/>" +
            "&lifecycle=Recreate" +
            "&RBSAdmin_TaskDelegate=taskDelegate" +
            "&selectedCollectionName=" + urlEncodePack("<c:out value="${selectedCollectionName}"/>") +
            "&CreateRoleContext=" + urlEncodePack("<c:out value="${selectedCollectionName}"/>");
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function neweGuideRole()
      {
         window.location = "frameservice?NPService=fw.LaunchService" +
            "&NPAction=Delegate" +
            "&delegate=fw.Create eGuide Role" +
            "&launcher=<c:out value="${taskId}"/>" +
            "&lifecycle=Recreate" +
            "&RBSAdmin_TaskDelegate=taskDelegate" +
            "&selectedCollectionName=" + urlEncodePack("<c:out value="${selectedCollectionName}"/>") +
            "&CreateRoleContext=" + urlEncodePack("<c:out value="${selectedCollectionName}"/>");
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function editRole(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            showTasks(tableData[selectedIndices[0]][1]);
         }

         return;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function deleteRole(selectedIndices, tableData)
      {
         if(selectedIndices.length > 0)
         {
            var rolesToDelete = new Array(selectedIndices.length);

            for(var i=0; i < selectedIndices.length; i++)
            {
               var index = selectedIndices[i];
               var listElement = unpack(tableData[index][1]);
               rolesToDelete[i] = urlEncode(listElement[0]);
            }

            if(confirm("<%= c.string("RBS.DeleteRoleObjects") %>"))
            {
               window.location = "frameservice?NPService=fw.LaunchService" +
                                    "&NPAction=Delegate" +
                                    "&delegate=fw.Delete Roles" +
                                    "&launcher=<c:out value="${taskId}"/>" +
                                    "&lifecycle=Recreate" +
                                    "&PackedRolesToDelete=" + pack(rolesToDelete) +
                                    "&nextState=initialState";
            }
         }
         else
         {
            alert("<%= c.string("RBS.CheckOneOrMoreObjectsToPerformOperation") %>");
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function associationsRole(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            var listElement = unpack(tableData[selectedIndices[0]][1]);
            if(listElement[1] == "iManager")
            {
               window.location = "frameservice?NPService=fw.LaunchService" +
                  "&NPAction=Delegate" +
                  "&delegate=fw.Modify eDirectory Roles" +
                  "&launcher=<c:out value="${taskId}"/>" +
                  "&lifecycle=Recreate" +
                  "&SelectedRoleFullName=" + urlEncodePack(listElement[0]) +
                  "&SelectedRoleDisplayName=" + urlEncodePack(listElement[1]) +
                  "&RBSAdmin_RoleType=" + listElement[2] +
                  "&RBSAdmin_TaskDelegate=taskDelegate" +
                  "&merge=fw.ModifyRoleAssociations" +
                  "&nextState=setupModifyAssociationsPage";
            }
            else
            {
               window.location = "frameservice?NPService=fw.LaunchService" +
                  "&NPAction=Delegate" +
                  "&delegate=fw.Modify eGuide Roles" +
                  "&launcher=<c:out value="${taskId}"/>" +
                  "&lifecycle=Recreate" +
                  "&SelectedRoleFullName=" + urlEncodePack(listElement[0]) +
                  "&SelectedRoleDisplayName=" + urlEncodePack(listElement[1]) +
                  "&RBSAdmin_RoleType=" + listElement[2] +
                  "&RBSAdmin_TaskDelegate=taskDelegate" +
                  "&merge=fw.ModifyRoleAssociations" +
                  "&nextState=setupModifyAssociationsPage";
            }
         }
     }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function descriptionRole(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            var listElement = unpack(tableData[selectedIndices[0]][1]);
            window.location = "frameservice?NPService=fw.LaunchService" +
                              "&NPAction=Delegate" +
                              "&delegate=fw.Modify Role Description" +
                              "&launcher=<c:out value="${taskId}"/>" +
                              "&lifecycle=Recreate" +
                              "&ModifyRBSObjectDescriptionName=" + urlEncodePack(listElement[0]) +
                              "&merge=fw.ModifyRBSObjectDescription" +
                              "&nextState=showModifyForm";
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function showTasks(rolePackedData)
      {
         var form = document.RoleMain;
         var listElement = unpack(rolePackedData);

         form.nextState.value = "roleSelected";
         form.merge.value = "fw.ContentMain";
         form.SelectedRoleFullName.value = urlEncodePack(listElement[0]);
         form.SelectedRoleDisplayName.value = urlEncodePack(listElement[1]);
         form.RBSAdmin_RoleType.value = listElement[2];
         form.submit();
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function categoryAssignmentRole(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            var listElement = unpack(tableData[selectedIndices[0]][1]);
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.Modify Role Category Assigment" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&RoleName=" + urlEncodePack(listElement[0]) +
               "&selectedCollectionName=" + urlEncodePack("<c:out value="${selectedCollectionName}"/>") +
               "&merge=fw.ModifyRoleCategoryAssignment" +
               "&nextState=showRoleCategoryAssignment";
         }
      }

/*-----------------------------------------------------------------------------
       -- TASK --
------------------------------------------------------------------------------/
      /*******************
       * FUNCTION HEADER *
       *******************/
      function taskMenuActionHandler(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="TaskNewiManager")
         {
            newiManagerTask();
         }
         else if(menuItemId == "TaskNeweGuide")
         {
            neweGuideTask();
         }
         else if(menuItemId=="TaskNewiManagerNVDS")
         {
            alert("<%= c.string("RBS.FeatureNotSupportedIniManagerInNVDS") %>");
         }
         else if(menuItemId == "TaskNeweGuideNVDS")
         {
            alert("<%= c.string("RBS.FeatureNotSupportedInNVDS") %>");
         }
         else if(menuItemId == "TaskDelete")
         {
            deleteTask(selectedIndices, tableData);
         }
         else if(menuItemId == "TaskRoleAssignment")
         {
            roleAssignmentTask(selectedIndices, tableData);
         }
         else if(menuItemId == "TaskDescription")
         {
            descriptionTask(selectedIndices, tableData);
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function newiManagerTask()
      {
         window.location = "frameservice?NPService=fw.LaunchService" +
            "&NPAction=Delegate" +
            "&delegate=fw.Create iManager Task" +
            "&launcher=<c:out value="${taskId}"/>" +
            "&lifecycle=Recreate" +
            "&RBSAdmin_TaskDelegate=taskDelegate" +
            "&selectedCollectionName=" + urlEncode("<c:out value="${selectedCollectionName}"/>") +
            "&CreateTaskContext=" + urlEncode("<c:out value="${selectedCollectionName}"/>");
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function neweGuideTask()
      {
         window.location = "frameservice?NPService=fw.LaunchService" +
            "&NPAction=Delegate" +
            "&delegate=fw.Create eGuide Task" +
            "&launcher=<c:out value="${taskId}"/>" +
            "&lifecycle=Recreate" +
            "&RBSAdmin_TaskDelegate=taskDelegate" +
            "&selectedCollectionName=" + urlEncodePack("<c:out value="${selectedCollectionName}"/>") +
            "&CreateTaskContext=" + urlEncodePack("<c:out value="${selectedCollectionName}"/>");
      }


      /*******************
       * FUNCTION HEADER *
       *******************/
      function deleteTask(selectedIndices, tableData)
      {
         if(selectedIndices.length > 0)
         {
            var tasksToDelete = new Array(selectedIndices.length);

            for(var i=0; i < selectedIndices.length; i++)
            {
               var index = selectedIndices[i];
               tasksToDelete[i] = urlEncode(tableData[index][1]);
            }

            if(confirm("<%= c.string("RBS.DeleteTaskObjects") %>"))
            {
               window.location = "frameservice?NPService=fw.LaunchService" +
                  "&NPAction=Delegate" +
                  "&delegate=fw.Delete Tasks" +
                  "&launcher=<c:out value="${taskId}"/>" +
                  "&lifecycle=Recreate" +
                  "&PackedTasksToDelete=" + pack(tasksToDelete) +
                  "&nextState=initialState";
            }
         }
         else
         {
            alert("<%= c.string("RBS.CheckOneOrMoreObjectsToPerformOperation") %>");
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function roleAssignmentTask(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.Modify Task Role Assignment" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&TaskName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
               "&merge=fw.ModifyTaskRoleAssignment" +
               "&nextState=showTaskRoleAssignment";
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function descriptionTask(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.Modify Task Description" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&ModifyRBSObjectDescriptionName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
               "&merge=fw.ModifyRBSObjectDescription" +
               "&nextState=showModifyForm";
         }
      }

/*-----------------------------------------------------------------------------
       -- BOOK --
------------------------------------------------------------------------------/
      /*******************
       * FUNCTION HEADER *
       *******************/
      function bookMenuActionHandler(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="BookNew")
         {
            newBook();
         }
         else if(menuItemId=="BookDelete")
         {
            deleteBook(selectedIndices, tableData);
         }
         else if(menuItemId=="BookRoleAssignment")
         {
            roleAssignmentBook(selectedIndices, tableData);
         }
         else if(menuItemId=="BookPageList")
         {
            pageListBook(selectedIndices, tableData);
         }
         else if(menuItemId=="BookObjectType")
         {
            objectTypeBook(selectedIndices, tableData);
         }
         else if(menuItemId=="BookDescription")
         {
            descriptionBook(selectedIndices, tableData);
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function newBook()
      {
         document.RoleMain.nextState.value = "createPropertyBook";
         document.RoleMain.selectedCollectionName.value = urlEncodePack("<c:out value="${selectedCollectionName}"/>");
         document.RoleMain.submit();
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function deleteBook(selectedIndices, tableData)
      {
         if(selectedIndices.length > 0)
         {
            var booksToDelete = new Array(selectedIndices.length);

            for(var i=0; i < selectedIndices.length; i++)
            {
               var index = selectedIndices[i];
               booksToDelete[i] = urlEncode(tableData[index][1]);
            }

            if(confirm("<%= c.string("RBS.DeleteBookObjects") %>"))
            {
               window.location = "frameservice?NPService=fw.LaunchService" +
                  "&NPAction=Delegate" +
                  "&delegate=fw.Delete Books" +
                  "&launcher=<c:out value="${taskId}"/>" +
                  "&lifecycle=Recreate" +
                  "&PackedBooksToDelete=" + pack(booksToDelete) +
                  "&nextState=initialState";
            }
         }
         else
         {
            alert("<%= c.string("RBS.CheckOneOrMoreObjectsToPerformOperation") %>");
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function roleAssignmentBook(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.Modify Book Role Assignment" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&BookName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
               "&merge=fw.ModifyBookRoleAssignment" +
               "&nextState=showBookRoleAssignment";
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function pageListBook(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.Modify Page List" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&BookName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
               "&merge=fw.ModifyBookPageList" +
               "&nextState=showBookPageList";
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function objectTypeBook(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.Modify Object Type" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&BookName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
               "&merge=fw.ModifyBookObjectType" +
               "&nextState=showBookObjectType";
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function descriptionBook(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.Modify Book Description" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&ModifyRBSObjectDescriptionName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
               "&merge=fw.ModifyRBSObjectDescription" +
               "&nextState=showModifyForm";
         }
      }

/*-----------------------------------------------------------------------------
       -- MODULE --
------------------------------------------------------------------------------/
      /*******************
       * FUNCTION HEADER *
       *******************/
      function moduleMenuActionHandler(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="ModuleNew")
         {
            newModule();
         }
         else if(menuItemId=="ModuleDelete")
         {
            deleteModule(selectedIndices, tableData);
         }
         else if(menuItemId=="ModuleDescription")
         {
            descriptionModule(selectedIndices, tableData);
         }

         return;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function newModule()
      {
         window.location = "frameservice?NPService=fw.LaunchService" +
            "&NPAction=Delegate" +
            "&delegate=fw.CreateModule" +
            "&launcher=<c:out value="${taskId}"/>" +
            "&returnID=<c:out value="${taskId}"/>" +
            "&lifecycle=Recreate" +
            "&RBSAdmin_TaskDelegate=taskDelegate" +
            "&selectedCollectionName=" + urlEncode("<c:out value="${selectedCollectionName}"/>") +
            "&nextState=initialState" +
            "&ShowModifyObject=false";
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function deleteModule(selectedIndices, tableData)
      {
         if(selectedIndices.length > 0)
         {
            var modulesToDelete = new Array(selectedIndices.length);

            for(var i=0; i < selectedIndices.length; i++)
            {
               var index = selectedIndices[i];
               modulesToDelete[i] = urlEncode(tableData[index][1]);
            }

            if(confirm("<%= c.string("RBS.DeleteModuleObjects") %>"))
            {
               window.location = "frameservice?NPService=fw.LaunchService" +
                                    "&NPAction=Delegate" +
                                    "&delegate=fw.Delete Module" +
                                    "&launcher=<c:out value="${taskId}"/>" +
                                    "&lifecycle=Recreate" +
                                    "&DeleteObjectName=" + pack(modulesToDelete) +
                                    "&objectTypeName=rbsModule,rbsModule2" +
                                    "&nextState=doDeleteObject";
            }
         }
         else
         {
            alert("<%= c.string("RBS.CheckOneOrMoreObjectsToPerformOperation") %>");
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function descriptionModule(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.Modify Module Description" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&ModifyRBSObjectDescriptionName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
               "&merge=fw.ModifyRBSObjectDescription" +
               "&nextState=showModifyForm";
         }
      }

/*-----------------------------------------------------------------------------
       -- CATEGORY --
------------------------------------------------------------------------------/
      /*******************
       * FUNCTION HEADER *
       *******************/
      function categoryMenuActionHandler(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="CategoryNew")
         {
            newCategory();
         }
         else if(menuItemId=="CategoryDelete")
         {
            deleteCategory(selectedIndices, tableData);
         }
         else if(menuItemId=="CategoryDescription")
         {
            descriptionCategory(selectedIndices, tableData);
         }
         else if(menuItemId=="CategoryRoleAssignment")
         {
            roleAssignmentCategory(selectedIndices, tableData);
         }

         return;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function newCategory()
      {
         window.location = "frameservice?NPService=fw.LaunchService" +
            "&NPAction=Delegate" +
            "&delegate=fw.Create Category" +
            "&launcher=<c:out value="${taskId}"/>" +
            "&returnID=<c:out value="${taskId}"/>" +
            "&lifecycle=Recreate" +
            "&selectedCollectionName=" + urlEncodePack("<c:out value="${selectedCollectionName}"/>") +
            "&merge=fw.CreateCategory" +
            "&nextState=startCategoryWizard";
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function deleteCategory(selectedIndices, tableData)
      {
         if(selectedIndices.length > 0)
         {
            var categoriesToDelete = new Array(selectedIndices.length);

            for(var i=0; i < selectedIndices.length; i++)
            {
               var index = selectedIndices[i];
               categoriesToDelete[i] = urlEncode(tableData[index][1]);
            }

            if(confirm("<%= c.string("RBS.DeleteCategoryObjects") %>"))
            {
               window.location = "frameservice?NPService=fw.LaunchService" +
                                    "&NPAction=Delegate" +
                                    "&delegate=fw.Delete Categories" +
                                    "&launcher=<c:out value="${taskId}"/>" +
                                    "&lifecycle=Recreate" +
                                    "&PackedCategoriesToDelete=" + pack(categoriesToDelete) +
                                    "&nextState=initialState";
            }
         }
         else
         {
            alert("<%= c.string("RBS.CheckOneOrMoreObjectsToPerformOperation") %>");
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function roleAssignmentCategory(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.Modify Category Role Assigment" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&CategoryName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
               "&selectedCollectionName=" + urlEncodePack("<c:out value="${selectedCollectionName}"/>") +
               "&merge=fw.ModifyCategoryRoleAssignment" +
               "&nextState=showCategoryRoleAssignment";
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function descriptionCategory(selectedIndices, tableData)
      {
         if(selectedIndices.length == 0)
         {
            alert("<%= c.string("RBS.CheckOneObjectToPerformOperation") %>");
         }
         else if(selectedIndices.length > 1)
         {
            alert("<%= c.string("RBS.CheckOnlyOneObjectToPerformOperation") %>");
         }
         else
         {
            window.location = "frameservice?NPService=fw.LaunchService" +
               "&NPAction=Delegate" +
               "&delegate=fw.Modify Category Description" +
               "&launcher=<c:out value="${taskId}"/>" +
               "&lifecycle=Recreate" +
               "&ModifyRBSObjectDescriptionName=" + urlEncodePack(tableData[selectedIndices[0]][1]) +
               "&merge=fw.ModifyRBSObjectDescription" +
               "&nextState=showModifyForm";
         }
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function roleSortHandler(tableName, column, direction, tableData)
      {
         var form = document.RoleMain;
         form.nextState.value = "roleSortHandler";
         form.sortRoleColumn.value = column;
         form.sortRoleDirection.value = direction;
         form.merge.value = "fw.RoleMain";
         form.submit();
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function taskSortHandler(tableName, column, direction, tableData)
      {
         var form = document.RoleMain;
         form.nextState.value = "taskSortHandler";
         form.sortTaskColumn.value = column;
         form.sortTaskDirection.value = direction;
         form.merge.value = "fw.RoleMain";
         form.submit();
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function bookSortHandler(tableName, column, direction, tableData)
      {
         var form = document.RoleMain;
         form.nextState.value = "bookSortHandler";
         form.sortBookColumn.value = column;
         form.sortBookDirection.value = direction;
         form.merge.value = "fw.RoleMain";
         form.submit();
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function moduleSortHandler(tableName, column, direction, tableData)
      {
         var form = document.RoleMain;
         form.nextState.value = "moduleSortHandler";
         form.sortModuleColumn.value = column;
         form.sortModuleDirection.value = direction;
         form.merge.value = "fw.RoleMain";
         form.submit();
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function categorySortHandler(tableName, column, direction, tableData)
      {
         var form = document.RoleMain;
         form.nextState.value = "categorySortHandler";
         form.sortCategoryColumn.value = column;
         form.sortCategoryDirection.value = direction;
         form.merge.value = "fw.RoleMain";
         form.submit();
      }

   </SCRIPT>
</HEAD>

<BODY onLoad="onPageLoad()">
<FORM name="RoleMain">
   <INPUT type="hidden" name="nextState" value="<c:out value="${nextState}"/>">
   <INPUT type="hidden" name="SelectedRoleFullName">
   <INPUT type="hidden" name="SelectedRoleDisplayName">
   <INPUT type="hidden" name="selectedCollectionName" value="<c:out value="${selectedCollectionName}"/>">
   <INPUT type="hidden" name="taskId" value="<c:out value="${taskId}"/>">
   <INPUT type="hidden" name="merge">
   <INPUT type="hidden" name="error" value="dev.GenErr">
   <INPUT type="hidden" name="selectedTab" value="<c:out value="${selectedTab}"/>">
   <INPUT type="hidden" name="CreateRoleContext">
   <INPUT type="hidden" name="RBSAdmin_RoleType">
   <INPUT type="hidden" name="sortRoleColumn" value="<c:out value="${sortRoleColumn}"/>">
   <INPUT type="hidden" name="sortRoleDirection" value="<c:out value="${sortRoleDirection}"/>">
   <INPUT type="hidden" name="sortTaskColumn" value="<c:out value="${sortTaskColumn}"/>">
   <INPUT type="hidden" name="sortTaskDirection" value="<c:out value="${sortTaskDirection}"/>">
   <INPUT type="hidden" name="sortBookColumn" value="<c:out value="${sortBookColumn}"/>">
   <INPUT type="hidden" name="sortBookDirection" value="<c:out value="${sortBookDirection}"/>">
   <INPUT type="hidden" name="sortModuleColumn" value="<c:out value="${sortModuleColumn}"/>">
   <INPUT type="hidden" name="sortModuleDirection" value="<c:out value="${sortModuleDirection}"/>">
   <INPUT type="hidden" name="sortCategoryColumn" value="<c:out value="${sortCategoryColumn}"/>">
   <INPUT type="hidden" name="sortCategoryDirection" value="<c:out value="${sorCategorytDirection}"/>">
   <INPUT type="hidden" name="fw_fromId" value="<c:out value="${fw_respId}"/>">
   <INPUT type="hidden" name="fw_from" value="<c:out value="RoleMain"/>">

	<div class="smalltext" style="margin-bottom: 1em">
	   <a href="#" onClick="backToCollectionList()" ><iman:string key="RBS.Configuration"/></a><img src="/nps/portal/modules/dev/images/breadspace.gif" width="17" height="9" border="0" align="absmiddle"><iman:string key="RBS.Collection"/>
   </div>
         </div>
         <%
            c.set("taskHeaderTitle", c.string("RBS.CollectionColon") + " " + c.var("selectedCollectionName"));
         %>
         <iman:taskHeader title="${taskHeaderTitle}" iconUrl="dev/dir/rbsCollection2.gif" helpFile="fw/rolemain.html" /><BR>
         <iman:include page="dev/Messagebar_inc.jsp"/>
   <div class="formdescriptextml0" style="width: 80%"><iman:string key="RBS.CollectionInstructions"/></div>
   <div id="packagetable" class="margintop3">

<!----------- ROLE ----- ROLE ----- ROLE ------------------------------------------------------------------------------>
<!--------------------------------------------------------------------------------------------------------------------->
   <div id="roletab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="0">
         <iman:tab textKey="RBS.Role" onClick="showHideTabs('roletab','tasktab','booktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.Task" onClick="showHideTabs('tasktab','roletab','booktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.PropertyBook" onClick="showHideTabs('booktab','roletab','tasktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.Module" onClick="showHideTabs('moduletab','roletab','tasktab','booktab','categorytab')"/>
         <iman:tab textKey="RBS.Category" onClick="showHideTabs('categorytab','moduletab','roletab','tasktab','booktab')"/>
      </iman:tabSet>
      <iman:dataTable id="roleTable" tableData="${tableData}" menuActionHandler="roleMenuActionHandler" linkActionHandler="roleLinkActionHandler" sortHandler="roleSortHandler" sortedColumn="${sortRoleColumn}" sortedDirection="${sortRoleDirection}">
         <iman:menuItem textKey="RBS.New" id="New">
            <iman:menuItem textKey="RBS.iManagerRole" id="RoleNewiManager"/>
            <% if(isNVDS == false) { %>
               <iman:menuItem textKey="RBS.eGuideRole" id="RoleNeweGuide"/>
            <% } else { %>
               <iman:menuItem textKey="RBS.eGuideRole" id="RoleNeweGuideNVDS"/>
            <% } %>

         </iman:menuItem>
         <iman:menuItem textKey="RBS.Edit" id="RoleEdit"/>
         <iman:menuItem textKey="RBS.Delete" id="RoleDelete"/>
         <iman:menuItem textKey="RBS.Actions" id="Actions">
            <iman:menuItem textKey="RBS.Associations" id="RoleAssociations"/>
            <iman:menuItem textKey="RBS.CategoryAssignment" id="CategoryAssignment"/>
            <iman:menuItem textKey="RBS.Description" id="RoleDescription"/>
         </iman:menuItem>

         <iman:columnHeader textKey="RBS.Type" sortable="false"/>
         <iman:columnHeader textKey="RBS.Name"/>
         <iman:columnHeader textKey="RBS.Module"/>
         <iman:columnHeader textKey="RBS.InitialVersion"/>
         <iman:columnHeader textKey="RBS.ExpiredVersion"/>

      </iman:dataTable>
   </div>

<!----------- TASK ----- TASK ----- TASK ------------------------------------------------------------------------------>
<!--------------------------------------------------------------------------------------------------------------------->
   <div id="tasktab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="1">
         <iman:tab textKey="RBS.Role" onClick="showHideTabs('roletab','tasktab','booktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.Task" onClick="showHideTabs('tasktab','roletab','booktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.PropertyBook" onClick="showHideTabs('booktab','roletab','tasktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.Module" onClick="showHideTabs('moduletab','roletab','tasktab','booktab','categorytab')"/>
         <iman:tab textKey="RBS.Category" onClick="showHideTabs('categorytab','moduletab','roletab','tasktab','booktab')"/>
      </iman:tabSet>
      <iman:dataTable id="taskTable" tableData="${tableData}" menuActionHandler="taskMenuActionHandler" sortHandler="taskSortHandler" sortedColumn="${sortTaskColumn}" sortedDirection="${sortTaskDirection}">
         <% if(isNVDS == false) { %>
            <iman:menuItem textKey="RBS.New" id="New">
               <iman:menuItem textKey="RBS.iManagerTask" id="TaskNewiManager"/>
               <iman:menuItem textKey="RBS.eGuideTask" id="TaskNeweGuide"/>
            </iman:menuItem>
            <% } else { %>
            <iman:menuItem textKey="RBS.New" id="New">
               <iman:menuItem textKey="RBS.iManagerTask" id="TaskNewiManagerNVDS"/>
               <iman:menuItem textKey="RBS.eGuideTask" id="TaskNeweGuideNVDS"/>
            </iman:menuItem>
         <% } %>
         <iman:menuItem textKey="RBS.Delete" id="TaskDelete"/>
         <iman:menuItem textKey="RBS.Actions" id="Actions">
            <iman:menuItem textKey="RBS.RoleAssignment" id="TaskRoleAssignment"/>
            <iman:menuItem textKey="RBS.Description" id="TaskDescription"/>
         </iman:menuItem>

         <iman:columnHeader textKey="RBS.Type" sortable="false"/>
         <iman:columnHeader textKey="RBS.Name"/>
         <iman:columnHeader textKey="RBS.Module"/>
         <iman:columnHeader textKey="RBS.InitialVersion"/>
         <iman:columnHeader textKey="RBS.ExpiredVersion"/>
      </iman:dataTable>
   </div>

<!----------- BOOK ----- BOOK ----- BOOK ------------------------------------------------------------------------------>
<!--------------------------------------------------------------------------------------------------------------------->
   <div id="booktab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="2">
         <iman:tab textKey="RBS.Role" onClick="showHideTabs('roletab','tasktab','booktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.Task" onClick="showHideTabs('tasktab','roletab','booktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.PropertyBook" onClick="showHideTabs('booktab','roletab','tasktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.Module" onClick="showHideTabs('moduletab','roletab','tasktab','booktab','categorytab')"/>
         <iman:tab textKey="RBS.Category" onClick="showHideTabs('categorytab','moduletab','roletab','tasktab','booktab')"/>
      </iman:tabSet>
      <iman:dataTable id="bookTable" tableData="${tableData}" menuActionHandler="bookMenuActionHandler" sortHandler="bookSortHandler" sortedColumn="${sortBookColumn}" sortedDirection="${sortBookDirection}">
         <iman:menuItem textKey="RBS.New" id="BookNew"/>
         <iman:menuItem textKey="RBS.Delete" id="BookDelete"/>
         <iman:menuItem textKey="RBS.Actions" id="Actions">
            <iman:menuItem textKey="RBS.RoleAssignment" id="BookRoleAssignment"/>
            <iman:menuItem textKey="RBS.PageList" id="BookPageList"/>
            <iman:menuItem textKey="RBS.ObjectType" id="BookObjectType"/>
            <iman:menuItem textKey="RBS.Description" id="BookDescription"/>
         </iman:menuItem>

         <iman:columnHeader textKey="RBS.Type" sortable="false"/>
         <iman:columnHeader textKey="RBS.Name"/>
         <iman:columnHeader textKey="RBS.Module"/>
         <iman:columnHeader textKey="RBS.InitialVersion"/>
         <iman:columnHeader textKey="RBS.ExpiredVersion"/>
      </iman:dataTable>   </div>

<!----------- MODULE ----- MODULE ----- MODULE ------------------------------------------------------------------------>
<!--------------------------------------------------------------------------------------------------------------------->
   <div id="moduletab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="3">
         <iman:tab textKey="RBS.Role" onClick="showHideTabs('roletab','tasktab','booktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.Task" onClick="showHideTabs('tasktab','roletab','booktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.PropertyBook" onClick="showHideTabs('booktab','roletab','tasktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.Module" onClick="showHideTabs('moduletab','roletab','tasktab','booktab','categorytab')"/>
         <iman:tab textKey="RBS.Category" onClick="showHideTabs('categorytab','moduletab','roletab','tasktab','booktab')"/>
      </iman:tabSet>
      <iman:dataTable id="moduleTable" tableData="${tableData}" menuActionHandler="moduleMenuActionHandler" sortHandler="moduleSortHandler" sortedColumn="${sortModuleColumn}" sortedDirection="${sortModuleDirection}">
         <iman:menuItem textKey="RBS.New" id="ModuleNew"/>
         <iman:menuItem textKey="RBS.Delete" id="ModuleDelete"/>
         <iman:menuItem textKey="RBS.Actions" id="Actions">
            <iman:menuItem textKey="RBS.Description" id="ModuleDescription"/>
         </iman:menuItem>

         <iman:columnHeader textKey="RBS.Type" sortable="false"/>
         <iman:columnHeader textKey="RBS.Name"/>
      </iman:dataTable>
   </div>

<!----------- CATEGORY ----- CATEGORY ----- CATEGORY ------------------------------------------------------------------>
<!--------------------------------------------------------------------------------------------------------------------->
   <div id="categorytab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="4">
         <iman:tab textKey="RBS.Role" onClick="showHideTabs('roletab','tasktab','booktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.Task" onClick="showHideTabs('tasktab','roletab','booktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.PropertyBook" onClick="showHideTabs('booktab','roletab','tasktab','moduletab','categorytab')"/>
         <iman:tab textKey="RBS.Module" onClick="showHideTabs('moduletab','roletab','tasktab','booktab','categorytab')"/>
         <iman:tab textKey="RBS.Category" onClick="showHideTabs('categorytab','moduletab','roletab','tasktab','booktab')"/>
      </iman:tabSet>
      <iman:dataTable id="categoryTable" tableData="${tableData}" menuActionHandler="categoryMenuActionHandler" sortHandler="categorySortHandler" sortedColumn="${sortCategoryColumn}" sortedDirection="${sortCategoryDirection}">
         <iman:menuItem textKey="RBS.New" id="CategoryNew"/>
         <iman:menuItem textKey="RBS.Delete" id="CategoryDelete"/>
         <iman:menuItem textKey="RBS.Actions" id="Actions">
            <iman:menuItem textKey="RBS.RoleAssignment" id="CategoryRoleAssignment"/>
            <iman:menuItem textKey="RBS.Description" id="CategoryDescription"/>
         </iman:menuItem>

         <iman:columnHeader textKey="RBS.Type" sortable="false"/>
         <iman:columnHeader textKey="RBS.Name"/>
         <iman:columnHeader textKey="RBS.Module"/>
      </iman:dataTable>
   </div>
   <iman:bar/>
   <iman:button key="Close" onClick="backToCollectionList(); return false;"/>

</FORM>
</BODY>
</HTML>
