<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8"
   import="com.novell.webaccess.common.JSPConduit,
           com.novell.emframe.fw.LookAndFeelDefaults" %>

<%
   JSPConduit c = JSPConduit.getJSPConduit(request);
//   c.stringTable("DevResources");
//   c.stringTable("FwResources");

String[] RBSTreeListParam = (String[])request.getAttribute("RBSTreeListParam");
String[] AuthTreeListParam = (String[])request.getAttribute("AuthTreeListParam");
%>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>

<iman:stringtable bundle="FwResources"/>
<iman:stringtable bundle="DevResources"/>



<%@page import="com.novell.emframe.fw.config.ModuleManager"%>
<%@page import="com.novell.emframe.dev.config.SystemConfig"%>
<%@page import="com.novell.emframe.fw.FwUtils"%>
<html>
<HEAD>
   <iman:eMFrameScripts/>
   <iman:osScripts/>
   <iman:mvedScripts mode="mvsel"/>
   <c:if test="${DeviceType=='browser'}">
      <iman:mvedScripts mode="mvie"/>
   </c:if>
   <iman:include page="dev/PageScripts_inc.jsp"/>
   <iman:stylesheet/>
   <iman:validationScripts/>
   
   <SCRIPT src="<c:out value="${ContextPath}" />/portal/modules/fw/javascripts/SelectHelpers.js"></SCRIPT>
   <SCRIPT language="JavaScript" src="<%= c.getModulesUrl() + "/dev/javascripts/" %>Interval.js"></SCRIPT>
   
   <SCRIPT>

   var ENABLED_COLOR = "white";
   var DISABLED_COLOR = "#EFEEEC";
   var blockPrevAuthInfoOnFocus = false;
   var formChanged = false;
   
    // if no lowerBound or upperBound, will still verify is number
	function validateInteger(intStr, lowerBound, upperBound)
	{
	   // allow textfields to be empty
	   if(intStr=="")
	   {
	      return true;
	   }
	
	   var val = Number(intStr);
	   var top = (typeof upperBound == "number" ? upperBound : 99999999999);
	   var bottom = (typeof lowerBound == "number" ? lowerBound : -99999999999);
	
	   if (intStr == "")
	   {
	      alert(formatMessage(window.rc_invalidNumberMsg, [bottom, top]));
	      return false;
	   }
	
	   if(isNaN(val) || val>top || val<bottom)
	   {
	      alert(formatMessage(window.rc_invalidNumberMsg, [bottom, top]));
	      return false;
	   }
	
	   return true;
	}
	
	function validateIntegerField(field, low, high)
	{
	   if(!validateInteger(field.value, low, high))
	   {
	      field.focus();
	      field.value=low;
	      return false;
	   }
	   return true;
	}
   

   function changed()
   {
   	formChanged = true;
   }

   function disableContainers()
   {
      
   	mvselDisable("AuthSearchContainers");
    mvLoadFromPack("AuthSearchContainers", pack(new Array()));
   	
   }

   function enableContainers()
   {
   	mvselEnable("AuthSearchContainers");
   }
    

    function checkInitial(){
        if(document.SysConfig.SecurityEnableNSureAuditAuthorizedUsers.checked
           && document.SysConfig.SecurityEnableNSureAuditFailedSSLConnection.checked
           && document.SysConfig.SecurityEnableNSureAuditLoginFailed.checked
           && document.SysConfig.SecurityEnableNSureAuditLoginSuccess.checked
           && document.SysConfig.SecurityEnableNSureAuditLogout.checked
           && document.SysConfig.SecurityEnableNSureAuditNPMFailedInstall.checked
           && document.SysConfig.SecurityEnableNSureAuditNPMInstalled.checked
           && document.SysConfig.SecurityEnableNSureAuditChangedConfiguration.checked
           && document.SysConfig.SecurityEnableNSureAuditShutdown.checked
           && document.SysConfig.SecurityEnableNSureAuditStartup.checked
           ){
        	document.SysConfig.SecurityNSureAuditSelectAll.checked='true';
        }
    }

   function disableAudit()
   {
  	
   	if(document.SysConfig.SecurityEnableNSureAudit.checked)
   	{
   		document.SysConfig.SecurityEnableNSureAuditAuthorizedUsers.disabled=false;
   		document.SysConfig.SecurityEnableNSureAuditFailedSSLConnection.disabled=false;
   		document.SysConfig.SecurityEnableNSureAuditLoginFailed.disabled=false;
   		document.SysConfig.SecurityEnableNSureAuditLoginSuccess.disabled=false;
   		document.SysConfig.SecurityEnableNSureAuditLogout.disabled=false;
   		document.SysConfig.SecurityEnableNSureAuditNPMFailedInstall.disabled=false;
   		document.SysConfig.SecurityEnableNSureAuditNPMInstalled.disabled=false;
   		document.SysConfig.SecurityEnableNSureAuditChangedConfiguration.disabled=false;
   		document.SysConfig.SecurityEnableNSureAuditStartup.disabled=false;
   		document.SysConfig.SecurityEnableNSureAuditShutdown.disabled=false;
         document.SysConfig.SecurityNSureAuditSelectAll.disabled=false;
   	}else
   	{
   		document.SysConfig.SecurityEnableNSureAuditAuthorizedUsers.disabled=true;
   		document.SysConfig.SecurityEnableNSureAuditFailedSSLConnection.disabled=true;
   		document.SysConfig.SecurityEnableNSureAuditLoginFailed.disabled=true;
   		document.SysConfig.SecurityEnableNSureAuditLoginSuccess.disabled=true;
   		document.SysConfig.SecurityEnableNSureAuditLogout.disabled=true;
   		document.SysConfig.SecurityEnableNSureAuditNPMFailedInstall.disabled=true;
   		document.SysConfig.SecurityEnableNSureAuditNPMInstalled.disabled=true;
   		document.SysConfig.SecurityEnableNSureAuditChangedConfiguration.disabled=true;
   		document.SysConfig.SecurityEnableNSureAuditStartup.disabled=true;
   		document.SysConfig.SecurityEnableNSureAuditShutdown.disabled=true;
         document.SysConfig.SecurityNSureAuditSelectAll.disabled=true;
   	}
   }
   
   function checkAllAudit()
   {
    
      if(document.SysConfig.SecurityNSureAuditSelectAll.checked)
      {
	      document.SysConfig.SecurityEnableNSureAuditAuthorizedUsers.checked=true;
	      document.SysConfig.SecurityEnableNSureAuditFailedSSLConnection.checked=true;
	      document.SysConfig.SecurityEnableNSureAuditLoginFailed.checked=true;
	      document.SysConfig.SecurityEnableNSureAuditLoginSuccess.checked=true;
	      document.SysConfig.SecurityEnableNSureAuditLogout.checked=true;
	      document.SysConfig.SecurityEnableNSureAuditNPMFailedInstall.checked=true;
	      document.SysConfig.SecurityEnableNSureAuditNPMInstalled.checked=true;
	      document.SysConfig.SecurityEnableNSureAuditChangedConfiguration.checked=true;
	      document.SysConfig.SecurityEnableNSureAuditStartup.checked=true;
	      document.SysConfig.SecurityEnableNSureAuditShutdown.checked=true;
      }
      else
      {
         document.SysConfig.SecurityEnableNSureAuditAuthorizedUsers.checked=false;
         document.SysConfig.SecurityEnableNSureAuditFailedSSLConnection.checked=false;
         document.SysConfig.SecurityEnableNSureAuditLoginFailed.checked=false;
         document.SysConfig.SecurityEnableNSureAuditLoginSuccess.checked=false;
         document.SysConfig.SecurityEnableNSureAuditLogout.checked=false;
         document.SysConfig.SecurityEnableNSureAuditNPMFailedInstall.checked=false;
         document.SysConfig.SecurityEnableNSureAuditNPMInstalled.checked=false;
         document.SysConfig.SecurityEnableNSureAuditChangedConfiguration.checked=false;
         document.SysConfig.SecurityEnableNSureAuditStartup.checked=false;
         document.SysConfig.SecurityEnableNSureAuditShutdown.checked=false;
      }
   }

   function onPageLoad()
   {
      var form = document.SysConfig;
      toggleDiv(form.selectedTab.value, 'block');

      initLogging();
      initRBS();
      initAuth();
      initMisc();
      disableAudit();

   }

   function toggleDiv(id, hideOrShow)
   {
      document.getElementById(id).style.display = hideOrShow;
   }

   function showHideTabs(div1, div2, div3, div4, div5, div6, div7)
   {
      var form = document.SysConfig;
      var element1 = document.getElementById(div1);
      var element2 = document.getElementById(div2);
      var element3 = document.getElementById(div3);
      var element4 = document.getElementById(div4);
      var element5 = document.getElementById(div5);
      var element6 = document.getElementById(div6);
      var element7 = document.getElementById(div7);


      if(element1.style.display == "none")
      {
         element1.style.display = "block";
         element2.style.display = "none";
         element3.style.display = "none";
         element4.style.display = "none";
         element5.style.display = "none";
         element6.style.display = "none";
         element7.style.display = "none";

         form.selectedTab.value = div1;
      }
   }
   
   function Validate_DownloadURL()
   {
   	  var form = document.SysConfig;
   	  if(form.ShouldModuleDownload.checked == true && form.DownloadModulesOption[1].checked && (form.DownloadURL.value == "" || form.DownloadURL.value.length == 0))
      {
      		alert("<iman:toScript><iman:string key="SysConfig.DownloadURLAlert" /></iman:toScript>");
      		return false;
      }
      return true;
   }
   

   function isPageValid()
   {
   		var valid = true;
   		  		
   		if (!ValidateColorInputs(document.SysConfig.LookAndFeel_MenuColor))
   		{
	   		document.SysConfig.LookAndFeel_MenuColor.value = "<iman:resultString key="LookAndFeel_MenuColor"/>";
	   	  	valid = false;
   		}
   		if (!ValidateColorInputs(document.SysConfig.LookAndFeel_MenuHeaderColor))
   		{
   			document.SysConfig.LookAndFeel_MenuHeaderColor.value = "<iman:resultString key="LookAndFeel_MenuHeaderColor"/>";
			valid = false; 
   		} 
   		if (!valid)
   		{
   			alert("<iman:string key="SysConfig.LAFMenuHeaderColorDesc"/>");
   		
   		}
   		if (!Validate_FilePaths())
   		{
   			valid = false;
   		}
   		if (!Validate_PostLogout())
   		{
   			valid = false;	
   		}
   		if (!Validate_DownloadURL())
   		{
   			valid = false;	
   		}
   		if (document.SysConfig.ModulesDownloadEnableProxy.checked)
   		{
	   		if (!validate_ProxySettings())
	   		{
	   			valid= false;
	   		
	   		}
   		}
   		
   		if (!document.SysConfig.NeverTimeout.checked && iman.trim(document.SysConfig._ServerTimeoutSettingsDays.value)=='0' && iman.trim(document.SysConfig._ServerTimeoutSettingsHours.value)=='0' && iman.trim(document.SysConfig._ServerTimeoutSettingsMinutes.value)=='0' )
   		{
   			alert('<iman:string key="SysConfig.TimeoutAllZeroError" />');
   			valid= false;
   		}
   		
   		
   	
   		return valid;
   }
   
   function isReadyToSave()
   {
   	if (!isPageValid())
   	{
		return false;
   	}

   	if(formChanged == false)
   	{
			alert('<iman:string key="PropertyBook.noChanges" />');
   	   	return false;
   	}
      if (bPasswordChanged)
      {
         if (checkPasswords() == false)
            return false;
      }
      if (checkAuthorizedUsers() == false)
         return false;

      return true;
   }

   function saveConfig()
   {
      if (isReadyToSave())
      {
         saveRBS();
         saveAuth();
         saveSecurity();
         document.SysConfig.nextState.value = "SaveConfiguration";
         document.SysConfig.merge.value = "fw.SystemConfigurationPage1";
         document.SysConfig.submit();
       	<% 
       	    ModuleManager.resetCache(true);
            ModuleManager.readModulesToInstall();
       	%>
      }

   }

   function enableSettings(control)
   {
      if (control.value == 'false' || control.checked == false)
      {
         control.checked = true;
         control.value = 'true';
      }
      else
      {
         control.checked = false;
         control.value = 'false';
      }
   }


   function enableCheckBoxes(control)
   {
      if (control.checked)
      {
         control.value = 'true';
      }
      else
      {
         control.value = 'false';
      }
   }


/******************* Security *********************/

   function checkAuthorizedUsers()
   {
      var arrAuthUser = unpack(mvGetValuesAsPack("SecurityAuthorizedUsers"));
      if (arrAuthUser.length == 0)
      {
         alert("<iman:toScript><iman:string key="SysConfig.EmptyAuthorizedUsers" /></iman:toScript>");
         return false;
      }
      return true;
   }



/******************* Look and Feel *********************/

   function resetLookAndFeelToDefaults()
   {
      document.SysConfig.LookAndFeel_OrganizationName.value = "<%= LookAndFeelDefaults.OrganizationName %>";
      document.SysConfig.LookAndFeel_iManagerHeaderBackgroundImage.value = "<%= LookAndFeelDefaults.HeaderBackgroundImage %>";
      document.SysConfig.LookAndFeel_iManagerHeaderFillerImage.value = "<%= LookAndFeelDefaults.HeaderFillerImage %>";
      document.SysConfig.LookAndFeel_iManagerBrandingImage.value = "<%= LookAndFeelDefaults.BrandingImage %>";
      document.SysConfig.LookAndFeel_MenuHeaderColor.value = "<%= LookAndFeelDefaults.MenuHeaderColor %>";
      document.SysConfig.LookAndFeel_MenuColor.value = "<%= LookAndFeelDefaults.MenuColor %>";      
      document.SysConfig.LookAndFeel_HomeImage.value = "<%= LookAndFeelDefaults.HomeImage %>";
      document.SysConfig.LookAndFeel_ShowHomeImage.value = "<%= LookAndFeelDefaults.ShowHomeImage %>";
   }

   function ValidateColorInputs(InputField)
   {

   	  var val = InputField.value;
   	  var valid = true;

   	  if (validateHex(val,false))//if value is hex
   	  {
   	  	if (val.charAt(0)!="#")//add a preceding '#'
   	  		InputField.value = "#" + val;
   	  	valid = (InputField.value.length == 7);//verify that length is exactly 7 "#RRGGBB"

   	  }
   	  else
   	  {
   	  	val = InputField.value.toLowerCase();
   	  	var colors = {aqua:0, black:0, blue:0, fuchsia:0, gray:0, green:0, lime:0, maroon:0, navy:0,
			olive:0, purple:0, red:0, silver:0, teal:0, white:0, yellow:0}

   	  	var color = colors[val];//this returns null if the index val is not found

   	  	valid = (color != null);
   	  }

   	  if (valid)
   	  	changed();

   	  return valid;

   }
   
   function Validate_FilePaths()
   {
   		var valid = true;
   		var errmsg = "";
   		
   		var value1 = document.SysConfig.LookAndFeel_iManagerHeaderBackgroundImage.value;
   		if (value1 == "")
   		{
   			valid = false;
   			errmsg += "<iman:string key='SysConfig.LAFHeaderImgLoc'/> <iman:string key='SysConfig.LAFBlankFilePath'/>";
   		}
   			
   		var value2 = document.SysConfig.LookAndFeel_iManagerHeaderFillerImage.value;
   		if (value2 == "")
   		{
   			valid = false;
   			errmsg += "\n<iman:string key='SysConfig.LAFHeaderFillerImgLoc'/> <iman:string key='SysConfig.LAFBlankFilePath'/>";
   		}
   			
   		var value3 = document.SysConfig.LookAndFeel_iManagerBrandingImage.value;
   		if (value3 == "")
   		{
   			valid = false;
   			errmsg += "\n<iman:string key='SysConfig.LAFBrandingImgLoc'/> <iman:string key='SysConfig.LAFBlankFilePath'/>";
   		}
   		if (!valid)
   			alert(errmsg);   			
   		
   		return valid;   
   }


/******************* Logging *********************/

   var loggingLevel = "<c:out value='${loggingLevel}' />";
   var loggingToErr = <c:out value="${loggingToErr}" />;
   var loggingToOut = <c:out value="${loggingToOut}" />;
   var loggingToFile = <c:out value="${loggingToFile}" />;

   function initLogging()
   {
      if(loggingLevel=="0")
      {
         enableLoggingSettings(false);
      }
      else
      {
         enableLoggingSettings(true);
      }
   }

   function enableLoggingSettings(enable)
   {
      document.SysConfig.loggingToErr.disabled=!enable;
      document.SysConfig.loggingToOut.disabled=!enable;
      document.SysConfig.loggingToFile.disabled=!enable;
   }

   function loggingDoAction(state)
   {
      document.SysConfig.nextState.value=state;
      document.SysConfig.submit();
   }


/******************* RBS *********************/

   function initRBS()
   {
      <!--   RBSRoleDiscovery  -->
      var value = "<c:out value="${RBSRoleDiscovery}"/>";
      var options = document.SysConfig.RBSRoleDiscoveryList.options;
      if(value)
      {
         for (var i = 0; i < document.SysConfig.RBSRoleDiscoveryList.length; i++)
         {
            if (value == options[i].text.toLowerCase())
            {
               options[i].selected=true;
               document.SysConfig.RBSRoleDiscoveryList[i].selected = true;
               document.SysConfig.RBSRoleDiscovery.value = value;
            }
         }
      }
      else
      {
         document.SysConfig.RBSRoleDiscoveryList[0].selected=true;
      }

      <!--  RBSGroupDiscovery  -->
      var value = "<c:out value="${RBSGroupDiscovery}"/>";
      var options = document.SysConfig.RBSGroupDiscoveryList.options;
      if(value)
      {
         for (var i = 0; i < document.SysConfig.RBSGroupDiscoveryList.length; i++)
         {
            if (value == options[i].text.toLowerCase())
            {
              options[i].selected=true;
              document.SysConfig.RBSGroupDiscoveryList[i].selected=true;
              document.SysConfig.RBSGroupDiscovery.value=value;
            }
         }
      }
      else
      {
         document.SysConfig.RBSGroupDiscoveryList[0].selected=true;
      }

      <!--  RBSGroupSearchType   -->
      var value = "<iman:toScript><iman:resultString key="RBSGroupSearchType" /></iman:toScript>" ;
      var options = document.SysConfig.RBSGroupSearchTypeList.options;
      if(value)
      {
         for (var i = 0; i < document.SysConfig.RBSGroupSearchTypeList.length; i++)
         {
            if (value == options[i].text)
            {
              document.SysConfig.RBSGroupSearchTypeList[i].selected=true;
              document.SysConfig.RBSGroupSearchType.value=value;
            }
         }
      }
      else
      {
         document.SysConfig.RBSGroupSearchTypeList[0].selected=true;
      }

   }


   function updateRBSRoleDiscovery()
   {
      var index = document.SysConfig.RBSRoleDiscoveryList.selectedIndex;
      document.SysConfig.RBSRoleDiscovery.value = document.SysConfig.RBSRoleDiscoveryList.options[index].text;
   }

   function updateRBSGroupDiscovery()
   {
      var index = document.SysConfig.RBSGroupDiscoveryList.selectedIndex;
      document.SysConfig.RBSGroupDiscovery.value = document.SysConfig.RBSGroupDiscoveryList.options[index].text;
   }

   function updateRBSGroupSearchType()
   {
      var index = document.SysConfig.RBSGroupSearchTypeList.selectedIndex;
      document.SysConfig.RBSGroupSearchType.value = document.SysConfig.RBSGroupSearchTypeList.options[index].text;
   }

   function saveRBS()
   {
      var form = document.SysConfig;
      enableCheckBoxes(form.RBSEnableThis);
      enableCheckBoxes(form.RBSEnableDynamicGroup);
      enableCheckBoxes(form.RBSShowRolesInCollection);
      enableCheckBoxes(form.RBSUnrestrictedAccess);
      getRBSNewTreeList(form.RBSTreeList);
      
   }

   function removeRBSTreeList(list)
   {
   	list = eval(list);
      if (list.selectedIndex > -1)
      {
         list.options[list.selectedIndex] = null;
         list.selectedIndex = 0;
      }
      changed();
   }

   function addRBSTreeList(list, n, p)
   {
      if(p)
      {
         n = prompt("<iman:toScript><iman:string key="SysConfig.AuthSelectTreePrompt" /></iman:toScript>", "");
      }

      if (n!="" && n!=null)
      {
         list = eval(list);
         list[list.length] = new Option(n,n);
         list.selectedIndex = list.length-1;
      }
      changed();
   }

   function getRBSNewTreeList(list)
   {
      list = eval(list);
      var form = document.SysConfig;
      var options = list.options;
      var valueArr = new Array();
      for (var i = 0; i < list.length; i++)
      {
         valueArr[i] = options[i].text;
      }
      form.RBSTreeListParam.value = pack(valueArr);
   }

/******************* Authentication *********************/
	
	function putValuesInControl(mainControl)
	{
		var intStr = eval("document.SysConfig." + mainControl).value;
		var val = Number(intStr);
		var days = parseInt(val/86400);
		var hours = parseInt((val%86400)/3600);
		var minutes = parseInt(((val%86400)%3600)/60);
	
		var daysControl = eval("document.SysConfig." + mainControl + "Days");
		var hoursControl = eval("document.SysConfig." + mainControl + "Hours");
		var minutesControl = eval("document.SysConfig." + mainControl + "Minutes");
  		if (days =='0' && hours =='0' && minutes =='0' )
		{	
		daysControl.value = days;
		hoursControl.value = hours;
		minutesControl.value = 30;
		}
		else
		{	
		daysControl.value = days;
		hoursControl.value = hours;
		minutesControl.value = minutes;
		}
	}
	

   function initAuth()
   {
      document.SysConfig.PasswordChanged.value = "false";

   /*
      <!--   AuthDefProtocol  -->
      var value = "<c:out value="${AuthDefProtocol}"/>";
      var options = document.SysConfig.AuthDefProtocolList.options;
      if(value)
      {
         for (var i = 0; i < document.SysConfig.AuthDefProtocolList.length; i++)
         {
            if (value == options[i].text)
            {
               options[i].selected=true;
               document.SysConfig.AuthDefProtocolList[i].selected = true;
               document.SysConfig.AuthDefProtocol.value = value;
            }
         }
      }
      else
      {
         document.SysConfig.AuthDefProtocolList[0].selected=true;
      }
   */
      
      if(document.SysConfig.searchContainers[0].checked)
      {
         disableContainers();         
      }
      
      window.setTimeout('checkCxtlessLoginFields()', 100);
      window.setTimeout('toggleContextlessSubFields()', 100);
      window.setTimeout('togglePostLogoutURLBox()', 100);
      window.setTimeout('disableDownloadUrl()', 100);
      window.setTimeout('toggleDownloadUrl()', 100);
	  
	  
	  document.SysConfig._ServerTimeoutSettings.value = "<c:out value="${TimeoutInSeconds}"/>";
	  window.setTimeout('putValuesInControl("_ServerTimeoutSettings")', 100);	
   }


   /*
   function updateAuthDefProtocol()
   {
      var index = document.SysConfig.AuthDefProtocolList.selectedIndex;
      document.SysConfig.AuthDefProtocol.value = document.SysConfig.AuthDefProtocolList.options[index].text;
   }
   */


   function updateAuthTreeList(list)
   {
      list = eval(list);
      var form = document.SysConfig;
      if (list.length > 0)
      {
         var index = list.selectedIndex;
         <!--      if (index == 0)-->
         <!--      {-->
         <!--         form.AuthEnableCxtlessLogin.checked = false;-->
         <!--         form.AuthEnableCxtlessLogin.disabled = true;-->
         <!--         checkCxtlessLoginFields();-->
         <!--      }-->
         <!--      else-->
         <!--      {-->
         <!--         // ??? need to get the values from java code-->
         <!--         form.AuthEnableCxtlessLogin.checked = false;-->
         <!--         form.AuthEnableCxtlessLogin.disabled = false;-->
         <!--         checkCxtlessLoginFields();-->
         <!--      }-->

         var form = document.SysConfig;
         var options = list.options;
         var valueArr = new Array();
         for (var i = 0; i < list.length; i++)
         {
            valueArr[i] = options[i].text;

         }
         form.AuthTreeListParam.value = pack(valueArr);
         form.SelectedAuthTreeList.value = options[index].text;
<!--         sCurrentAuthTree = options[index].text;-->
		 goGetAuthInfo(document.SysConfig.AuthTreeList);
      }

   }

   function removeAuthTreeList(list)
   {
   	  list = eval(list);
      var options = list.options;
      var treeValue = options[list.selectedIndex].text;
      if (list.selectedIndex > -1)
      {
         list.options[list.selectedIndex] = null;
         list.selectedIndex = 0;
      }

      // this will call into the java code SystemConfigGetAuthInfoTask.java to send data back to exchanger-->
      window.sysConfigExchanger = new exchanger("sysConfigExchangerFrame");
      var url = "webacc?taskId=fw.SystemConfigGetAuthInfo&merge=fw.SystemConfigGetAuthInfoExchanger&error=fw.SystemConfigGetAuthInfoExchanger&AuthenticationSelectedTreeName=" + urlEncode(treeValue) + "&ExchangerAction=Remove";
      sysConfigExchanger.sendData(url);

      window.setTimeout("goGetAuthInfo(document.SysConfig.AuthTreeList)",1000);
   }

   function addAuthTreeList(list, n, p)
   {
      var protocol = "<c:out value="${authenticatedProtocol}"/>";
      if (protocol == "eDirectory")
      {
         if(p)
         {
            n = prompt("<iman:toScript><iman:string key="SysConfig.AuthSelectTreePrompt" /></iman:toScript>", "");
         }

         if (n!="" && n!=null)
         {
            var i=0;
            for (i=0; i< n.length; i++)
            {
               var temp = "" + n.substring(i, i+1);
               if (n.indexOf(".") !=-1)
               {
                  //dots in the name, then its an IP addr and cannot take that
                  alert("<iman:string key="eMFrameConsts.RES_AUTHENTICATE_NOTREE" />");
                  break;
               }
            }
            if (i == n.length)
            {

               // found a tree name so add it to the list
               list = eval(list);
               list[list.length] = new Option(n,n);
               list.selectedIndex = list.length-1;
            }
         }
      }
      else      // Kepler
      {
         if(p)
         {
            n = prompt("<iman:toScript><iman:string key="SysConfig.AuthSelectIPPrompt" /></iman:toScript>", "");
         }

         if (n!="" && n!=null)
         {
            // found an IP so add it to the list
            list = eval(list);
            list[list.length] = new Option(n,n);
            list.selectedIndex = list.length-1;
         }
      }
      updateAuthTreeList(list);
      //goGetAuthInfo(list);
   }
   
   function calculateTimeout(mainControl, daysControl, hoursControl, minutesControl)
   {
		if ((minutesControl.value==0 || minutesControl.value=="") && (hoursControl.value==0 || hoursControl.value=="") && (daysControl.value==0 || daysControl.value=="" ))
			minutesControl.value=30;
		var newVal = (minutesControl.value * 60) + (hoursControl.value * 3600) + (daysControl.value * 86400);
		mainConrol = eval("document.SysConfig." + mainControl.name);
		mainControl.value = newVal;
   }


   function saveAuth()
   {
      var form = document.SysConfig;
      enableCheckBoxes(form.AuthEnableCxtlessLogin);			//      enableCheckBoxes(form.AuthShowProtocol);      LDAP protocol choice disabled.
      enableCheckBoxes(form.AuthShowTree);
      enableCheckBoxes(form.AuthUseCookies);
      enableCheckBoxes(form.AuthHideLoginFailReason);
      enableCheckBoxes(form.AuthSecondayLDAPUsingSSL);			//      updateAuthTreeList(form.AuthTreeList);
      checkAuthShowTree();										//      checkAuthShowProtocol(false);			      LDAP protocol choice disabled.
      calculateTimeout(form.ServerTimeoutSettings, form._ServerTimeoutSettingsDays, form._ServerTimeoutSettingsHours, form._ServerTimeoutSettingsMinutes);
      
      form.AuthSearchContainers_mvedData.value = mvGetValuesAsPack("AuthSearchContainers"); 
      
   }

   function checkAuthShowTree()
   {
      var form = document.SysConfig;
      if (form.AuthShowTree.checked == false)
      {
         if (form.AuthDefTree.value.length == 0)
         {
            alert("<iman:toScript><iman:string key="SysConfig.AuthUncheckTreeSelection" /></iman:toScript>");
            form.AuthShowTree.value = 'true';
            form.AuthShowTree.checked = true;
            form.AuthDefTree.focus();
         }
      }
   }
   
   function Validate_PostLogout()
   {
   	  var form = document.SysConfig;
   	  if(form.PostLogoutURLEnable.checked == true && (form.PostLogoutURL.value == "" || form.PostLogoutURL.value.length == 0))
      {
      		alert("<iman:toScript><iman:string key="SysConfig.AuthPostLogoutURLAlert" /></iman:toScript>");
      		return false;
      }
      if(form.PostLogoutURLEnable.checked == false)
      {
      		//form.PostLogoutURL.disabled = false;
      		//form.PostLogoutURLFinal.value = form.PostLogoutURL.value;
      		//form.PostLogoutURL.disabled = true;
      }
      form.PostLogoutURLFinal.value = form.PostLogoutURL.value;
      return true;
   }

/*       LDAP protocol choice disabled.
   function checkAuthShowProtocol(showAlert)
   {
      var form = document.SysConfig;
      if (form.AuthShowProtocol.checked == false  && showAlert == true)
      {
         alert("<iman:toScript><iman:string key="SysConfig.AuthUncheckProtocolSelection" /></iman:toScript>");
         form.AuthShowTree.value = 'false';
      }
      else
      {
         form.AuthShowProtocol.checked = true;
         form.AuthShowTree.value = 'true';
      }
   }
*/
   function checkPasswords()
   {
      var form = document.SysConfig;
      if ((form.AuthRetypePublicPassword.value != form.AuthPublicPassword.value))
      {
         alert("<iman:string key="SysConfig.AuthPassDontMatch" />");
         return false;
      }	  
      bPasswordChanged = false;
      return true;
   }
      
	function checkValidSelection(sel)
	{
		var index = sel.selectedIndex;
		if (document.SysConfig.searchContainers[1].checked && document.SysConfig.AuthEnableCxtlessLogin.checked && index<0 )
		{
			alert("<iman:string key="SysConfig.checkValidSelection" />");
		}
	}

   function toggleContextlessSubFields()
   {
      var form = document.SysConfig;
      if (document.SysConfig.searchContainers[0].checked || !form.AuthEnableCxtlessLogin.checked)
      {  
         form.AuthSearchContainers.disabled = true;
         form.AuthSearchContainers.value = "";
         form.AuthSearchContainers.style.backgroundColor = DISABLED_COLOR;

//         form.AuthPublicUser.disabled = true;
//         form.AuthPublicUser.value = "";
//         form.AuthPublicUser.style.backgroundColor = DISABLED_COLOR;
//
//         form.AuthPublicPassword.disabled = true;
//         form.AuthPublicPassword.value = "";
//         form.AuthPublicPassword.style.backgroundColor = DISABLED_COLOR;

//         form.AuthRetypePublicPassword.disabled = true;
//         form.AuthRetypePublicPassword.value = "";
//         form.AuthRetypePublicPassword.style.backgroundColor = DISABLED_COLOR;
         
      }
      else
      {
         form.AuthSearchContainers.disabled = false;
         form.AuthSearchContainers.style.backgroundColor = ENABLED_COLOR;

//         form.AuthPublicUser.disabled = false;
//         form.AuthPublicUser.style.backgroundColor = ENABLED_COLOR;

//         form.AuthPublicPassword.disabled = false;
//         form.AuthPublicPassword.style.backgroundColor = ENABLED_COLOR;

//         form.AuthRetypePublicPassword.disabled = false;
//         form.AuthRetypePublicPassword.style.backgroundColor = ENABLED_COLOR;
        
      }
   }

   function checkCxtlessLoginFields()
   {
      var form = document.SysConfig;
      if (!form.AuthEnableCxtlessLogin.checked)
      {  
         form.AuthSearchContainers.disabled = true;
         form.AuthSearchContainers.value = "";
         form.AuthSearchContainers.style.backgroundColor = DISABLED_COLOR;

         form.AuthPublicUser.disabled = true;
         form.AuthPublicUser.value = "";
         form.AuthPublicUser.style.backgroundColor = DISABLED_COLOR;

         form.AuthPublicPassword.disabled = true;
         form.AuthPublicPassword.value = "";
         form.AuthPublicPassword.style.backgroundColor = DISABLED_COLOR;

         form.AuthRetypePublicPassword.disabled = true;
         form.AuthRetypePublicPassword.value = "";
         form.AuthRetypePublicPassword.style.backgroundColor = DISABLED_COLOR;
         
         form.searchContainers[0].disabled = true;
         form.searchContainers[1].disabled = true;
         
      }
      else
      {
         form.AuthSearchContainers.disabled = false;
         form.AuthSearchContainers.style.backgroundColor = ENABLED_COLOR;

         form.AuthPublicUser.disabled = false;
         form.AuthPublicUser.style.backgroundColor = ENABLED_COLOR;

         form.AuthPublicPassword.disabled = false;
         form.AuthPublicPassword.style.backgroundColor = ENABLED_COLOR;

         form.AuthRetypePublicPassword.disabled = false;
         form.AuthRetypePublicPassword.style.backgroundColor = ENABLED_COLOR;
         
         form.searchContainers[0].disabled = false;
         form.searchContainers[1].disabled = false;
      }
   }

       
   var bPasswordChanged = false;
   function setPasswordFlag()
   {
      bPasswordChanged = true;
   }

	function togglePostLogoutURLBox()
	{
		var form = document.SysConfig;
		if(form.PostLogoutURLEnable.checked == true)
		{
			form.PostLogoutURL.disabled = false;
			form.PostLogoutURL.style.backgroundColor = ENABLED_COLOR;
		}
		else
		{
			form.PostLogoutURL.disabled = true;
			form.PostLogoutURL.style.backgroundColor = DISABLED_COLOR;
		}
	}
	
   /******** exchanger for Authentication tab **********/

   var sPrevAuthTree = "";
   var sCurrentAuthTree = "";

   var sCurrUsername = "";
   var sCurrPassword = "";
   var sCurrContainers = "";

   var sPrevUsername = "";
   var sPrevPassword = "";
   var sPrevContainers = "";

   function savePrevAuthenticationInfo(list)
   {
      if(!blockPrevAuthInfoOnFocus)
      {
      	list = eval(list);
      	sPrevAuthTree = list.options[list.selectedIndex].text;
   	  	sPrevUsername = document.SysConfig.AuthPublicUser.value;
      	sPrevPassword = document.SysConfig.AuthPublicPassword.value;
      	sPrevContainers = mvGetValuesAsPack("AuthSearchContainers");
      }
      blockPrevAuthInfoOnFocus = false;

   }


   // this is called from SystemConfigGetAuthInfoExchanger.jsp
   function getAuthenticationInfo(username, userpwd, containers)
   {
      sCurrUsername = username;
      sCurrPassword = userpwd;
      sCurrContainers = containers;

      document.SysConfig.AuthPublicUser.value = username;
      document.SysConfig.AuthPublicPassword.value = userpwd;
      document.SysConfig.AuthRetypePublicPassword.value = userpwd;

      mvLoadFromPack("AuthSearchContainers",containers);
      window.setTimeout('savePrevAuthenticationInfo(document.SysConfig.AuthTreeList)',1000);
   }

   function goGetAuthInfo(list)
   {
      list = eval(list);

      var index = list.selectedIndex;
      var treeValue = list.options[index].text;
      // this will call into the java code SystemConfigGetAuthInfoTask.java to send data back to exchanger
      window.sysConfigExchanger = new exchanger("sysConfigExchangerFrame");
      var url = "webacc?taskId=fw.SystemConfigGetAuthInfo&merge=fw.SystemConfigGetAuthInfoExchanger&error=fw.SystemConfigGetAuthInfoExchanger&AuthenticationSelectedTreeName=" + urlEncode(treeValue) + "&AuthenticationPrevAuthTree=" + urlEncode(sPrevAuthTree) + "&AuthenticationPrevUsername=" + urlEncode(sPrevUsername) + "&AuthenticationPrevPassword=" + urlEncode(sPrevPassword) + "&AuthenticationPrevContainers=" + urlEncode(sPrevContainers);

      sysConfigExchanger.sendData(url);
   }

/******************* Misc *********************/
   function initMisc()
   {
      var shouldDownload = "<c:out value="${ShouldModuleDownload}"/>";
      EnableDisableMiscRadio(document.SysConfig.ShouldModuleDownload);
   }

   function EnableDisableMiscRadio(control)
   {
      if (control.name=="ShouldModuleDownload" && control.checked==false)
      {
//         document.SysConfig.AllModulesToDownload.disabled=true;
//         document.SysConfig.PartialModulesToDownload.disabled=true;
//         document.SysConfig.AllModulesToDownload.style.backgroundColor = DISABLED_COLOR;
//         document.SysConfig.PartialModulesToDownload.style.backgroundColor = DISABLED_COLOR;
//         document.SysConfig.AllModulesToDownload.value=false;
//         document.SysConfig.PartialModulesToDownload.value=true;
         control.value = 'false';
      }
      else
      {
//         document.SysConfig.AllModulesToDownload.disabled=false;
//         document.SysConfig.PartialModulesToDownload.disabled=false;
//         document.SysConfig.AllModulesToDownload.style.backgroundColor = ENABLED_COLOR;
//         document.SysConfig.PartialModulesToDownload.style.backgroundColor = ENABLED_COLOR;
//         document.SysConfig.AllModulesToDownload.value=true;
//         document.SysConfig.PartialModulesToDownload.value=false;
         control.value = 'true';
      }

      if (control.name=="AllModulesToDownload")
      {
         if (control.checked==false)
         {
            document.SysConfig.AllModulesToDownload.checked = false;
            document.SysConfig.AllModulesToDownload.value = false;
            document.SysConfig.PartialModulesToDownload.checked = true;
            document.SysConfig.PartialModulesToDownload.value = true;
         }
         else
         {
            document.SysConfig.AllModulesToDownload.checked = true;
            document.SysConfig.AllModulesToDownload.value = true;
            document.SysConfig.PartialModulesToDownload.checked = false;
            document.SysConfig.PartialModulesToDownload.value = false;
         }
      }

      if (control.name=="PartialModulesToDownload")
      {
         if (control.checked==false)
         {
            document.SysConfig.AllModulesToDownload.checked = true;
            document.SysConfig.AllModulesToDownload.value = true;
            document.SysConfig.PartialModulesToDownload.checked = false;
            document.SysConfig.PartialModulesToDownload.value = false;
         }
         else
         {
            document.SysConfig.AllModulesToDownload.checked = false;
            document.SysConfig.AllModulesToDownload.value = false;
            document.SysConfig.PartialModulesToDownload.checked = true;
            document.SysConfig.PartialModulesToDownload.value = true;
         }
      }

   }
	   function disableProxy()
	   {
	   	if(document.SysConfig.ModulesDownloadEnableProxy.checked)
	   	{
	   		document.SysConfig.ModulesDownloadProxyHost.disabled=false;
	   		document.SysConfig.ModulesDownloadProxyHost.style.backgroundColor = ENABLED_COLOR;
	   		document.SysConfig.ModulesDownloadProxyPort.disabled=false;
	   		document.SysConfig.ModulesDownloadProxyPort.style.backgroundColor = ENABLED_COLOR;
	   		document.SysConfig.ModulesDownloadProxyUserName.disabled=false;
	   		document.SysConfig.ModulesDownloadProxyUserName.style.backgroundColor = ENABLED_COLOR;
	   		document.SysConfig.ModulesDownloadProxyPassword.disabled=false;
	   		document.SysConfig.ModulesDownloadProxyPassword.style.backgroundColor = ENABLED_COLOR;
	   		document.SysConfig.ModulesDownloadProxyRetypePassword.disabled=false;
	   		document.SysConfig.ModulesDownloadProxyRetypePassword.style.backgroundColor = ENABLED_COLOR;
	   		
	   	}else
	   	{
	   		document.SysConfig.ModulesDownloadProxyHost.disabled=true;
	   		document.SysConfig.ModulesDownloadProxyHost.style.backgroundColor = DISABLED_COLOR;
	   		document.SysConfig.ModulesDownloadProxyPort.disabled=true;
	   		document.SysConfig.ModulesDownloadProxyPort.style.backgroundColor = DISABLED_COLOR;
	   		document.SysConfig.ModulesDownloadProxyUserName.disabled=true;
	   		document.SysConfig.ModulesDownloadProxyUserName.value = "";
	   		document.SysConfig.ModulesDownloadProxyUserName.style.backgroundColor = DISABLED_COLOR;
	   		document.SysConfig.ModulesDownloadProxyPassword.disabled=true;
	   		document.SysConfig.ModulesDownloadProxyPassword.value = "";
	   		document.SysConfig.ModulesDownloadProxyPassword.style.backgroundColor = DISABLED_COLOR;	   		
	   		document.SysConfig.ModulesDownloadProxyRetypePassword.disabled=true;
	   		document.SysConfig.ModulesDownloadProxyRetypePassword.value = "";
	   		document.SysConfig.ModulesDownloadProxyRetypePassword.style.backgroundColor = DISABLED_COLOR;
	   	}
	   }
	   
	   function disableDownloadUrl()
	   {
	   	if(document.SysConfig.ShouldModuleDownload.checked)
	   	{
	   		document.getElementById('hideDownloadOptions').style.display="block";
	   		//document.SysConfig.DownloadModulesOption[0].disabled = false;
         	//document.SysConfig.DownloadModulesOption[1].disabled = false;
         	
	   	}else
	   	{
	   		document.getElementById('hideDownloadOptions').style.display="none";
	   		//document.SysConfig.DownloadModulesOption[0].disabled = true;
         	//ddocument.SysConfig.DownloadModulesOption[1].disabled = true;
	   		
	   	}
	   }
	   
	   function toggleDownloadUrl()
	   {
	   	var form = document.SysConfig;
	   	if(form.DownloadModulesOption[0].checked || !form.ShouldModuleDownload.checked)
	   	{
	   	 
         form.DownloadURL.disabled = true;
         form.DownloadURL.style.backgroundColor = DISABLED_COLOR;
        }
  	    else
        {
         form.DownloadURL.disabled = false;
         form.DownloadURL.style.backgroundColor = ENABLED_COLOR;
        }
        
	   }
	   
	   function disableCustomUrl()
   	   {
   			document.SysConfig.DownloadURL.disabled=true;
	   		document.SysConfig.DownloadURL.style.backgroundColor = DISABLED_COLOR;
   			
   	   }
	   
	   function enableCustomUrl()
   	   {
   			document.SysConfig.DownloadURL.disabled=false;
	   		document.SysConfig.DownloadURL.style.backgroundColor = ENABLED_COLOR;
   			
   	   }
	   
	   var bProxyPasswordChanged = false;
	   function setProxyPasswordFlag()
	   {
	      bProxyPasswordChanged = true;
	   }
	   
	   function checkProxyPasswords()
	   {
	   		var form = document.SysConfig;
	   		if (form.ModulesDownloadProxyPassword.value != form.ModulesDownloadProxyRetypePassword.value)
			{		       
	           return false;
		 	}
		 	bProxyPasswordChanged = false;
	        return true;
	    }  
	   
	   function validate_ProxySettings()
	   {
	   		var valid = true;
	   		var errmsg = "";
	   		
	   		var value1 = document.SysConfig.ModulesDownloadProxyHost.value;
	   		if (value1 == "")
	   		{
	   			valid = false;
	   			errmsg += "<iman:string key='SysConfig.ModulesDownloadProxyHost'/> <iman:string key='SysConfig.ModulesDownloadProxyEmpty'/>\n";
	   		}
	   		else if(!isValidProxyAddress(value1))
	   		{
	   			valid= false;
	   			errmsg += "<iman:string key='SysConfig.ModulesDownloadProxyHost'/> <iman:string key='SysConfig.ModulesDownloadProxyInvalid'/>\n";
	   		
	   		}
	   			
	   		var value2 = document.SysConfig.ModulesDownloadProxyPort.value;
	   		if (value2 == "")
	   		{
	   			valid = false;
	   			errmsg += "<iman:string key='SysConfig.ModulesDownloadProxyPort'/> <iman:string key='SysConfig.ModulesDownloadProxyEmpty'/>\n";
	   		}
	   		else if(!value2.match(/^\d+$/))
	   		{
	   			valid = false;
	   			errmsg += "<iman:string key='SysConfig.ModulesDownloadProxyPort'/> <iman:string key='SysConfig.ModulesDownloadProxyInvalid'/>\n";
	   		
	   		}
	   		if (bProxyPasswordChanged)
	   		{
	   			if (checkProxyPasswords()== false)
	   			{
	   				valid = false;
	   				errmsg += "<iman:string key="SysConfig.AuthPassDontMatch" />";
	   			}
	   			
	   		}
	   		   		
	   		if (!valid)
	   			alert(errmsg);   			
	   		
	   		return valid;   	
	   
	   }
	   function isValidProxyAddress(proxyHost) 
	   {
		   var re = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
		   if (re.test(proxyHost))
		    {
		      var parts = proxyHost.split(".");
		      if (parseInt(parseFloat(parts[0])) == 0) { return false; }
		      for (var i=0; i<parts.length; i++) 
		      {
		         if (parseInt(parseFloat(parts[i])) > 255) { return false; }
		      }
		      return true;
		    } 
		    else
		    {
		      return false;
		    }
	  }



/******************* Security *********************/

   function saveSecurity()
   {
   
	   var form = document.SysConfig;
   	form.SecurityEnableNSureAuditAuthorizedUsers.disabled=false;
   	form.SecurityEnableNSureAuditFailedSSLConnection.disabled=false;
   	form.SecurityEnableNSureAuditLoginFailed.disabled=false;
   	form.SecurityEnableNSureAuditLoginSuccess.disabled=false;
   	form.SecurityEnableNSureAuditLogout.disabled=false;
   	form.SecurityEnableNSureAuditNPMFailedInstall.disabled=false;
   	form.SecurityEnableNSureAuditNPMInstalled.disabled=false;
   	form.SecurityEnableNSureAuditChangedConfiguration.disabled=false;
   	form.SecurityEnableNSureAuditStartup.disabled=false;
   	form.SecurityEnableNSureAuditShutdown.disabled=false;


      enableCheckBoxes(form.SecurityWarnNonSecure);
      enableCheckBoxes(form.SecurityEnableNSureAudit);
      enableCheckBoxes(form.SecurityEnableNSureAuditAuthorizedUsers);
      enableCheckBoxes(form.SecurityEnableNSureAuditFailedSSLConnection);
      enableCheckBoxes(form.SecurityEnableNSureAuditLoginFailed);
      enableCheckBoxes(form.SecurityEnableNSureAuditLoginSuccess);
      enableCheckBoxes(form.SecurityEnableNSureAuditLogout);
      enableCheckBoxes(form.SecurityEnableNSureAuditNPMFailedInstall);
      enableCheckBoxes(form.SecurityEnableNSureAuditNPMInstalled);
      enableCheckBoxes(form.SecurityEnableNSureAuditChangedConfiguration);
      enableCheckBoxes(form.SecurityEnableNSureAuditStartup);
      enableCheckBoxes(form.SecurityEnableNSureAuditShutdown);
      enableCheckBoxes(form.SecurityNSureAuditSelectAll);
      
      enableCheckBoxes(form.SecurityAutoImportCertificate);
   }
   
   function disableControls()
   {
       	if(document.SysConfig.NeverTimeout.checked){
       		document.SysConfig._ServerTimeoutSettingsDays.disabled = true;
       		document.SysConfig._ServerTimeoutSettingsHours.disabled = true;
       		document.SysConfig._ServerTimeoutSettingsMinutes.disabled = true;
       		document.SysConfig._ServerTimeoutSettingsDays.style.backgroundColor = DISABLED_COLOR;
       		document.SysConfig._ServerTimeoutSettingsHours.style.backgroundColor = DISABLED_COLOR;
       		document.SysConfig._ServerTimeoutSettingsMinutes.style.backgroundColor = DISABLED_COLOR;
       		
       	}
       	else
      	{
       		document.SysConfig._ServerTimeoutSettingsDays.disabled = false;
       		document.SysConfig._ServerTimeoutSettingsHours.disabled = false;
       		document.SysConfig._ServerTimeoutSettingsMinutes.disabled = false;
       		document.SysConfig._ServerTimeoutSettingsDays.style.backgroundColor = ENABLED_COLOR;
       		document.SysConfig._ServerTimeoutSettingsHours.style.backgroundColor = ENABLED_COLOR;
       		document.SysConfig._ServerTimeoutSettingsMinutes.style.backgroundColor = ENABLED_COLOR;
       		
       	}
   }
   
   


   </SCRIPT>
</HEAD>

<BODY onLoad="returnFromOS();onPageLoad();checkInitial();disableControls();">
<FORM name="SysConfig" method=post action="webacc">
   <INPUT type="hidden" name="nextState" value="<c:out value="${nextState}"/>">
   <INPUT type="hidden" name="taskId" value="<c:out value="${taskId}"/>">
   <INPUT type="hidden" name="merge" value="fw.SystemConfigurationPage1">
   <INPUT type="hidden" name="error" value="dev.GenErr">
   <INPUT type="hidden" name="selectedTab" value="<c:out value="${selectedTab}"/>">
   <INPUT type="hidden" name="authenticatedProtocol" value="<c:out value="${authenticatedProtocol}"/>">
   <INPUT type="hidden" name="RBSRoleDiscovery" value="<c:out value="${RBSRoleDiscovery}"/>">
   <INPUT type="hidden" name="RBSGroupDiscovery" value="<c:out value="${RBSGroupDiscovery}"/>">
   <INPUT type="hidden" name="RBSGroupSearchType" value="<c:out value="${RBSGroupSearchType}"/>">
   <INPUT type="hidden" name="RBSTreeListParam" value="<c:out value="${RBSTreeListParam}"/>">

   <INPUT type="hidden" name="AuthTreeListParam" value="<%=AuthTreeListParam[0]%>">
   <INPUT type="hidden" name="AuthSelectedTreeName" value="<c:out value="${AuthSelectedTree}" />">
   <INPUT type="hidden" name="AuthDefProtocol" value="<c:out value="${AuthDefProtocol}"/>">
   <INPUT type="hidden" name="PasswordChanged" value="<c:out value=""/>">
   <INPUT type="hidden" name="SelectedAuthTreeList" value="<c:out value=""/>">
   <INPUT type="hidden" name="PreviousPackedContainerList" value=""/>
   <INPUT type="hidden" name="PreviousPackedAuthTreeList" value=""/>
   <INPUT type="hidden" name="PreviousPassword" value=""/>
   <INPUT type="hidden" name="PreviousPublicUser" value=""/>
   <INPUT type="hidden" name="PostLogoutURLFinal" value=""/>
   <c:set var="TaskHeader.title" scope="request"><iman:string key="SysConfig.Configuration"/></c:set>
   <c:set var="TaskHeader.iconUrl" scope="request">dir/object16.gif</c:set>
   <c:set var="TaskHeader.helpFile" scope="request">base/systemconfiguration.html</c:set>

	<jsp:include page='<%= c.getPath("dev/TaskHeader_inc.jsp") %>' flush="true" />
	<div class="instructions" style="width: 80%"><iman:string key="SysConfig.Description"/></div>

	<div style="margin:1em"><iman:messagebar /></div>

<!---------------------- Security Div ---------------------->
<div id="SecurityTab" style="display: none" class="margintop3" border="0" cellspacing="2" cellpadding="0">
	<iman:tabSet selectedIndex="0">
		<iman:tab textKey="SysConfig.Security" onClick="showHideTabs('SecurityTab','LookFeelTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
		<iman:tab textKey="SysConfig.LookFeel" onClick="showHideTabs('LookFeelTab','SecurityTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
		<iman:tab textKey="SysConfig.Logging" onClick="showHideTabs('LoggingTab','SecurityTab','LookFeelTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
		<iman:tab textKey="SysConfig.Authentication" onClick="showHideTabs('AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab','ModuleTab','MiscTab')"/>
		<iman:tab textKey="SysConfig.RBS" onClick="showHideTabs('RBSTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','ModuleTab','MiscTab')"/>
		<iman:tab textKey="SysConfig.Module" onClick="showHideTabs('ModuleTab','MiscTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
		<iman:tab textKey="SysConfig.Misc" onClick="showHideTabs('MiscTab','ModuleTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
	</iman:tabSet>

   <div id="SecurityContent" style="margin-left: 1em">
      <div style="margin-top: 1em"><input onChange="changed();" type="checkbox" name="SecurityWarnNonSecure" value="<c:out value="${SecurityWarnNonSecure}"/>" <c:if test="${SecurityWarnNonSecure=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityWarnNonSecure"/>&nbsp;<b><iman:string key="AuthenticateForm.Warn.nonSecure"/></b></label></div>
      <div style="margin-top: 0.25em"><input onChange="changed();" type="checkbox" name="SecurityAutoImportCertificate" value="<c:out value="${SecurityAutoImportCertificate}"/>" <c:if test="${SecurityAutoImportCertificate=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityAutoImportCertificate"/></label></div>

<!--		<div style="margin-top: 1em"><label><iman:string key="SysConfig.SecurityTrustedAddress"/></label></div>	-->
<!--		<div><iman:mved name="SecurityTrustedAddress" enforceUnique="true" items="${SecurityTrustedAddress}" /><img src="../../../../1Graphics/GraphicsDB/16x16/eMbut/eMbut_drop_down.gif" alt="Button: Properties" height="16" width="16" align="absmiddle" border="0"></a></div> -->
<!--		<div style="margin-top: 0.5em"><label style="margin-top: 0.5em"><iman:string key="SysConfig.SecurityValidTrees"/></label></div> -->
<!--		<div  style="margin-bottom: 1em"><input type=text name="SecurityValidTrees" value="<c:out value="${SecurityValidTrees}"/>" style="width:<iman:string key="UI.textboxPixel"/>" size='iman:string key="UI.textboxSize"' maxlength=64></input></div> -->

   </div>
   <div class="tablesubhead1" style="margin-top: 1em"><iman:string key="SysConfig.SecurityAuthorizedUsersTitle"/></div>
   <div style="margin-top: 1em; margin-left: 1em"><label><iman:string key="SysConfig.SecurityAuthorizedUsers"/></label></div>

   <c:if test="${authenticatedProtocol =='LDAP'}">
      <div style="margin-left: 1em"><iman:mved name="SecurityAuthorizedUsers"  objectTypeName="inetOrgPerson,group"  enforceUnique="true" history="true" items="${SecurityAuthorizedUsers}" useRootedName="true" onChangeCallback="changed" /></div>
   </c:if>
   <c:if test="${authenticatedProtocol !='LDAP'}">
      <div style="margin-left: 1em"><iman:mved name="SecurityAuthorizedUsers" objectTypeName="User,Group" enforceUnique="true" history="true" items="${SecurityAuthorizedUsers}" useRootedName="true" onChangeCallback="changed" /></div>
   </c:if>

   <div style="margin-left: 1em" class="instructions"><iman:string key="SysConfig.SecurityAuthorizedUsersNote"/></div>

   <div class="tablesubhead1" style="margin-top: 1em"><iman:string key="SysConfig.SecurityAuditTitle"/> 
      <font style="margin-top: 0.25em"><input onclick="disableAudit();changed();" onChange="disableAudit();changed();" type="checkbox" name="SecurityEnableNSureAudit" value="<c:out value="${SecurityEnableNSureAudit}"/>" <c:if test="${SecurityEnableNSureAudit=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAudit"/></label></font>
   </div>
	<div style="margin-top: 0.25em">
		<table cellpadding="0" cellspacing="0" border="0">
      <tr>
         <td colspan="3">
            <font style="margin-top: 0.25em"><input onclick="checkAllAudit();changed();" onChange="checkAllAudit();changed();" type="checkbox" name="SecurityNSureAuditSelectAll" /><label><iman:string key="Button.SelectAll.alt"/></label></font>
         </td>
      </tr>
		<tr>
			<td><input onChange="changed();" type="checkbox" name="SecurityEnableNSureAuditAuthorizedUsers" value="<c:out value="${SecurityEnableNSureAuditAuthorizedUsers}"/>" <c:if test="${SecurityEnableNSureAuditAuthorizedUsers=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAuditAuthorizedUsers"/></label></td>
			<td><input onChange="changed();" type="checkbox" name="SecurityEnableNSureAuditFailedSSLConnection" value="<c:out value="${SecurityEnableNSureAuditFailedSSLConnection}"/>" <c:if test="${SecurityEnableNSureAuditFailedSSLConnection=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAuditFailedSSLConnection"/></label></td>
			<td><input onChange="changed();" type="checkbox" name="SecurityEnableNSureAuditLoginFailed" value="<c:out value="${SecurityEnableNSureAuditLoginFailed}"/>" <c:if test="${SecurityEnableNSureAuditLoginFailed=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAuditLoginFailed"/></label></td>
		</tr>
		<tr>
			<td><input onChange="changed();" type="checkbox" name="SecurityEnableNSureAuditLoginSuccess" value="<c:out value="${SecurityEnableNSureAuditLoginSuccess}"/>" <c:if test="${SecurityEnableNSureAuditLoginSuccess=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAuditLoginSuccess"/></label></td>
			<td><input onChange="changed();" type="checkbox" name="SecurityEnableNSureAuditLogout" value="<c:out value="${SecurityEnableNSureAuditLogout}"/>" <c:if test="${SecurityEnableNSureAuditLogout=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAuditLogout"/></label></td>
			<td><input onChange="changed();" type="checkbox" name="SecurityEnableNSureAuditNPMFailedInstall" value="<c:out value="${SecurityEnableNSureAuditNPMInstallFailed}"/>" <c:if test="${SecurityEnableNSureAuditNPMFailedInstall=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAuditNPMFailedInstall"/></label></td>
		</tr>
		<tr>
			<td><input onChange="changed();" type="checkbox" name="SecurityEnableNSureAuditNPMInstalled" value="<c:out value="${SecurityEnableNSureAuditNPMInstalled}"/>" <c:if test="${SecurityEnableNSureAuditNPMInstalled=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAuditNPMInstalled"/></label></td>
			<td><input onChange="changed();" type="checkbox" name="SecurityEnableNSureAuditChangedConfiguration" value="<c:out value="${SecurityEnableNSureAuditChangedConfiguration}"/>" <c:if test="${SecurityEnableNSureAuditChangedConfiguration=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAuditChangedConfiguration"/></label></td>
			<td><input onChange="changed();" type="checkbox" name="SecurityEnableNSureAuditShutdown" value="<c:out value="${SecurityEnableNSureAuditShutdown}"/>" <c:if test="${SecurityEnableNSureAuditShutdown=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAuditShutdown"/></label></td>
		</tr>
		<tr>
			<td><input onChange="changed();" type="checkbox" name="SecurityEnableNSureAuditStartup" value="<c:out value="${SecurityEnableNSureAuditStartup}"/>" <c:if test="${SecurityEnableNSureAuditStartup=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.SecurityEnableNSureAuditStartup"/></label></td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
		</tr>
	   </table>
	</div>
</div>



<!---------------------- Look and Feel Div ---------------------->
<div id="LookFeelTab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="1">
         <iman:tab textKey="SysConfig.Security" onClick="showHideTabs('SecurityTab','LookFeelTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.LookFeel" onClick="showHideTabs('LookFeelTab','SecurityTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Logging" onClick="showHideTabs('LoggingTab','SecurityTab','LookFeelTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Authentication" onClick="showHideTabs('AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.RBS" onClick="showHideTabs('RBSTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Module" onClick="showHideTabs('ModuleTab','MiscTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
         <iman:tab textKey="SysConfig.Misc" onClick="showHideTabs('MiscTab','ModuleTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
     </iman:tabSet>

	<div class="instructions" style="margin-top: 0.75em"><iman:string key="SysConfig.LAFGeneral"/></div>
	<div style="margin-top: 1em"><label><iman:string key="SysConfig.LAFOrgNameColon"/></label></div>
	<div><input onChange="changed();" type="text" name="LookAndFeel_OrganizationName" value="<iman:resultString key="LookAndFeel_OrganizationName" />" size="30"/></div>
	<div class="tablesubhead1" style="margin-top: 1em"><span style="float: right"><iman:button key="Reset" onClick="resetLookAndFeelToDefaults()"/></span><iman:string key="SysConfig.LAFHeaderCust"/></div>
	<div class="instructions" style="margin-top: 0.75em"><iman:string key="SysConfig.LAFHeaderBkgrdImgDesc"/></div>

	<table style="white-space:nowrap" width="180" border="0" cellspacing="3" cellpadding="0" style="white-space: nowrap">
		<tr>
			<td><label><iman:string key="SysConfig.LAFCurrBkgrdImg"/></label></td>
			<td></td>
			<td style="white-space:nowrap" align="center"><label><iman:string key="SysConfig.LAFCurrFillerImg"/></label></td>
			<td><img src="<%= c.getModulesUrl() %>/fw/images/7px_spacer.gif" alt="" height="10" width="10" border="0"></td>
			<td style="white-space:nowrap" align="center"><label><iman:string key="SysConfig.LAFCurrBrandingImg"/></label></td>
		</tr>
		<tr>
			<td><img src="<c:out value="${ContextPath}" /><iman:resultString key="LookAndFeel_iManagerHeaderBackgroundImage"/>"></td>
			<td><img src="<%= c.getModulesUrl() %>/fw/images/7px_spacer.gif" alt="" height="10" width="10" border="0"></td>
			<td align="center" valign="middle"><img src="<c:out value="${ContextPath}" /><iman:resultString key="LookAndFeel_iManagerHeaderFillerImage"/>" alt="" height="80" width="15" align="middle" border="0"></td>
			<td></td>
			<td align="center" valign="middle"><img src="<c:out value="${ContextPath}" /><iman:resultString key="LookAndFeel_iManagerBrandingImage"/>" alt="" height="80" width="60" align="middle" border="0"></td>
		</tr>
		<tr>
			<td style="white-space:nowrap" class="mediumtext"><label><iman:string key="SysConfig.LAFHeaderDimensionsLabel"/></label>&nbsp;<iman:string key="SysConfig.LAFBkgrdImg"/><span class="textblue1">&nbsp;<iman:string key="SysConfig.LAFHeaderPixelLabel"/></span></td>
			<td></td>
			<td style="white-space:nowrap" class="mediumtext" align="center"><iman:string key="SysConfig.LAFFillerImgDesc"/><span class="textblue1">&nbsp;<iman:string key="SysConfig.LAFHeaderPixelLabel"/></span></td>
			<td></td>
			<td style="white-space:nowrap" class="mediumtext" align="center"><iman:string key="SysConfig.LAFBrandingImgDesc"/><span class="textblue1">&nbsp;<iman:string key="SysConfig.LAFHeaderPixelLabel"/></span></td>
		</tr>
	</table>

	<!-- HEADER, FILL, LOGO IMAGES-->
	<div style="margin-top: 1em" class="instructions"><iman:string key="SysConfig.LAFPathNote"/></div>
	<div style="margin-top: 0.5em">
		<table width="180" border="0" cellspacing="3" cellpadding="0">
			<tr>
				<td style="white-space:nowrap"><label><iman:string key="SysConfig.LAFHeaderImgLoc"/></label></td>
				<td><input onChange="changed();" type="text" name="LookAndFeel_iManagerHeaderBackgroundImage" value="<iman:resultString key="LookAndFeel_iManagerHeaderBackgroundImage"/>" size="60"/></td>
				<td></td>
			</tr>
			<tr>
				<td style="white-space:nowrap"><label><iman:string key="SysConfig.LAFHeaderFillerImgLoc"/></label></td>
				<td><input onChange="changed();" type="text" name="LookAndFeel_iManagerHeaderFillerImage" value="<iman:resultString key="LookAndFeel_iManagerHeaderFillerImage"/>" size="60"/></td>
				<td></td>
			</tr>
			<tr>
				<td style="white-space:nowrap"><label><iman:string key="SysConfig.LAFBrandingImgLoc"/></label></td>
				<td><input onChange="changed();" type="text" name="LookAndFeel_iManagerBrandingImage" value="<iman:resultString key="LookAndFeel_iManagerBrandingImage"/>" size="60"/></td>
				<td></td>
			</tr>
		</table>
	</div>
	
	<!-- HOME PAGE IMAGE -->
	<div class="tablesubhead1" style="margin-top: 1em"><iman:string key="SysConfig.LAFHomePageImageCust"/></div>
	<div class="instructions"  style="margin-top: 0.75em"><iman:string key="SysConfig.LAFHomePageDesc"/></div>
	<div style="margin-top: 0.5em; margin-bottom: 1em">
		<table border="0" cellspacing="3" cellpadding="0">
			<col width="100px">
			<tr>
				<td><label><iman:string key="SysConfig.LAFHomePageImageCust"/></label></td>				
				<td><img src="<c:out value="${ContextPath}" /><iman:resultString key="LookAndFeel_HomeImage"/>" alt="" border="1"></td>
			</tr>
			<tr>
				<td><label><iman:string key="SysConfig.LAFShowHomeImage"/></label>
					<input onChange="changed();" type="checkbox" name="LookAndFeel_ShowHomeImage" 
						value="<c:out value="${LookAndFeel_ShowHomeImage}"/>" 
						<c:if test="${LookAndFeel_ShowHomeImage=='true'}">checked</c:if>></input></td>
				<td><input onChange="changed();" type="text" name="LookAndFeel_HomeImage" value="<iman:resultString key='LookAndFeel_HomeImage'/>" size="60"/></td>
			</tr>
		</table>
	</div>
	
	<!--  COLORS -->
	<div class="tablesubhead1" style="margin-top: 1em"><iman:string key="SysConfig.LAFMenuCust"/></div>
	<div class="instructions"  style="margin-top: 0.75em"><iman:string key="SysConfig.LAFMenuHeaderColorDesc"/></div>
	<div style="margin-top: 0.5em; margin-bottom: 1em">
		<table width="180" border="0" cellspacing="3" cellpadding="0">
			<tr>
				<td style="white-space:nowrap"><label><iman:string key="SysConfig.LAFMenuHeaderColorColon"/></label></td>
				<td style="border-color:black; border-style:solid; border-width:1px;background-color:<c:out value="${LookAndFeel_MenuHeaderColor}"/>;"><img src="<%= c.getModulesUrl() %>/fw/images/7px_spacer.gif" alt="" height="10" width="20" border="0"></td>
				<td><input onChange="changed();" type="text" name="LookAndFeel_MenuHeaderColor" value="<c:out value="${LookAndFeel_MenuHeaderColor}"/>" size="15"/></td>
			</tr>
			<tr>
				<td style="white-space:nowrap"><label><iman:string key="SysConfig.LAFMenuColorColon"/></label></td>
				<td style="border-color:black; border-style:solid; border-width:1px; background-color:<c:out value="${LookAndFeel_MenuColor}"/>;"><img src="<%= c.getModulesUrl() %>/fw/images/7px_spacer.gif" alt="" height="10" width="20" border="0"></td>
				<td><input onChange="changed();" type="text" name="LookAndFeel_MenuColor" value="<iman:resultString key="LookAndFeel_MenuColor"/>" size="15"/></td>
			</tr>
		</table>
	</div>

</div>

<!---------------------- Logging Div ---------------------->
<div id="LoggingTab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="2">
         <iman:tab textKey="SysConfig.Security" onClick="showHideTabs('SecurityTab','LookFeelTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.LookFeel" onClick="showHideTabs('LookFeelTab','SecurityTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Logging" onClick="showHideTabs('LoggingTab','SecurityTab','LookFeelTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Authentication" onClick="showHideTabs('AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.RBS" onClick="showHideTabs('RBSTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Module" onClick="showHideTabs('ModuleTab','MiscTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
         <iman:tab textKey="SysConfig.Misc" onClick="showHideTabs('MiscTab','ModuleTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
      </iman:tabSet>


	<div class="tablesubhead1"><iman:string key="LoggingConfig.LoggingLevel.label"/></div>
	<div style="margin-left: 1em">
		<div style="margin-top: 0.75em"><input onChange="changed();" type="radio" name="loggingLevel" value="0" onClick="enableLoggingSettings(false)" <c:if test="${loggingLevel=='0'}">checked</c:if>><label><iman:string key="LoggingConfig.LoggingNone.label"/></label></input></div>
		<div><input onChange="changed();" type="radio" name="loggingLevel" value="1" onClick="enableLoggingSettings(true)" <c:if test="${loggingLevel=='1'}">checked</c:if>><label><iman:string key="LoggingConfig.Error.label"/></label></input></div>
		<div><input onChange="changed();" type="radio" name="loggingLevel" value="2" onClick="enableLoggingSettings(true)" <c:if test="${loggingLevel=='2'}">checked</c:if>><label><iman:string key="LoggingConfig.Warning.label"/></label></input></div>
		<div><input onChange="changed();" type="radio" name="loggingLevel" value="3" onClick="enableLoggingSettings(true)" <c:if test="${loggingLevel=='3'}">checked</c:if>><label><iman:string key="LoggingConfig.Info.label"/></label></input></div>
	</div>

	<div class="tablesubhead1" style="margin-top: 1em"><iman:string key="LoggingConfig.LoggingLocations.label" /></div>
	<div style="margin-left: 1em">
		<div style="margin-top: 0.75em"><input onChange="changed();" type="checkbox" name="loggingToErr" <c:if test="${loggingToErr=='true'}">checked</c:if> ><label><iman:string key="LoggingConfig.LogToErr.label"/></label></input></div>
		<div><input onChange="changed();" type="checkbox" name="loggingToOut" <c:if test="${loggingToOut=='true'}">checked</c:if> ><label><iman:string key="LoggingConfig.LogToOut.label"/></label></input></div>
		<div><input onChange="changed();" type="checkbox" name="loggingToFile" <c:if test="${loggingToFile=='true'}">checked</c:if> ><label><iman:string key="LoggingConfig.LogToFile.label"/></label></input></div>
		<div class="smalltext" style="margin-top: 0.75em"><iman:string key="LoggingConfig.LogFile" />&nbsp;&nbsp;<b><c:out value="${loggingFile}" /></b></div>
		<div class="smalltext" style="margin-top: 0.5em"><iman:string key="LoggingConfig.LogFileSize" />&nbsp;&nbsp;<b><c:out value="${loggingFileSize}" />&nbsp;<iman:string key="BYTES"/></b></div>
		<div style="margin-top: 1em"><iman:button key="View" onClick="loggingDoAction('LoggingView')" />&nbsp;<iman:button key="Clear" onClick="loggingDoAction('LoggingClear')"/></div>
	</div>
</div>


<!---------------------- Authentication Div ---------------------->
   <div id="AuthenticationTab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="3">
         <iman:tab textKey="SysConfig.Security" onClick="showHideTabs('SecurityTab','LookFeelTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.LookFeel" onClick="showHideTabs('LookFeelTab','SecurityTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Logging" onClick="showHideTabs('LoggingTab','SecurityTab','LookFeelTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Authentication" onClick="showHideTabs('AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.RBS" onClick="showHideTabs('RBSTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Module" onClick="showHideTabs('ModuleTab','MiscTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
         <iman:tab textKey="SysConfig.Misc" onClick="showHideTabs('MiscTab','ModuleTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
      </iman:tabSet>

	<div style="margin-top: 1em; margin-left: 1em"><input onChange="changed();" type="checkbox" name="AuthUseCookies" value="<c:out value="${AuthUseCookies}"/>" <c:if test="${AuthUseCookies=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.AuthUseCookies"/></label></div>
	<div style="margin-top: 0.25em; margin-left: 1em"><input onChange="changed();" type="checkbox" name="AuthSecondayLDAPUsingSSL" value="<c:out value="${AuthSecondayLDAPUsingSSL}"/>" <c:if test="${AuthSecondayLDAPUsingSSL=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.AuthSecondayLDAPUsingSSL"/></label>&nbsp;&nbsp;<span class="instructions">(<iman:string key="SysConfig.AuthSecondayLDAPUsingSSLWarning"/>)</span></div>
	<div style="margin-top: 0.25em; margin-left: 1em"><input onChange="changed();" type="checkbox" name="AuthHideLoginFailReason" value="<c:out value="${AuthHideLoginFailReason}"/>" <c:if test="${AuthHideLoginFailReason=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.AuthHideLoginFailReason"/></label></div>
	
	<!--       LDAP protocol choice disabled.
	<div style="margin-top: 1em; margin-left: 1em"><input onChange="changed();" type="checkbox" name="AuthShowProtocol" onclick="checkAuthShowProtocol(true);" value="<c:out value="${AuthShowProtocol}"/>" <c:if test="${AuthShowProtocol=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.AuthShowProtocol"/></label></div>
   <div style="margin-left: 2em; margin-bottom: 2em"><label><iman:string key="SysConfig.AuthDefProtocol"/></label>
      <select style="height: 24px; width: <iman:string key="UI.textboxPixel"/>"  size='iman:string key="UI.textboxPixel"'  name="AuthDefProtocolList" onChange="updateAuthDefProtocol();changed();" style="width:<iman:string key="UI.textboxPixel"/>">
         <option value="none" class=mediumtext><iman:string key="SysConfig.AutheDirectory"/></option>
         <option value="none" class=mediumtext><iman:string key="SysConfig.AuthLDAP"/></option>
         <option value="none" class=mediumtext><iman:string key="SysConfig.AuthLDAPUsingSSL"/></option>
      </select>
   </div>-->




	<div style="margin-top: 0.25em; margin-left: 1em"><input onChange="changed();" type="checkbox" name="AuthShowTree" onclick="checkAuthShowTree();" value="<c:out value="${AuthShowTree}"/>" <c:if test="${AuthShowTree=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.AuthShowTree"/></label></div>
	<div style="margin-left: 2em"><label><iman:string key="SysConfig.AuthDefTree"/></label>&nbsp;<input onChange="changed();" type=text name="AuthDefTree" value="<c:out value="${AuthDefTree}"/>" style="width:<iman:string key="UI.textboxPixel"/>"  size='iman:string key="UI.textboxPixel"' maxlength=64></input></div>
	<div class="tablesubhead1"  style="margin-top: 1em; width: 98%"><iman:string key="SysConfig.AuthEnableCxtlessLogin"/>&nbsp;&nbsp;<input onChange="changed();" type="checkbox" name="AuthEnableCxtlessLogin" onclick="checkCxtlessLoginFields();" value="<c:out value="${AuthEnableCxtlessLogin}"/>" <c:if test="${AuthEnableCxtlessLogin=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.AuthEnableLabel"/></label></div>
	<div class="instructions" style="margin-top: 0.75em; width: 80%"><iman:string key="SysConfig.AuthCxtlessLoginDesc"/></div>
	<table style="margin-top: 1em; margin-bottom: 1em" border="0" cellspacing="3" cellpadding="0">
		<tr>
			<td></td>
			<td></td>
		</tr>
		<tr>
			<td><label><iman:string key="SysConfig.AuthSelectedTreeName"/></label></td>
			<td><c:out value="${AuthSelectedTree}" /></td>
		</tr>
		<!--<tr>
			<td><label><iman:string key="SysConfig.AuthSelectedTree"/></label></td>
			<td>
				<select name="AuthTreeList" onChange="updateAuthTreeList(this);changed();" style="width:<iman:string key="UI.textboxPixel" />" onFocus="savePrevAuthenticationInfo(this);">
               <%
                  //if (null != AuthTreeListParam)
                  //{
                  //   int size = AuthTreeListParam.length;
                  //   for(int i=0; i<size; i++)
                  //   {
                  //      out.print("<option value=\"" + AuthTreeListParam[i] + "\">" + AuthTreeListParam[i]);
                  //   }
                  //}
               %>
				</select>
            <a href="#" onClick="savePrevAuthenticationInfo(document.SysConfig.AuthTreeList);blockPrevAuthInfoOnFocus=true;addAuthTreeList(SysConfig.AuthTreeList, 'junk', 'My new Value:');"><img alt="<iman:string key="Widgets.addItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconadd.gif" border="0" ></a>
            <a href="#" onClick="removeAuthTreeList(SysConfig.AuthTreeList);"><img alt="<iman:string key="Widgets.removeItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconremove.gif" border="0" ></a>
			</td>
		</tr>-->
		<tr>
			<td>&nbsp;</td><td><input type="radio" name="searchContainers" value="search-root"  <c:if test="${SearchContainerOption=='root'}">checked</c:if> onClick="disableContainers();toggleContextlessSubFields();"/><label><iman:string key="SysConfig.SearchFromRoot"/></label></td>
		</tr>
		<tr>
			<td>&nbsp;</td><td><input type="radio" name="searchContainers" value="search-containers" <c:if test="${SearchContainerOption=='containers'}">checked</c:if> onClick="enableContainers();toggleContextlessSubFields();"/><label><iman:string key="SysConfig.SearchContainers"/></label></td>
		</tr>
		<tr>
			<td valign="top"><label><iman:string key="SysConfig.AuthSearchContainers"/></label></td>
			<td><iman:mved mode="mvsel" size="5" name="AuthSearchContainers" objectTypeName="Alias,[containers],[root]," enforceUnique="true" history="true" items="${AuthSearchContainers}" onChangeCallback="changed"/></td>
			<td valign="top"><table><tr><td valign="middle"><A href="#" onclick="javascript:moveOptionUp(document.SysConfig.AuthSearchContainers);changed();checkValidSelection(document.SysConfig.AuthSearchContainers);"><IMG  title="<iman:string key="MoveUp.alt"/>" border="0" src="<c:out value="${ModulesPath}"/>/dev/images/up16.gif"></A>&nbsp;<A href="#" onclick="javascript:moveOptionDown(document.SysConfig.AuthSearchContainers);changed();checkValidSelection(document.SysConfig.AuthSearchContainers);"><IMG title="<iman:string key="MoveDown.alt"/>" border="0" src="<c:out value="${ModulesPath}"/>/dev/images/down16.gif" ></A></td></tr></table></td>
			<input type="hidden" name="AuthSearchContainers_mvedData"/>
		</tr>
		<tr/><tr/>
		<tr>
			<td><label><iman:string key="SysConfig.AuthPublicUser"/></label></td>
			<td><input onChange="changed();" type=text name="AuthPublicUser" value="<c:out value="${AuthPublicUser}"/>" style="width:<iman:string key="UI.textboxPixel"/>"  size='iman:string key="UI.textboxPixel"' maxlength=64>
			         <iman:os control="AuthPublicUser" typeFilter="User" history="true" windowed="true"/>
			</td>
		</tr>
		<tr>
			<td><label><iman:string key="SysConfig.AuthPublicPassword"/></label></td>
			<td><input type=password name="AuthPublicPassword" onChange="setPasswordFlag();changed();" value="<c:out value="${AuthPublicPassword}"/>" style="width:<iman:string key="UI.textboxPixel"/>"  size='iman:string key="UI.textboxPixel"' maxlength=64 onChange=""></input></td>
		</tr>
		<tr>
			<td><label><iman:string key="SysConfig.AuthRetypePublicPassword"/></label></td>
			<td><input type=password name="AuthRetypePublicPassword" onChange="setPasswordFlag();changed();" value="<c:out value="${AuthRetypePublicPassword}"/>" style="width:<iman:string key="UI.textboxPixel"/>"  size='iman:string key="UI.textboxPixel"' maxlength=64 onChange=""></input></td>
		</tr>
		<tr>
			<td></td>
			<td>	<div class="instructions"><iman:string key="SysConfig.AuthPsswordNote" /></div></td>
		</tr>
		<IFRAME src="/nps/Empty.html" style="visibility: hidden" name="sysConfigExchangerFrame" id="sysConfigExchangerFrame" width="0" height="0" marginwidth="0" marginheight="0"></IFRAME>
	</table>

	<div class="tablesubhead1"  style="margin-top: 1em; width: 98%"><iman:string key="SysConfig.ServerTimeoutSettings"/></div>    
    <TABLE>
	 	<TR>
	  	<TD align=left colspan=2> 
               <INPUT name='NeverTimeout' onClick="disableControls();" type=checkbox value="<c:out value="${NeverTimeoutEnable}"/>" <c:if test="${NeverTimeoutEnable=='true'}">checked</c:if>>
               <LABEL><iman:string key="SysConfig.NeverTimeout"/></LABEL> 
            </TD>
    	 </TR>
	      <TR>
            <TD height=8></TD>
         </TR>
         <TR>
            <TD class=smalltext>
            
              <INPUT name='ServerTimeoutSettings' type=hidden>
              <INPUT name='_ServerTimeoutSettings' type=hidden>
              &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<LABEL><%= c.string("UIHandler.Days") %></LABEL>
               <INPUT type=text size="3" maxlength="3" name="_ServerTimeoutSettingsDays" onChange='validateNumericString(this, "<%= c.string("UIHandler.OnlyDigits") %> "); validateIntegerField(this, 0, 999); '>
               &nbsp;<LABEL><%= c.string("UIHandler.Hours") %></LABEL>
              <INPUT type=text size="3" maxlength="3" name="_ServerTimeoutSettingsHours" onChange='validateNumericString(this, "<%= c.string("UIHandler.OnlyDigits") %> "); validateIntegerField(this, 0, 999); '>
              &nbsp;<LABEL><%= c.string("UIHandler.Minutes") %></LABEL>
               <INPUT type=text size="3" maxlength="3" name="_ServerTimeoutSettingsMinutes"  onChange='validateNumericString(this, "<%= c.string("UIHandler.OnlyDigits") %> "); validateIntegerField(this, 0, 999); '>
            
            </td>
         </tr>
         
      </TABLE>
      
         
    
	<div class="tablesubhead1"  style="margin-top: 1em; width: 98%"><iman:string key="SysConfig.AuthPostLogoutURLEnable"/>&nbsp;&nbsp;<input onChange="changed();" type="checkbox" name="PostLogoutURLEnable" onClick="togglePostLogoutURLBox();" value="<c:out value="${PostLogoutURLEnable}"/>" <c:if test="${PostLogoutURLEnable=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.AuthEnableLabel"/></label></div>
	<div class="instructions" style="margin-top: 0.75em; width: 80%"><iman:string key="SysConfig.AuthPostLogoutURLNote"/></div>
	<div style="margin-top: 0.50em;"><label><iman:string key="SysConfig.AuthPostLogoutURLURL"/></label>&nbsp;<input type=text name="PostLogoutURL" onChange="changed();" value="<c:out value="${PostLogoutURL}"/>" style="width:<iman:string key="UI.textboxPixel"/>" size='iman:string key="UI.textboxSize"' maxlength=64></input></div>	
	
</div>

<!---------------------- RBS Div ---------------------->
<div id="RBSTab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="4">
         <iman:tab textKey="SysConfig.Security" onClick="showHideTabs('SecurityTab','LookFeelTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.LookFeel" onClick="showHideTabs('LookFeelTab','SecurityTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Logging" onClick="showHideTabs('LoggingTab','SecurityTab','LookFeelTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Authentication" onClick="showHideTabs('AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.RBS" onClick="showHideTabs('RBSTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Module" onClick="showHideTabs('ModuleTab','MiscTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
         <iman:tab textKey="SysConfig.Misc" onClick="showHideTabs('MiscTab','ModuleTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
      </iman:tabSet>

	<div class="tablesubhead1" style="margin-bottom: 1em"><iman:string key="SysConfig.RBSTitle"/></div>
	<div style="margin-left: 1em">
		<div><input onChange="changed();" type="checkbox" name="RBSUnrestrictedAccess" value="<c:out value="${RBSUnrestrictedAccess}"/>" <c:if test="${RBSUnrestrictedAccess=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.RBSUnrestrictedAccess"/></label></div>
		<div style="margin-left: 1em" class="instructions"><iman:string key="SysConfig.RBSUnrestrictedAccessNote"/></div>
		<div><input onChange="changed();" type="checkbox" name="RBSEnableDynamicGroup" value="<c:out value="${RBSEnableDynamicGroup}"/>" <c:if test="${RBSEnableDynamicGroup=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.RBSEnableDynamicGroup"/></label></div>
		<div><input onChange="changed();" type="checkbox" name="RBSShowRolesInCollection" value="<c:out value="${RBSShowRolesInCollection}"/>" <c:if test="${RBSShowRolesInCollection=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.RBSShowRolesInCollection"/></label></div>
		<table>
			<tr>
				<td colspan="4">&nbsp;</td></tr>
			<tr>
				<td><label><iman:string key="SysConfig.RBSRoleDiscovery"/></label></td>
            <td>
					<select name="RBSRoleDiscoveryList" onChange="updateRBSRoleDiscovery();changed();" style="width:<iman:string key="UI.textboxPixel"/>">
                  	<option value="none"><iman:string key="SysConfig.RBSParent"/></option>
                  	<option value="none"><iman:string key="SysConfig.RBSRoot"/></option>
                  	<option value="none"><iman:string key="SysConfig.RBSPartition"/></option>
					</select>
		   	</td>
		   </tr>
		   <tr>
		    	<td><label><iman:string key="SysConfig.RBSGroupDiscovery"/></label></td>
            <td>
		         <select name="RBSGroupDiscoveryList" onChange="updateRBSGroupDiscovery();changed();" style="width:<iman:string key="UI.textboxPixel"/>">
          	      <option value="none"><iman:string key="SysConfig.RBSParent"/></option>
                  <option value="none"><iman:string key="SysConfig.RBSRoot"/></option>
                  <option value="none"><iman:string key="SysConfig.RBSPartition"/></option>
				</select>
		   	</td>
		   </tr>
			<tr>
				<td><label><iman:string key="SysConfig.RBSGroupSearchType"/></label></td>
            <td>
		  			<select name="RBSGroupSearchTypeList" onChange="updateRBSGroupSearchType();changed();" style="width:<iman:string key="UI.textboxPixel"/>">
		     			<option value="none"><iman:string key="SysConfig.DynamicGroupObjectsOnly"/></option>
                	  	<option value="none"><iman:string key="SysConfig.DynamicGroupObjectsAuxClasses"/></option>
		     		</select>
				</td>
			</tr>
			<tr>
				<td ><label><iman:string key="SysConfig.RBSTreeList"/></label></td>
            <td>
               <select onChange="changed();" name="RBSTreeList" style="width:<iman:string key="UI.textboxPixel"/>">
               <%
                  if (null != RBSTreeListParam && RBSTreeListParam.length > 0)
                  {
                     int rbsTreeSize = RBSTreeListParam.length;
                     for(int j=0; j<rbsTreeSize; j++)
                     {
                        out.print("<OPTION value=\"" + RBSTreeListParam[j] + "\">" + RBSTreeListParam[j]);
                     }
                  }
                  else
                  {
                     out.print("<OPTION value=\"" + "none" + "\">" + "None");
                  }

               %>
               </select><a href="#" onClick="removeRBSTreeList(SysConfig.RBSTreeList);"><img alt="<iman:string key="Widgets.removeItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconremove.gif" border="0"></a>
				</td>
			</tr>
		</table>
   </div>

</div>

<!---------------------- Module Div ---------------------->
   <div id="ModuleTab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="5">
         <iman:tab textKey="SysConfig.Security" onClick="showHideTabs('SecurityTab','LookFeelTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.LookFeel" onClick="showHideTabs('LookFeelTab','SecurityTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Logging" onClick="showHideTabs('LoggingTab','SecurityTab','LookFeelTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Authentication" onClick="showHideTabs('AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.RBS" onClick="showHideTabs('RBSTab','ModuleTab','MiscTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab')"/>
         <iman:tab textKey="SysConfig.Module" onClick="showHideTabs('ModuleTab','MiscTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
         <iman:tab textKey="SysConfig.Misc" onClick="showHideTabs('MiscTab','ModuleTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
      </iman:tabSet>

      <div>
         <div class="tablesubhead1" ><iman:string key="SysConfig.MiscDownloadModule"/></div>
         <div style="margin-left: 1em" class="instructions"><iman:string key="SysConfig.DownloadUrlRestartTomcatNote"/></div>
         
         <div nowrap style="margin-bottom: 0.25em;margin-top:  0.75em; margin-left: 1em"><input type="checkbox" onChange="disableDownloadUrl(); changed();" name="ShouldModuleDownload" onClick="disableDownloadUrl(); toggleDownloadUrl(); EnableDisableMiscRadio(this);" value="<c:out value="${ShouldModuleDownload}"/>" <c:if test="${ShouldModuleDownload=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.MiscShouldModuleDownload"/></label></div>
         
         <div id="hideDownloadOptions"> 
         <div nowrap style="margin-bottom: 0.25em; margin-left: 2em"><input type="radio" name="DownloadModulesOption" onChange="changed();" onClick="disableCustomUrl()" value="novell-site" <c:if test="${NovellSite=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.NovellDownloadModules"/></label><span class="instructions">(http://www.novell.com/products/consoles/imanager/iman_mod_desc.xml)</span></div>
         <div nowrap style="margin-bottom: 0.25em; margin-left: 2em"><input type="radio" name="DownloadModulesOption" onChange=" changed();" onClick="enableCustomUrl()" value="custom-site" <c:if test="${NovellSite=='false'}">checked</c:if>></input><label><iman:string key="SysConfig.CustomDownloadModules"/></label></div>
         <div nowrap style="margin-left: 3.5em"><label><iman:string key="SysConfig.DownloadUrl"/></label><input type=text name="DownloadURL" onChange="changed();" value="<c:out value="${DownloadURL}"/>" style="width:375" ></input></div>
         </div>
         
         <div nowrap style="margin-top: 1em; margin-bottom: 0.25em; margin-left: 1em"><input type="radio" name="AllModulesToDownload" onChange="changed();" onClick="EnableDisableMiscRadio(this)" value="<c:out value="${AllModulesToDownload}"/>" <c:if test="${AllModulesToDownload=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.MiscAllModulesToDownload"/></label></div>
         <div nowrap style="margin-bottom: 1em; margin-left: 1em"><input type="radio" name="PartialModulesToDownload" onChange="changed();" onClick="EnableDisableMiscRadio(this)" value="<c:out value="${PartialModulesToDownload}"/>" <c:if test="${PartialModulesToDownload=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.MiscPartialModulesToDownload"/></label></div>
    
         <div class="tablesubhead1" style="margin-top: 1em"><iman:string key="SysConfig.ModulesDownloadProxyTitle"/> 
      		<font style="margin-top: 0.25em"><input onclick="enableCheckBoxes(this);disableProxy();changed();" onChange="disableProxy();changed();" type="checkbox" name="ModulesDownloadEnableProxy" value="<c:out value="${ModulesDownloadEnableProxy}"/>" <c:if test="${ModulesDownloadEnableProxy=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.ModulesDownloadEnableProxy"/></label></font>
   		 </div>
   		 <div style="margin-left: 1em" class="instructions"><iman:string key="SysConfig.ModulesDownloadProxyRestartTomcatNote"/></div>
         <div nowrap style="margin-top:  0.75em; margin-left: 1em" >
         <table style="margin-bottom: 0.25em" border="0" cellspacing="3" cellpadding="0">
			<tr>
			<td><label><iman:string key="SysConfig.ModulesDownloadProxyHost"/></label></td>
			<td><input onChange="changed();" type=text name="ModulesDownloadProxyHost" value="<c:out value="${ModulesDownloadProxyHost}"/>" size="16" maxlength=15 <c:if test="${ModulesDownloadEnableProxy=='false'}">disabled</c:if>></td>
			</tr>
			<tr>
			<td><label><iman:string key="SysConfig.ModulesDownloadProxyPort"/></label></td>
			<td><input onChange="changed();" type=text name="ModulesDownloadProxyPort" value="<c:out value="${ModulesDownloadProxyPort}"/>"   size="16" maxlength=5 <c:if test="${ModulesDownloadEnableProxy=='false'}">disabled</c:if>></td>			
			</tr>
			
			<tr>
			<td><label><iman:string key="SysConfig.ModulesDownloadProxyUserName"/></label></td>
			<td><input onChange="changed();" type=text name="ModulesDownloadProxyUserName" value="<c:out value="${ModulesDownloadProxyUserName}"/>" style="width:<iman:string key="UI.textboxPixel"/>"  size='iman:string key="UI.textboxPixel"' maxlength=64 <c:if test="${ModulesDownloadEnableProxy=='false'}">disabled</c:if>>
			</td>
			</tr>
			<tr>
			<td><label><iman:string key="SysConfig.ModulesDownloadProxyPassword"/></label></td>
			<td><input type=password name="ModulesDownloadProxyPassword" onChange="setProxyPasswordFlag();changed();" value="<c:out value="${ModulesDownloadProxyPassword}"/>" style="width:<iman:string key="UI.textboxPixel"/>"  size='iman:string key="UI.textboxPixel"' maxlength=64 onChange="" <c:if test="${ModulesDownloadEnableProxy=='false'}">disabled</c:if>></input></td>
			</tr>
			<tr>
			<td><label><iman:string key="SysConfig.ModulesDownloadProxyRetypePassword"/></label></td>
			<td><input type=password name="ModulesDownloadProxyRetypePassword" onChange="setProxyPasswordFlag();changed();" value="<c:out value="${ModulesDownloadProxyRetypePassword}"/>" style="width:<iman:string key="UI.textboxPixel"/>"  size='iman:string key="UI.textboxPixel"' maxlength=64 onChange="" <c:if test="${ModulesDownloadEnableProxy=='false'}">disabled</c:if>></input></td>
			</tr>
			
			
		  </table>
		  </div>
         
      </div>

   </div>


<!---------------------- Misc Div ---------------------->
   <div id="MiscTab" style="display: none" class="margintop3">
      <iman:tabSet selectedIndex="6">
         <iman:tab textKey="SysConfig.Security" onClick="showHideTabs('SecurityTab','LookFeelTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.LookFeel" onClick="showHideTabs('LookFeelTab','SecurityTab','LoggingTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Logging" onClick="showHideTabs('LoggingTab','SecurityTab','LookFeelTab','AuthenticationTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.Authentication" onClick="showHideTabs('AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab','ModuleTab','MiscTab')"/>
         <iman:tab textKey="SysConfig.RBS" onClick="showHideTabs('RBSTab','ModuleTab','MiscTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab')"/>
         <iman:tab textKey="SysConfig.Module" onClick="showHideTabs('ModuleTab','MiscTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
         <iman:tab textKey="SysConfig.Misc" onClick="showHideTabs('MiscTab','ModuleTab','AuthenticationTab','LoggingTab','SecurityTab','LookFeelTab','RBSTab')"/>
      </iman:tabSet>

      <div style="margin-left: 1em" style="margin-top: 1em">
         <div nowrap style="margin-bottom: 1em"><input type="checkbox" name="RBSEnableThis" onChange="changed();" value="<c:out value="${RBSEnableThis}"/>" <c:if test="${RBSEnableThis=='true'}">checked</c:if>></input><label><iman:string key="SysConfig.RBSEnableThis"/></label></div>
         <div><label><iman:string key="SysConfig.MisceGuideURL"/>&nbsp<input type=text name="MisceGuideURL" onChange="changed();" value="<c:out value="${MisceGuideURL}"/>" style="width:<iman:string key="UI.textboxPixel"/>" size='iman:string key="UI.textboxSize"' maxlength=64></label></input></div>
      </div>

   </div>


<div class="ruleabove" style="margin-top: 2em"><iman:button key="Save" onClick="saveConfig(); return false;"/>&nbsp;<a href="webacc?NPService=fw.LaunchService&NPAction=Return&returnID=<c:out value="${requestScope.taskId}" />"><IMG src="<%= c.getModulesUrl() %>/dev/images/<iman:string key='Button.Close.image' />" border=0 alt="<iman:string key="Button.Close.alt"/>" title="<iman:string key="Button.Close.alt"/>"></a></div>


</FORM>
   <iman:osFooter/>

</body>
</html>