<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" 
   import="com.novell.webaccess.common.JSPConduit" %>

<%
   JSPConduit c = JSPConduit.getJSPConduit(request);

   c.stringTable("DevResources");
   c.stringTable("FwResources");
%>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>
<iman:stringtable bundle="DevResources"/>
<iman:stringtable bundle="FwResources"/>

<HTML>
<HEAD>
<TITLE><%= c.string("RenameObject.RenameObjectTitle") %></TITLE>
<LINK href="<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>" rel="styleSheet" type="text/css">
<LINK href="<%= c.getModulesUrl() + "/dev/css/hf_obj_list_table.css" %>" rel="styleSheet" type="text/css">
<LINK href="<%= c.getModulesUrl() + "/dev/css/hf_dialog.css" %>" rel="stylesheet" type="text/css">
<LINK href="<%= c.getModulesUrl() + "/dev/css/hf_menu.css" %>" rel="stylesheet" type="text/css">
<LINK href="<%= c.getModulesUrl() + "/dev/css/hf_message.css" %>" rel="stylesheet" type="text/css">

<iman:eMFrameScripts />
<jsp:include page='<%= c.getPath("dev/OSScripts_inc.jsp") %>' flush="true" />
<SCRIPT type="text/javascript" src="<%= c.getModulesUrl() %>/fw/javascripts/TreeViewContent.js"></SCRIPT>
<jsp:include page='<%= c.getPath("dev/HelpScripts_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/ASScripts_inc.jsp") %>' flush="true" />
<SCRIPT type="text/javascript" src="<%= c.getModulesUrl() %>/dev/javascripts/ASBrowserScripts.js"></SCRIPT>

<STYLE type="text/css" media="screen">
	td {white-space:nowrap}
	.dialog .footer img { float: none; margin-right: 5px; }
</style>

<SCRIPT>
	/**
	 * 
	 */
	 
	var m_newAdvFilt = "";  // Holds the new Advanced Filter defined in the Filter dropdown box.
	
	function onPageLoad()
	{
		// Set the selected option in the select box to the selected type param we passed in.
		try {
			var sel = document.getElementById("selectTypeControl");
			sel.selectedIndex=0;  // Assume the first option.
			var typeSpan = document.getElementById("SelectedTypeSpan").firstChild.data;
			if (typeSpan != "")
			{
				var options = sel.options;
				for (var i=0; i<options.length; i++)
				{
					if(options.item(i).value == typeSpan)
					{
						sel.selectedIndex=i;
						document.TreeViewContent.TVCSelectedTypeIndex.value=i;
						break;
					}
				}
			}
		} catch(e) {}
		
		document.TreeViewContent.showAllContainers.checked = (document.TreeViewContent.TVCShowAllContainers.value=="true");

		m_newAdvFilt = document.TreeViewContent.TVCAdvFilter.value;
		updateFilterDisplay();
							
		TreeView_createXMLHttpRequest();
	
		var url = "webacc?NPService=<%= c.var("taskId") %>&nextState=initialCallBack";
		g_xmlHttpRequest.open("GET", url);
		g_xmlHttpRequest.onreadystatechange = TreeView_onPageLoadCallBack;
		g_xmlHttpRequest.send(null);
		
		TreeView_resizePage();
	} // end of onPageLoad()

	/**
	 * 
	 */
	function handleClickOnShowNextPage()
	{
		var url = "webacc?NPService=<%= c.var("taskId") %>&nextState=getNextBlockCallBack";
		TreeView_createXMLHttpRequest();
		g_xmlHttpRequest.open("GET", url);
		g_xmlHttpRequest.onreadystatechange = TreeView_getNextBlockCallBack;
		g_xmlHttpRequest.send(null);
	} // end of handleClickOnShowNextPage()

/**
 * Refresh the treeview content pane and then call tree pane to refresh appropriate containers
 * Bug 267739 – Cannot dismiss success message in Tree View after every other ojbect creation on Firefox.
 */
	function refreshTVC(url)
	{
		window.setTimeout("delayedRefreshTVC()",100)
	}
	
	/**
	 * 
	 */
	function delayedRefreshTVC()
	{
		var xmlDoc = g_xmlHttpRequest.responseXML;
		var error = TreeView_checkForError(xmlDoc);
		if(error == false)
		{		
			var containerDN = TreeView_getCurrentContainerDN(xmlDoc);
			var  cDNArray= new Array(1);		
			cDNArray[0] = containerDN;
			top.Mainscreen.ObjectView.Results.refreshContextsInTreeView(cDNArray);
		
			var url = "webacc?NPService=<%= c.var("taskId") %>&nextState=refreshListCallBack";
			TreeView_createXMLHttpRequest();
			g_xmlHttpRequest.open("GET", url);
			g_xmlHttpRequest.onreadystatechange = TreeView_refreshListCallBack;
			g_xmlHttpRequest.send(null);
		}
	}

	/**
	 * 
	 */
	function handleClickOnShowPreviousPage()
	{
		var url = "webacc?NPService=<%= c.var("taskId") %>&nextState=getPreviousBlockCallBack";
		TreeView_createXMLHttpRequest();
		g_xmlHttpRequest.open("GET", url);
		g_xmlHttpRequest.onreadystatechange = TreeView_getPreviousBlockCallBack;
		g_xmlHttpRequest.send(null);
	} // end of handleClickOnShowPreviousPage()

	 /**
	 * 
	 */
	 function showHelpWindow()
	{
	   launchHelp("fw/treeview.html");
	} // end of showHelpWindow()
 
	 /**
	 * 
	 */
	function removeNodeAndChildrenRecursively(node)
	{
		if (node != null)
		{
			removeChildrenRecursively(node);
			node.parentNode.removeChild(node);
		}
	} // end of removeNodeAndChildrenRecursively()
 
	 /**
	 * 
	 */
	function removeChildrenRecursively(node)
	{
		if (node != null)
    	{
	   	while (node.hasChildNodes())
			{
	      	removeChildrenRecursively(node.firstChild);
	       	node.removeChild(node.firstChild);
			}
		}
	} // end of removeChildrenRecursively()
    
	 /**
	 * 
	 */
	function addDeleteMenuItems(xmlDoc)
	{
		var deleteMenuSpan = document.getElementById("deleteMenuSpan");
		
		// Remove the deleteMenuDiv if it exist
		var deleteMenuDiv = document.getElementById("deleteMenuDiv");
		removeNodeAndChildrenRecursively(deleteMenuDiv);
		
		// Get the menu items for the Delete menu
		var menuItemNodes = TreeView_getMenuItemNodes(xmlDoc);
		if(menuItemNodes.length > 0)
		{
			if(menuItemNodes.length == 1)
			{
				singleMenuItem(menuItemNodes[0]);
			}
			else
			{		
				// Create the deleteMenuDiv
				deleteMenuDiv = document.createElement('div');	// create dynamically div tag
				deleteMenuDiv.setAttribute('id',"deleteMenuDiv");     //give it an id
				deleteMenuDiv.className="menudetail";						// set the style classname
				deleteMenuSpan.appendChild(deleteMenuDiv);				// added it the the deleteMenuSpan
				
				// Create the deleteMenuTitleDiv
				deleteMenuTitleDiv = document.createElement('div');	// create dynamically div tag
				deleteMenuTitleDiv.setAttribute('id',"deleteMenuTitleDiv");     //give it an id
				deleteMenuTitleDiv.className="menutitle";						// set the style classname
				deleteMenuTitleDiv.innerHTML="<%= JSPConduit.toHTML( c.string( "TV.Menu.Delete" ) )%>";
				deleteMenuDiv.appendChild(deleteMenuTitleDiv);				// added it the the deleteMenuSpan
				
				var closeA = document.createElement('a');
				closeA.href = '#';		
				closeA.onclick=function()	{showhide('deleteMenuSpan');	}
				deleteMenuTitleDiv.appendChild(closeA);
				
				var img = document.createElement( 'img' );
				img.className="closebutton";
				img.src="<%= c.getModulesUrl() + "/dev/images/nl_close_16.gif" %>";
				img.alt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Close" ) )%>";
				img.title="<%= JSPConduit.toHTML( c.string( "TV.Alt.Close" ) )%>";
				img.height="16";
				img.width="16";
				img.align="absmiddle";
				img.border="0";
				closeA.appendChild(img);
							
				addMenuItemsToMenu(deleteMenuDiv, menuItemNodes, "delete");							
		
				// Create the deleteMenuFooterDiv
				deleteMenuFooterDiv = document.createElement('div');	// create dynamically div tag
				deleteMenuFooterDiv.setAttribute('id',"deleteMenuFooterDiv");     //give it an id
				deleteMenuFooterDiv.className="menubottom";						// set the style classname
				deleteMenuDiv.appendChild(deleteMenuFooterDiv);				// added it the the deleteMenuSpan
				showhide('deleteMenuSpan');
			}
		}
		else
		{
			alert("<%= JSPConduit.toHTML( c.string("TV.Alert.No.Delete.Tasks") )%>");
		}
	} // end of addDeleteMenuItems()
   
   /*
   *
   */
   function addMenuItemsToMenu(menuDiv, menuItemNodes, divAndActionPrefix, containerDN)
   {
		var minWidth = 0;
		// added to fix bugs with mozilla.  Should not needed for ie and firefox fixes menu resize issues.
		var b=document.getElementsByTagName('body')[0];
			var span = document.createElement( 'span' );
			b.appendChild(span);
				for(var i = 0; i < menuItemNodes.length; i++)
				{
					var str = menuItemNodes[i].getAttribute('display-name');
					var taskID = menuItemNodes[i].getAttribute('task-id');
				
					var dv = document.createElement('div'); // create dynamically div tag
			dv.setAttribute('id',divAndActionPrefix+"MenuContentDiv" + i);       //give id to it
					dv.className="menuitem1";                 // set the style classname
					dv.align="left"; 
					if(navigator.appName == "Microsoft Internet Explorer")
					{
						dv.style.width="10px";
					}
					
					var anchor = document.createElement( 'a' );
			
			anchor.setAttribute('id',divAndActionPrefix+"MenuAnchor" + i);       //give id to it
					anchor.href = '#';
					anchor.innerHTML=str;
			span.innerHTML=str;
					anchor.taskID=taskID;
					anchor.onmouseover=function(){TreeView_setMenuItemMouseOverColor(this);} 
					anchor.onmouseout=function(){	TreeView_setMenuItemMouseOutColor(this);}
			if(divAndActionPrefix != "new"){
				anchor.onclick=function(){handleClickOnMenuItem(this, divAndActionPrefix+'MenuSpan');}
			}else{
				anchor.onclick=function(){handleClickOnNewMenuItem(this, divAndActionPrefix+'MenuSpan', containerDN);}
			}
			
					dv.appendChild(anchor);
			menuDiv.appendChild(dv);
			// added to fix bugs with mozilla.  Should not needed for ie and firefox fixes menu resize issues.
			var textWidth = span.scrollWidth;
			if(textWidth > minWidth)
			{
				minWidth = textWidth;
			}
			
		}
		// added to fix bugs with mozilla.  Should not needed for ie and firefox fixes menu resize issues.
		b.removeChild(span);
		if(menuDiv.style.width < minWidth){
			menuDiv.style.width=minWidth; 
		}
   
   } // end of addMenuItemsToMenu
   
   
	 /**
	 * 
	 */
	function addActionsMenuItems(xmlDoc)
	{
		var actionsMenuSpan = document.getElementById("actionsMenuSpan");
		
		// Remove the actionsMenuDiv if it exist
		var actionsMenuDiv = document.getElementById("actionsMenuDiv");
		removeNodeAndChildrenRecursively(actionsMenuDiv);
		
		// Get the menu items for the Actions menu
		var menuItemNodes = TreeView_getMenuItemNodes(xmlDoc);
		if(menuItemNodes.length > 0)
		{
			// Create the actionsMenuDiv
			actionsMenuDiv = document.createElement('div');	// create dynamically div tag
			actionsMenuDiv.setAttribute('id',"actionsMenuDiv");     //give it an id
			actionsMenuDiv.className="menudetail";						// set the style classname				
			actionsMenuSpan.appendChild(actionsMenuDiv);				// added it the the actionsMenuSpan
			
			// Create the actionsMenuTitleDiv
			actionsMenuTitleDiv = document.createElement('div');	// create dynamically div tag
			actionsMenuTitleDiv.setAttribute('id',"actionsMenuTitleDiv");     //give it an id
			actionsMenuTitleDiv.className="menutitle";						// set the style classname
			actionsMenuTitleDiv.innerHTML="<%= JSPConduit.toHTML( c.string( "TV.Menu.Actions" ) )%>";
			actionsMenuDiv.appendChild(actionsMenuTitleDiv);				// added it the the actionsMenuSpan
			
			var closeA = document.createElement('a');
			closeA.href = '#';		
			closeA.onclick=function()	{showhide('actionsMenuSpan');}
			actionsMenuTitleDiv.appendChild(closeA);
			
			var img = document.createElement( 'img' );
			img.className="closebutton";
			img.src="<%= c.getModulesUrl() + "/dev/images/nl_close_16.gif" %>";
			img.alt="<%= JSPConduit.toHTML( c.string("TV.Alt.Close") )%>";
			img.title="<%= JSPConduit.toHTML( c.string("TV.Alt.Close") )%>";
			img.height="16";
			img.width="16";
			img.align="absmiddle";
			img.border="0";
			closeA.appendChild(img);
						
			addMenuItemsToMenu(actionsMenuDiv, menuItemNodes, "actions");							
			
				
			// Create the actionsMenuFooterDiv
			actionsMenuFooterDiv = document.createElement('div');	// create dynamically div tag
			actionsMenuFooterDiv.setAttribute('id',"actionsMenuFooterDiv");     //give it an id
			actionsMenuFooterDiv.className="menubottom";						// set the style classname
			actionsMenuDiv.appendChild(actionsMenuFooterDiv);				// added it the the actionsMenuSpan
			showhide('actionsMenuSpan');
		}
		else
		{
			alert("<%= JSPConduit.toHTML( c.string( "TV.Alert.No.Actions.Tasks" ) )%>");
		}
	} // end of addActionsMenuItems()

	 /**
	 * 
	 */
	function addEditMenuItems(xmlDoc)
	{
		var editMenuSpan = document.getElementById("editMenuSpan");
		
		// Remove the editMenuDiv if it exist
		var editMenuDiv = document.getElementById("editMenuDiv");
		removeNodeAndChildrenRecursively(editMenuDiv);
		
		// Get the menu items for the Edit menu
		var menuItemNodes = TreeView_getMenuItemNodes(xmlDoc);
		if(menuItemNodes.length > 0)
		{
			if(menuItemNodes.length == 1)
			{
				singleMenuItem(menuItemNodes[0]);
			}
			else
			{		
				// Create the editMenuDiv
				editMenuDiv = document.createElement('div');	// create dynamically div tag
				editMenuDiv.setAttribute('id',"editMenuDiv");     //give it an id
				editMenuDiv.className="menudetail";						// set the style classname
				editMenuSpan.appendChild(editMenuDiv);				// added it the the editMenuSpan
				
				// Create the editMenuTitleDiv
				editMenuTitleDiv = document.createElement('div');	// create dynamically div tag
				editMenuTitleDiv.setAttribute('id',"editMenuTitleDiv");     //give it an id
				editMenuTitleDiv.className="menutitle";						// set the style classname
				editMenuTitleDiv.innerHTML="<%= JSPConduit.toHTML( c.string( "TV.Menu.Edit" ) )%>";
				editMenuDiv.appendChild(editMenuTitleDiv);				// added it the the editMenuSpan
				
				var closeA = document.createElement('a');
				closeA.href = '#';		
				closeA.onclick=function()	{showhide('editMenuSpan');	}
				editMenuTitleDiv.appendChild(closeA);
				
				var img = document.createElement( 'img' );
				img.className="closebutton";
				img.src="<%= c.getModulesUrl() + "/dev/images/nl_close_16.gif" %>";
				img.alt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Close" ) )%>";
				img.title="<%= JSPConduit.toHTML( c.string( "TV.Alt.Close" ) )%>";
				img.height="16";
				img.width="16";
				img.align="absmiddle";
				img.border="0";
				closeA.appendChild(img);
							

				addMenuItemsToMenu(editMenuDiv, menuItemNodes, "edit");							

	
				// Create the editMenuFooterDiv
				editMenuFooterDiv = document.createElement('div');	// create dynamically div tag
				editMenuFooterDiv.setAttribute('id',"editMenuFooterDiv");     //give it an id
				editMenuFooterDiv.className="menubottom";						// set the style classname
				editMenuDiv.appendChild(editMenuFooterDiv);				// added it the the editMenuSpan
				showhide('editMenuSpan');
			}
		}
		else
		{
			alert("<%= JSPConduit.toHTML( c.string( "TV.Alert.No.Edit.Tasks" ) )%>");
		}
	} // end of addEditMenuItems()

	function addBreadCrumbLinks(xmlDoc)
	{
		// Remove the breadCrumbDiv content
		var breadCrumbDiv = document.getElementById("breadCrumbDiv");
		removeChildrenRecursively(breadCrumbDiv);
	
		var nsNode = xmlDoc.getElementsByTagName("name-space");
		var nsElement = nsNode[0]; // Should only be one container node
		var nsType = nsElement.getAttribute('ns-type');

		var breadCrumbNodes = xmlDoc.getElementsByTagName("bread-crumb");
		for(var i = 0; i < breadCrumbNodes.length; i++)
		{
			if((i > 0) || (nsType == "filesystem"))
			{
				var img = document.createElement('img');
				if(nsType == "eDirectory")
				{
					img.src="<%= c.getModulesUrl() + "/dev/images/breadspace.gif" %>";
				}
				else
				{
					img.src="<%= c.getModulesUrl() + "/dev/images/volumespace.gif" %>";
				}
				
				img.height="8";
				img.width="17";
				img.align="absmiddle";
				breadCrumbDiv.appendChild(img);
			}
			
			var displayName = breadCrumbNodes[i].getAttribute('display-name');
			var objectDN = breadCrumbNodes[i].getAttribute('object-dn');
			
			if((i + 1) == breadCrumbNodes.length)
			{
					var tail = document.createTextNode(displayName);
					breadCrumbDiv.appendChild(tail);
			}
			else
			{
				var anchor = document.createElement( 'a' );
				anchor.setAttribute('id',"breadCrumbAnchor" + i);       //give id to it
				anchor.href = '#';
				anchor.align="absmiddle";
				anchor.height="8";
				anchor.innerHTML=displayName;
				anchor.objectDN=objectDN;
				anchor.onmouseover=function(){TreeView_setMenuItemMouseOverColor(this);} 
				anchor.onmouseout=function(){	TreeView_setMenuItemMouseOutColor(this);}
				anchor.onclick=function(){handleClickOnBreadCrumb(this)}
				breadCrumbDiv.appendChild(anchor);
			}
		}
	} // end of addBreadCrumbLinks()
	
	function handleClickOnBreadCrumb(anchor)
	{
//		alert(anchor.objectDN);
		displayContainer(anchor.objectDN);
	}
	
	 /**
	 * 
	 */
	function addNewMenuItems(xmlDoc)
	{
		var containerDN = TreeView_getCurrentContainerDN(xmlDoc);
		var newMenuSpan = document.getElementById("newMenuSpan");
		
		// Remove the newMenuDiv if it exist
		var newMenuDiv = document.getElementById("newMenuDiv");
		removeNodeAndChildrenRecursively(newMenuDiv);
		
		// Get the menu items for the New menu
		var menuItemNodes = TreeView_getMenuItemTypeNodes(xmlDoc, "create");
		if(menuItemNodes.length > 0)
		{
			// Create the newMenuDiv
			newMenuDiv = document.createElement('div');	// create dynamically div tag
			newMenuDiv.setAttribute('id',"newMenuDiv");     //give it an id
			newMenuDiv.className="menudetail";						// set the style classname
			newMenuSpan.appendChild(newMenuDiv);				// added it the the newMenuSpan
			
			// Create the newMenuTitleDiv
			newMenuTitleDiv = document.createElement('div');	// create dynamically div tag
			newMenuTitleDiv.setAttribute('id',"newMenuTitleDiv");     //give it an id
			newMenuTitleDiv.className="menutitle";						// set the style classname
			newMenuTitleDiv.innerHTML="<%= JSPConduit.toHTML( c.string( "TV.Menu.New" ) )%>";
			newMenuDiv.appendChild(newMenuTitleDiv);				// added it the the newMenuSpan
			
			var closeA = document.createElement('a');
			closeA.href = '#';		
			closeA.onclick=function()	{showhide('newMenuSpan');	}
			newMenuTitleDiv.appendChild(closeA);
			
			var img = document.createElement( 'img' );
			img.src="<%= c.getModulesUrl() + "/dev/images/nl_close_16.gif" %>";
			img.alt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Close" ) )%>";
			img.title="<%= JSPConduit.toHTML( c.string( "TV.Alt.Close" ) )%>";
			img.height="16";
			img.width="16";
			img.align="absmiddle";
			img.border="0";
			closeA.appendChild(img);
						
			addMenuItemsToMenu(newMenuDiv, menuItemNodes, "new", containerDN);							

	
			// Create the newMenuFooterDiv
			newMenuFooterDiv = document.createElement('div');	// create dynamically div tag
			newMenuFooterDiv.setAttribute('id',"newMenuFooterDiv");     //give it an id
			newMenuFooterDiv.className="menubottom";						// set the style classname
			newMenuDiv.appendChild(newMenuFooterDiv);				// added it the the newMenuSpan
		}
	} // end of addNewMenuItems()

	/**
	 * 
	 */
	function handleClickOnEditMenu()
	{
		var	selectedRows;
		var	table;
	
		// Get the <table> that holds the list of object entries.
		table = TreeView_getObjectEntryTable();
		
		// Get the list of rows that have the checkbox checked.
		selectedRows = TreeView_getSelectedRows( table );
		if(TreeView_isDefined( selectedRows ) && selectedRows.length > 0)
		{
		   var selectedObjects = new Array(selectedRows.length);
			for(i = 0; i < selectedRows.length; ++i)
			{
				var	objectEntryElement;
				var	tr;
	
				// Get the next selected tr
				tr = selectedRows[i];
	
				// Get the element associated with this row.
				objectEntryElement = tr.n_objectEntryElement;
				if (TreeView_isDefined( objectEntryElement))
				{
					var	objectEntryDN;
	
					// Get the dn of the objects we are to edit.
					objectEntryDN = objectEntryElement.getAttribute('object-dn');
					if(TreeView_hasString( objectEntryDN))
					{
	               selectedObjects[i] = urlEncode(objectEntryDN);					
					}
				}
			}
			
			var url = "webacc?";
			var queryString = "NPService=<%= c.var("taskId") %>&nextState=getEditMenuTaskListCallBack&TVC_SelectedObjectList="+ pack(selectedObjects);
			TreeView_createXMLHttpRequest();
			g_xmlHttpRequest.open("POST", url);
			g_xmlHttpRequest.onreadystatechange = TreeView_getEditMenuTaskListCallBack;
			g_xmlHttpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;");
			g_xmlHttpRequest.send(queryString);
		}
		else
		{
			alert("<%= JSPConduit.toHTML(c.string("TV.Alert.No.Items.Selected"))%>");
		}
	} // end of handleClickOnEditMenu()


	/**
	 * 
	 */
	function handleClickOnDeleteMenu()
	{	
		var	selectedRows;
		var	table;
	
		// Get the <table> that holds the list of object entries.
		table = TreeView_getObjectEntryTable();
		
		// Get the list of rows that have the checkbox checked.
		selectedRows = TreeView_getSelectedRows( table );
		if(TreeView_isDefined( selectedRows ) && selectedRows.length > 0)
		{
		   var selectedObjects = new Array(selectedRows.length);
			for(i = 0; i < selectedRows.length; ++i)
			{
				var	objectEntryElement;
				var	tr;
	
				// Get the next selected tr
				tr = selectedRows[i];
	
				// Get the element associated with this row.
				objectEntryElement = tr.n_objectEntryElement;
				if(TreeView_isDefined( objectEntryElement))
				{
					var	objectEntryDN;
	
					// Get the dn of the objects we are to delete.
					objectEntryDN = objectEntryElement.getAttribute('object-dn');
					if(TreeView_hasString( objectEntryDN))
					{
	               selectedObjects[i] = urlEncode(objectEntryDN);					
					}
				}
			}
			
			var url = "webacc?";
			var queryString = "NPService=<%= c.var("taskId") %>&nextState=getDeleteMenuTaskListCallBack&TVC_SelectedObjectList="+ pack(selectedObjects);
			TreeView_createXMLHttpRequest();
			g_xmlHttpRequest.open("POST", url);
			g_xmlHttpRequest.onreadystatechange = TreeView_getDeleteMenuTaskListCallBack;
			g_xmlHttpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;");
			g_xmlHttpRequest.send(queryString);
		}
		else
		{
			alert("<%= JSPConduit.toHTML(c.string("TV.Alert.No.Items.Selected"))%>");
		}
	} // end of handleClickOnDeleteMenu()
 
	 /**
	 * 
	 */
	function handleClickOnActionsMenu()
	{	
		var	selectedRows;
		var	table;
	
		// Get the <table> that holds the list of object entries.
		table = TreeView_getObjectEntryTable();
		
		// Get the list of rows that have the checkbox checked.
		selectedRows = TreeView_getSelectedRows( table );
		if(TreeView_isDefined( selectedRows ) && selectedRows.length > 0)
		{
		   var selectedObjects = new Array(selectedRows.length);
			for(i = 0; i < selectedRows.length; ++i)
			{
				var	objectEntryElement;
				var	tr;
	
				// Get the next selected tr
				tr = selectedRows[i];
	
				// Get the element associated with this row.
				objectEntryElement = tr.n_objectEntryElement;
				if(TreeView_isDefined( objectEntryElement))
				{
					var	objectEntryDN;
	
					// Get the dn of the object we are to delete.
//					objectEntryDN = objectEntryElement.childNodes[0].nodeValue;
					objectEntryDN = objectEntryElement.getAttribute('object-dn');
					if(TreeView_hasString( objectEntryDN))
					{
	               selectedObjects[i] = urlEncode(objectEntryDN);					
					}
				}
			}
			
			var url = "webacc?";
			var queryString = "NPService=<%= c.var("taskId") %>&nextState=getActionsMenuTaskListCallBack&TVC_SelectedObjectList="+ pack(selectedObjects);
			TreeView_createXMLHttpRequest();
			g_xmlHttpRequest.open("POST", url);
			g_xmlHttpRequest.onreadystatechange = TreeView_getActionsMenuTaskListCallBack;
			g_xmlHttpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;");
			g_xmlHttpRequest.send(queryString);
		}
		else
		{
			alert("<%= JSPConduit.toHTML(c.string("TV.Alert.No.Items.Selected" ))%>");
		}
	} // end of handleClickOnActionsMenu()
   

	 /**
	 * 
	 */
	function editContainer(containerDN, launchTaskID)
	{
		var dnArray = new Array();
		dnArray[0] = containerDN;
			
		launchTask(launchTaskID, dnArray);
	} // end of editContainer()
 
	 /**
	 * 
	 */
	function launchTask(launchTaskID, dnArray )
	{     	
		// Open up a window for the property book to run in.
		var maxHeight = window.screen.height - 70;
		var height = 650;
		if(height > maxHeight)
		{
			height = maxHeight;
		}
		var width = 650;
		var x = (window.screen.width - width) / 2;
		var y = (maxHeight - height) / 2;
		var strUrl 	= "/nps/Empty.html";
		var windowName = "TreeViewLaunchTask";
		var woFeatures = 'height=' + height + ',width=' + width + ',left=' + x + ',top=' + y + ',resizable,scrollbars';
       				
		window.open(strUrl, windowName, woFeatures);

		document.TreeViewPostData.launch.value = launchTaskID;
		// Give em a repeat button for these tasks
		if(launchTaskID=="base.CreateUser" || launchTaskID=="base.ExtendObjects")
		{
		   document.TreeViewPostData.repeatable.value = "true";
		}
		else
		{
		   document.TreeViewPostData.repeatable.value = "false";
		}
  		document.TreeViewPostData.targetNames.value = pack(dnArray);	
		document.TreeViewPostData.target = windowName;
		document.TreeViewPostData.submit();
	} //end of launchTask()

	 /**
	 * 
	 */
	function onExit()
   {
   	window.location = "webacc?NPService=fw.LaunchService&NPAction=Return&returnID=<c:out value="${GI_ID}"/>";
	} // end of onExit()

	/**
	 * 
	 */
	function addObjectEntryToPage( objectEntryElement, editTaskID)
	{
		var	table;
		var	tr;
		var	td;
		var	id;
		var	ckbox;
		var img;
		var	anchor;
		var	status;
		var isParent;
		
		// Get the <table> that holds the list of object entries.
		table = TreeView_getObjectEntryTable();
		
		// Create a <tr> to hold the object entry information.
		id = 'tr-' + TreeView_getUniqueId();
		tr = TreeView_createTR( table, id, 'mediumtext', null, null );
		
		isParent = objectEntryElement.getAttribute('is-parent');
		if((isParent != null) && (isParent == "false"))
		{
			// Create a <input type="checkbox"> to put in the first column.
			ckbox = document.createElement('input');
			ckbox.name = 'objectEntryCkbox';
			ckbox.type = 'checkbox';
			ckbox.n_tr = tr;
			ckbox.onclick =	function()
					  				{
										var ckboxCtrl;
											  
										// arguments.callee is a Function object that points to this function.
										// Get the check box that we are working with.
										ckboxCtrl = arguments.callee.n_ckboxCtrl;
			
										// Is the checkbox checked?
										if(ckboxCtrl.checked)
										{
											// Yes
											// Highlight the row.
											ckboxCtrl.n_tr.style.backgroundColor = '#e8e887';
										}
										else
										{
											// No
											// Unhighlight the row.
											ckboxCtrl.n_tr.style.backgroundColor = 'white';
										}
									}// end function()
			ckbox.onclick.n_ckboxCtrl = ckbox;
			
			// Provide an easy way to get the element associated with this row.
			tr.n_objectEntryElement = objectEntryElement;
			
			// Provide an easy way to get the checkbox that lives in this row.
			tr.n_ckboxCtrl = ckbox;
				
			// Create a <td> to hold the checkbox
			td = TreeView_createTD( tr, '', null, null, null, null );
			td.className = 'rulebelow2';
			td.appendChild(ckbox);
		}
		else
		{
			// Create a <td> to hold a non breaking space - the parent element doesn't need a check box
			tr.n_objectEntryElement = objectEntryElement;
			td = TreeView_createTD( tr, '', null, null, null, null );
			td.className = 'rulebelow2';
			td.innerHTML = '&nbsp;';			
		}
		
		// Create a <td> as a spacer between the checkbox and the object entry name.
		td = TreeView_createTD(tr, '', null, null, null, null);
		td.className = 'rulebelow2';
		td.align='left';
		td.valign='middle';

		var iconName = objectEntryElement.getAttribute('icon-name');
		var altText = objectEntryElement.getAttribute('display-name');
		img = document.createElement('img');
		if(isParent == "false")
		{		
			img.src = "<%= c.getModulesUrl() %>/dev/images/dir/" + iconName;
			td.appendChild(img);
		}
		else
		{
			var objectDN = objectEntryElement.getAttribute('object-dn');
			var upA = document.createElement('a');
			upA.href = '#';		
			upA.onclick=function() {displayContainer(objectDN);}
		
			img.src = "<%= c.getModulesUrl() %>/fw/images/" + iconName;
			img.border="0";
			
			upA.appendChild(img);
			td.appendChild(upA);
		}
		
		img.alt=altText;
		img.title=altText;
		
		imgPart = document.createElement('img');
		var isPartition = objectEntryElement.getAttribute('is-partition');
		if((isParent != null) && (isParent == "true"))
		{
			imgPart.src = "<%= c.getModulesUrl() %>/dev/images/spacer.gif";
		}
		else
		{
			if((isPartition != null) && (isPartition == "true"))
			{
				imgPart.src = "<%= c.getModulesUrl() %>/dev/images/dir/Partition.gif";
			}
			else
			{
				var isAlias = objectEntryElement.getAttribute('is-alias');
				if((isAlias != null) && (isAlias == "true"))
				{
					imgPart.src = "<%= c.getModulesUrl() %>/dev/images/dir/Alias.gif";
				}
				else
				{
					var isJunction = objectEntryElement.getAttribute('is-junction');
					if((isJunction != null) && (isJunction == "true"))
					{
						imgPart.src = "<%= c.getModulesUrl() %>/dev/images/dir/Junction.gif";
					}
					else
					{
						imgPart.src = "<%= c.getModulesUrl() %>/dev/images/spacer.gif";
					}
				}
			}
		}
		
		td.appendChild(imgPart);
	
		// Add the object entry name to the row.
	
		// Create a <td> to hold the object entry name
		td = TreeView_createTD(tr, null, null, null, null, null);
		td.className = 'rulebelow2';
		td.style.paddingRight = '1em';
		
		var	name = objectEntryElement.childNodes[0].nodeValue;
		var container = objectEntryElement.getAttribute('is-container');
		var isCurrent = objectEntryElement.getAttribute('is-current');
		var objectType = objectEntryElement.getAttribute('object-type');
		
		if(isCurrent == "false")
		{
			if((container == "true") || (objectType == "Volume")  || (objectType == "NCP Server")  || (objectType == "Netware Volume") || (editTaskID != null))
			{
				// Create an <a> element to hold the object entry name.
				anchor = document.createElement( 'a' );
				td.appendChild( anchor );
				anchor.href = '#';
				anchor.onclick =	function()
										{
											var tmpObjectEntryElement;
											var tmpTR;
											  
											// arguments.callee is a Function object that points to this function.
											// Get the object entry element object that was stored on this function.
											tmpTR = arguments.callee.n_tr;
											tmpObjectEntryElement = tmpTR.n_objectEntryElement;
			
											// Bring up a property book on the DirXML-ObjectEntry object.
											editObjectEntry( tmpObjectEntryElement, editTaskID );
											
											// Returning false will stop the onclick event
											return false;
										}
				anchor.onclick.n_tr = tr;
			
				// Add the object entry name to the anchor
			
				anchor.innerHTML = '&nbsp;';
				TreeView_updateElementsTextNode( anchor, name);
				if(container == "true")
				{
					var subordinateCount = objectEntryElement.getAttribute('subordinate-count');
					if(subordinateCount != null)
					{
						var countText = document.createTextNode("  (" + subordinateCount +")");
						td.appendChild(countText);
					}
				}
			}
			else
			{
				td.innerHTML=name;
			}
		}
		else
		{
			if(editTaskID != null)
			{
				// Create an <a> element to hold the object entry name.
				anchor = document.createElement( 'a' );
				td.appendChild( anchor );
				anchor.href = '#';
				anchor.onclick =	function()
										{
											var tmpObjectEntryElement;
											var tmpTR;
											  
											// arguments.callee is a Function object that points to this function.
											// Get the object entry element object that was stored on this function.
											tmpTR = arguments.callee.n_tr;
											tmpObjectEntryElement = tmpTR.n_objectEntryElement;
			
											// Bring up a property book on the DirXML-ObjectEntry object.
											editObjectEntry( tmpObjectEntryElement, editTaskID );
											
											// Returning false will stop the onclick event
											return false;
										}
				anchor.onclick.n_tr = tr;
			
				// Add the object entry name to the anchor
			
				anchor.innerHTML = '&nbsp;';
				TreeView_updateElementsTextNode( anchor, name);
				if(container == "true")
				{
					var subordinateCount = objectEntryElement.getAttribute('subordinate-count');
					if(subordinateCount != null)
					{
						var countText = document.createTextNode("  (" + subordinateCount +")");
						td.appendChild(countText);
					}
				}
			}
			else
			{
				td.innerHTML=name;
			}
		}
		
		
		// Create a <td> as a spacer at the end of the row.
		td = TreeView_createTD( tr, '', null, null, null, null );
		td.className = 'rulebelow2';
		td.innerHTML = '&nbsp;';
		
		// Create a <td> as a spacer at the end of the row.
		td = TreeView_createTD( tr, '', null, null, null, null );
		td.className = 'rulebelow2';
		td.innerHTML = '&nbsp;';
		
		return tr;
	} // end addObjectEntryToPage()
 
	 /**
	 * 
	 */
	function editObjectEntry( objectEntryElement, editTaskID )
	{
		var objectDN = objectEntryElement.getAttribute('object-dn');
		var container = objectEntryElement.getAttribute('is-container');
		var isCurrent = objectEntryElement.getAttribute('is-current');
		var objectType = objectEntryElement.getAttribute('object-type');
		
		if(isCurrent == "false")
		{
			if((container == "true") || (objectType == "Volume")  || (objectType == "NCP Server")  || (objectType == "Netware Volume"))
			{
				displayContainer(objectDN);
			}
			else
			{
				var dnArray = new Array();
				dnArray[0] = objectDN;
				launchTask(editTaskID, dnArray);				
			}
		}
		else
		{
				var dnArray = new Array();
				dnArray[0] = objectDN;
				launchTask(editTaskID, dnArray);				
		}
	} // end editObjectEntry()

/**
*
*/
function displayContainer(containerDN)
{
			var url = "webacc?NPService=<%= c.var("taskId") %>&nextState=browseIntoContainerCallBack&TVC_ContainerName="+urlEncode(xmlEncode(containerDN));
			TreeView_createXMLHttpRequest();
			g_xmlHttpRequest.open("GET", url);
			g_xmlHttpRequest.onreadystatechange = TreeView_onPageLoadCallBack;
			g_xmlHttpRequest.send(null);
		
			TreeView_resizePage();
}// end displayContainer()

	/**
	 * 
	 */
	function handleClickOnSortOrder()
	{
		var url = "webacc?NPService=<%= c.var("taskId") %>&nextState=changeDirectionCallBack";
		TreeView_createXMLHttpRequest();
		g_xmlHttpRequest.open("GET", url);
		g_xmlHttpRequest.onreadystatechange = TreeView_onPageLoadCallBack;
		g_xmlHttpRequest.send(null);
	
		TreeView_resizePage();
	} // end of handleClickOnSortOrder()
 
	 /**
	 * 
	 */
	function setTitleRowInfo(xmlDoc)
	{
		var containerNode = xmlDoc.getElementsByTagName("container");
		var containerElement = containerNode[0]; // Should only be one container node
		var otDisplayName = containerElement.getAttribute('object-type-display-name');
		var containerFullName = containerElement.getAttribute('container-full-name');
		var containerDN = containerElement.getAttribute('container-dn');
		var otIconName = containerElement.getAttribute('object-type-icon-name');
		var menuItemNodes = xmlDoc.getElementsByTagName("menu-item");
		var taskID = null;
		if(menuItemNodes != null)
		{
			for(var i = 0; i < menuItemNodes.length; i++)
			{
				var menuType = menuItemNodes[i].getAttribute('menu-type');
				if(menuType == "edit")
				{
					taskID = menuItemNodes[i].getAttribute('task-id'); // Should only be one
					break;
				}
			}
		}
		
		var img = document.getElementById('iconImage');
		if(img != null)
		{
				img.src = "<%= c.getModulesUrl() + "/dev/images/dir/" %>" + otIconName;
				img.title=otDisplayName;
				img.alt=otDisplayName;
		}
		
		var span = document.getElementById( 'containerNameSpan' );
		TreeView_updateElementsTextNode( span, containerFullName);
		
		var anchor = document.getElementById('editContainerAnchor');
		if(taskID != null)
		{
			var editImg = document.getElementById('iconEditImage');
			if(editImg != null)
			{
				editImg.src = "<%= c.getModulesUrl() + "/dev/images/iconedit.gif" %>";
				editImg.alt="<%= JSPConduit.toHTML( c.string("TV.Alt.Edit")) %>";
				editImg.title="<%= JSPConduit.toHTML( c.string("TV.Alt.Edit")) %>";
			}
			if(anchor != null)
			{
			 	anchor.onclick =	function()	{editContainer(containerDN, taskID);}
			}
		}
		else
		{
			var editImg = document.getElementById('iconEditImage');
			if(editImg != null)
			{
				editImg.src = "<%= c.getModulesUrl() + "/dev/images/nl_edit_dis_16.gif" %>";
				editImg.alt="<%= JSPConduit.toHTML( c.string("TV.Alt.Edit.Container.Disabled")) %>";
				editImg.title="<%= JSPConduit.toHTML( c.string("TV.Alt.Edit.Container.Disabled")) %>";
			}
			
			if(anchor != null)
			{
		 		anchor.onclick =	function() {} //	{alert("<%= JSPConduit.toHTML( c.string("TV.Alert.Edit.Container.Disabled")) %>");}
			}
		}
	} // end of setTitleRowInfo()

	/**
	 * 
	 */
	function createErrorMessageContent(xmlDoc)
	{
		var rootElement = xmlDoc.documentElement;
		
		var errorTitle = rootElement.getAttribute('error-title');
		var errorMsg = rootElement.getAttribute('error-message');
		var errorLink = rootElement.getAttribute('error-link');

		var mBoxContentDiv = document.createElement('div');
		mBoxContentDiv.className = "messagebox_content";
		
		var closeA = document.createElement('a');
		closeA.href = '#';		
		closeA.onclick=function()	{hideError();}
		mBoxContentDiv.appendChild(closeA);
		
		var closeImg = document.createElement( 'img' );
		closeImg.src="<%= c.getModulesUrl() + "/dev/images/nl_close_16.gif" %>";
		closeImg.alt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Close" ) )%>";
		closeImg.title="<%= JSPConduit.toHTML( c.string( "TV.Alt.Close" ) )%>";
		closeImg.height="16";
		closeImg.width="16";
		closeImg.border="0";
		closeImg.className="closebutton";
		closeA.appendChild(closeImg);
		
		var errorImg = document.createElement( 'img' );
		errorImg.src="<%= c.getModulesUrl() + "/dev/images/error_icon.gif" %>";
		errorImg.align="absmiddle";
		errorImg.border="0";
		mBoxContentDiv.appendChild(errorImg);
		
		var messageTextDiv = document.createElement('div');
		messageTextDiv.className = "messagetext";
		mBoxContentDiv.appendChild(messageTextDiv);
	
		if(errorLink != null)
		{
			var spanA = document.createElement('a');
			spanA.href = '#';		
			spanA.onclick=function()	{TreeView_showErrorLink(errorLink);}
			messageTextDiv.appendChild(spanA);
			
			var errorTypeSpan = document.createElement('span');
			errorTypeSpan.className = "errortype";
			errorTypeSpan.innerHTML = errorTitle;
			spanA.appendChild(errorTypeSpan);
		}
		else
		{
			var errorTypeSpan = document.createElement('span');
			errorTypeSpan.className = "errortype";
			errorTypeSpan.innerHTML = errorTitle;
			messageTextDiv.appendChild(errorTypeSpan);
		}

		var subTextDiv = document.createElement('div');
		subTextDiv.className = "subtext";
		subTextDiv.innerHTML = errorMsg;
		mBoxContentDiv.appendChild(subTextDiv);
		
		return mBoxContentDiv;				
	}

	/**
	 * 
	 */
	function setMenuRowInfo(xmlDoc)
	{
		var newMenu = false;
		
		var newMenuItem = document.getElementById('newMenuItem');
		if(newMenuItem.className == "inactive")
		{
				newMenuItem.className="active";
				newMenuItem.onmouseover=function(){TreeView_setMenuItemMouseOverColor(this);} 
				newMenuItem.onmouseout=function(){TreeView_setMenuItemMouseOutColor(this);}
				newMenuItem.alt="<%= JSPConduit.toHTML( c.string("TV.Menu.New")) %>";
				newMenuItem.title="<%= JSPConduit.toHTML( c.string("TV.Menu.New")) %>";
				newMenuItem.onclick=function(){TreeView_handleClickOnNewMenu('newMenuSpan');}
		}
		
		var menuItemNodes = xmlDoc.getElementsByTagName("menu-item");
		if(menuItemNodes != null)
		{
			for(var i = 0; i < menuItemNodes.length; i++)
			{
				var menuType = menuItemNodes[i].getAttribute('menu-type');
				if(menuType == "create")
				{
					newMenu = true;
					break;
				}
			}
		}
		
		if(newMenu == false)
		{
			if(newMenuItem != null)
			{
				newMenuItem.className="inactive";
				newMenuItem.onmouseover=function(){};
				newMenuItem.onmouseout=function(){};
				newMenuItem.alt="<%= JSPConduit.toHTML( c.string("TV.Alt.New.Disabled")) %>";
				newMenuItem.title="<%= JSPConduit.toHTML( c.string("TV.Alt.New.Disabled")) %>";
				newMenuItem.onclick=function(){alert("<%= JSPConduit.toHTML( c.string("TV.Alert.New.Disabled")) %>")};
			}	
		}
	} // end of setMenuRowInfo()

	/**
	 * 
	 */
	function setNameSortImage(xmlDoc)
	{
		// Get the root element of the xml document	
		var rootElement = xmlDoc.documentElement;
	
		var iteratorEnabled = rootElement.getAttribute('iterator-enabled');
		var direction = rootElement.getAttribute('direction');
		var img = document.getElementById('nameSortImg');
	
		if(img != null)
		{
			if((iteratorEnabled == null) || (iteratorEnabled == "false"))
			{
					img.src = "<%= c.getModulesUrl() + "/dev/images/SortcolumnA_dis.gif" %>";
					img.alt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Ascending.Disabled" ) ) %>";
					img.title="<%= JSPConduit.toHTML( c.string( "TV.Alt.Ascending.Disabled" ) ) %>";
					img.onclick=function(){alert("<%= JSPConduit.toHTML( c.string( "TV.Alert.Ascending.Disabled" ) ) %>");}
					var anchor = document.getElementById('nameSortAnchor');
					if(anchor != null)
					{
						anchor.onmouseover=function(){};
						anchor.onmouseout=function(){};
						anchor.onclick=function(){alert("<%= JSPConduit.toHTML( c.string( "TV.Alert.Ascending.Disabled" ) ) %>");}
					}
			}
			else
			{		
				if((direction != null) && (direction == "ascending"))
				{
					img.src = "<%= c.getModulesUrl() + "/dev/images/SortcolumnZ.gif" %>";
					img.alt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Descending" ) ) %>";
					img.title="<%= JSPConduit.toHTML( c.string( "TV.Alt.Descending" ) ) %>";
				}
				else
				{
					img.src = "<%= c.getModulesUrl() + "/dev/images/SortcolumnA.gif" %>";
					img.alt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Ascending" ) ) %>";
					img.title="<%= JSPConduit.toHTML( c.string( "TV.Alt.Ascending" ) ) %>";
				}
			}
		}
	} // end of setNameSortImage()

	/**
	 * 
	 */
	function showhide(divID)
	{
		var element;
		element = document.getElementById(divID);
		
	    	if(element.style.display == "none")
	  	{
			element.style.display = "block";
		}
		else
		{
			element.style.display = "none";
		} 
	} // end of showhide()

	/**
	 * 
	 */
	function hideError()
	{
		var element;
		element = document.getElementById('errorMessageDiv');
		
	   if(element.style.display == "block")
	  	{
			element.style.display = "none";
		}
	} // end of hideError()

	/**
	 * 
	 */
	function handleClickOnNewMenuItem(item, span, containerDN)
	{
		showhide(span);
	   var dnArray = new Array();
		dnArray[0] = containerDN;
	
		launchTask(item.taskID, dnArray);
	} // end of handleClickOnNewMenuItem()

	/**
	 * 
	 */
	function singleMenuItem(menuItemNode)
	{
		var	selectedRows;
		var	table;
	
		// Get the <table> that holds the list of object entries.
		table = TreeView_getObjectEntryTable();
		
		// Get the list of rows that have the checkbox checked.
		selectedRows = TreeView_getSelectedRows( table );
		if ( TreeView_isDefined( selectedRows ) && selectedRows.length > 0 )
		{
		   var selectedObjects = new Array(selectedRows.length);
			for (i = 0; i < selectedRows.length; ++i)
			{
				var	objectEntryElement;
				var	tr;
	
				// Get the next selected tr
				tr = selectedRows[i];
	
				// Get the element associated with this row.
				objectEntryElement = tr.n_objectEntryElement;
				if ( TreeView_isDefined( objectEntryElement ) )
				{
					var	objectEntryDN;
	
					// Get the dn of the object entry we are to delete.
//					objectEntryDN = objectEntryElement.childNodes[0].nodeValue;
					objectEntryDN = objectEntryElement.getAttribute('object-dn');
					
					if ( TreeView_hasString( objectEntryDN ) )
					{
	               selectedObjects[i] = objectEntryDN;
					}
				}
			}
		}
		else
		{
			alert("<%= JSPConduit.toHTML( c.string( "TV.Alert.No.Items.Selected" ) )%>");
			return;
		}
	
		var taskID = menuItemNode.getAttribute('task-id');
		launchTask(taskID, selectedObjects);
	}
	
	/**
	 * 
	 */
	function handleClickOnMenuItem(item, span)
	{
		var	selectedRows;
		var	table;
	
		// Get the <table> that holds the list of object entries.
		table = TreeView_getObjectEntryTable();
		
		// Get the list of rows that have the checkbox checked.
		selectedRows = TreeView_getSelectedRows( table );
		if ( TreeView_isDefined( selectedRows ) && selectedRows.length > 0 )
		{
		   var selectedObjects = new Array(selectedRows.length);
			for (i = 0; i < selectedRows.length; ++i)
			{
				var	objectEntryElement;
				var	tr;
	
				// Get the next selected tr
				tr = selectedRows[i];
	
				// Get the element associated with this row.
				objectEntryElement = tr.n_objectEntryElement;
				if ( TreeView_isDefined( objectEntryElement ) )
				{
					var	objectEntryDN;
	
					// Get the dn of the object entry we are to delete.
//					objectEntryDN = objectEntryElement.childNodes[0].nodeValue;
					objectEntryDN = objectEntryElement.getAttribute('object-dn');
					
					if ( TreeView_hasString( objectEntryDN ) )
					{
	               selectedObjects[i] = objectEntryDN;								
					}
				}
			}
		}
		else
		{
			alert("<%= JSPConduit.toHTML( c.string( "TV.Alert.No.Items.Selected" ) )%>");
			showhide(span);
			return;
		}
	
		showhide(span);
		launchTask(item.taskID, selectedObjects);
	} // end of handleClickOnMenuItem()

	/**
	 * Update the text that shows 101-200 of 750
	 */
	function updateCountersText(xmlDoc)
	{
		var	startIndex	= 0;
		var	endIndex		= 0;
		var	totalCount	= 0;
		var	span;
	
		// Get the root element of the xml document	
		var rootElement = xmlDoc.documentElement;
		
		// See if the iterator is enabled
		var iteratorEnabled = rootElement.getAttribute('iterator-enabled');
		if(TreeView_hasString(iteratorEnabled) == false)
		{
			iteratorEnabled = "false";
		}
	
		// Get the index of the first entry object in our list.
		startIndex = rootElement.getAttribute("start-index");
		if(TreeView_hasString(startIndex) == false)
		{
			startIndex = 0;
		}
	
		// Get the index of the last entry object in our list.
		endIndex = rootElement.getAttribute("end-index");
		if(TreeView_hasString(endIndex) == false)
		{
			endIndex = 0;
		}
	
		var displayBlockSize = rootElement.getAttribute("display-block-size");
		var currentBlockSize = ((endIndex-startIndex)+1);
	
		// Update the text that shows 101 - 200 of 750
		// Get the total number of entry objects.
		totalCount = rootElement.getAttribute("total-count");
		if((TreeView_hasString(totalCount) == false) || (totalCount == "-1"))
		{
			if( currentBlockSize < displayBlockSize)
			{
				totalCount = endIndex;
			}
			else
			{
				totalCount = "(?)";
			}
		}
		else
		{
			totalCount++; // this is here because of a problem
			totalCount--; // dont know why 
		}
	
		if(totalCount == "(?)")
		{				
			// Should the "Next" anchor be visible.
			if( currentBlockSize < displayBlockSize)
			{
				// Yes
				span = document.getElementById( 'nextPageSpan' );
				span.style.display = 'none';
			}
			else
			{
				// No
				span = document.getElementById( 'nextPageSpan' );
				span.style.display = '';
			}
		}
		else
		{
			// Should the "Next" anchor be visible.
			if (  totalCount > 0 && totalCount > endIndex )
			{
				// Yes
				span = document.getElementById( 'nextPageSpan' );
				span.style.display = '';
			}
			else
			{
				// No
				span = document.getElementById( 'nextPageSpan' );
				span.style.display = 'none';
			}
		}
		
		// Update the starting index text.
		span = document.getElementById( 'startIndexSpan' );
		TreeView_updateElementsTextNode( span, startIndex );
	
		// Update the ending index text.
		span = document.getElementById( 'endIndexSpan' );
		TreeView_updateElementsTextNode( span, endIndex );
	
		// Update the total count text.
		span = document.getElementById( 'countSpan' );
		TreeView_updateElementsTextNode( span, totalCount );
		
		// Should the "Previous" anchor be visible.
		if ( startIndex > 1 )
		{
			if(iteratorEnabled == "false")
			{
				var showPreviousPageImg = document.getElementById( 'showPreviousPageImg' );
				showPreviousPageImg.src="<%= c.getModulesUrl() + "/dev/images/nl_left_dis_16.gif" %>";
				
				var showPreviousPageAnchor = document.getElementById( 'showPreviousPageAnchor' );
				showPreviousPageAnchor.onclick=function(){alert("<%= JSPConduit.toHTML( c.string( "TV.Alert.Previous.Disabled" ) ) %>");}
				showPreviousPageAnchoralt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Previous.Disabled" ) ) %>"
				showPreviousPageAnchor.title="<%= JSPConduit.toHTML( c.string( "TV.Alt.Previous.Disabled" ) ) %>"
			}
			// Yes
			span = document.getElementById( 'previousPageSpan' );
			span.style.display = '';
		}
		else
		{
			// No
			span = document.getElementById( 'previousPageSpan' );
			span.style.display = 'none';
		}
	}// end of updateCountersText()

	/**
	 * handleFilterOK().    Called when the 'OK' button on the filter dropdown box is pressed.
	 */
	function handleFilterOK()
	{
		// Update the hidden form fields to send back to server.
		var newNameFilter = document.TreeViewContent.textfieldName.value;
		var newSelectedTypeIndex = document.TreeViewContent.selectTypeControl.selectedIndex;	
		var newSelectedType = document.TreeViewContent.selectTypeControl.value;
		if (newSelectedTypeIndex == 0) newSelectedType = "";
		var showConts = (document.TreeViewContent.showAllContainers.checked?"true":"false");

		// Don't allow Name + Adv + ShowConts
		if ((newNameFilter.length>0 && newNameFilter!="*") && m_newAdvFilt.length>0 && showConts=="true")
		{
			alert("<%= JSPConduit.toHTML( c.string( "TV.Filter.ShowContainersRestriction" ) )%>");
			return;
		}

		document.TreeViewContent.TVCNameFilter.value = newNameFilter;
		document.TreeViewContent.TVCSelectedTypeIndex.value = newSelectedTypeIndex;
		document.TreeViewContent.TVCAdvFilter.value = m_newAdvFilt;
		document.TreeViewContent.TVCShowAllContainers.value = showConts;
		
		updateFilterDisplay();
				
		
		var url = "webacc?NPService=<%= c.var("taskId") %>&nextState=changeFilterCallBack&TVC_NameFilter="+newNameFilter+"&TVC_SelectedType="+newSelectedType+"&TVC_AdvFilterXML="+m_newAdvFilt+"&TVC_ShowAllContainers="+showConts;
		TreeView_createXMLHttpRequest();
		g_xmlHttpRequest.open("GET", url);
		g_xmlHttpRequest.onreadystatechange = TreeView_onPageLoadCallBack;
		g_xmlHttpRequest.send(null);
		showhide('filter');
	}

	/**
	 * handleFilterCancel()
	 * Resets name, type, and advanced filter to previous values.
	 */
	function handleFilterCancel()
	{
		document.TreeViewContent.textfieldName.value = document.TreeViewContent.TVCNameFilter.value;
		document.TreeViewContent.selectTypeControl.selectedIndex = document.TreeViewContent.TVCSelectedTypeIndex.value;
		m_newAdvFilt = document.TreeViewContent.TVCAdvFilter.value;
		if (m_newAdvFilt == "")
			document.getElementById("AdvFilterPresent").src = "<%= c.getModulesUrl() + "/dev/images/1px_spacer.gif" %>";
		else
			document.getElementById("AdvFilterPresent").src = "<%= c.getModulesUrl() + "/dev/images/enabled_16.gif" %>";
		document.TreeViewContent.showAllContainers.checked = (document.TreeViewContent.TVCShowAllContainers.value=="true");
		showhide('filter');
	}

	/**
	 * handleFilterClear()
	 */
	function handleFilterClear()
	{
		document.TreeViewContent.textfieldName.value = "*";  // Reset Name text field to default.
		document.TreeViewContent.selectTypeControl.selectedIndex = 0;  // Reset Type select box to default.
		m_newAdvFilt = "";
		document.getElementById("AdvFilterPresent").src = "<%= c.getModulesUrl() + "/dev/images/1px_spacer.gif" %>";
	}

	/**
	 * updateFilterDisplay() 
	 *   Set the name and type filter display in the header.  Don't display name or type if it's default.
	 *   Set the filter gif image on if a non-default filter is defined.
	 */
	function updateFilterDisplay()
	{
		// Don't display name filter if it's "*".
		var nameFilter = document.getElementById("textfieldName").value;
		if (nameFilter == "*")
			nameFilter = "";
		var span = document.getElementById("NameFilterSpan");
		TreeView_updateElementsTextNode( span, nameFilter );

		// Don't display type filter if "*".
		var selectedType = document.getElementById("selectTypeControl").value;
		if (document.getElementById("selectTypeControl").selectedIndex == 0)
			selectedType = "";
		span = document.getElementById("SelectedTypeSpan");
		TreeView_updateElementsTextNode( span, selectedType );
		
		// Set the Advanced Filter indication gif.
		if (document.TreeViewContent.TVCAdvFilter.value == "")
		{
			document.getElementById("AdvFilterIndication").src = "<%= c.getModulesUrl() + "/dev/images/1px_spacer.gif" %>";
			document.getElementById("AdvFilterIndication").title = "";
		}
		else
		{
			document.getElementById("AdvFilterIndication").src = "<%= c.getModulesUrl() + "/dev/images/enabled_16.gif" %>";
			document.getElementById("AdvFilterIndication").title = "<%= JSPConduit.toHTML( c.string( "TV.Filter.AdvancedFilterIsDefined" ) )%>";
		}
				
		// Set the filter gif to on or off
		var img = document.getElementById("filterimage");
		if (nameFilter == "" && selectedType == "" && document.TreeViewContent.TVCAdvFilter.value == "")
			img.src = "<%= c.getModulesUrl() + "/dev/images/filter_off.gif" %>";
		else
			img.src = "<%= c.getModulesUrl() + "/dev/images/filter_on.gif" %>";

	}

	/* Handle the Advanced Filter button. */
	function handleAdvFilter()
	{
		AS = new Object();
		AS.types = document.getElementById("selectTypeControl").value;
		AS.initialCriterionCallBack = "TVCGetCriterion";
		AS.controlCallBack = "TVCSaveCriterion";
		doDynamicAS("", AS);
	}
	
	/* Callback function to get the starting Advanced filter */
	function TVCGetCriterion(typeName)
	{
		return m_newAdvFilt;
	}
	
	/* Callback function to return the new Advanced Filter */
	function TVCSaveCriterion(controlName, typeNames, xmlCriterion)
	{
		m_newAdvFilt = xmlCriterion;
		if (m_newAdvFilt == "")  // Set the Advanced Filter checkbox gif accordingly.
			document.getElementById("AdvFilterPresent").src = "<%= c.getModulesUrl() + "/dev/images/1px_spacer.gif" %>";
		else
			document.getElementById("AdvFilterPresent").src = "<%= c.getModulesUrl() + "/dev/images/enabled_16.gif" %>";
	}
	

	function handleEnterOK(e)  // Treat ENTER as OK button
	{
		if ( (window.event? e.keyCode : e.which) == 13)
		{
			handleFilterOK();
			return false;
		}
		return true;
	}
		
	function handleEnterCancel(e)  // Treat ENTER as CANCEL button
	{
		if ( (window.event? e.keyCode : e.which) == 13)
		{
			handleFilterCancel();
			return false;
		}
		return true;
	}
		
	function handleEnterClear(e)  // Treat ENTER as CLEAR button
	{
		if ( (window.event? e.keyCode : e.which) == 13)
		{
			handleFilterClear();
			return false;
		}
		return true;
	}
		
</SCRIPT>
</HEAD>
<BODY	onload="onPageLoad()"
				onResize="TreeView_handleOnResize()" >
	<form name="TreeViewContent" method="post" action="frameservice" >
		<div id="contentDiv">
			<div id="breadCrumbDiv" class="breadcrumb" style="margin-top: 0.5em">
			</div>
			<div id="errorMessageDiv" class="message" style="display: none; width: 80%">
				<% /* errorMessageDiv will be dynamically added if a error message is encountered*/ %>
			</div>
			<div id="selectDriverDiv">
				<table class="objlist" cellspacing="0" cellpadding="0" width="98%">
					<tr class="title">
						<td><A href='Javascript:showHelpWindow();'><IMG class="floatright" id=helpimage src='<%= c.getModulesUrl() + "/dev/images/help_16.gif" %>' alt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Help" ) ) %>" title="<%= JSPConduit.toHTML(c.string("TV.Alt.Help")) %>" border="0" width="16" height="16" align="absmiddle"></A>	<IMG id=iconImage border="0" width="16" height="16" align="absmiddle">							
							<span id="containerNameSpan"></span><a id="editContainerAnchor" href="#"><IMG id="iconEditImage" class="margin5l" src="<%= c.getModulesUrl() + "/dev/images/iconedit.gif" %>" alt="<%= JSPConduit.toHTML(c.string("TV.Alt.Edit")) %>" title="<%= JSPConduit.toHTML(c.string("TV.Alt.Edit")) %>" border="0" align="absmiddle"></a>
                  </td>
					</tr>
				</table>
			</div>
			<div id="menuDiv">
				<table class="objlist" cellspacing="0" cellpadding="0" width="98%">
					<tr class="menu">
						<td>
						<table cellspacing="0" cellpadding="0">
							<tr>
							<td id="newMenuItemTD">
								<a	onclick="TreeView_handleClickOnNewMenu('newMenuSpan');return false;"
									id="newMenuItem"
									title="<%= JSPConduit.toHTML( c.string( "TV.Menu.New" ) )%>"
									href="#"
									onmouseover="TreeView_setMenuItemMouseOverColor( this )"
									onmouseout="TreeView_setMenuItemMouseOutColor( this )"><%= JSPConduit.toHTML( c.string( "TV.Menu.New" ) )%>
									<img src="<%= c.getModulesUrl() %>/dev/images/menu_down_arrow.gif" align="absmiddle" border="0">
								</a>

									<span id="newMenuSpan" style="display: none; position: relative;">
										<% /* newMenuDiv will be dynamically added */ %>
									</span>
									</td>
								<td>|</td>
								<td>
								<% /* Edit menu item */ %>
									<a onclick="handleClickOnEditMenu();return false;"
										id="editMenuItem"
										title="<%= JSPConduit.toHTML( c.string( "TV.Menu.Edit" ) )%>"
										href="#"
										onmouseover="TreeView_setMenuItemMouseOverColor( this )"
										onmouseout="TreeView_setMenuItemMouseOutColor( this )"><%= JSPConduit.toHTML( c.string( "TV.Menu.Edit" ) )%></a>
									
									<span id="editMenuSpan" style="display: none; position: relative;">
										<% /* editMenuDiv will be dynamically added */ %>
									</span>
								</td>
								<td>|</td>
								<td>				
								<% /* Delete menu item */ %>
								<a onclick="handleClickOnDeleteMenu();return false;"
									id="deleteMenuItem"
									title="<%= JSPConduit.toHTML( c.string( "TV.Menu.Delete" ) )%>"
									href="#"
									onmouseover="TreeView_setMenuItemMouseOverColor( this )"
									onmouseout="TreeView_setMenuItemMouseOutColor( this )"><%= JSPConduit.toHTML( c.string( "TV.Menu.Delete" ) )%></a>
									
									<span id="deleteMenuSpan" style="display: none; position: relative;">
										<% /* deleteMenuDiv will be dynamically added */ %>
									</span>
								</td>
								<td>|</td>
								<td>				
								<% /* Actions menu item */ %>
								<a onclick="handleClickOnActionsMenu();return false;"
									id="actionsMenuItem"
									title="<%= JSPConduit.toHTML( c.string( "TV.Menu.Actions" ) )%>"
									href="#"
									onmouseover="TreeView_setMenuItemMouseOverColor( this )"
									onmouseout="TreeView_setMenuItemMouseOutColor( this )"><%= JSPConduit.toHTML( c.string( "TV.Menu.Actions" ) )%>
									<img src="<%= c.getModulesUrl() %>/dev/images/menu_down_arrow.gif" align="absmiddle" border="0">
								</a>
									
									<span id="actionsMenuSpan" style="display: none; position: relative;">
										<% /* actionsMenuDiv will be dynamically added */ %>
									</span>
									</td>
									</tr>
									</table>
						</td>
						<td	class="smalltext"
								valign="middle"
								align="right">
							<% /* This anchor is for "Previous" */ %>
							<span id="previousPageSpan">
								<a	onclick="handleClickOnShowPreviousPage();return false"
									id="showPreviousPageAnchor"
									alt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Previous" ) ) %>" 
									title="<%= JSPConduit.toHTML( c.string( "TV.Label.Previous" ) )%>"
									href="#"><img id="showPreviousPageImg" src="<%= c.getModulesUrl() %>/fw/images/previous.gif" align="absmiddle" border="0"></a>
							</span>
							
							<% /* This anchor holds the text that shows 101-200 of 750 */ %>
							<span>
								<span id="startIndexSpan"></span>-<span id="endIndexSpan"></span>&nbsp;<%= JSPConduit.toHTML( c.string( "TV.Label.Of" ) ) %>&nbsp;<span id="countSpan"></span>
							</span>
							
							<% /* This anchor is for "Next" */ %>
							<span id="nextPageSpan">
								<a	onclick="handleClickOnShowNextPage();return false"
									id="showNextPageAnchor"
									title="<%= JSPConduit.toHTML( c.string( "TV.Label.Next" ) )%>"
									href="#"><img src="<%= c.getModulesUrl() %>/fw/images/next.gif" alt="<%= JSPConduit.toHTML( c.string( "TV.Alt.Next" ) ) %>" align="absmiddle" border="0"></a>
							</span>
						</td>
					</tr>
				</table>
			</div>
			<div id="listOfObjectEntrysDiv" style="overflow: auto">
				<% /* This table holds the list of object entries. */ %>
				<table	id="objectEntryTable"
							width="98%"
							border="0"
							cellspacing="0"
							cellpadding="0">
					<% /* Column Headings */ %>
					<tr>
						<td class="tablecolumnhead1" width="1%"><input type="checkbox" onclick="TreeView_onClickSelectAll();" id="selectAllCkbox"></td>
						<td class="tablecolumnhead1" width="1%">&nbsp;</td>
						<td class="tablecolumnhead1">
							<a id="nameSortAnchor" onclick="handleClickOnSortOrder();return false"
								title="<%= JSPConduit.toHTML( c.string( "TV.Alt.Name" ) ) %>"
								style="text-decoration: none;"
								onmouseover="TreeView_setMenuItemMouseOverColor( this )"
								onmouseout="TreeView_setMenuItemMouseOutColor( this )"
								href="#"><%= JSPConduit.toHTML( c.string( "TV.ColHeading.Name" ) )%></a>
							<a	title="<%= JSPConduit.toHTML( c.string( "TV.Alt.Sort" ) )%>"
								href="#">
								<img	id="nameSortImg"
										onclick="handleClickOnSortOrder();return false"
										align="absmiddle"
										width="16px"
										height="16px"
										border="0">	</a>
						</td>
						<td class="tablecolumnhead1" width="100%">&nbsp;</td>
<% /* Start of Filter header and dropdown */ %>
						<td class="tablecolumnhead1" align="right">
						  <span id="FilterStatusIndicators">
							<span id="NameFilterSpan"><%= c.var("TVC_NameFilter") %></span>
							<span id="SelectedTypeSpan"><%= c.var("TVC_SelectedType") %></span>
							<img id="AdvFilterIndication" src="<%= c.getModulesUrl() + "/dev/images/1px_spacer.gif" %>" title="" class="margin5l" height="16" width="16" align="absmiddle" border="0">
						    <span style="font-weight: normal">
							 <a onclick="showhide('filter')" title="<%= JSPConduit.toHTML( c.string( "TV.Filter.DefineFilter" ) )%>" name="" href="#">
							 <img id="filterimage" class="margin5l" src="<%= c.getModulesUrl() + "/dev/images/filter_off.gif" %>" 
							      alt="<%= JSPConduit.toHTML( c.string( "TV.Filter.DefineFilter" ) )%>" height="16" width="16" align="absmiddle" border="0"><img src="<%= c.getModulesUrl() + "/dev/images/menu_down_arrow.gif" %>" align="absmiddle" border="0"></a>&nbsp;
						    </span>
						  </span>
						<span id="filter" style="display: none; position: relative;">
							<div id="filtermenu" class="dialog" style="width: 260px; top: 0px; left: auto; right: 5px ! important">
								<div class="title">
								    <%= JSPConduit.toHTML( c.string( "TV.Filter.Filter" ) )%>
									<a title="Close" onclick="showhide('filter')" href="#"><img class="closebutton" src="<%= c.getModulesUrl() + "/dev/images/nl_close_16.gif" %>" alt="Button: Close" height="16" width="16" align="absmiddle" border="0"></a>
								</div>

								<div align="left" class="content">
									<table border="0" cellspacing="0" cellpadding="0" style="table-layout:  fixed">
										<tr>
											<td style="border-bottom: none; background-color: transparent; font-size: 1em; font-weight: normal"><label><%= JSPConduit.toHTML( c.string( "TV.Filter.Name" ) )%></label></td>
										</tr>
										<tr>
<% /* Name input */ %>						<td style="border-bottom: none; background-color: transparent; font-size: 1em; font-weight: normal"><input type="text" id="textfieldName" name="textfieldName" value='<c:out value="${TVC_NameFilter}"/>' onkeypress="return handleEnterOK(event)" class="smalltext" size="20"></td>
										</tr>
										<tr height="8">
											<td style="border-bottom: none; background-color: transparent; font-weight: normal" height="8"></td>
										</tr>										
										<tr style="margin-top: 0.5em">
											<td style="border-bottom: none; background-color: transparent; font-size: 1em; font-weight: normal" valign="top"><label><%= JSPConduit.toHTML( c.string( "TV.Filter.Type" ) )%></label></td>
										</tr>
										<tr>
										<td style="border-bottom: none; background-color: transparent; font-size: 1em; font-weight: normal">
<% /* Type select */ %>						  <select name="selectTypeControl" id="selectTypeControl" onkeypress="return handleEnterOK(event)" size="1" class="smalltext">
												<option value="*"><iman:nobr>*</iman:nobr></option>
												<c:forEach items="${TVC_FilterTypeList}" var="ftype">
													<option value="<c:out value='${ftype}'/>"><iman:nobr><c:out value="${ftype}"/></iman:nobr></option>
												</c:forEach>
											  </select>
											</td>
										</tr>
										<tr height="8">
											<td style="border-bottom: none; background-color: transparent; font-weight: normal" height="8"></td>
										</tr>
										<tr style="margin-top: 0.5em">
											<td style="border-bottom: none; background-color: transparent; font-size: 1em; font-weight: normal" valign="top">											
											  <div class="margintop1" style="font-size: 0.85em">
<% /* Adv filter */ %>							<a href="#" style="text-decoration:none" onclick="handleAdvFilter()" title="<%= JSPConduit.toHTML( c.string( "TV.Filter.AdvancedFilterTip" ) )%>"><%= JSPConduit.toHTML( c.string( "TV.Filter.AdvancedFilter" ) )%>
												<img id="AdvFilterPresent" src="<%= c.getModulesUrl() + "/dev/images/1px_spacer.gif" %>" class="margin5l" height="16" width="16" align="absmiddle" border="0">
												</a>
											  </div>
											</td>
										</tr>
										<tr height="8">
											<td style="border-bottom: none; background-color: transparent; font-weight: normal" height="8"></td>
										</tr>										
<% /* Container option */ %>	        <tr><td><span title="<%= JSPConduit.toHTML( c.string( "TV.Filter.ShowAllContainersTip" ) )%>">
											<input type="checkbox" name="showAllContainers" >&nbsp;<%= JSPConduit.toHTML( c.string( "TV.Filter.ShowAllContainers" ) )%>
										</span></td></tr>
										
									</table>
								</div>
								<div class="footer">
<% /* OK */ %>						<img onclick="handleFilterOK()" onkeypress="handleEnterOK(event)" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.OK2.image") %>" border="0" tabindex="0">
<% /* Cancel */ %>					<img onclick="handleFilterCancel()" onkeypress="handleEnterCancel(event)" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Cancel2.image") %>" border="0" tabindex="0">
<% /* Clear */ %>					<img onclick="handleFilterClear()" onkeypress="handleEnterClear(event)" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Clear2.image") %>" border="0" tabindex="0">									
								</div>							
							</div>
						</span>						
					
					</td>
<% /* End of Filter header and dropdown */ %>
					</tr>
										
					<% /* The content of this table will be added dynamically */ %>
				</table>
			</div>
		</div>
		<% /* DIV to hold the close button. */ %>
		<DIV style="margin-top: 2em" id="buttonDiv">
		   <iman:bar/>
<!-- 	<iman:button key="Close" onClick="onExit(); return false;"/> -->
		</DIV>
	
		<INPUT type="hidden" name="taskId" value="<c:out value="${taskId}"/>">
		<INPUT type="hidden" name="nextState" value="<c:out value="${nextState}"/>">
 	    <INPUT type="hidden" name="TVCNameFilter" value="<c:out value="${TVC_NameFilter}"/>">
 	    <INPUT type="hidden" name="TVCSelectedTypeIndex" value="0"/>
 	    <INPUT type="hidden" name="TVCAdvFilter" value="<c:out value="${TVC_AdvFilterXML}"/>">
 	    <INPUT type="hidden" name="TVCShowAllContainers" value="<c:out value="${TVC_ShowAllContainers}"/>">
	</form> 	    

	<form name="TreeViewPostData"  method="post" action="frameservice" target="">
      <input type="hidden" name="NPService" value="fw.LaunchService"/>
      <input type="hidden" name="NPAction" value="Launch"/>
      <input type="hidden" name="launcher" value="fw.CloseWindow"/>
      <input type="hidden" name="launch" value=""/>
      <input type="hidden" name="lifecycle" value="New"/>
      <input type="hidden" name="repeatable" value="false"/>
      <input type="hidden" name="targetNames" value=""/>
	</form>
</BODY>
</HTML>