<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

   <xsl:template match="fw.WidgetExample">
   <HTML>
   <HEAD>
      <TITLE><xsl:value-of select="$dev.ProductName"/></TITLE>
      <xsl:call-template name="eMFrameScripts"/>
      <xsl:call-template name="OSScripts"/>
      <xsl:call-template name="MVStringEditorScripts"/>
      <xsl:call-template name="help-scripts"/>
      <xsl:call-template name="target-chooser-scripts"/>
      <LINK rel='stylesheet' href='{$Portal.ResourcePath}/modules/dev/css/hf_style.css'></LINK>

      <SCRIPT>
         function onInit()
         {
            <!--document.form.single.focus();-->
         }

         function onExit()
         {
         }
      </SCRIPT>
   </HEAD>

   <BODY onLoad="returnFromOS();onInit();">
   <FORM name="form" method="post" action="{$Portal.Servlet.Normal}" onSubmit="onExit();return true">
      <INPUT type="hidden" name="NPService" value="{../@id}"/>

      <xsl:call-template name="task-header">
         <xsl:with-param name="TaskHeader.title">XSL Widget Reference/Demo</xsl:with-param>
         <xsl:with-param name="TaskHeader.iconUrl" select="concat($Portal.ResourcePath, '/modules/dev/images/dir/SLP_Service.gif')"/>
         <xsl:with-param name="TaskHeader.iconAlt">XSL Widget Reference/Demo</xsl:with-param>
         <xsl:with-param name="TaskHeader.helpFile">base/vieweffectiverights.html</xsl:with-param>
      </xsl:call-template>
       <br/>

       This gadget illustrates the basic XSL usage of each of the built-in UI widgets in iManager.
       <br/>
       <br/>






       <xsl:call-template name="bar"/>
       <b>eMFrameScripts</b>
       <br/>
       The eMFrameScripts widget is not a graphical element, but rather contains javascript functions that are used in tasks. This widget should be placed in the "head" section of every page.
       <br/>
       <br/>
       <u>Details:</u>
       <br/>
       Found in: WidgetTemplates.xsl
       <br/>
       Template name: eMFrameScripts
       <br/>
       Parameters: None
       <br/>
       <br/>
       <u>Code:</u>
       <br/>
       &lt;xsl:call-template name="eMFrameScripts"/&gt;
       <br/>
       <br/>
       <xsl:call-template name="bar"/>




       <b>cancel</b>
       <br/>
       When clicked, the cancel button cancels the current task and returns the user to the main page.
       <br/>
       <br/>
       <u>Details:</u>
       <br/>
       Found in: WidgetTemplates.xsl
       <br/>
       Template name: cancel
       <br/>
       Parameters: none
       <br/>
       <br/>
       <u>Example:</u>
       <br/>
       <xsl:call-template name="cancel">
          <xsl:with-param name="taskId" select="../@id"/>
       </xsl:call-template>
       <br/>
       <br/>
       <u>Code for this example:</u>
       <br/>
       &lt;xsl:call-template name="cancel"/&gt;
       <br/>
       <br/>
       <xsl:call-template name="bar"/>




       <b>Spacer2px</b>
       <br/>
       This simply displays a 2 pixel wide transparent graphic.
       <br/>
       <br/>
       <u>Details:</u>
       <br/>
       Found in: WidgetTemplates.xsl
       <br/>
       Template name: Spacer2px
       <br/>
       Parameters: none
       <br/>
       <br/>
       <u>Example:</u>
       <br/>
       <xsl:call-template name="Spacer2px"/> (Note: It's there, you just can't see it)
       <br/>
       <br/>
       <u>Code for this example:</u>
       <br/>
       &lt;xsl:call-template name="Spacer2px"/&gt;
       <br/>
       <br/>
       <xsl:call-template name="bar"/>





       <b>bar</b>
       <br/>
       The bar widget displays a horizontal rule, and can be seen separating the items on this page.
       <br/>
       <br/>
       <u>Details:</u>
       <br/>
       Found in: WidgetTemplates.xsl
       <br/>
       Template name: bar
       <br/>
       Parameters: none
       <br/>
       <br/>
       <u>Code:</u>
       <br/>
       &lt;xsl:call-template name="bar"/&gt;
       <br/>
       <br/>
       <xsl:call-template name="bar"/>





       <b>help-icon</b> ( &amp; <b>help-scripts</b> )
       <br/>
       help-icon displays an icon which, when clicked, pops up context-sensitive help for the task.
       <br/>
       <br/>
       <u>Details:</u>
       <br/>
       Found in: WidgetTemplates.xsl
       <br/>
       Template name: help-icon
       <br/>
       Parameters:
       <ul>
           <li>Help.file</li>
       </ul>
       Note: <b>help-scripts</b> must be included in the "head" section of your page for this widget to work.
       <br/>
       <br/>
       <u>Example:</u>
       <br/>
       <xsl:call-template name="help-icon">
           <xsl:with-param name="Help.file">base/vieweffectiverights.html</xsl:with-param>
       </xsl:call-template>
       (Note: clicking this loads the context-sensitive help for the View Effective Rights task)
       <br/>
       <br/>
       <u>Code for this example:</u>
       <br/>
       <b>help-scripts</b>:
       <br/>
       &lt;xsl:call-template name="help-scripts"/&gt;
       <br/>
       <br/>
       <b>help-icon</b>:
       <br/>
       &lt;xsl:call-template name="help-icon"&gt;<br/>
       &lt;xsl:with-param name="Help.file"&gt;help.html&lt;/xsl:with-param&gt;<br/>
       &lt;/xsl:call-template&gt;
       <br/>
       <br/>
       <xsl:call-template name="bar"/>





       <b>OS</b> ( &amp; <b>OSScripts</b> )
       <br/>
       This displays two icons: <b>1)</b> an icon which, when clicked, pops up the eDirectory Object Selector dialog window. The object selector allows the user to either browse the objects in a tree or search for a specific object or type of object, and <b>2)</b> an icon which, when clicked, shows a list of the last few items selected from the object selector (this is known as the "history" list).
       <br/>
       <br/>
       <u>Details:</u>
       <br/>
       Found in: WidgetTemplates.xsl
       <br/>
       Template name: OS
       <br/>
       Parameters:
       <ul>
            <li>OS.Control</li>
            <li>OS.CallBack</li>
            <li>OS.AdvancedSelection</li>
            <li>OS.InitialContext</li>
            <li>OS.IsOSAllowed</li>
            <li>OS.Mode</li>
            <li>OS.MultiSelect</li>
            <li>OS.NameFilter</li>
            <li>OS.ResultsPerPage</li>
            <li>OS.SearchSubContainers</li>
            <li>OS.SearchOnStartup</li>
            <li>OS.ShowSubClasses</li>
            <li>OS.TypeFilter</li>
            <li>OS.TypeFilterCallBack</li>
            <li>OS.AltText</li>
            <li>OS.Text</li>
            <li>OS.IconName</li>
       </ul>
       Note: <b>OSScripts</b> must be included in the "head" section of your page for the Object Selector to work.
       <br/>
       <br/>
       <u>Example:</u>
       <br/>
       <xsl:call-template name="OS">
           <xsl:with-param name="OS.Control">single</xsl:with-param>
           <xsl:with-param name="OS.Mode">Browse</xsl:with-param>
           <xsl:with-param name="OS.TypeFilter">*</xsl:with-param>    <!-- REMIND: {SET OS.TypeFilter=TC.osTypeFilter} -->
           <xsl:with-param name="OS.History">false</xsl:with-param>
       </xsl:call-template>
       <br/>
       <br/>
       <u>Code for this example:</u>
       <br/>
       <b>OSScripts</b>:
       <br/>
       &lt;xsl:call-template name="OSScripts"/&gt;
       <br/>
       <br/>
       <b>OS</b>:
       <br/>
       &lt;xsl:call-template name="OS"&gt;<br/>
       &lt;xsl:with-param name="OS.Control"&gt;single&lt;/xsl:with-param&gt; <br/>
       &lt;xsl:with-param name="OS.Mode"&gt;Browse&lt;/xsl:with-param&gt; <br/>
       &lt;xsl:with-param name="OS.TypeFilter"&gt;*&lt;/xsl:with-param&gt; <br/>
       &lt;xsl:with-param name="OS.History"&gt;false&lt;/xsl:with-param&gt; <br/>
       &lt;/xsl:call-template&gt;
       <br/>
       <br/>
       <xsl:call-template name="bar"/>





       <b>target-chooser</b> ( &amp; <b>target-chooser-scripts</b> )
       <br/>
       The target-chooser widget displays a textbox which is used to declare the target receiving the action of a task. It contains options to allow the user to select multiple objects, and also contains an advanced selection option. The Object Selector is included with the target chooser.
       <br/>
       <br/>
       <u>Details:</u>
       <br/>
       Found in: WidgetTemplates.xsl
       <br/>
       Template name: target-chooser
       <br/>
       Parameters:
       <ul>
            <li>TC.advancedSelectionEnabled</li>
            <li>TC.multipleObjectEnabled</li>
            <li>TC.initialValue</li>
            <li>TC.controlName</li>
            <li>TC.prompt</li>
       </ul>
       Note: <b>target-chooser-scripts</b> must be included in the "head" section of your page for this widget to work.
       <br/>
       <br/>
       <u>Example:</u>
       <br/>
       <xsl:call-template name="target-chooser">
          <xsl:with-param name="TC.prompt">false</xsl:with-param>
       </xsl:call-template>

       <br/>
       (Note: Click on the object selector and select an object to see how the target chooser works.)
       <br/>
       <br/>
       <u>Code for this example:</u>
       <br/>
       <b>target-chooser-scripts</b>:<br/>
       &lt;xsl:call-template name="target-chooser-scripts"/&gt;
       <br/>
       <br/>
       <b>target-chooser</b>:<br/>
       &lt;xsl:call-template name="target-chooser"/&gt;
       <br/>
       <br/>
       <xsl:call-template name="bar"/>





        <b>task-header</b>
        <br/>
        The task header can be seen at the top of this frame. It shows an icon pertaining to the task, the title of the task, a horizontal bar, and an optional help button.
        <br/>
        <br/>
        <u>Details:</u>
        <br/>
        Found in: WidgetTemplates.xsl
        <br/>
        Template name: task-header
        <br/>
        Parameters:
        <ul>
            <li>TaskHeader.title</li>
            <li>TaskHeader.bgcolor</li>
            <li>TaskHeader.iconUrl</li>
            <li>TaskHeader.iconAlt</li>
            <li>TaskHeader.helpFile</li>
        </ul>
        Note: If TaskHeader.helpFile is set, an icon will show up in the top right side of the header which contains a link to the context sensitive help.
        <br/>
        <br/>
       <u>Code for this example:</u> (found at the top of this frame)
       <br/>
       &lt;xsl:call-template name="task-header"&gt;
          &lt;xsl:with-param name="TaskHeader.title"&gt;Widget Example&lt;/xsl:with-param&gt;
          &lt;xsl:with-param name="TaskHeader.iconUrl" select="concat($Portal.ResourcePath, '/modules/dev/images/dir/SLP_Service.gif')"/&gt;
          &lt;xsl:with-param name="TaskHeader.iconAlt"&gt;Widget Example&lt;/xsl:with-param&gt;
       &lt;/xsl:call-template&gt;
       <br/>
       <br/>
        <xsl:call-template name="bar"/>




       <b>form-header</b>
       <br/>
       The form header displays information about a form.
       <br/>
       <br/>
       <u>Details:</u>
       <br/>
       Found in: WidgetTemplates.xsl
       <br/>
       Template name: form-header
       <br/>
       Parameters:
       <ul>
           <li>FormHeader.title</li>
           <li>FormHeader.helpFile</li>
       </ul>
       <br/>
       <br/>
       <u>Example Code:</u>
       <br/>
       &lt;xsl:call-template name="form-header"&gt;
          &lt;xsl:with-param name="FormHeader.title"&gt;Form1&lt;/xsl:with-param&gt;
          &lt;xsl:with-param name="FormHeader.HelpFile"&gt;help1.html&lt;/xsl:with-param&gt;
       &lt;/xsl:call-template&gt;
       <br/>
       <br/>
       <xsl:call-template name="bar"/>



       <b>wizard-header</b>
       <br/>
       The wizard header displays information about pertaining to the pages of a wizard.
       <br/>
       <br/>
       <u>Details:</u>
       <br/>
       Found in: WidgetTemplates.xsl
       <br/>
       Template name: wizard-header
       <br/>
       Parameters:
       <ul>
           <li>WizardHeader.title</li>
           <li>WizardHeader.subtitle</li>
           <li>WizardHeader.helpFile</li>
           <li>WizardHeader.instruction</li>
       </ul>
       <br/>
       <br/>
       <u>Example Code:</u>
       <br/>
       &lt;xsl:call-template name="wizard-header"&gt;
          &lt;xsl:with-param name="WizardHeader.title"&gt;Wizard1&lt;/xsl:with-param&gt;
          &lt;xsl:with-param name="WizardHeader.subTitle"&gt;Page 2&lt;/xsl:with-param&gt;
          &lt;xsl:with-param name="WizardHeader.helpFile"&gt;help1.html&lt;/xsl:with-param&gt;
       &lt;/xsl:call-template&gt;
       <br/>
       <br/>
       <xsl:call-template name="bar"/>



       <b>MVStringEditor</b> ( &amp; <b>MVStringEditorScripts</b> )
       <br/>
       The MVStringEditor is the main string editor used in iManager. It allows users to type strings or select objects from the object selector. It is simple to use, but has quite a few optional parameters (See MVStringEditor.xsl for specific information)
       <br/>
       <br/>
       <u>Examples:</u>
       <br/>
       Simple mode:
       <br/>
       <xsl:call-template name="MVStringEditor">
           <xsl:with-param name="name">mv1</xsl:with-param>
       </xsl:call-template>
       <br/>
       Code for this example:
       <br/>
       &lt;xsl:call-template name="MVStringEditor"&gt;<br/>
       &lt;xsl:with-param name="name"&gt;mv1&lt;/xsl:with-param&gt;<br/>
       &lt;/xsl:call-template&gt;
       <br/>
        <br/>
        Expanded Simple mode:
        <br/>
        <xsl:call-template name="MVStringEditor">
            <xsl:with-param name="mode">sel</xsl:with-param>
            <xsl:with-param name="size">10</xsl:with-param>
            <xsl:with-param name="name">mv2</xsl:with-param>
        </xsl:call-template>
       <br/>
       Code for this example:
       <br/>
        &lt;xsl:call-template name="MVStringEditor"&gt;<br/>
        &lt;xsl:with-param name="mode"&gt;sel&lt;/xsl:with-param&gt;<br/>
        &lt;xsl:with-param name="size"&gt;10&lt;/xsl:with-param&gt;<br/>
        &lt;xsl:with-param name="name"&gt;mv2&lt;/xsl:with-param&gt;<br/>
        &lt;/xsl:call-template&gt;
       <br/>
        <br/>
        Internet Explorer mode:
        <br/>


        <xsl:call-template name="MVStringEditor">
           <xsl:with-param name="mode">ie</xsl:with-param>
           <xsl:with-param name="name">mv3</xsl:with-param>
           <xsl:with-param name="items" select="./items"/>
        </xsl:call-template>



       <br/>
       Code for this example:
       <br/>
        &lt;xsl:call-template name="MVStringEditor"&gt;<br/>
        &lt;xsl:with-param name="mode"&gt;ie&lt;/xsl:with-param&gt;<br/>
        &lt;xsl:with-param name="name"&gt;mv3&lt;/xsl:with-param&gt;<br/>
        &lt;/xsl:call-template&gt;
       <br/>
        <br/>
       Internet Explorer mode with objectTypeName set as *:
       <br/>
       <xsl:call-template name="MVStringEditor">
           <xsl:with-param name="mode">ie</xsl:with-param>
           <xsl:with-param name="objectTypeName">*</xsl:with-param>
           <xsl:with-param name="name">mv4</xsl:with-param>
       </xsl:call-template>
       <br/>
       Code for this example:
       <br/>
       &lt;xsl:call-template name="MVStringEditor"&gt;<br/>
       &lt;xsl:with-param name="mode"&gt;ie&lt;/xsl:with-param&gt;<br/>
       &lt;xsl:with-param name="objectTypeName"&gt;*&lt;/xsl:with-param&gt;<br/>
       &lt;xsl:with-param name="name"&gt;mv4&lt;/xsl:with-param&gt;<br/>
       &lt;/xsl:call-template&gt;
       <br/>
        <br/>
       <u>Details:</u>
       <br/>
       Found in: MVStringEditor.xsl
       <br/>
       Template name: MVStringEditor
       <br/>
       Parameters:
       <ul>
            <li>items</li>
            <li>mode</li>
            <li>size</li>
            <li>width</li>
            <li>disabled</li>
            <li>formName</li>
            <li>enforceUnique</li>
            <li>numbersOnly</li>
            <li>ignoreCase</li>
            <li>upperBound</li>
            <li>lowerBound</li>
            <li>maxLength</li>
            <li>minLength</li>
            <li>name</li>
            <li>history</li>
            <li>objectTypeName</li>
       </ul>

       Note: <b>MVStringEditorScripts</b> must be included in the "head" section of your page for this widget to work.
       <br/>
       <br/>
       <xsl:call-template name="bar"/>






   </FORM>
   </BODY>
   </HTML>
   </xsl:template>

</xsl:stylesheet>