<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);

  /* **************************************************************************
%name: WizProgress_js.jsp %
%version: 9 %
%date_modified: Tue May 20 17:07:58 2003 %
Copyright (c) 2001, 2002 Novell, Inc. All Rights Reserved.
THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO THIS WORK IS
RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A NEED TO KNOW HOW
TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS AND (II)
ENTITIES OTHER THAN NOVELL, INC. WHO HAVE ENTERED INTO APPROPRIATE
LICENSE AGREEMENTS. NO PART OF THIS WORK MAY BE USED, PRACTICED,
PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, TRANSFORMED
OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE
OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
***************************************************************************  */


  /* ------------------------------------------------------------------  */
  /* This file contains JavaScript specific to the progress 			   */
  /* template.                                                           */
  /* ------------------------------------------------------------------  */


  /* Global variables.  */

  /* True while a backup or restore is in progress.  */%>
var	bWizActive = false;
	<% if ( c.def("Operation.Active")) {
		   if ("true".equals(c.var("Operation.Active"))) { %>
			bWizActive = true;
		<% }
	   }

  /* The following is used to control the intervals between automatic  */
  /* progress updates.                                                 */%>
var iUpdateInterval = 5;
	<% if ( c.def("CfgWiz.UpdateInterval")) { %>
		iUpdateInterval = Number( "<%= c.toScript(c.var("CfgWiz.UpdateInterval")) %>" );
	<% }

  /* Tracks information about an open question window.  */%>
var	oQuestionInfo = null;

<%/* Tracks the timer object used to refresh the progress window.  */%>
var	oRefreshTimer = null;



<%/* --------------------------------------------------------  */
  /* Confirms that the user really wants to perform a cancel.  */
  /* --------------------------------------------------------  */%>
function confirmCancel()
{
	var	bHadTimer;
	var	bReply;


	<%/* If we"ve got a timeout set...  */%>
	bHadTimer = (null != oRefreshTimer);
	if (bHadTimer)
	{
		<%/* ...clear it while we confirm the cancel.  */%>
		window.clearTimeout( oRefreshTimer );
		oRefreshTimer = null;
	} <%/* if  */


	  /* Does the user really wants to cancel?  */%>
	if (confirm( "<%= c.toScript(c.string("CfgWiz.Progress.ConfirmCancel")) %>" ))
	     bReply = true;
	else bReply = false;


	<%/* Do we need to restore the update timeout?  */%>
	if (bHadTimer &&			<%/* If we had a timer set...                   */%>
		(!bReply) &&			<%/* ...and the user doesn"t want to cancel...  */%>
		(0 < iUpdateInterval))	<%/* ...and there is a non-0 update interval.   */%>
	{
		<%/* Yes!  Reset it.  */%>
		oRefreshTimer = window.setTimeout(
			handleUpdate,
			Number( iUpdateInterval*1000 ));
	} <%/* if  */


	  /* If we get here, bReply contains true if the user wants to  */
	  /* cancel and false otherwise.  Return it.                    */%>
	return( bReply );
} <%/* confirmCancel  */


  /* ----------------------------------------------  */
  /* Called when the update push button is pressed.  */
  /* ----------------------------------------------  */%>
function handleUpdate()
{
	<%/* This function works on the main form.  */%>
	with (getMainWizForm())
	{
		<%/* If we"ve got a timeout set...  */%>
		if (null != oRefreshTimer)
		{
			<%/* ...clear it.  */%>
			window.clearTimeout( oRefreshTimer );
			oRefreshTimer = null;
		} <%/* if  */


		  /* Is a creation still active?  */%>
		if (!bWizActive)
		{
			<%/* No!  Then we don"t allow the update.  Tell the user  */
			  /* why and bail.                                        */%>
			alert( "<%= c.toScript(c.string("CfgWiz.Error.CreateNotActive"))%>" );
			return;
		} <%/* if  */


		  /* Simply submit the progress form.  This issues  */
		  /* a request to retrieve additional progress info.            */%>
		submitMain();
	} <%/* with  */%>
} <%/* handleUpdate  */



  /* -------------------------------------------------------  */
  /* Called when the update interval push button is pressed.  */
  /* -------------------------------------------------------  */%>
function handleUpdateInterval()
{
	<%/* This function works on the main form.  */%>
	with (getMainWizForm())
	{
		var	bHadTimer;
		var	c;
		var	i;
		var	iL;
		var	sI;


		<%/* Is a create currently active?  */%>
		if (!bWizActive)
		{
			<%/* No!  Then the update interval can"t be updated.  */%>
			return;
		} <%/* if  */


		  /* If we"ve got a timeout set...  */%>
		bHadTimer = (null != oRefreshTimer);
		if (bHadTimer)
		{
			<%/* ...clear it.  */%>
			window.clearTimeout( oRefreshTimer );
			oRefreshTimer = null;
		} <%/* if  */%>


		while (true)
		{
			<%/* Does the user want to set a new interval value?  */%>
			sI = prompt(
				"<%= c.toScript(c.string("CfgWiz.Progress.UpdateInterval")) %>",
				String( iUpdateInterval ));

			if (null == sI)
			{
				<%/* No!  Break out of the read loop.  */%>
				break;
			} <%/* if  */


			  /* Did the user enter a value?  */%>
			iL = sI.length;
			if (0 < iL)
			{
				<%/* Yes!  Is it a number?  */%>
				for (i = 0; i < iL; i += 1)
				{
					c = sI.charAt( i );
					if ((c < '0') || (c > '9'))
					{
						break;
					} <%/* if  */%>
				} <%/* for  */%>

				if (i < iL)
				{
					<%/* No!  Tell them about the problem and let them  */
					  /* enter another value.                           */%>
					alert( "<%= c.toScript(c.string("CfgWiz.Error.BogusNumber")) %>" );
					continue;
				} <%/* if  */


				  /* The value they entered was a number.  Put it into  */
				  /* effect.                                            */%>
				iUpdateInterval = Number( sI );
				Hidden_UpdateInterval.value = sI;
				break;
			} <%/* if  */%>
		} <%/* while  */


		  /* Is the user requesting automatic updates?  */%>
		if (0 < iUpdateInterval)
		{
			<%/* Yes!  Is the user being asked a question?  */
			   if ("question".equals(c.var("Progress_Type")) == false) {
				  /* No!  Set the timeout to update this page.  */%>
				oRefreshTimer = window.setTimeout(
					handleUpdate,
					Number( iUpdateInterval*1000 ));
			<% } %>
		} <%/* if  */%>
	} <%/* with  */%>
} <%/* handleUpdateInterval  */



  /* ---------------------------------------------------------  */
  /* Returns true if a question is active and false otherwise.  */
  /* ---------------------------------------------------------  */%>
function isQuestionActive()
{
	<%/* Are we tracking a question?  */%>
	if (null == oQuestionInfo)
	{
		<%/* No!  Then one isn"t active.  Return false.  */%>
		return( false );
	} <%/* if  */


	  /* Are we tracking a question that"s been closed?  */%>
	if (!(isNameDefined( oQuestionInfo.oEditor )))
	{
		<%/* Yes!  Forget about it.  */%>
		oQuestionInfo = null;
	} <%/* if  */


	  /* Return true if we"re still tracking a question and false  */
	  /* otherwise.                                                */%>
	return( null != oQuestionInfo );
} <%/* isQuestionActive  */



  /* --------------------------------------------  */
  /* Called when the user responds to a question.  */
  /* --------------------------------------------  */%>
function questionApply(
	aResponses)	<%/* An array of responses to the question.  */%>
{
	<%/* This function works on the main form.  */%>
	with (getMainWizForm())
	{
		var	i;
		var	iA;
		var	si;


		<%/* Scan the answers to the question...  */%>
		iA = (isDefined( aResponses ) ? aResponses.length : 0);
		for (i = 0; i < iA; i += 1)
		{
			<%/* ...storing each in the appropriate holder.  */%>
			getWizElement( "Hidden_Answer." + String( i ) ).value =
				aResponses[i];
		} <%/* for  */


		  /* If we can we still access the question window...  */%>
		if (isQuestionActive())
		{
			<%/* ...close it.  */%>
			oQuestionInfo.oEditor.close();
			oQuestionInfo = null;
		} <%/* if  */


		  /* Finally, submit the form so that the responses get sent  */
		  /* back to eMBox.                                           */%>
		submit();
	} <%/* with  */%>
} <%/* questionApply  */



  /* -----------------------------------------  */
  /* Runs a window to ask the user a question.  */
  /* -----------------------------------------  */%>
function questionSpawn()
{
	<%/* If a question is currently active...  */%>
	if (isQuestionActive())
	{
		<%/* ...we won"t open another one.  Bail */%>
		alert( "<%= c.toScript(c.string("CfgWiz.Error.EditorActive_Question")) %>" );
		return( false );
	} <%/* if  */


	  /* Run the question...  */%>
	oQuestionInfo         = new Object();
	oQuestionInfo.oEditor = questionSpawn_Impl();

	<%/* ...and return true to indicate the spawn was successful.  */%>
	return( true );
} <%/* questionSpawn  */



  /* ----------------------------------------------  */
  /* Performs the actual spawning for the question.  */
  /* ----------------------------------------------  */%>
function questionSpawn_Impl()
{
	<%/* This function works on the question form.  */%>
	with (getQuestionWizForm())
	{
		var qFeatures;
		var	qWI;
		var	url;
		var	w;


		<%/* Build a URL for the question...  */%>
		url =
			("webacc"                          +
			 "?taskId=CfgWiz.RPC"          +
			 "&merge=fw.WizQuestion" +
			 "&error=dev.GenErr"               +
			 "&User.context=<%= c.var("User.context") %>");

		<%/* ...and run the question in a popup window.  */%>
		qWI       = centeredWindowInfo( 600, 300 );
		qFeatures =
			("toolbar=no,"              +
			 "location=no,"             +
			 "directories=no,"          +
			 "menubar=no,"              +
			 "resizable=yes,"           +
			 "scrollbars=no,"    		+
			 "width="  + qWI.cx + "," +
			 "height=" + qWI.cy);

		<% if (("true".equals(c.var("Wiz.BrowserIsNetscape")))) { %>
			qFeatures +=
				(",screenX=" + qWI.x +
				 ",screenY=" + qWI.y);

		<% } else if (("true".equals(c.var("Wiz.BrowserIsIE")))) { %>
			qFeatures +=
				(",left=" + qWI.x +
				 ",top="  + qWI.y);
		<% } %>
		w = window.open(
			"",
			"<%= c.toScript(c.string("CfgWiz.Window.Question")) %>",
			qFeatures );


		<%/* Did the popup question window open?  */%>
		if (null != w)
		{
			<%/* Yes!  Submit the form to load the question.  */%>
			action = url;
			target = "<%= c.toScript(c.string("CfgWiz.Window.Question")) %>";
			submit();
		} <%/* if  */


		  /* Finally, return the question"s window object.  */%>
		return( w );
	} <%/* with  */%>
} <%/* questionSpawn_Impl  */



  /* -------------------------------------------  */
  /* Puts the initial input focus into the page.  */
  /* -------------------------------------------  */%>
function setFocusAndInitializeForm()
{
	<%/* This function works on the main form.  */%>
	with (getMainWizForm())
	{
		var	aCaptionData;
		var	oNavData;


		<%/* Perform initializations common to all Wizard panels.  */%>
		initializePanel_Common();
		msgText.focus();


		<%/* Does the message area have a scroll bar?  */
		   if ( c.def("CfgWiz.Response.Count")) {
		   } else {    c.set("CfgWiz.Response.Count", "0");
		   } %>
		if (msgText.rows < <%= c.var("CfgWiz.Response.Count") %>)
		{
			<%/* Yes!  Make sure the last message is scrolled into  */
			  /* view.                                              */
			   if (("true".equals(c.var("Wiz.BrowserIsIE")))) { %>
				msgText.scrollTop = msgText.scrollHeight;

			<% } else {
				  /* I can"t figure out how to make the TEXTAREA scroll  */
				  /* in Netscape.  For now, it won"t.                    */
			   } %>
		} <%/* if  */


		  /* Is a create active and does the user want to do automatic  */
		  /* updates?                                                  */%>
		if (bWizActive && (0 < iUpdateInterval))
		{
			<%/* Yes!  Is the user being asked a question?  */
			   if ("question".equals(c.var("Progress_Type")) == false) {
				  /* No!  Set an appropriate timeout to update this  */
				  /* page.                                           */%>
				oRefreshTimer = window.setTimeout(
					handleUpdate,
					iUpdateInterval*1000 );
			<% } %>
		} <%/* if  */


		  /* Force the caption frame to update with settings  */
		  /* appropriate for this panel.                      */%>
		aCaptionData = new Array();
		aCaptionData["Wiz_Banner_Text"]     = "<%= c.toScript(c.string("CfgWiz.Wizard.Title")) %>";
	 	aCaptionData["Wiz_Banner_ShowHelp"] = false;
		parent.window.Wiz_BannerFrame.updateCaption( aCaptionData );


		<%/* Is the user being asked a question?  */
		   if ("question".equals(c.var("Progress_Type"))) {
			  /* Yes!  Disable all the navigation push buttons...  */%>
			oNavData               = new Object();
			oNavData.disableBack   =
			oNavData.disableClose  =
			oNavData.disableFinish =
			oNavData.disableNext   = true;
			parent.window.Wiz_NavigationFrame.updateNavigation( oNavData );

			<%/* ...and ask the question.  */%>
			questionSpawn();

		<% } else {
			  /* No, the user isn"t being asked a question!     */
			  /* Enable/Disable the navigation push buttons as  */
			  /* appropriate.                                   */%>
			oNavData               = new Object();
			oNavData.disableBack   = bWizActive;
			oNavData.disableClose  = bWizActive;

			if ( !bWizActive )
			{
				 <%/*-- if we are done, only allow them to go Back if there was a fatal error -- */
				   if ((c.string("CfgWiz.Error.Error").equals(c.var("CfgWiz.ErrorStatus")))) { %>
				oNavData.disableBack   = false;
				<% } else { %>
				oNavData.disableBack   = true;
				<% }

				  /*-- bring window to the top so they can see the Completed image -- */%>
				window.scrollTo( 0,0 );
			}
			oNavData.disableFinish =
			oNavData.disableNext   = true;
			parent.window.Wiz_NavigationFrame.updateNavigation( oNavData );

		<% } %>
	} <%/* with  */%>
} <%/* setFocusAndInitializeForm  */



  /* -----------------------------------------------------  */
  /* Called when the help button is pressed on this panel.  */
  /* -----------------------------------------------------  */%>
function showHelp()
{
	<%/* runHelp( "helpfileforpanel.html" );  */ 	  /* Uncomment to enable help on this panel.  */%>
} <%/* showHelp  */



  /* ---------------------------------------------------------------  */
  /* Validates the selected server information when one of the 	    */
  /* push buttons is pressed.                                         */
  /* ---------------------------------------------------------------  */%>
function validateForm_PerPanel()
{
	<%/* This function works on the main form.  */%>
	with (getMainWizForm())
	{
		var	sPB;


		<%/* Validate which push button was pressed.  */%>
		sPB = getPBClicked();
		if ("WizPB_Back" == sPB)
		{
			<%/* If a create is active...  */%>
			if (bWizActive)
			{
				<%/* ...we don"t allow the back.  */%>
				Hidden_PBNavigation.value = "";
				alert( "<%= c.toScript(c.string("CfgWiz.Warning.CantBackWhileActive")) %>" );
			} <%/* if  */%>

			else
			{
				<%/* ...otherwise, we do.  */%>
				performBack();
			} <%/* else  */%>

			return( false );
		} <%/* if  */%>
		if ("WizPB_Next" == sPB)
		{
			return( false );
		} <%/* if  */%>
		if ("WizPB_Cancel" == sPB)
		{
			<%/* Return true if the user really wants to cancel and  */
			  /* false otherwise.                                    */%>
			return( confirmCancel() );
		} <%/* if  */%>
		if ("WizPB_Close"  == sPB)
		{
			<%/* Return true so that the form gets submitted and the  */
			  /* plug-in gets a chance to cleanup.                    */%>
			return( true );
		} <%/* if  */%>
		if ("WizPB_Finish" != sPB)
		{
			alert( "<%= c.toScript(c.string("CfgWiz.InternalError.UnknownPB")) %>" );
			return( false );
		} <%/* if  */


		  /* Finishing means that we"re done.  Treat things as though  */
		  /* the user pressed close and return true so that the form   */
		  /* gets submitted and the plug-in gets a chance to cleanup.  */%>
		Hidden_PBNavigation.value = "WizPB_Close";
		return( true );
	} <%/* with  */%>
} <%/* validateForm_PerPanel  */



						     /* * * * * * *  */
                             /* End of File  */
                             /* * * * * * *  */%>
