<!--
//   Name:  CustomeCreateExampleTemplate.jsp
//
//   Copyright (c) 1997-2004 Novell, Inc.  All Rights Reserved.
//
//   THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
//   USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
//   ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
//   PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
//   ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
//   PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
//   DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
//   PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
//   CUSTOMERS WITH RESPECT TO THIS CODE.
-->

<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit,
                  com.novell.emframe.dev.eMFrameUtils, com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/fmt.tld" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>


<iman:stringtable bundle="DevResources"/>
<iman:stringtable bundle="FwResources"/>
<iman:stringtable bundle="BaseResources"/>
<!-- --- -->
<iman:stringtable bundle="com.company.plugins.iManagerCodeExamplesResources"/>


<%-- Empty xml, since we don't have an object to read --%>
<c:set var="edas" value="<edas></edas>"/>
<x:parse xml="${edas}" var="edasXml"/>

<HTML>
<HEAD>
   <TITLE><iman:string key="ProductName"/></TITLE>
   <LINK rel="stylesheet" href="<c:out value="${ContextPath}" />/portal/modules/dev/css/hf_style.css">
   <iman:include page="fw/UiHandlerTools.jsp" />


   <iman:include page="dev/eMFrameScripts_inc.jsp"/>
   <iman:include page="dev/ValidateIntegerScripts_inc.jsp"/>
   <iman:include page="dev/OSScripts_inc.jsp"/>
   <iman:include page="dev/MVStringEditorScripts_inc.jsp"/>

   <SCRIPT>
      function onInit()
      {
         var form = document.forms[0];
         returnFromOS();
      }

      function onExit()
      {
         var form=document.forms[0];

         var success = notifyAllOfExit();
         if(!success)
         {
            return false;
         }



         form.eDir$target.value = getValueFromXml(form.eDir$target$CN.value);
         if ((null == form.eDir$target.value) || (form.eDir$target.value.length == 0))
         {
            alert("<iman:string key='Creator.InvalidObjectName'/>");
            return false;
         }


         var containerInput = document.form.eDir$target$createContext.value;
         var radioButton = (form.eDir$target$createContext[0] && form.eDir$target$createContext[0].type == "radio");
         if(!radioButton)
         {
            if ((containerInput==null) || (containerInput.length==0))
            {
               alert("<iman:string key='Creator.InvalidContainerName'/>");
               return false;
            }
         }

         return true;
      }

      var ENABLED_COLOR = "white";
      var DISABLED_COLOR = "#EFEEE9";

      function enableTemplate(control)
      {
         with(document.forms[0])
         {
            var tf = eDir$target$createSourceObjectForClone;
            if (control.checked == true)
            {
               tf.disabled = false;
               tf.style.backgroundColor = ENABLED_COLOR;
            }
            else
            {
               tf.disabled = true;
               tf.value = "";
               tf.style.backgroundColor = DISABLED_COLOR;
            }
         }
      }

	   function checkDefaultKey(evt)
      {
         var form = document.forms[0];
         var keyCode = evt.which ? evt.which : evt.keyCode;
         // 13 is the Enter key code
         if (keyCode == 13)
         {
            if(onExit() != false)
            {
               document.forms[0].submit();
               return false;
            }
         }
         return true;
      }
   </SCRIPT>
</HEAD>


<body text="#000000" bgcolor="#ffffff" onLoad="onInit();">
<FORM name=form method=post action=webacc onSubmit="onExit();">


   <!---- EDAS and System Variables ---->
   <INPUT type=hidden name="taskId" value="<iman:string key='taskId' />">
   <INPUT type=hidden name="eDirCommand" value="create">
   <INPUT type=hidden name="eDir$target" value="">
   <INPUT type=hidden name="merge" value="dev.GenConf">
   <INPUT type=hidden name="error" value="dev.GenErr">
   <INPUT type=hidden name="nextState" value="eDasServiceAccess">

   <INPUT type=hidden name="eDir$target$createClassName" value="<iman:string key='createClassName'/>">

   
   <iman:taskHeader titleKey="CustomCreateExample.TaskDisplayName" iconAlt="This is taskHeader.iconAlt text." />
   
   <iman:string key="CustomCreateExample.Description"/>
   <br/><br/>
   <iman:string key="CustomCreateExample.Description2"/>
   <br/>
   <br/>
   <iman:string key="CustomCreateExample.Description3"/>
   <br/>
   <br/>
   <iman:string key="CustomCreateExample.Description4"/>
   <br/>
   <br/>
   <!---- UI Created by UiHandlers ---->

   <TABLE class="mediumtext" border="0" bgcolor="#FFFFFF" cellpadding="0" cellspacing="0">


   <%-- Create Context --%>
   <TR>
      <TD><iman:string key="Creator.Context"/></TD>
   </TR>
   <TR>
      <TD>
     
        
        <INPUT type=text name="eDir$target$createContext" 
         		value="<%= eMFrameUtils.getSingleTarget(request) %>"
         		size="<iman:string key='UI.textboxSize'/>" 
         		style="width:<iman:string key='UI.textboxPixel'/>" 
         		onkeypress="return checkDefaultKey(event)"
         > 
        
         <iman:os 
         	control="eDir$target$createContext" 
         	typeFilter="CreatorSearchFilter" 
			history="true"
			windowed="true" 
         />
         
         <iman:include page="dev/OS_inc.jsp"/>
      </TD>
   </TR>
   <TR><TD height="9"></TD></TR>

   <%-- CN --%>
   <TR>
      <TD align="left" colspan="2">
         <c:out value="${CNDisplayName}"/>:&nbsp;&nbsp;
      </TD>
   </TR>
   <TR>
      <TD>
         <c:if test="${edasRights.target.CN.writeable}">
            <INPUT type="hidden" name="eDir$target$CN" value="<c:out value="${eDir$target$CN}" escapeXml="false"/>">
            <SCRIPT>addToNotificationList('CN', 'uih_mvStringEditor');</SCRIPT>
         </c:if>
         <x:set var="MVStringEditor_xmlNodeSet" select="$edasXml/edas/CN" scope="request"/>
         <iman:mved maxLength="64" readonly="${!edasRights.target.CN.writeable}" enforceUnique="true" ignoreCase="true" minLength="1" name="_CN"         />
      </TD>
      <TD valign="top">
         <x:set var="mode" select="$edasXml/edas/CN[mode]"/>
         <iman:mooMode name="_CN_mode" value="${mode}" multi="true" />
      </TD>
   </TR>
   <TR><TD height="9"></TD></TR>

   <%-- Surname --%>
   <TR>
      <TD align="left" colspan="2">
         <c:out value="${SurnameDisplayName}"/>:&nbsp;&nbsp;
      </TD>
   </TR>
   <TR>
      <TD>
         <c:if test="${edasRights.target.Surname.writeable}">
            <INPUT type="hidden" name="eDir$target$Surname" value="<c:out value="${eDir$target$Surname}" escapeXml="false"/>">
            <SCRIPT>addToNotificationList('Surname', 'uih_mvStringEditor');</SCRIPT>
         </c:if>
         <x:set var="MVStringEditor_xmlNodeSet" select="$edasXml/edas/Surname" scope="request"/>
         <iman:mved maxLength="64" readonly="${!edasRights.target.Surname.writeable}" enforceUnique="true" ignoreCase="true" minLength="1" name="_Surname"         />
      </TD>
      <TD valign="top">
         <x:set var="mode" select="$edasXml/edas/Surname[mode]"/>
         <iman:mooMode name="_Surname_mode" value="${mode}" multi="true" />
      </TD>
   </TR>
   <TR><TD height="9"></TD></TR>

   </TABLE><BR>

   <iman:include page="dev/Bar_inc.jsp"/>
   <A href="Javascript: if(onExit() != false) document.forms[0].submit();">
   		
   		<iman:button key="OK" onClick="Javascript: if(onExit() != false) document.forms[0].submit();"/>
   </A> 
   
   <iman:include page="dev/Cancel_inc.jsp"/>

</FORM>
<iman:include page="dev/OSFooter_inc.jsp"/>
</BODY>
</HTML>



