<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	This template builds the Branding Area.

	The Branding Area consists of a header, body, and
	footer.  This template is also responsible for passing
	control to the Inheritable Area template.

	Since the Inheritable Area is represented as a Gadget,
	there is nothing implicit that is done in the Branding
	Area templates for the Inheritable Area.

	In this template, we ensure that we don't create
	empty rows or cells where not necessary.  For this
	reason, there are extra <xsl:if> conditions that
	prevent the Header, Body, and/or Footer from being
	rendered to the ObjectScheme when there are no
	gadgets assigned to one of these.

	All style elements come from LayoutSettings.xsl.

	*******************************************************

	The following conditions are REQUIRED for this file to
	function properly in Novell Portal Services.  Any
	additional templates are optional and may be added,
	removed, or modified as needed.

	Templates REQUIRED in this file:

		<xsl:template match="com.novell.nps.BrandingArea">

	Templates that must be called in this file:

		1.  The Inheritable Area.  This is normally placed
			inside the Branding Area Body.

			<xsl:apply-templates select="Gadget/com.novell.nps.MainPage"/>

		2.  The Branding Area template must render Gadgets
			that are directly assigned to the Header,
			Body (Column 1, 2, or 3), and Footer.  Follow
			the same syntax as made in the base stylesheets.

			<xsl:call-template name="Portal.Gadget"/>
-->
	<xsl:template match="com.novell.nps.BrandingArea">
		<html>
			<head>
				<!--
			The <title> tag is populated here by the title
			of the Branding Area.  This title will be shown
			as the title of the browser window.
		-->
				<title>
					<xsl:value-of select="../@title"/>
				</title>
				<xsl:copy-of select="$Portal.Layout.CSS"/>
				<!-- Add in any CSS Stylesheets specified by gadgets. -->
				<xsl:for-each select="/PortalData/Resources/Resource[@type=&apos;css&apos;]">
					<link href="{@href}" rel="stylesheet"/>
				</xsl:for-each>
				<!-- Add in any Javascript files specified by gadgets. -->
				<xsl:for-each select="/PortalData/Resources/Resource[@type=&apos;js&apos;]">
					<script language="javascript" src="{@href}" type="text/javascript"/>
				</xsl:for-each>
			</head>
			<body class="PortalBrandingArea" xsl:use-attribute-sets="Portal.Layout.Attributes">
				<!-- Build the Branding Area Header -->
				<xsl:call-template name="Portal.BrandingAreaHeader"/>
				<!-- Build the Branding Area Body -->
				<xsl:call-template name="Portal.BrandingAreaBody"/>
				<!-- Build the Branding Area Footer -->
				<xsl:call-template name="Portal.BrandingAreaFooter"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Portal.Fullpage.Branding">
		<html>
			<head>
				<!--
			The <title> tag is populated here by the title
			of the Gadget that is in full-page mode.  This
			title will be shown as the title of the browser
			window.
		-->
				<title>
					<xsl:value-of select="@title"/>
				</title>
				<xsl:copy-of select="$Portal.Layout.CSS"/>
				<!-- Add in any CSS Stylesheets specified by gadgets. -->
				<xsl:for-each select="/PortalData/Resources/Resource[@type=&apos;css&apos;]">
					<link href="{@href}" rel="stylesheet"/>
				</xsl:for-each>
				<!-- Add in any Javascript files specified by gadgets. -->
				<xsl:for-each select="/PortalData/Resources/Resource[@type=&apos;js&apos;]">
					<script language="javascript" src="{@href}" type="text/javascript"/>
				</xsl:for-each>
			</head>
			<body>
				<xsl:call-template name="Portal.Gadget"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Portal.BrandingAreaHeader">

		<SCRIPT Language="javascript">
			<xsl:comment><![CDATA[
        
        function dotearaway(url, targetWin, h, w)
        {

			var moveWin = 0;
            if (h && h > screen.availHeight)
			{				
                height=screen.availHeight-100;
				moveWin = 1;
			}
            else
                height=470;

            if (w && w > screen.availWidth)
			{
                width=screen.availWidth-20;
				moveWin = 1;
			}
            else
                width=630;

			var newWin;
			
            newWin = window.open(url, targetWin,'width='+width+',height='+height+',resizable=yes,menubar=yes,scrollbars=yes,status=yes' );

			if (moveWin == 1)
			{			
				newWin.moveTo(0,0);				
			}


          } // popout

        ]]>//</xsl:comment>
		</SCRIPT>

		<!--
		In the Branding Area Header, just layout the Gadgets
		as Inline Gadgets.  This means that Gadgets assigned
		to the Branding Area Header will be place left to right
		inside the Header.
	-->
		<div id="Head" style="position: absolute; z-index: 2; top: 0px; left: 0px; width: 650px; visibility: visible">
			<img alt="Novell exteNd Director" border="0" height="59" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/banner.gif" width="650"/>
		</div>
		<xsl:for-each select="Gadget[@container=&apos;n&apos; and @position=&apos;Header&apos;]">
			<xsl:sort data-type="number" order="ascending" select="@priority"/>
			<xsl:sort order="ascending" select="@title"/>
			<div style="position: absolute; z-index: 5; top: 28px; left: {position() * 27 + 193}px; width: 24px; height: 24px; visibility: visible">
				<xsl:apply-templates select="*[last()]">
					<xsl:with-param name="Position" select="Header"/>
				</xsl:apply-templates>
			</div>
		</xsl:for-each>
		<!--	<div id="logo" style="text-align: right; position: absolute; z-index: 4; top: 0px; left: 0px; width: 100%; height: 22px; visibility: visible">
			<table border="0" cellpadding="0" cellspacing="0" align="left">
				<tr>
					<td width="450" align="left"><img height="65" width="900" src="&ResourcePath;/stylesheets/skins/{$Portal.Stylesheet.Name}/images/Head_bg.gif" border="0" alt=""/></td>

				</tr>
			</table>
		</div> -->
		<div id="logo" style="text-align: right; position: absolute; z-index: 3; top: 30px; left: 0px; width: 100%; height: 22px; visibility: visible">
			<table align="left" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td align="left" width="450">
						<img alt="" border="0" height="10" src="{$Portal.ResourcePath}/stylesheets/images/pixel.gif" width="600"/>
					</td>
					<td align="right" width="100%">
						<a href="http://www.novell.com/" target="_blank">
							<img alt="Novell" border="0" height="22" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/Novellogo.gif" width="100"/>
						</a>
					</td>
				</tr>
			</table>
		</div>
		<xsl:if test="/PortalData/SessionInfo/AuthInfo/State/text()[.= &apos;StateLoggedIn&apos;]">
			<div style="position: absolute; z-index: 0; top: 59px; left: 8px; width: 340px; height: 18px; visibility: visible;" nowrap="true">
				<font color="#663000" face="Trebuchet MS" size="-1">
					<xsl:value-of select="$com.novell.nps.skins.default.UsernameText"/>: </font>
				<font face="Trebuchet MS" size="-1">
					<xsl:value-of select="/PortalData/SessionInfo/User/CN"/>
				</font>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Portal.BrandingAreaBody">
		<!--
		This Branding Area Body Arranges the Object Scheme
		Tabs down the left side of the Inheritable Area.

		This functionality is provided in the templates
		available in the inheritable_area.xsl file.
	-->
		<!-- Insert the Inheritable Area before the Branding Area Body -->
		<xsl:apply-templates select="Gadget/com.novell.nps.MainPage"/>
		<!--
		Test to see whether there are any Gadgets that should be
		placed in the Body of the Branding Area.

		If there are, we'll dynamically build the columns.

		Gadgets are sorted in each column first by their
		priority and then by their title.
	-->
		<xsl:if test="Gadget[@container=&apos;n&apos; and starts-with(@position,&apos;Column&apos;)]">
			<!-- pushes the BA gadgets down from under the BA header <div> stuff if there isn't already a gadget doing that -->
			<xsl:if test="not(Gadget/com.novell.nps.MainPage)">
				<table>
					<tr>
						<td>
							<img alt="" height="75" src="{$Portal.ResourcePath}/stylesheets/images/pixel.gif"/>
						</td>
					</tr>
				</table>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="../@scheme=&apos;3 Column&apos;">
					<!--
					A three column scheme layout is selected
					for the Branding Area Body.
				-->
					<table border="0" cellpadding="0" cellspacing="0" width="100%">
						<tr>
							<!-- Column 1 is built here -->
							<td valign="top">
								<table border="0" cellpadding="0" cellspacing="0" width="100%">
									<xsl:for-each select="Gadget[@container=&apos;n&apos; and @position=&apos;Column 1&apos;]">
										<xsl:sort data-type="number" order="ascending" select="@priority"/>
										<xsl:sort order="ascending" select="@title"/>
										<tr>
											<td>
												<xsl:call-template name="Portal.Gadget"/>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</td>
							<!-- Column 2 is built here -->
							<td valign="top">
								<table border="0" cellpadding="0" cellspacing="0" width="100%">
									<xsl:for-each select="Gadget[@container=&apos;n&apos; and @position=&apos;Column 2&apos;]">
										<xsl:sort data-type="number" order="ascending" select="@priority"/>
										<xsl:sort order="ascending" select="@title"/>
										<tr>
											<td>
												<xsl:call-template name="Portal.Gadget"/>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</td>
							<!-- Column 3 is built here -->
							<td valign="top">
								<table border="0" cellpadding="0" cellspacing="0" width="100%">
									<xsl:for-each select="Gadget[@container=&apos;n&apos; and @position=&apos;Column 3&apos;]">
										<xsl:sort data-type="number" order="ascending" select="@priority"/>
										<xsl:sort order="ascending" select="@title"/>
										<tr>
											<td>
												<xsl:call-template name="Portal.Gadget"/>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</tr>
					</table>
				</xsl:when>
				<xsl:when test="../@scheme=&apos;2 Column&apos;">
					<!--
					A two column scheme layout is selected
					for the Branding Area Body.
				-->
					<table border="0" cellpadding="0" cellspacing="0" width="100%">
						<tr>
							<!-- Column 1 is built here -->
							<td valign="top">
								<table border="0" cellpadding="0" cellspacing="0" width="100%">
									<xsl:for-each select="Gadget[@container=&apos;n&apos; and @position=&apos;Column 1&apos;]">
										<xsl:sort data-type="number" order="ascending" select="@priority"/>
										<xsl:sort order="ascending" select="@title"/>
										<tr>
											<td>
												<xsl:call-template name="Portal.Gadget"/>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</td>
							<!-- Column 2 is built here.
							Since Column 3 does not exist in the
							two-column layout, we'll force all
							Gadgets that could have accidentally been
							assigned to Column 3 to show up at the
							bottom of Column 2.
						-->
							<td valign="top">
								<table border="0" cellpadding="0" cellspacing="0" width="100%">
									<xsl:for-each select="Gadget[@container=&apos;n&apos; and @position!=&apos;Column 1&apos; and starts-with(@position,&apos;Column&apos;)]">
										<xsl:sort order="ascending" select="@position"/>
										<xsl:sort data-type="number" order="ascending" select="@priority"/>
										<xsl:sort order="ascending" select="@title"/>
										<tr>
											<td>
												<xsl:call-template name="Portal.Gadget"/>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</tr>
					</table>
				</xsl:when>
				<xsl:otherwise>
					<!--
					A one column scheme layout is selected
					for the Branding Area Body.
				-->
					<table border="0" cellpadding="0" cellspacing="0" width="100%">
						<!-- Column 1 is built here

						Since Column 2 and 3 do not exist in the
						one-column layout, we'll force all
						Gadgets that could have accidentally been
						assigned to Column 2 and 3 to show up at
						the of Column 1.
					-->
						<xsl:for-each select="Gadget[@container=&apos;n&apos; and starts-with(@position,&apos;Column&apos;)]">
							<xsl:sort order="ascending" select="@position"/>
							<xsl:sort data-type="number" order="ascending" select="@priority"/>
							<xsl:sort order="ascending" select="@title"/>
							<tr valign="top">
								<td>
									<xsl:call-template name="Portal.Gadget"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Portal.BrandingAreaFooter">
		<!--
		In the Branding Area Footer, just layout the Gadgets
		as Inline Gadgets.  This means that Gadgets assigned
		to the Branding Area Footer will be place left to right
		inside the Header.
	-->
		<table border="0" cellpadding="0" cellspacing="0" width="100%">
			<tr valign="top">
				<xsl:for-each select="Gadget[@container=&apos;n&apos; and @position=&apos;Footer&apos;]">
					<xsl:sort data-type="number" order="ascending" select="@priority"/>
					<xsl:sort order="ascending" select="@title"/>
					<td>
						<xsl:call-template name="Portal.Gadget"/>
					</td>
				</xsl:for-each>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Portal.BrandingArea.Gadget">
		<!--
		This is a special template made specifically for THIS
		Branding Area file.  In this skin, we want to align the
		Gadgets in the Branding Area to the right-hand side of
		the table row.  We also want to force them to NOT have
		a frame around them, so this setting in the XML is
		ignored entirely.  Rather than rely on the basic
		"Portal.Gadget" template (from gadget_frame.xsl), we
		have specifically created this template.
	-->
		<table border="0" cellpadding="0" cellspacing="0" class="PortalGadget" width="100%">
			<tr>
				<td align="right">
					<xsl:apply-templates select="*[last()]"/>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>

<!-- Stylus Studio meta-information - (c)1998-2002 eXcelon Corp.
<metaInformation>
<scenarios/><MapperInfo srcSchemaPath="" srcSchemaRoot="" srcSchemaPathIsRelative="yes" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes"/>
</metaInformation>
-->