<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!--
	This template is responsible for defining the style of
	the Gadget Frame/Title Bar.  It also makes the call
	into the actual Gadget Stylesheet which displays the
	Gadget's data.

	The template works off of the "hasframe" attribute of
	the Gadget's <Gadget> tag.  Additional functionality
	can be added to this template if needed in order to
	support building different style of frames based on
	where the Gadget is assigned (i.e. Different columns
	have different Gadget Frame Styles).

	An important part of building a Gadget's Title Bar is
	displaying the Gadget and System Icons.  Reference the
	base stylesheet for an example of how to do this.

	*******************************************************

	The following conditions are REQUIRED for this file to
	function properly in Novell Portal Services.  Any
	additional templates are optional and may be added,
	removed, or modified as needed.

	Templates REQUIRED in this file:

		<xsl:template name="Portal.Gadget">

	Templates that must be called in this file:

		1.  This template must call into the Gadget's
			own stylesheet template so that the Gadget's
			data can be rendered.  The Gadget's XML
			Data Tag will ALWAYS be the very last
			child inside the <Gadget> tag.  For this
			reason, the following <xsl:apply-template>
			call is used in the place where the Gadget's
			Data should be displayed:

			<xsl:apply-templates select="*[last()]"/>

-->
    <xsl:template name="Portal.Gadget">
        <xsl:choose>
            <xsl:when test="@hasframe=&apos;y&apos; and @top=&apos;n&apos;">
                <table border="0" cellpadding="0" cellspacing="0" class="PortalGadget" width="100%">
                    <tr>
                        <td>
                            <xsl:call-template name="Portal.Gadget.TitleBar"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <xsl:apply-templates select="*[last()]"/>
                        </td>
                    </tr>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <table border="0" cellpadding="0" cellspacing="0" class="PortalGadget" width="100%">
                    <tr>
                        <td>
                            <xsl:apply-templates select="*[last()]"/>
                        </td>
                    </tr>
                </table>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="Portal.Gadget.TitleBar">
        <table border="0" cellpadding="0" cellspacing="0" class="PortalGadgetTitleBar" width="100%">
            <tr valign="middle">
                <td class="PortalGadgetTitleBar"> <xsl:value-of select="@title"/>
                </td>
                <!--
				Check to see whether there are any Gadget Action
				Icons to be displayed.  If so, display them here.
				Otherwise, we won't build an empty <td /> tag.
			-->
                <xsl:if test="Icons/Icon">
                    <td align="right">
                        <xsl:call-template name="Portal.Gadget.TitleBar.GadgetIcons"/>
                    </td>
                </xsl:if>
                <!--
				Here we'll build the normal System Icons by calling
				into the Portal.Gadget.TitleBar.SystemIcons template.
			-->
                <td align="right">
                    <xsl:call-template name="Portal.Gadget.TitleBar.SystemIcons"/>
                </td>
            </tr>
        </table>
    </xsl:template>
    <xsl:template name="Portal.Gadget.TitleBar.SystemIcons">
		<!-- 
			Using the following variable, this skin will not allow the minimize
			button to appear if the gadget is assigned anywhere in the Branding
			Area.
		-->
		<xsl:variable name="isBrandingAreaGadget">
			<xsl:choose>
				<xsl:when test="name(..)='com.novell.nps.BrandingArea' or name(..)='PortalData'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        <table border="0" cellpadding="0" cellspacing="0">
            <tr>
                <xsl:if test="@NPConfig">
                    <!-- Display the Personalize/Edit/Configure Icon -->
                    <td>
                        <a href="{$Portal.Servlet.FullPage}GI_ID={@id}&amp;NPAction=Configurable">
                            <img alt="{$com.novell.nps.skins.builder.PersonalizeImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/personalize.gif"/>
                        </a>
                    </td>
                </xsl:if>
                <xsl:if test="@NPHelp">
                    <!-- Display the Help Icon -->
                    <td>
                        <a TARGET="Help" href="{@NPHelp}">
                            <img alt="{$com.novell.nps.skins.builder.HelpImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/question.gif"/>
                        </a>
                    </td>
                </xsl:if>
                <xsl:if test="@ssGad">
                    <!-- Display the Reset Secret Store Icon -->
                    <td>
                        <a href="{$Portal.Servlet.Normal}GI_ID={@id}&amp;NPAction=ResetGadgetSS">
                            <img alt="{$com.novell.nps.skins.builder.ResetSecretStoreImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/reset_ss.gif"/>
                        </a>
                    </td>
                </xsl:if>
				<!-- 
					Prevent the following three gadgets from being displayed
					if the gadget is assigned to the Branding Area.
				-->
				<xsl:if test="$isBrandingAreaGadget='false'">
					<xsl:if test="@allowTearaway='y'">
						<!-- Allow the gadget to be tear away -->
						<td>
							<!--<a href="{$Portal.Servlet.Service}GI_ID={@id}"> -->
							<a href="#">
								<xsl:attribute name="onclick">dotearaway(&quot;<xsl:value-of select="$Portal.Servlet.Service"/>GI_ID=<xsl:value-of select="@id"/>&quot;,  &quot;<xsl:value-of select="@title"/>&quot;, &quot;<xsl:value-of select="@tearawayHeight"/>&quot;, &quot;<xsl:value-of select="@tearawayWidth"/>&quot;);</xsl:attribute>
								<img alt="{$com.novell.nps.skins.TearAwayImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/tearaway.gif"/>
							</a>
						</td>
					</xsl:if>
	                <xsl:if test="@state=&apos;min&apos;">
	                    <!-- Display the Maximize Icon -->
	                    <td>
	                        <a href="{$Portal.Servlet.Normal}GI_ID={../../@id}&amp;maxWnd={@id}">
	                            <img align="right" alt="{$com.novell.nps.skins.builder.MaximizeImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/maximize.gif"/>
	                        </a>
	                    </td>
	                </xsl:if>
	                <xsl:if test="@state=&apos;max&apos;">
	                    <!-- Display the Minimize Icon -->
	                    <td>
	                        <a href="{$Portal.Servlet.Normal}GI_ID={../../@id}&amp;minWnd={@id}">
	                            <img align="right" alt="{$com.novell.nps.skins.builder.MinimizeImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/minimize.gif"/>
	                        </a>
	                    </td>
	                </xsl:if>
	                <xsl:if test="@allowClose=&apos;y&apos;">
	                    <!-- Display the Close Icon -->
	                    <td>
	                        <a href="{$Portal.Servlet.Normal}GI_ID={../../@id}&amp;remWnd={@id}">
	                            <img alt="{$com.novell.nps.skins.builder.RemoveImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/remove.gif"/>
	                        </a>
	                    </td>
	                </xsl:if>
				</xsl:if>
            </tr>
        </table>
    </xsl:template>
    <xsl:template name="Portal.Gadget.TitleBar.GadgetIcons">
        <!-- Only build the table if Gadget Instance Action Icons Exist -->
        <xsl:if test="Icons/Icon">
            <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                    <xsl:for-each select="Icons/Icon">
                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                        <xsl:sort data-type="text" order="ascending" select="@name"/>
                        <td>
                            <a>
                                <xsl:attribute name="href">
                                    <xsl:value-of select="$Portal.Servlet.Normal"/>GI_ID=<xsl:value-of select="../../@id"/>
                                    <xsl:for-each select="actions/action">&amp;<xsl:value-of select="@name"/>=<xsl:value-of select="."/>
                                    </xsl:for-each>
                                </xsl:attribute>
                                <img align="right" alt="{@name}" border="0" src="{@href}"/>
                            </a>
                        </td>
                    </xsl:for-each>
                </tr>
            </table>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>

<!-- Stylesheet edited using Stylus Studio - (c)1998-2002 eXcelon Corp. -->