<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!--
	This template builds the Inheritable Area.

	The Inheritable Area can exist in two different modes:

		Paged		(Contains Object Schemes)
		Non-Paged	(Builds a Header, Body, and Footer)


	When the Inheritable Area is in a Paged mode, each
	Object Scheme will be shown as a Page (Tab) on the
	screen.  One Object Scheme at a time will be in focus
	or maximized.

	When the Inheritable Area is in a Non-Paged mode, it
	is responsible to build a Header, Body, and Footer.
	Gadgets will be contained inside the Inheritable Area
	XML Tag with their position and priority specified.

	The state of the Inheritable Area can be queried using
	XSL by viewing it's <Gadget> tag attribute named,
	"scheme".  It will either be set to: "Paged",
	"1 Column", "2 Column", or "3 Column".

	*******************************************************

	The following conditions are REQUIRED for this file to
	function properly in Novell Portal Services.  Any
	additional templates are optional and may be added,
	removed, or modified as needed.

	Templates REQUIRED in this file:

		<xsl:template match="com.novell.nps.MainPage">

	Templates that must be called in this file:

		PAGED MODE ONLY

		1.  The Maximized Object Scheme/Page.  This is
			normally placed inside the Inheritable Area
			Body.  (Paged mode ONLY)

			<xsl:apply-templates select="Gadget/com.novell.nps.gadgetManager.ObjectSchemeGadget"/>

		NON-PAGED MODE ONLY

		1.  The Inheritable Area template must render the
			Gadgets that are inherited by the user's
			inheritance in the directory.  These Gadgets
			will exist in the Header, Body (Column 1, 2,
			or 3), and Footer.  Follow the same syntax
			as made in the base stylesheets.

			<xsl:call-template name="Portal.Gadget"/>
-->
    <xsl:template match="com.novell.nps.MainPage">
        <xsl:choose>
            <xsl:when test="../@scheme=&apos;Paged&apos;">
                <!-- TODO: Test if Paged/Non-Paged -->
                <xsl:call-template name="Portal.InheritableAreaPaged"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="Portal.InheritableAreaNonPaged"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="Portal.InheritableAreaPaged">
        <table>
            <tr>
                <td>
                    <img alt="" height="75" src="{$Portal.ResourcePath}/stylesheets/images/pixel.gif"/>
                </td>
            </tr>
        </table>
        <table border="0" cellpadding="0" cellspacing="0" class="PortalInheritableArea" width="100%">
            <tr>
                <td bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}" valign="top" width="150">
                    <xsl:choose>
                        <!-- NPS 1.0, sp1, or sp2 (no hierarchy) or only 1 level of hierarchy stuff -->
<!--                        <xsl:when test="not(/PortalData/PageHierarchy) or not(/PortalData/PageHierarchy/*/Page)">-->
                        <xsl:when test="not(/PortalData/PageHierarchy)">
                            <xsl:call-template name="Portal.InheritableArea.Navigation.oldVerticalTabs"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="Portal.InheritableArea.Navigation.VerticalTabs"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </td>
                <td class="PortalObjectScheme" valign="top">
                    <xsl:apply-templates select="Gadget/com.novell.nps.gadgetManager.ObjectSchemeGadget"/>
                </td>
            </tr>
        </table>
        <!--
	In this template, we will place the Object Scheme
	Navigation Tabs (the tabs which users use to navigate
	to separate portal pages) on the left side of the
	Inheritable Area.  This is controlled by the templates
	inside the object_scheme.xsl file.

	<table border="0" cellpadding="0" cellspacing="0" width="100%" class="PortalInheritableArea" style="position: absolute; z-index: 1; top: 77px; left: 0px; visibility: visible;">
		<tr>
			<td valign="top" width="150">
				<xsl:call-template name="Portal.InheritableArea.Navigation.VerticalTabs"/>
			</td>
			<td valign="top" class="PortalObjectScheme">
				<xsl:apply-templates select="Gadget/com.novell.nps.gadgetManager.ObjectSchemeGadget"/>
			</td>
		</tr>
	</table>-->
    </xsl:template>
    <xsl:template name="Portal.InheritableArea.Navigation.oldVerticalTabs">
        <table bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}" border="0" cellpadding="0" cellspacing="0" width="150">
            <tr>
                <td bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}">
                    <img alt="" height="7" src="{$Portal.ResourcePath}/stylesheets/images/pixel.gif"/>
                </td>
            </tr>
            <tr>
                <td align="left" bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}" height="20">
                    <font face="Trebuchet MS" size="-1">  <b>
                            <xsl:value-of select="$com.novell.nps.skins.default.ServicesText"/>:</b>
                    </font>
                </td>
            </tr>
            <tr>
                <td bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}" height="10" valign="center">
                    <img alt="" src="{$Portal.ResourcePath}/stylesheets/images/pixel.gif"/>
                </td>
            </tr>
            <xsl:for-each select="Gadget">
                <xsl:sort data-type="number" order="ascending" select="@priority"/>
                <xsl:sort order="ascending" select="@title"/>
                <!--
				Treat minimized and maximized object schemes differently.
			-->
                <xsl:choose>
                    <xsl:when test="@state=&apos;max&apos;">
                        <!--
						This is the maximized Object Scheme Tab
					-->
                        <tr>
                            <td class="PortalActiveNavigationTab" nowrap="true">                    <font color="{$Portal.ObjectScheme.Select.Active.Color.Foreground}" face="Trebuchet MS" size="-1">
                                    <xsl:value-of select="@title"/>         </font>
                            </td>
                        </tr>
                    </xsl:when>
                    <xsl:otherwise>
                        <!--
						This is a minimized Object Scheme Tab
					-->
                        <tr>
                            <td class="PortalInactiveNavigationTab" nowrap="true">                    <a class="PortalInactiveNavigationTab" href="{$Portal.Servlet.Normal}GI_ID={../../@id}&amp;maxWnd={@id}">
                                    <font color="{$Portal.ObjectScheme.Select.Inactive.Color.Foreground}" face="Trebuchet MS" size="-1">
                                        <xsl:value-of select="@title"/>
                                    </font>
                                </a>                </td>
                        </tr>
                    </xsl:otherwise>
                </xsl:choose>
                <!--
				This next row in the table just a spacer to
				space out the different Object Scheme Tabs.
			-->
                <tr>
                    <td style="BACKGROUND-COLOR: {$Portal.ObjectScheme.Select.Inactive.Color.Background};">
                        <img alt="" height="20" src="{$Portal.ResourcePath}/stylesheets/images/pixel.gif"/>
                    </td>
                </tr>
            </xsl:for-each>
        </table>
    </xsl:template>
    <xsl:template name="Portal.InheritableArea.Navigation.VerticalTabs">
        <table bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}" border="0" cellpadding="0" cellspacing="0" width="150">
            <tr>
                <td bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}">
                    <img alt="" height="5" src="{$Portal.ResourcePath}/stylesheets/images/pixel.gif"/>
                </td>
            </tr>
            <!--	<tr>
			<td align="left" height="20" bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}">
				<font size="-1" face="Trebuchet MS">
					&#160;<b><xsl:value-of select="$com.novell.nps.skins.default.ServicesText"/>:</b>
				</font>
			</td>
		</tr>
		<tr>
			<td height="5" valign="center" bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}">
				<img src="&ResourcePath;/stylesheets/images/pixel.gif" alt=""/>
			</td>
		</tr> -->
            <xsl:apply-templates select="/PortalData/PageHierarchy/Page">
                <xsl:sort data-type="number" order="ascending" select="@priority"/>
                <xsl:sort order="ascending" select="@name"/>
            </xsl:apply-templates>
        </table>
    </xsl:template>
    <xsl:variable name="Portal.InheritableAreaID">
        <xsl:value-of select="/PortalData/Gadget/com.novell.nps.BrandingArea/Gadget[descendant::com.novell.nps.MainPage]/@id"/>
    </xsl:variable>
    <xsl:variable name="Portal.MaximizedObjectSchemeID">
        <xsl:value-of select="/PortalData/Gadget/com.novell.nps.BrandingArea/Gadget/com.novell.nps.MainPage/Gadget[@state=&apos;max&apos;]/@id"/>
    </xsl:variable>
    <xsl:template match="Page[ancestor::PageHierarchy]">
        <xsl:param name="level" select="1"/>
	    
	    <!-- Added for menu priority issue -->
	    <xsl:variable name="NextLink">
		    <xsl:choose>
			    <xsl:when test="@id">
				    <xsl:value-of select="@id"/>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:choose>
					    <xsl:when test="@link">
						    <xsl:value-of select="@link"/>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:value-of select="descendant-or-self::Page/@id"/>
					    </xsl:otherwise>
				    </xsl:choose>
			    </xsl:otherwise>
		    </xsl:choose>
	    </xsl:variable>
	    
        <xsl:choose>
            <xsl:when test="@id = $Portal.MaximizedObjectSchemeID">
                <tr>
                    <td height="30" valign="middle">
                        <table border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td valign="middle">
                                    <img alt="" src="{$Portal.ResourcePath}/stylesheets/images/pixel.gif" width="{3+ ($level -1) *12}" height="1"/>
                                    <xsl:choose>
                                        <xsl:when test="descendant::Page[@id = $Portal.MaximizedObjectSchemeID]">
                                            <img alt="" height="11" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/minus.gif" width="9"/>
                                        </xsl:when>
                                        <xsl:when test="not(Page)">
                                            <img alt="" height="11" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif" width="9"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <img alt="" height="11" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/minus.gif" width="9"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </td>
                                <td class="PortalActiveNavigationTab" nowrap="true">        <xsl:value-of disable-output-escaping="yes" select="@name"/>       </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <td height="30" valign="middle">
                        <table border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td valign="middle">
                                    <img alt="" src="{$Portal.ResourcePath}/stylesheets/images/pixel.gif" width="{3+ ($level -1) *12}" height="1"/>
                                    <xsl:choose>
                                        <xsl:when test="not(Page)">
                                            <img alt="" height="11" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif" width="9"/>
                                        </xsl:when>
                                        <xsl:when test="descendant::Page[@id = $Portal.MaximizedObjectSchemeID]">
                                            <img alt="" height="11" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/minus.gif" width="9"/>
                                        </xsl:when>
                                        <xsl:otherwise>
	                                        <!--<a href="{$Portal.Servlet.Normal}GI_ID={$Portal.InheritableAreaID}&amp;maxWnd={descendant-or-self::Page/@id}"> -->
                                            <a href="{$Portal.Servlet.Normal}GI_ID={$Portal.InheritableAreaID}&amp;maxWnd={$NextLink}">
                                                <img alt="" border="0" height="11" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/plus.gif" width="9"/>
                                            </a>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </td>
                                <td nowrap="true">
	                                <!--<a href="{$Portal.Servlet.Normal}GI_ID={$Portal.InheritableAreaID}&amp;maxWnd={descendant-or-self::Page/@id}">-->
	                                <a href="{$Portal.Servlet.Normal}GI_ID={$Portal.InheritableAreaID}&amp;maxWnd={$NextLink}">
                                        <xsl:attribute name="class">PortalInactiveNavigationTab</xsl:attribute>           <xsl:value-of disable-output-escaping="yes" select="@name"/>
                                    </a>         </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
        <!-- Only display deeper paths if a descendant somewhere
		 is maximized.  Otherwise, don't expand the hierarchy. -->
        <xsl:if test="descendant-or-self::Page[@id = $Portal.MaximizedObjectSchemeID]">
            <xsl:apply-templates select="Page">
                <xsl:sort data-type="number" order="ascending" select="@priority"/>
                <xsl:sort order="ascending" select="@name"/>
                <xsl:with-param name="level" select="number($level + 1)"/>
            </xsl:apply-templates>
            <!--	<xsl:if test="$level=1">
				<tr>
					<td bgcolor="{$Portal.ObjectScheme.Select.Active.Color.Background}">
						<img src="&ResourcePath;/stylesheets/images/pixel.gif" alt="" height="5"/>
					</td>
				</tr>
			</xsl:if> -->
        </xsl:if>
    </xsl:template>
    <xsl:template name="Portal.InheritableAreaNonPaged">
        <!--
		When the Branding Area is in Non-Paged mode, Object
		Schemes are ignored and every gadget inside each
		Object Scheme are displayed on one page.

		The function of this template is to build a header,
		body, and footer for the Inheritable Area Gadget.

		In this template, we ensure that we don't create
		empty rows or cells where not necessary.  For this
		reason, there are extra <xsl:if> conditions that
		prevent the Header, Body, and/or Footer from being
		rendered to the ObjectScheme when there are no
		gadgets assigned to one of these.
	-->
        <table>
            <tr>
                <td>
                    <img alt="" height="75" src="{$Portal.ResourcePath}/stylesheets/images/pixel.gif"/>
                </td>
            </tr>
        </table>
        <table border="0" cellpadding="0" cellspacing="0" class="PortalInheritableArea" width="100%">
            <xsl:if test="Gadget[@position=&apos;Header&apos;]">
                <tr>
                    <td valign="top">
                        <xsl:call-template name="Portal.InheritableAreaHeader"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="Gadget[contains(@position,&apos;Column&apos;)]">
                <tr>
                    <td valign="top">
                        <xsl:call-template name="Portal.InheritableAreaBody"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="Gadget[@position=&apos;Footer&apos;]">
                <tr>
                    <td valign="top">
                        <xsl:call-template name="Portal.InheritableAreaFooter"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>
    <xsl:template name="Portal.InheritableAreaHeader">
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
            <tr valign="top">
                <xsl:for-each select="Gadget[@position=&apos;Header&apos;]">
                    <xsl:sort data-type="number" order="ascending" select="@priority"/>
                    <xsl:sort order="ascending" select="@title"/>
                    <td>
                        <xsl:call-template name="Portal.Gadget"/>
                    </td>
                </xsl:for-each>
            </tr>
        </table>
    </xsl:template>
    <xsl:template name="Portal.InheritableAreaBody">
        <!--
		Test to see whether there are any Gadgets that should be
		placed in the Body of the Inheritable Area.

		If there are, we'll dynamically build the columns.

		Gadgets are sorted in each column first by their
		priority and then by their title.
	-->
        <xsl:if test="Gadget[starts-with(@position,&apos;Column&apos;)]">
            <xsl:choose>
                <xsl:when test="../@scheme=&apos;3 Column&apos;">
                    <!--
					A three column scheme layout is selected
					for the Inheritable Area Body.
				-->
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <!-- Column 1 is built here -->
                            <td valign="top">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[@position=&apos;Column 1&apos;]">
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td>
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                            <!-- Column 2 is built here -->
                            <td valign="top">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[@position=&apos;Column 2&apos;]">
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td>
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                            <!-- Column 3 is built here -->
                            <td valign="top">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[@position=&apos;Column 3&apos;]">
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td>
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                        </tr>
                    </table>
                </xsl:when>
                <xsl:when test="../@scheme=&apos;2 Column&apos;">
                    <!--
					A two column scheme layout is selected
					for the Inheritable Area Body.
				-->
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <!-- Column 1 is built here -->
                            <td valign="top">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[@position=&apos;Column 1&apos;]">
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td>
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                            <!-- Column 2 is built here.

							Since Column 3 does not exist in the
							two-column layout, we'll force all
							Gadgets that could have accidentally been
							assigned to Column 3 to show up at the
							bottom of Column 2.
						-->
                            <td valign="top">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[@position!=&apos;Column 1&apos; and starts-with(@position,&apos;Column&apos;)]">
                                        <xsl:sort order="ascending" select="@position"/>
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td>
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                        </tr>
                    </table>
                </xsl:when>
                <xsl:otherwise>
                    <!--
					A one column scheme layout is selected
					for the Inheritable Area Body.
				-->
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <!-- Column 1 is built here

						Since Column 2 and 3 do not exist in the
						one-column layout, we'll force all
						Gadgets that could have accidentally been
						assigned to Column 2 and 3 to show up at
						the of Column 1.
					-->
                        <xsl:for-each select="Gadget[starts-with(@position,&apos;Column&apos;)]">
                            <xsl:sort order="ascending" select="@position"/>
                            <xsl:sort data-type="number" order="ascending" select="@priority"/>
                            <xsl:sort order="ascending" select="@title"/>
                            <tr valign="top">
                                <td>
                                    <xsl:call-template name="Portal.Gadget"/>
                                </td>
                            </tr>
                        </xsl:for-each>
                    </table>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    <xsl:template name="Portal.InheritableAreaFooter">
        <!--
		In the Inheritable Area Footer, just layout the Gadgets
		as Inline Gadgets.  This means that Gadgets assigned
		to the Inheritable Area Footer will be place left to right
		inside the Header.
	-->
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
            <tr valign="top">
                <xsl:for-each select="Gadget[@position=&apos;Footer&apos;]">
                    <xsl:sort data-type="number" order="ascending" select="@priority"/>
                    <xsl:sort order="ascending" select="@title"/>
                    <td>
                        <xsl:call-template name="Portal.Gadget"/>
                    </td>
                </xsl:for-each>
            </tr>
        </table>
    </xsl:template>
</xsl:stylesheet>
<!-- Stylesheet edited using Stylus Studio - (c)1998-2001 eXcelon Corp. -->
