<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="*|/"><xsl:apply-templates/></xsl:template>

<xsl:template match="text()|@*"><xsl:value-of select="."/></xsl:template>

<xsl:variable name="CRLF"><xsl:text>&#xD;&#xA;</xsl:text></xsl:variable>

<xsl:template match="file[@datatype='xsl']"><xsl:text disable-output-escaping="yes">&lt;xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"&gt;</xsl:text>
<xsl:value-of select="$CRLF"/>
	<xsl:apply-templates select="body" mode="xsl"/>

<xsl:value-of select="$CRLF"/><xsl:text disable-output-escaping="yes">&lt;/xsl:stylesheet&gt;</xsl:text>
</xsl:template>

<xsl:template match="body" mode="xsl">
	<xsl:apply-templates select="group" mode="xsl">
		<xsl:sort select="@id" order="ascending" data-type="number"/>
	</xsl:apply-templates>
</xsl:template>

<xsl:template match="group" mode="xsl">
<xsl:apply-templates select="trans-unit" mode="xsl">
<xsl:sort select="target/text()" order="ascending"/>
<xsl:sort select="source/text()" order="ascending"/>
</xsl:apply-templates>
<!-- This text node is just here to add spacing between groups. -->
<xsl:value-of select="$CRLF"/>
</xsl:template>

<xsl:template match="trans-unit" mode="xsl">
<!--<xsl:comment> <xsl:value-of select="source"/> </xsl:comment>-->
<xsl:value-of select="$CRLF"/><xsl:text disable-output-escaping="yes">&lt;xsl:variable name="</xsl:text>
<xsl:value-of select="@id"/>
<xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
<xsl:choose>
	<xsl:when test="target">
		<xsl:for-each select="*"><xsl:apply-templates mode="xsl"/></xsl:for-each>
	</xsl:when>
	<xsl:otherwise>
		<xsl:for-each select="*"><xsl:apply-templates mode="xsl"/></xsl:for-each>
	</xsl:otherwise>
</xsl:choose>
<xsl:text disable-output-escaping="yes">&lt;/xsl:variable&gt;</xsl:text>
</xsl:template>

<xsl:template match="x" mode="xsl"><xsl:value-of select="@ts" disable-output-escaping="yes"/></xsl:template>

<!-- BEGIN JAVA PROPERTIES FILE TEMPLATE -->

<xsl:template match="file[@datatype='java']">
<xsl:apply-templates select="body" mode="java"/>
</xsl:template>

<xsl:template match="body" mode="java">
	<xsl:apply-templates select="group" mode="java">
		<xsl:sort select="@id" order="ascending" data-type="number"/>
	</xsl:apply-templates>
</xsl:template>

<xsl:template match="group" mode="java">
<xsl:apply-templates select="trans-unit" mode="java">
	<xsl:sort select="target/text()" order="ascending"/>
	<xsl:sort select="source/text()" order="ascending"/>
</xsl:apply-templates>
</xsl:template>

<xsl:template match="trans-unit" mode="java">
<xsl:value-of select="@id"/>=<xsl:choose><xsl:when test="target"><xsl:value-of select="target" disable-output-escaping="yes"/></xsl:when><xsl:otherwise><xsl:value-of select="source" disable-output-escaping="yes"/></xsl:otherwise></xsl:choose><xsl:value-of select="$CRLF"/>
</xsl:template>

<!-- END JAVA PROPERTIES FILE TEMPLATE -->

<!-- BEGIN DTD ENTITIES FILE TEMPLATE -->

<xsl:template match="file[@datatype='dtd']">
	<xsl:call-template name="AvailableSettingsDTD"/>
	<xsl:apply-templates select="body" mode="dtd"/>
</xsl:template>

<xsl:template match="body" mode="dtd">
<xsl:apply-templates select="group" mode="dtd">
	<xsl:sort select="@id" order="ascending" data-type="number"/>
</xsl:apply-templates>
</xsl:template>

<xsl:template match="group" mode="dtd">
<xsl:apply-templates select="trans-unit" mode="dtd">
	<xsl:sort select="target/text()" order="ascending"/>
	<xsl:sort select="source/text()" order="ascending"/>
</xsl:apply-templates>
</xsl:template>

<xsl:template match="trans-unit" mode="dtd">
<xsl:variable name="useCDATA">
	<xsl:choose>
		<xsl:when test="../../../@ts='no-cdata'">no</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="@ts='no-cdata'">no</xsl:when>
				<xsl:otherwise>yes</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:variable>
<xsl:text disable-output-escaping="yes">&lt;!ENTITY </xsl:text><xsl:value-of select="@id"/> &quot;<xsl:if test="$useCDATA='yes'"><xsl:text disable-output-escaping="yes"><![CDATA[<![CDATA[]]></xsl:text></xsl:if><xsl:choose><xsl:when test="target"><xsl:value-of select="target" disable-output-escaping="yes"/></xsl:when><xsl:otherwise><xsl:value-of select="source" disable-output-escaping="yes"/></xsl:otherwise></xsl:choose><xsl:if test="$useCDATA='yes'">]]&gt;</xsl:if>&quot;&gt;<xsl:value-of select="$CRLF"/>
</xsl:template>

<xsl:template name="AvailableSettingsDTD">
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT config (setting*)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT setting ANY>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT name (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT displayname (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT value (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT description (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT rangedescription (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT minimumrange (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT maximumrange (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT type (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT availablevalue (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT allowmultiplevalues (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT cumulative (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT overwriteable (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT order (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT required (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT advanced (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT userconfigurable (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT adminconfigurable (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT hidefromuser (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT hidefromadmin (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:text disable-output-escaping="yes"><![CDATA[<!ELEMENT parsemacros (#PCDATA)>]]></xsl:text><xsl:value-of select="$CRLF"/>
<xsl:value-of select="$CRLF"/>
</xsl:template>

<!-- END DTD ENTITIES FILE TEMPLATE -->

<!-- BEGIN XML FILE TEMPLATE -->
<xsl:template match="file[@datatype='xml']">
&lt;?xml version="1.0"?&gt;
<xsl:value-of select="$CRLF"/>
&lt;res&gt;
<xsl:value-of select="$CRLF"/>
<xsl:apply-templates select="body" mode="xml"/>
<xsl:value-of select="$CRLF"/>
&lt;/res&gt;
</xsl:template>

<xsl:template match="body" mode="xml">
	<xsl:apply-templates select="group" mode="xml">
		<xsl:sort select="@id" order="ascending" data-type="number"/>
	</xsl:apply-templates>
</xsl:template>

<xsl:template match="group" mode="xml">
<xsl:apply-templates select="trans-unit" mode="xml">
<xsl:sort select="target/text()" order="ascending"/>
<xsl:sort select="source/text()" order="ascending"/>
</xsl:apply-templates>
<!-- This text node is just here to add spacing between groups. -->
<xsl:value-of select="$CRLF"/>
</xsl:template>

<xsl:template match="trans-unit" mode="xml">
<xsl:text disable-output-escaping="yes">&lt;</xsl:text><xsl:value-of select="@id"/><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:for-each select="*"><xsl:apply-templates mode="xml"/></xsl:for-each><xsl:text disable-output-escaping="yes">&lt;/</xsl:text><xsl:value-of select="@id"/><xsl:text disable-output-escaping="yes">&gt;</xsl:text>
</xsl:template>

<xsl:template match="x" mode="xml"><xsl:value-of select="@ts" disable-output-escaping="yes"/></xsl:template>
<!-- END XML FILE TEMPLATE -->

</xsl:stylesheet>

<!-- Stylus Studio meta-information - (c)1998-2002 eXcelon Corp.
<metaInformation>
<scenarios/><MapperInfo srcSchemaPath="" srcSchemaRoot="" srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/>
</metaInformation>
-->