/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPModification
implements Externalizable {
    private int op;
    private LDAPAttribute attr;
    public static final int ADD = 0;
    public static final int DELETE = 1;
    public static final int REPLACE = 2;

    public LDAPModification() {
    }

    public LDAPModification(int op, LDAPAttribute attr) {
        this.op = op;
        this.attr = attr;
    }

    public LDAPAttribute getAttribute() {
        return this.attr;
    }

    public int getOp() {
        return this.op;
    }

    void newLine(int indentTabs, Writer out) throws IOException {
        String tabString = "    ";
        out.write("\n");
        for (int i = 0; i < indentTabs; ++i) {
            out.write(tabString);
        }
    }

    public void writeDSML(OutputStream oout) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(oout, "UTF-8");
        out.write("<modification name=\"");
        out.write(this.attr.getName());
        out.write("\" operation=\"");
        switch (this.getOp()) {
            case 0: {
                out.write("add");
                break;
            }
            case 1: {
                out.write("delete");
                break;
            }
            case 2: {
                out.write("replace");
            }
        }
        out.write("\">");
        LDAPAttribute attr = this.getAttribute();
        String[] values = attr.getStringValueArray();
        byte[][] bytevalues = attr.getByteValueArray();
        for (int j = 0; j < values.length; ++j) {
            this.newLine(1, out);
            if (Base64.isValidUTF8(bytevalues[j], false)) {
                out.write("<value>");
                out.write(values[j]);
                out.write("</value>");
                continue;
            }
            out.write("<value xsi:type=\"xsd:base64Binary\">");
            out.write(Base64.encode(bytevalues[j]));
            out.write("</value>");
        }
        this.newLine(0, out);
        out.write("</modification>");
        ((Writer)out).close();
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPModification.getXMLHandler("modification", null));
        return (LDAPModification)xmlreader.parseXML(input);
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String attrName;
            int operation;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                LDAPAttribute attr = new LDAPAttribute(this.attrName);
                if (!this.valuelist.isEmpty()) {
                    Iterator valueiterator = this.valuelist.iterator();
                    while (valueiterator.hasNext()) {
                        attr.addValue((byte[])valueiterator.next());
                    }
                }
                LDAPModification mod = new LDAPModification(this.operation, attr);
                this.setObject(mod);
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("value")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attrs) throws SAXException {
                this.attrName = attrs.getValue("name");
                String temp = attrs.getValue("operation");
                if (temp == null || this.attrName == null) {
                    throw new SAXException("Required attribute missing from tag <modification> (operation or name are required)");
                }
                if (temp.equals("add")) {
                    this.operation = 0;
                } else if (temp.equals("replace")) {
                    this.operation = 2;
                } else if (temp.equals("delete")) {
                    this.operation = 1;
                } else {
                    throw new SAXException("Invalid value for attribute 'operation': " + temp);
                }
            }
        };
    }

    public String toString() {
        StringBuffer result = new StringBuffer("LDAPModification: (operation=");
        switch (this.getOp()) {
            case 0: {
                result.append("add");
                break;
            }
            case 1: {
                result.append("delete");
                break;
            }
            case 2: {
                result.append("replace");
            }
        }
        result.append(",(" + this.getAttribute() + "))");
        return result.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String header = "";
        header = header + "*************************************************************************\n";
        header = header + "** The encrypted data above and below is the Class definition and  ******\n";
        header = header + "** other data specific to Java Serialization Protocol. The data  ********\n";
        header = header + "** which is of most application specific interest is as follows... ******\n";
        header = header + "*************************************************************************\n";
        header = header + "****************** Start of application data ****************************\n";
        header = header + "*************************************************************************\n";
        buff.append(header);
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("<modification name=\"");
        buff.append(this.attr.getName());
        buff.append("\" operation=\"");
        switch (this.getOp()) {
            case 0: {
                buff.append("add");
                break;
            }
            case 1: {
                buff.append("delete");
                break;
            }
            case 2: {
                buff.append("replace");
            }
        }
        buff.append("\">");
        LDAPAttribute attr = this.getAttribute();
        String[] values = attr.getStringValueArray();
        byte[][] bytevalues = attr.getByteValueArray();
        for (int j = 0; j < values.length; ++j) {
            buff.append(ValueXMLhandler.newLine(1));
            if (Base64.isValidUTF8(bytevalues[j], false)) {
                buff.append("<value>");
                buff.append(values[j]);
                buff.append("</value>");
                continue;
            }
            buff.append("<value xsi:type=\"xsd:base64Binary\">");
            buff.append(Base64.encode(bytevalues[j]));
            buff.append("</value>");
        }
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("</modification>");
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String tail = "";
        tail = tail + "*************************************************************************\n";
        tail = tail + "****************** End of application data ******************************\n";
        tail = tail + "*************************************************************************\n";
        buff.append(tail);
        buff.append(ValueXMLhandler.newLine(0));
        out.writeUTF(buff.toString());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String readData = in.readUTF();
        String readProperties = readData.substring(readData.indexOf(60), readData.lastIndexOf(62) + 1);
        StringBuffer parsedBuff = new StringBuffer();
        ValueXMLhandler.parseInput(readProperties, parsedBuff);
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(parsedBuff.toString().getBytes()));
        LDAPModification readObject = (LDAPModification)LDAPModification.readDSML(istream);
        this.op = readObject.getOp();
        this.attr = readObject.getAttribute();
        readObject = null;
    }
}

