/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.security.sasl.SaslClient;
import com.novell.security.sasl.SaslException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

class ExternalSaslClient
implements SaslClient {
    private String m_authorizationId = "";
    private String m_protocol = "";
    private String m_serverName = "";
    private Map m_props;
    private CallbackHandler m_cbh;
    private int m_state;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_VALID_SERVER_RESPONSE = 1;
    private static final int STATE_INVALID_SERVER_RESPONSE = 2;
    private static final int STATE_DISPOSED = 3;

    public static SaslClient getClient(String authorizationId, String protocol, String serverName, Map props, CallbackHandler cbh) {
        return new ExternalSaslClient(authorizationId, protocol, serverName, props, cbh);
    }

    private ExternalSaslClient(String authorizationId, String protocol, String serverName, Map props, CallbackHandler cbh) {
        this.m_authorizationId = authorizationId;
        this.m_protocol = protocol;
        this.m_serverName = serverName;
        this.m_props = props;
        this.m_cbh = cbh;
        this.m_state = 0;
    }

    public boolean hasInitialResponse() {
        return false;
    }

    public boolean isComplete() {
        return this.m_state == 1 || this.m_state == 2 || this.m_state == 3;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException("unwrap: QOP has neither integrity nor privacy>");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException("wrap: QOP has neither integrity nor privacy>");
    }

    public Object getNegotiatedProperty(String propName) {
        if (this.m_state != 1) {
            throw new IllegalStateException("getNegotiatedProperty: authentication exchange not complete.");
        }
        if ("com.novell.security.sasl.qop".equals(propName)) {
            return "auth";
        }
        return null;
    }

    public void dispose() throws SaslException {
        if (this.m_state != 3) {
            this.m_state = 3;
        }
    }

    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        byte[] response = null;
        switch (this.m_state) {
            case 0: {
                if (challenge.length != 0) {
                    this.m_state = 2;
                    throw new SaslException("Unexpected non-zero length response.");
                }
                this.m_state = 1;
                break;
            }
            case 2: {
                throw new SaslException("Authentication sequence is complete");
            }
            case 3: {
                throw new SaslException("Client has been disposed");
            }
            default: {
                throw new SaslException("Unknown client state.");
            }
        }
        return response;
    }

    public String getMechanismName() {
        return "EXTERNAL";
    }
}

