/*
 * Decompiled with CFR 0.152.
 */
import arguments.ApplicationArguments;
import arguments.Argument;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPJSSEStartTLSFactory;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.client.Debug;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.Security;
import java.text.ParseException;

public class ModifyPassword {
    public final int BIND_TIMEOUT = 20000;

    public static void main(String[] stringArray) {
        System.exit(new ModifyPassword().runPassword(stringArray));
    }

    private int runPassword(String[] stringArray) {
        String string;
        Options options = null;
        try {
            options = new Options();
            options.parse(stringArray);
        }
        catch (ParseException parseException) {
            String string2 = parseException.getMessage();
            if (string2 == null) {
                string2 = parseException.toString();
            }
            string2 = options.usage(string2);
            this.displayArguments(options, stringArray);
            System.err.println(string2);
            return 1;
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.toString());
            exception.printStackTrace();
            return 1;
        }
        if (options.debug()) {
            Debug.setTraceStream((PrintStream)System.err);
            Debug.setTrace((String)"TraceAll", (boolean)true);
        }
        String string3 = null;
        String string4 = options.getConnectionType();
        string3 = options.getKeystore();
        if (string3 != null) {
            Security.addProvider((java.security.Provider)new Provider());
            if (options.getPrintVerbose()) {
                System.err.println("Java key store is \"" + string3 + "\"");
            }
            System.setProperty("javax.net.ssl.trustStore", string3);
            if (string4.equalsIgnoreCase("TLS")) {
                if (options.getPrintVerbose()) {
                    System.err.println("Setting factory for a TLS connection");
                }
                string = new LDAPJSSEStartTLSFactory();
            } else {
                if (options.getPrintVerbose()) {
                    System.err.println("Setting factory for a SSL connection");
                }
                string = new LDAPJSSESecureSocketFactory();
            }
            LDAPConnection.setSocketFactory((LDAPSocketFactory)string);
        }
        LDAPConnection lDAPConnection = new LDAPConnection();
        try {
            LDAPConstraints lDAPConstraints;
            if (options.getPrintVerbose()) {
                System.err.println("Connecting to host \"" + options.getHostPort() + "\"");
            }
            lDAPConnection.connect(options.getHostPort(), 0);
            if (string3 != null && string4.equalsIgnoreCase("TLS")) {
                lDAPConnection.startTLS();
            }
            if ((string = options.getLoginDN()).length() != 0) {
                lDAPConstraints = new LDAPConstraints();
                lDAPConstraints.setTimeLimit(20000);
                lDAPConnection.bind(3, string, options.getLoginPasswd().getBytes("UTF8"), lDAPConstraints);
            }
            lDAPConstraints = new LDAPModification[2];
            LDAPAttribute lDAPAttribute = new LDAPAttribute("userPassword", options.getLoginPasswd());
            lDAPConstraints[0] = new LDAPModification(1, lDAPAttribute);
            LDAPAttribute lDAPAttribute2 = new LDAPAttribute("userPassword", options.getNewPasswd());
            lDAPConstraints[1] = new LDAPModification(0, lDAPAttribute2);
            lDAPConnection.modify(string, (LDAPModification[])lDAPConstraints);
            System.out.println("Your password has been modified.");
            lDAPConnection.disconnect();
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getResultCode() == 32) {
                System.err.println("Error: No such entry");
            } else {
                System.err.println("Error: " + lDAPException.toString());
            }
            System.err.println("Your password has not been modified.");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Error: " + unsupportedEncodingException.toString());
        }
        return 0;
    }

    private void displayArguments(Options options, String[] stringArray) {
        if (options.getPrintVerbose()) {
            System.err.println("\nCommand line arguments");
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.println("   " + i + ": " + stringArray[i]);
            }
        }
    }

    private class Options {
        private ApplicationArguments options = new ApplicationArguments("jldappassword", 25);

        private Options() throws Exception {
            this.options.add(new Argument('d', "enable API debug output", false));
            this.options.add(new Argument('e', "keystore", "Path to a Java Keystore.  A valid certificate in the keystore enables\n          an encrypted TLS connection.  See also the -Z option.", "", false));
            this.options.add(new Argument('h', "host", "host name or IP address.  A port can  be specified with the\n          host name as hostname:port, i.e. myhost:389.  See also \n          the -p option", "localhost", false));
            this.options.add(new Argument('p', "port", "host IP port number.  See also the -h option", 389, false));
            this.options.add(new Argument('v', "enable verbose output", false));
            this.options.add(new Argument('Z', "encrypted connection", "sets the type of encrypted connection.  A Keystore must be specified\n            with the -e option to enable an encrypted connection.\n            SSL   - Establishes an encrypted connection using \n                    SSL.  The default port is 636\n            TLS   - Establishes an encrypted connection using \n                    TLS.  The default port is 389", "TLS", false));
            this.options.add(new Argument(false, "bind DN", "the DN of the object used for authentication", false));
            this.options.add(new Argument(false, "current password", "the current password value used for authentication", false));
            this.options.add(new Argument(false, "new password", "the new password value", false));
        }

        void parse(String[] stringArray) throws Exception {
            this.options.parse(stringArray);
        }

        String getHostPort() {
            int n;
            String string;
            try {
                string = (String)this.options.getArgument('h').getValue();
                Argument argument = this.options.getArgument('p');
                int n2 = argument.getValueCount();
                if (n2 == 0) {
                    n = (Integer)argument.getValue();
                    String string2 = this.getConnectionType();
                    if (string2.equalsIgnoreCase("SSL")) {
                        n = 636;
                    }
                } else {
                    n = (Integer)argument.getValue();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
            if (string.indexOf(":") == -1) {
                string = string + ":" + n;
            }
            return string;
        }

        String getConnectionType() {
            String string = null;
            try {
                string = (String)this.options.getArgument('Z').getValue();
                if (!string.equalsIgnoreCase("SSL") && !string.equalsIgnoreCase("TLS")) {
                    throw new NoSuchFieldException("Invalid connection type specified: " + string);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
            return string;
        }

        String getKeystore() {
            try {
                Argument argument = this.options.getArgument('e');
                int n = argument.getValueCount();
                if (n == 0) {
                    return null;
                }
                return (String)argument.getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String getLoginDN() {
            try {
                return (String)this.options.getArgument(1).getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String getLoginPasswd() {
            try {
                return (String)this.options.getArgument(2).getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String getNewPasswd() {
            try {
                return (String)this.options.getArgument(3).getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        boolean getPrintVerbose() {
            try {
                return (Boolean)this.options.getArgument('v').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        boolean debug() {
            try {
                return (Boolean)this.options.getArgument('d').getValue();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException.toString());
            }
        }

        String usage(String string) {
            return this.options.usage(string);
        }
    }
}

