/*
 * Decompiled with CFR 0.152.
 */
package arguments;

import arguments.Argument;
import java.text.ParseException;
import java.util.ArrayList;

public class ApplicationArguments {
    private ArrayList appArguments;
    private String applicationName = "program";

    public ApplicationArguments() {
        this.appArguments = new ArrayList();
    }

    public ApplicationArguments(String string) {
        this.applicationName = string;
        this.appArguments = new ArrayList();
    }

    public ApplicationArguments(int n) {
        this.appArguments = new ArrayList(n);
    }

    public ApplicationArguments(String string, int n) {
        this.applicationName = string;
        this.appArguments = new ArrayList(n);
    }

    public boolean add(Argument argument) {
        return this.appArguments.add(argument);
    }

    public boolean hasArgument(char c) throws NoSuchFieldException {
        return this.getArgument(c).getValueCount() > 0;
    }

    public int getNumberOfArguments() {
        return this.appArguments.size();
    }

    public int getNumberOfPositionalArguments() {
        int n = 0;
        Argument argument = null;
        for (int i = 0; i < this.appArguments.size(); ++i) {
            argument = (Argument)this.appArguments.get(i);
            if (!argument.isPositional()) continue;
            n += argument.getValueCount();
        }
        return n;
    }

    public Argument getArgument(char c) throws NoSuchFieldException {
        Argument argument = null;
        for (int i = 0; i < this.appArguments.size() && (argument = (Argument)this.appArguments.get(i)).getArgumentLetter() != c; ++i) {
            argument = null;
        }
        if (argument == null) {
            throw new NoSuchFieldException("Argument \"" + c + "\" is not defined in this application");
        }
        return argument;
    }

    public Argument getArgument(int n) throws NoSuchFieldException {
        int n2 = 1;
        Argument argument = null;
        for (int i = 0; i < this.appArguments.size(); ++i) {
            argument = (Argument)this.appArguments.get(i);
            if (argument.isPositional()) {
                if (n2 == n) break;
                ++n2;
            }
            argument = null;
        }
        if (argument == null) {
            throw new NoSuchFieldException("Argument at position " + n + " is not defined in this application");
        }
        return argument;
    }

    private String defString(Argument argument) {
        if (argument.isRequired()) {
            return " - Required Argument";
        }
        if (argument.isString()) {
            return " - Default=\"" + (String)argument.getDefaultValue() + "\"";
        }
        if (argument.isInteger()) {
            return " - Default=" + (Integer)argument.getDefaultValue();
        }
        return " - Default=" + (Boolean)argument.getDefaultValue();
    }

    public String usage(String string) {
        int n;
        int n2;
        Argument argument = null;
        String string2 = "";
        if (string != null) {
            string2 = string2 + "Error: " + string + "\n\n";
        }
        string2 = string2 + "Usage: " + this.applicationName;
        String string3 = " -";
        for (n2 = 0; n2 < this.appArguments.size(); ++n2) {
            argument = (Argument)this.appArguments.get(n2);
            if (!argument.isBoolean() || !argument.isRequired()) continue;
            string2 = string2 + string3 + argument.getArgumentLetter();
            string3 = "";
        }
        if (string3 == "") {
            string2 = string2 + " ";
        }
        string3 = " [ -";
        for (n2 = 0; n2 < this.appArguments.size(); ++n2) {
            argument = (Argument)this.appArguments.get(n2);
            if (!argument.isBoolean() || argument.isRequired()) continue;
            string2 = string2 + string3 + argument.getArgumentLetter();
            string3 = "";
        }
        if (string3 == "") {
            string2 = string2 + " ] ";
        }
        for (n2 = 0; n2 < this.appArguments.size(); ++n2) {
            argument = (Argument)this.appArguments.get(n2);
            if (argument.isBoolean() || argument.isPositional()) continue;
            if (!argument.isRequired()) {
                string2 = string2 + "[ ";
            }
            string2 = string2 + "-" + argument.getArgumentLetter();
            string2 = string2 + " <" + argument.getName() + ">";
            string2 = !argument.isRequired() ? string2 + " ] " : string2 + " ";
        }
        String string4 = "";
        for (n = 0; n < this.appArguments.size(); ++n) {
            argument = (Argument)this.appArguments.get(n);
            if (!argument.isPositional()) continue;
            if (!argument.isRequired()) {
                string2 = string2 + " [ ";
            }
            string2 = string2 + " <" + argument.getName() + ">";
            string4 = !argument.isRequired() ? string4 + " ]" : string4 + " ";
        }
        string2 = string2 + string4;
        string2 = string2 + "\n";
        for (n = 0; n < this.appArguments.size(); ++n) {
            argument = (Argument)this.appArguments.get(n);
            String string5 = argument.isPositional() ? (argument.getName().length() < 7 ? "<" + argument.getName() + ">" + "        ".substring(1, 9 - argument.getName().length()) : "<" + argument.getName() + "> ") : "    -" + argument.getArgumentLetter() + "    ";
            string2 = string2 + "\n" + string5 + argument.getDescription();
            string2 = string2 + this.defString(argument);
        }
        return string2;
    }

    public void parse(String[] stringArray) throws ParseException {
        Argument argument;
        int n;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        block6: for (n = 0; n < stringArray.length; ++n) {
            n3 = 0;
            String string = stringArray[n];
            if (string.length() > 1 && string.charAt(0) == '-') {
                for (n3 = 1; n3 < string.length(); ++n3) {
                    char c = string.charAt(n3);
                    try {
                        argument = this.getArgument(c);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw new ParseException("Argument " + (n + 1) + ": '-" + c + "' is an unknown option", n + 1);
                    }
                    if (argument.isBoolean()) {
                        if (n3 == 1) {
                            argument.add(new Boolean(true), n);
                            bl = true;
                            continue;
                        }
                        if (bl) {
                            argument.add(new Boolean(true), n);
                            continue;
                        }
                        if (n3 != string.length() - 1) {
                            throw new ParseException("Argument " + (n + 1) + ": '-" + c + "' must be " + "specified separately", n + 1);
                        }
                    }
                    if (argument.isBoolean()) continue;
                    if (n3 == string.length() - 1) {
                        if (n + 1 == stringArray.length) {
                            throw new ParseException("Argument " + (n + 1) + ": '-" + c + "' must have " + "a value", n + 1);
                        }
                        string = stringArray[++n];
                    } else {
                        string = stringArray[n].substring(++n3);
                    }
                    if (argument.isString()) {
                        argument.add(string, n);
                        continue block6;
                    }
                    try {
                        argument.add(Integer.decode(string), n);
                        continue block6;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Argument " + (n + 1) + ": '-" + c + "' does not have" + "a valid integer value", n + 1);
                    }
                }
                continue;
            }
            ++n2;
            try {
                argument = this.getArgument(n2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new ParseException("Argument " + (n + 1) + " Unknown positional argument \"" + string + "\"", n + 1);
            }
            argument.add(string, n);
            if (!argument.isMultivalued()) continue;
            while (n + 1 != stringArray.length && (stringArray[n + 1].length() <= 1 || stringArray[n + 1].charAt(0) != '-')) {
                argument.add(stringArray[++n], n);
            }
        }
        for (n = 0; n < this.appArguments.size(); ++n) {
            int n4 = 0;
            argument = (Argument)this.appArguments.get(n);
            if (argument.isPositional()) {
                ++n4;
            }
            if (!argument.isRequired() || argument.getValueCount() != 0) continue;
            if (argument.isPositional()) {
                throw new ParseException("Positional argument " + n4 + " (" + argument.getDescription() + ") not specified", n + 1);
            }
            throw new ParseException("Required argument '-" + argument.getArgumentLetter() + "' not specified", n + 1);
        }
    }
}

