/*
 * Decompiled with CFR 0.152.
 */
package arguments;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Argument {
    private char argumentLetter;
    private Object defaultValue;
    private String description;
    private String name;
    private boolean required;
    private boolean multiValued;
    ArrayList argValues = new ArrayList();
    private static final boolean REQUIRED = true;
    private static final boolean OPTIONAL = false;
    public static final boolean REQUIRED_INTEGER = true;
    public static final boolean REQUIRED_STRING = false;
    public static final boolean MULTI_VALUED = true;
    public static final boolean SINGLE_VALUED = false;

    public Argument(char c, String string, boolean bl) {
        this.setParams(c, "", string, false, false);
        this.defaultValue = new Boolean(bl);
    }

    public Argument(boolean bl, String string, String string2, boolean bl2) {
        this.defaultValue = bl ? new Integer(0) : "";
        this.setParams('\u0000', string, string2, true, bl2);
    }

    public Argument(boolean bl, char c, String string, String string2, boolean bl2) {
        this.defaultValue = bl ? new Integer(0) : "";
        this.setParams(c, string, string2, true, bl2);
    }

    public Argument(String string, String string2, String string3, boolean bl) {
        this.setParams('\u0000', string, string2, false, bl);
        if (string3 == null) {
            string3 = "";
        }
        this.defaultValue = string3;
    }

    public Argument(String string, String string2, int n, boolean bl) {
        this.setParams('\u0000', string, string2, false, bl);
        this.defaultValue = new Integer(n);
    }

    public Argument(char c, String string, String string2, String string3, boolean bl) {
        this.setParams(c, string, string2, false, bl);
        if (string3 == null) {
            string3 = "";
        }
        this.defaultValue = string3;
    }

    public Argument(char c, String string, String string2, int n, boolean bl) {
        this.setParams(c, string, string2, false, bl);
        this.defaultValue = new Integer(n);
    }

    private void setParams(char c, String string, String string2, boolean bl, boolean bl2) {
        this.argumentLetter = c;
        this.name = string;
        this.description = string2;
        this.required = bl;
        this.multiValued = bl2;
    }

    public final int getValueCount() {
        return this.argValues.size();
    }

    public final boolean add(Object object, int n) throws ParseException {
        if (this.argValues.size() == 1 && !this.multiValued) {
            throw new ParseException("Parameter " + n + ": '-" + this.argumentLetter + "' cannot have more than one value", n);
        }
        this.argValues.add(object);
        return true;
    }

    public final char getArgumentLetter() {
        return this.argumentLetter;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public final boolean isBoolean() {
        return this.defaultValue instanceof Boolean;
    }

    public final boolean isInteger() {
        return this.defaultValue instanceof Integer;
    }

    public final boolean isString() {
        return this.defaultValue instanceof String;
    }

    public final boolean isPositional() {
        return this.argumentLetter == '\u0000';
    }

    public final boolean isMultivalued() {
        return this.multiValued;
    }

    public final Object getDefaultValue() {
        return this.defaultValue;
    }

    public final Object getValue() {
        if (this.argValues.size() == 0) {
            return this.defaultValue;
        }
        return this.argValues.get(0);
    }

    public final Enumeration getValues() {
        if (this.argValues.size() == 0) {
            if (this.isBoolean()) {
                return new ArgEnumeration(new Boolean[]{(Boolean)this.defaultValue});
            }
            if (this.isInteger()) {
                return new ArgEnumeration(new Integer[]{(Integer)this.defaultValue});
            }
            if (this.isString()) {
                return new ArgEnumeration(new String[]{(String)this.defaultValue});
            }
        }
        return new ArgEnumeration(this.argValues.toArray());
    }

    public final void clearValues() {
        this.argValues = new ArrayList();
    }

    public class ArgEnumeration
    implements Enumeration {
        private Object[] eArray;
        private int index = 0;

        public ArgEnumeration(Object[] objectArray) {
            this.eArray = objectArray;
        }

        public boolean hasMoreElements() {
            return this.index < this.eArray.length;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.index >= this.eArray.length) {
                throw new NoSuchElementException("No more elements for argument " + Argument.this.argumentLetter);
            }
            return this.eArray[this.index++];
        }
    }
}

