/*
 * Decompiled with CFR 0.152.
 */
package schema;

import com.novell.ldap.LDAPAttributeSchema;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPSchema;
import java.awt.Button;
import java.awt.Component;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;

public class ListAttributeSchema
extends Panel
implements ActionListener {
    private String attrName;
    private String[] attrNames;
    private ArrayList al = new ArrayList();
    private Button exit;
    private Button properties;
    private List attrList;
    private TextArea textarea;
    private LDAPConnection connection;
    private LDAPSchema schema;
    private static final int USER_APPLICATIONS = 0;
    private static final int DIRECTORY_OPERATION = 1;
    private static final int DISTRIBUTED_OPERATION = 2;
    private static final int DSA_OPERATION = 3;

    public ListAttributeSchema(LDAPConnection lDAPConnection) {
        this.connection = lDAPConnection;
    }

    public void init() {
        int n;
        try {
            this.schema = this.connection.fetchSchema(this.connection.getSchemaDN());
            Enumeration enumeration = this.schema.getAttributeSchemas();
            while (enumeration.hasMoreElements()) {
                LDAPAttributeSchema lDAPAttributeSchema = (LDAPAttributeSchema)enumeration.nextElement();
                String[] stringArray = lDAPAttributeSchema.getNames();
                for (n = 0; n < stringArray.length; ++n) {
                    this.al.add(stringArray[n]);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\nError: " + exception.toString());
        }
        if (this.al.isEmpty()) {
            System.out.println("\nError in ListAttributeSchema.java: failed to get attribute schema.");
            System.exit(1);
        }
        this.attrNames = new String[this.al.size()];
        for (n = 0; n < this.al.size(); ++n) {
            this.attrNames[n] = (String)this.al.get(n);
        }
        Arrays.sort(this.attrNames);
        this.attrList = new List(31, false);
        for (n = 0; n < this.attrNames.length; ++n) {
            this.attrList.add(this.attrNames[n]);
        }
        this.add((Component)this.attrList, "West");
        this.exit = new Button("Exit");
        this.exit.addActionListener(this);
        this.add(this.exit);
        this.properties = new Button("List>");
        this.properties.addActionListener(this);
        this.add(this.properties);
        this.textarea = new TextArea(30, 68);
        this.textarea.setEditable(false);
        this.add((Component)this.textarea, "East");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        LDAPAttributeSchema lDAPAttributeSchema;
        if (actionEvent.getSource() == this.exit) {
            System.exit(0);
        }
        if ((this.attrName = this.attrList.getSelectedItem()) == null) {
            this.attrName = this.attrNames[0];
        }
        if ((lDAPAttributeSchema = this.schema.getAttributeSchema(this.attrName)) == null) {
            System.err.println("There is no such attribute: " + this.attrName);
            System.exit(1);
        }
        String[] stringArray = lDAPAttributeSchema.getNames();
        this.textarea.append("name: ");
        if (stringArray != null && stringArray.length > 0) {
            this.textarea.append(stringArray[0]);
        }
        for (n = 1; n < stringArray.length; ++n) {
            this.textarea.append(", " + stringArray[n]);
        }
        this.textarea.append("\n");
        this.textarea.append("properties:\n");
        this.textarea.append("    ID:\n");
        this.textarea.append("        " + lDAPAttributeSchema.getID() + "\n");
        this.textarea.append("    value:\n");
        String string = lDAPAttributeSchema.toString();
        int n2 = string.length();
        for (n = 0; n < n2; n += 70) {
            int n3 = n + 70 > n2 ? n2 : n + 70;
            this.textarea.append("        " + string.substring(n, n3) + "\n");
        }
        this.textarea.append("    description:\n");
        this.textarea.append("        " + lDAPAttributeSchema.getDescription() + "\n");
        Enumeration enumeration = lDAPAttributeSchema.getQualifierNames();
        this.textarea.append("    qualifier names and values:\n");
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray2 = lDAPAttributeSchema.getQualifier(string2);
                for (n = 0; n < stringArray2.length; ++n) {
                    this.textarea.append("        " + string2 + ": " + stringArray2[n] + "\n");
                }
            }
        } else {
            this.textarea.append("        no\n");
        }
        this.textarea.append("    syntax string:\n");
        this.textarea.append("        " + lDAPAttributeSchema.getSyntaxString() + "\n");
        this.textarea.append("    usage: \n");
        int n4 = lDAPAttributeSchema.getUsage();
        switch (n4) {
            case 0: {
                this.textarea.append("        USER_APPLICATIONS\n");
                break;
            }
            case 1: {
                this.textarea.append("        DIRECTORY_OPERATION\n");
                break;
            }
            case 2: {
                this.textarea.append("        DISTRIBUTED_OPERATION\n");
                break;
            }
            case 3: {
                this.textarea.append("        DSA_OPERATION\n");
                break;
            }
        }
        this.textarea.append("    has superior attribute?\n");
        this.textarea.append(lDAPAttributeSchema.getSuperior() != null ? "        yes\n" : "        no\n");
        this.textarea.append("    has equality matching rule?\n");
        this.textarea.append(lDAPAttributeSchema.getEqualityMatchingRule() != null ? "        yes\n" : "        no\n");
        this.textarea.append("    has ordering matching rule?\n");
        this.textarea.append(lDAPAttributeSchema.getOrderingMatchingRule() != null ? "        yes\n" : "        no\n");
        this.textarea.append("    has substring matching rule?\n");
        this.textarea.append(lDAPAttributeSchema.getSubstringMatchingRule() != null ? "        yes\n" : "        no\n");
        this.textarea.append("    is a collective attribute?\n");
        this.textarea.append(lDAPAttributeSchema.isCollective() ? "        yes\n" : "        no\n");
        this.textarea.append("    is a single valued attribute?\n");
        this.textarea.append(lDAPAttributeSchema.isSingleValued() ? "        yes\n" : "        no\n");
        this.textarea.append("    is a modifiable attribute?\n");
        this.textarea.append(lDAPAttributeSchema.isUserModifiable() ? "        yes\n" : "        no\n");
        this.textarea.append("\n");
    }
}

