/*
 * Decompiled with CFR 0.152.
 */
package schema;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPObjectClassSchema;
import com.novell.ldap.LDAPSchema;
import java.awt.Button;
import java.awt.Component;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;

public class ListObjectClassSchema
extends Panel
implements ActionListener {
    private String objClassName;
    private String[] objClassNames;
    private Button submit;
    private Button exit;
    private List objClassList;
    private TextArea textarea;
    private ArrayList al = new ArrayList();
    private LDAPConnection c;
    private LDAPSchema schema;
    private static final int ABSTRACT = 0;
    private static final int STRUCTURAL = 1;
    private static final int AUXILIARY = 2;

    public ListObjectClassSchema(LDAPConnection lDAPConnection) {
        this.c = lDAPConnection;
    }

    public void init() {
        int n;
        LDAPObjectClassSchema lDAPObjectClassSchema = null;
        try {
            this.schema = this.c.fetchSchema(this.c.getSchemaDN());
            Enumeration enumeration = this.schema.getObjectClassSchemas();
            while (enumeration.hasMoreElements()) {
                lDAPObjectClassSchema = (LDAPObjectClassSchema)enumeration.nextElement();
                String[] stringArray = lDAPObjectClassSchema.getNames();
                for (n = 0; n < stringArray.length; ++n) {
                    this.al.add(stringArray[n]);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.toString());
        }
        if (this.al.isEmpty()) {
            System.out.println("\nError in ListObjectClassSchema.java: failed to get object class schema.");
            System.exit(1);
        }
        this.objClassNames = new String[this.al.size()];
        for (n = 0; n < this.al.size(); ++n) {
            this.objClassNames[n] = (String)this.al.get(n);
        }
        Arrays.sort(this.objClassNames);
        this.objClassList = new List(31, false);
        for (n = 0; n < this.objClassNames.length; ++n) {
            this.objClassList.add(this.objClassNames[n]);
        }
        this.add((Component)this.objClassList, "West");
        this.exit = new Button("Exit");
        this.exit.addActionListener(this);
        this.add(this.exit);
        this.submit = new Button("List>");
        this.submit.addActionListener(this);
        this.add(this.submit);
        this.textarea = new TextArea(30, 68);
        this.textarea.setEditable(false);
        this.add((Component)this.textarea, "East");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        LDAPObjectClassSchema lDAPObjectClassSchema;
        if (actionEvent.getSource() == this.exit) {
            System.exit(0);
        }
        if ((this.objClassName = this.objClassList.getSelectedItem()) == null) {
            this.objClassName = this.objClassNames[0];
        }
        if ((lDAPObjectClassSchema = this.schema.getObjectClassSchema(this.objClassName)) == null) {
            System.err.println("There is no such object class: " + this.objClassName);
            System.exit(1);
        }
        String[] stringArray = lDAPObjectClassSchema.getNames();
        this.textarea.append("name: ");
        if (stringArray != null && stringArray.length > 0) {
            this.textarea.append(stringArray[0]);
        }
        for (n = 1; n < stringArray.length; ++n) {
            this.textarea.append(", " + stringArray[n]);
        }
        this.textarea.append("\n");
        this.textarea.append("properties:\n");
        this.textarea.append("    ID:\n");
        this.textarea.append("        " + lDAPObjectClassSchema.getID() + "\n");
        this.textarea.append("    value:\n");
        String string = lDAPObjectClassSchema.toString();
        int n2 = string.length();
        for (n = 0; n < n2; n += 70) {
            int n3 = n + 70 > n2 ? n2 : n + 70;
            this.textarea.append("        " + string.substring(n, n3) + "\n");
        }
        this.textarea.append("    description:\n");
        this.textarea.append("        " + lDAPObjectClassSchema.getDescription() + "\n");
        Enumeration enumeration = lDAPObjectClassSchema.getQualifierNames();
        this.textarea.append("    qualifier names and values:\n");
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray2 = lDAPObjectClassSchema.getQualifier(string2);
                for (n = 0; n < stringArray2.length; ++n) {
                    this.textarea.append("        " + string2 + ": " + stringArray2[n] + "\n");
                }
            }
        } else {
            this.textarea.append("        no\n");
        }
        this.textarea.append("    super class(es):\n");
        Object[] objectArray = lDAPObjectClassSchema.getSuperiors();
        if (objectArray != null) {
            Arrays.sort(objectArray);
            for (n = 0; n < objectArray.length; ++n) {
                this.textarea.append("        " + (String)objectArray[n] + "\n");
            }
        } else {
            this.textarea.append("        no\n");
        }
        this.textarea.append("    Type:\n");
        int n4 = lDAPObjectClassSchema.getType();
        switch (n4) {
            case 0: {
                this.textarea.append("        ABSTRACT\n");
                break;
            }
            case 1: {
                this.textarea.append("        STRUCTURAL\n");
                break;
            }
            case 2: {
                this.textarea.append("        AUXILIARY\n");
                break;
            }
        }
        Object[] objectArray2 = lDAPObjectClassSchema.getRequiredAttributes();
        this.textarea.append("    required attribute(s):");
        this.textarea.append("\n");
        if (objectArray2 != null) {
            Arrays.sort(objectArray2);
            for (n = 0; n < objectArray2.length; ++n) {
                this.textarea.append("        " + (String)objectArray2[n]);
                this.textarea.append("\n");
            }
        } else {
            this.textarea.append("        no\n");
        }
        Object[] objectArray3 = lDAPObjectClassSchema.getOptionalAttributes();
        this.textarea.append("    optional attribute(s):");
        this.textarea.append("\n");
        if (objectArray3 != null) {
            Arrays.sort(objectArray3);
            for (n = 0; n < objectArray3.length; ++n) {
                this.textarea.append("        " + (String)objectArray3[n]);
                this.textarea.append("\n");
            }
        } else {
            this.textarea.append("        no\n");
        }
        this.textarea.append("\n");
    }
}

