/*******************************************************************************

 * $Novell: CompareAttrs.java,v 1.13 2003/08/21 11:30:34 $

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         CompareAttrs.java

 * $description:  The CompareAttrs example compares specified attribute values

 *                with the entry's attribute values. The private class printOut is

 *                used to print out the comparison results.

 ******************************************************************************/



import com.novell.ldap.*;

import java.io.UnsupportedEncodingException;



public class CompareAttrs 

{

    public static void main( String[] args ) 

    {        

        if (args.length != 4) {

           System.err.println("Usage:   java CompareAttrs <host name> <login dn> "

                                      + "<password> <compare dn> ");

           System.err.println("Example: java CompareAttrs Acme.com \"cn=Admin,"

              + "o=Acme\" secret\n         \"cn=JSmith,ou=Sales,o=Acme\"");

           System.exit(1);

        }



        int ldapPort = LDAPConnection.DEFAULT_PORT;

        int ldapVersion = LDAPConnection.LDAP_V3;;

        boolean compareResults = false;        

        String ldapHost = args[0];

        String loginDN  = args[1];

        String password = args[2];

        String dn = args[3];

        LDAPConnection lc = new LDAPConnection();

        LDAPAttribute attr = null;



        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort );

            // authenticate to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );



            attr =new LDAPAttribute( "objectclass", "inetOrgPerson" );

                             // Compare the value of the objectclass attribute.

            if ( compareResults = lc.compare(dn, attr))

               System.out.println("\t" + (attr.getStringValues()).nextElement()

                  + " is contained in the " + attr.getName() + " attribute." );

            else

               System.out.println("\t" + (attr.getStringValues()).nextElement()

               + " is not contained in the " + attr.getName() + " attribute." );



            attr = new LDAPAttribute( "sn", "Bunny" );

                                // Compare the value of the sn attribute.

            if ( compareResults = lc.compare(dn, attr))

               System.out.println("\t" + (attr.getStringValues()).nextElement()

                  + " is contained in the " + attr.getName() + " attribute." );

            else

               System.out.println("\t" + (attr.getStringValues()).nextElement()

               + " is not contained in the " + attr.getName() + " attribute." );



            // disconnect with the server

            lc.disconnect();

        }

        catch( LDAPException e ) {

           System.out.println( "Error: " + e.toString() );

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        System.exit(0);

    }

}

