/*******************************************************************************

 * $Novell: DeleteAttribute.java,v 1.5 2003/08/21 11:31:03 $

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         DeleteAttribute.java

 * $description:  The DeleteAttribute example adds attributes to an entry and

 *                shows two ways to delete the attributes using the delete

 *                modification type and the replace modification type.

 *

 *                Attributes are deleted from an entry when the application

 *                requests a delete or replace modification and supplies an

 *                attribute parameter that has no accompanying attribute value.

 *

 *                To modify or delete a single value of an attribute

 *                see the sample ModAttrs.java

 ******************************************************************************/

import com.novell.ldap.*;

import java.util.Date;

import java.util.ArrayList;

import java.io.UnsupportedEncodingException;



public class DeleteAttribute 

{

    public static void main( String[] args ) {        

        if (args.length != 4) {

            System.err.println("Usage:   java DeleteAttribute <host name> "

                             + "<login dn> <password> <modify dn>");

            System.err.println("Example: java DeleteAttribute Acme.com "

                             + "\"cn=Admin,o=Acme\" secret\n"

                             + "         \"cn=JSmith,ou=Sales,o=Acme\"");

            System.exit(1);

        }



        int ldapPort  = LDAPConnection.DEFAULT_PORT;

        int ldapVersion  = LDAPConnection.LDAP_V3;        

        Date currentDate = new Date();

        String ldapHost = args[0];

        String loginDN  = args[1];

        String password = args[2];

        String dn = args[3];

        LDAPConnection lc = new LDAPConnection();

        ArrayList modList = new ArrayList();



        /* To delete an attribute of an entry,

         *     -- Specify the dn of the entry to modify

         *     -- Specify the attribute with no value

         *     -- Specify the modification type as delete or replace

         *     -- Call LDAPConnection modify() method

         */

         

        // Setup a modification array to add description and phone number

        // attributes using the add modification type.

        // description attribute value

        LDAPAttribute attribute = new LDAPAttribute( "description",

           "This object was modified at " + new Date( currentDate.getTime()));

        modList.add( new LDAPModification(LDAPModification.ADD, attribute));

            

        // first phone number value

        attribute = new LDAPAttribute( "telephoneNumber", "1 801 555 1212");

        modList.add( new LDAPModification(LDAPModification.ADD, attribute));

        

        // second phone number value

        attribute = new LDAPAttribute( "telephoneNumber", "1 801 555 2121");

        modList.add( new LDAPModification(LDAPModification.ADD, attribute));



        // Create modifications array

        LDAPModification[] modsadd = new LDAPModification[modList.size()]; 

        modsadd = (LDAPModification[])modList.toArray(modsadd);

        

        

        // Setup a modification array to delete description and phone number

        // attributes using the delete modification type.

        // description attribute

        modList.clear();

        attribute = new LDAPAttribute( "description");

        modList.add( new LDAPModification(LDAPModification.DELETE,attribute));

        

        // phone number attribute

        attribute = new LDAPAttribute( "telephoneNumber");

        modList.add( new LDAPModification(LDAPModification.DELETE,attribute));



        // Create modifications array

        LDAPModification[] modsdel = new LDAPModification[modList.size()]; 

        modsdel = (LDAPModification[])modList.toArray(modsdel);

        

        // Setup a modification array to delete description and phone number

        // attributes using the replace modification type

        // description attribute

        modList.clear();

        attribute = new LDAPAttribute( "description");

        modList.add( new LDAPModification(LDAPModification.REPLACE,attribute));

        

        // phone number attribute

        attribute = new LDAPAttribute( "telephoneNumber");

        modList.add( new LDAPModification(LDAPModification.REPLACE,attribute));



        // Create modifications array

        LDAPModification[] modsrep = new LDAPModification[modList.size()]; 

        modsrep = (LDAPModification[])modList.toArray(modsrep);

        

        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort);

            // bind to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );



            try {

                 // Add the attributes to the entry

                lc.modify( dn, modsadd);

                System.out.println(

                            "Successfully added the attributes to the entry." );

            } catch( LDAPException ex ) {

                if(ex.getResultCode()!=LDAPException.ATTRIBUTE_OR_VALUE_EXISTS){ 

                    System.out.println("failed to add attribute: " +

                                ex.toString());

                }                    

            }

                        

             // Delete the attributes from the entry using the delete

             // modification type

            lc.modify( dn, modsdel);

            System.out.println(

                        "Successfully deleted the attributes " +

                        "using the delete modification type." );

                        

            try {

                 // Add the attributes to the entry

                lc.modify( dn, modsadd);

                System.out.println(

                            "Successfully added the attributes to the entry." );

            } catch( LDAPException ex ) {

                if(ex.getResultCode()!=LDAPException.ATTRIBUTE_OR_VALUE_EXISTS){ 

                    System.out.println("failed to add attribute: " +

                                ex.toString());

                }                    

            }

                        

             // Delete the attributes from the entry using the replace

             // modification type

            lc.modify( dn, modsrep);

            System.out.println(

                        "Successfully deleted the attributes " +

                        "using the replace modification type." );





            // disconnect with the server

            lc.disconnect();

        }

        catch( LDAPException e ) {

            if ( e.getResultCode() == LDAPException.NO_SUCH_OBJECT )

               System.err.println( "Error: No such entry" );

            else if ( e.getResultCode() ==

                                    LDAPException.INSUFFICIENT_ACCESS_RIGHTS )

               System.err.println( "Error: Insufficient rights" );

            else if ( e.getResultCode() ==

                                       LDAPException.ATTRIBUTE_OR_VALUE_EXISTS )

               System.err.println( "Error: Attribute or value exists" );

            else {

               System.err.println( "Error: " + e.toString() );

            }       

            System.exit(1);

        }   

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }     

        System.exit(0);

    }

}

