/*******************************************************************************

 * $Novell: DeleteEntry.java,v 1.14 2003/08/21 11:31:36 $

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         DeleteEntry.java

 * $description:  The DeleteEntry example deletes an entry from the directory.

 ******************************************************************************/

import com.novell.ldap.*;

import java.io.UnsupportedEncodingException;



public class DeleteEntry 

{

    public static void main( String[] args ) 

    {        

        if (args.length != 4) {

           System.err.println("Usage:   java DeleteEntry <host name> <login dn>"

                                                  + " <password> <delete dn>");

           System.err.println("Example: java DeleteEntry Acme.com"

                              + " \"cn=Admin,o=Acme\" secret\n"

                              + "         \"cn=JSmith,ou=Sales,o=Acme\"");

           System.exit(1);

        }

        

        int ldapPort = LDAPConnection.DEFAULT_PORT;

        int ldapVersion  = LDAPConnection.LDAP_V3;        

        String ldapHost = args[0];

        String loginDN = args[1];

        String password = args[2];

        String deleteDN = args[3];

        LDAPConnection lc = new LDAPConnection();



        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort );

            // authenticate to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );



            // Deletes the entry from the directory

            lc.delete( deleteDN );

            System.out.println( "\nEntry: " + deleteDN + " was deleted." );



            // disconnect with the server

            lc.disconnect();

        }

        catch( LDAPException e ) {

            if ( e.getResultCode() == LDAPException.NO_SUCH_OBJECT )

               System.err.println( "Error: No such object" );

            else if ( e.getResultCode() ==

                              LDAPException.INSUFFICIENT_ACCESS_RIGHTS )

               System.err.println( "Error: Insufficient rights" );

            else

               System.err.println( "Error: " + e.toString() );

        }        

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        System.exit(0);

    }

}

