/*******************************************************************************

 * $Novell: GetAttributeSchema.java,v 1.1 2003/08/21 11:40:42 $

 * Copyright (c) 2003 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         GetAttributeSchema.java

 * $description:  GetAttributeSchema reads an entry in the directory, then for 

 *                each of the  attribute of the entry, It prints the

 *                corresponding Attribute Schema.

 ******************************************************************************/



import com.novell.ldap.*;

import java.util.*;

import java.io.UnsupportedEncodingException;



public class GetAttributeSchema {



    public static void main( String[] args ) {



          if (args.length != 4) {

            System.err.println("Usage:   java GetAttributeSchema  <host name>" + 

            " <login dn> <password> <entry dn>");

            System.err.println("Example: java GetAttributeSchema Acme.com"

                        + " \"cn=admin,o=Acme\" secret \"cn=john,o=Acme\"");

            System.exit(1);

        }





        int ldapPort = LDAPConnection.DEFAULT_PORT;

        int ldapVersion  = LDAPConnection.LDAP_V3;

        int searchScope = LDAPConnection.SCOPE_BASE;

        String ldapHost       = args[0];

        String loginDN        = args[1];

        String password       = args[2];

        String entryDN        = args[3];

        String searchFilter   = "Objectclass=*";

        LDAPConnection lc = new LDAPConnection();

        LDAPSchema dirSchema=null;



        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort );

            // bind to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );



            try    {

                dirSchema=lc.fetchSchema(lc.getSchemaDN());

            } catch( LDAPException e) {

                e.printStackTrace();

            }



            LDAPSearchResults searchResults =

                lc.search(  entryDN,

                            searchScope,

                            searchFilter,

                            null,          // return all attributes

                            false);        // return attrs and values



            LDAPEntry Entry = null;

            try {

                    Entry = searchResults.next();

            }catch(LDAPException e) {

                    System.out.println("Error: " + e.toString());

            }



            LDAPAttributeSet attributeSet = Entry.getAttributeSet();

            Iterator allAttributes = attributeSet.iterator();



            while(allAttributes.hasNext()) {

                    LDAPAttribute attribute =

                                (LDAPAttribute)allAttributes.next();

                    String attributeName = attribute.getName();



                    System.out.println("    " 

                      + attributeName 

                      + "      " 

                      + dirSchema.getAttributeSchema(attributeName).toString());

                    System.out.println("\n");

            }

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        System.exit(0);

    }

}

