/*******************************************************************************

 * $Novell: RenameRDN.java,v 1.12 2003/08/21 11:36:59 $

 * Copyright (c) 2000 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         RenameRDN.java

 * $description:  The RenameRDN example modifies the relative distinguished name

 *                of the specified entry.

 ******************************************************************************/

import com.novell.ldap.*;

import java.io.UnsupportedEncodingException;



public class RenameRDN 

{

    public static void main( String[] args ) 

    {        

        if (args.length != 6) {

            System.err.println("Usage:   java RenameRDN <host name> <login dn> "

                             + "<password>\n"

                             + "         <old dn> <new rdn> <parentDN>");

            System.err.println("Example: java RenameRDN Acme.com "

                             + "\"cn=Admin,o=Acme\" secret\n"

                             + "         \"cn=JSmith,ou=Sales,o=Acme\""

                             + " cn=JamesSmith \"o=Products,o=Acme\"");

            System.exit(1);

        }



        int ldapPort = LDAPConnection.DEFAULT_PORT;

        int ldapVersion = LDAPConnection.LDAP_V3;        

        String ldapHost = args[0];

        String loginDN = args[1];

        String password = args[2];

        String oldDN = args[3];

        String newRDN = args[4];

        String parentDN = args[5];

        LDAPConnection lc = new LDAPConnection();



        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort );

            // authenticate to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );



            // Modifies the entry's RDN

            lc.rename( oldDN, newRDN, parentDN, true );

            System.out.println( "Entry " + oldDN + " has been renamed as " 

                                                 + newRDN + "," + parentDN  );



            // disconnect with the server

            lc.disconnect();

        }

        catch( LDAPException e ) {



            if ( e.getResultCode() == LDAPException.NO_SUCH_OBJECT ) {

               System.err.println( "Error: No such object" );

            } else if ( e.getResultCode() ==

                LDAPException.INSUFFICIENT_ACCESS_RIGHTS ) {

                    System.err.println( "Error: Insufficient rights" );

            } else if ( e.getResultCode() ==

                LDAPException.ATTRIBUTE_OR_VALUE_EXISTS ) {

                    System.err.println( "Error: Attribute or value exists" );

            } else {

                System.out.println( "Error: " + e.toString() );

            }        

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }        

        System.exit(0);

    }

}

