/*******************************************************************************

 * $Novell: UnsolicitedListener.java,v 1.15 2003/08/21 11:37:01 $

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         UnsolicitedListener.java

 * $description:  UnsolicitedListener shows how to listen for unsolicited

                  notifications

 ******************************************************************************/

import com.novell.ldap.*;

import java.io.UnsupportedEncodingException;



// This class demonstrates how an application program can

// register to listen for unsolicited notifications.  It

// includes an inner class called "theListener" which

// gets notified on unsolicited notifications.

public class UnsolicitedListener {



   // This is the class that will be called when an unsolicited notification

   // is received

   public class theListener implements LDAPUnsolicitedNotificationListener {



      public theListener()

      {

      }



      // The required method that has to be implemented by all listeners.  This

      // method is called on unsolicited notifications.

      public void messageReceived(LDAPExtendedResponse msg)

      {

         System.out.println("Received notification of unsolicited notification");



        // Print the OID

        System.out.println("The OID in the notification was ==>" +

           ((LDAPExtendedResponse)msg).getID());



        // print the data field if there was one

        byte [] data = msg.getValue();

        if (data == null)

           System.out.println("The DATA in the notification was <null>" );

        else

           System.out.println("The DATA in the notification was ==> " + data);

     

      }

   }





   // Create a new instance of self and call the doWork()

   // method that register the listener, sleeps and waits

   // for unsolicited notifications

   public static void main( String[] args ) {

      UnsolicitedListener temp = new UnsolicitedListener();

      temp.doWork(args);



   }





   // This method registers the inner Class defined above as

   // a listener for unsolicited notifications.  It then

   // sleeps waiting for notifications.

   // The messageReceived method should get called when the client

   // receives an unsolicited notification

   public void doWork( String[] args ) {



       int            ldapVersion  = LDAPConnection.LDAP_V3;

        int            ldapPort = LDAPConnection.DEFAULT_PORT;

        LDAPConnection lc  = new LDAPConnection();



        if (args.length != 3) {

            System.err.println("Usage:   java UnsolicitedListener <host Name>"

                             + " <login dn> <password>");

            System.err.println("Example: java UnsolicitedListener Acme.com"

                             + " \"cn=Admin,o=Acme\" secret");

            System.exit(1);

        }



        String ldapHost  = args[0];

        String loginDN   = args[1];

        String passWord  = args[2];





        try {



            // connect to the server

            lc.connect( ldapHost, ldapPort );



          // authenticate to the server

         System.out.println("Connecting.......");

            lc.bind( ldapVersion,loginDN, passWord.getBytes("UTF8") );

          System.out.println("Authenticated to the server ");



         // Add unsolicted listener

         theListener notifyMe = new theListener();

         lc.addUnsolicitedNotificationListener(notifyMe);

         System.out.println("Added listener for unsolicited messages");



         System.out.println("Sleeping .ZZZZZZZZZZZZZZZZZZZZ");

         try {



            // Sleep for 100 seconds

            java.lang.Thread.sleep(100000);



         } catch (InterruptedException e) {

            System.out.println("Interrupted");

         }



         System.out.println("YAWN, I'M AWAKE NOW");



         // Remove self from list of registered listeners

         lc.removeUnsolicitedNotificationListener(notifyMe);

         System.out.println("Removed listener");



         // Dosconnect from Server

         lc.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }



        System.exit(0);

    }



}

