/*******************************************************************************

 * $Novell: VerifyPassword.java,v 1.14 2003/08/21 11:37:01 $

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:           VerifyPassword.java

 * $description:    The VerifyPassword.java sample verifies that a password is

 *                  correct for the given entry.

 *

 *                  We simply compare the password with the "userPassword"

 *                  attribute of the entry using the LDAP compare function.

 *

 ******************************************************************************/

import com.novell.ldap.*;

import java.io.UnsupportedEncodingException;



public class VerifyPassword

{

    public static void main( String[] args ) 

    {        

        if (args.length != 5) {

           System.out.println("Usage:   java VerifyPassword <host name>"

                            + " <login dn> <password> <object dn>\n"

                            + "         <test password>");

           System.out.println("Example: java VerifyPassword Acme.com "

                       + "\"cn=Admin,o=Acme\" secret\n"

                       + "         \"cn=JSmith,ou=Sales,o=Acme\" testPassword");

           System.exit(0);

        }



        int ldapPort = LDAPConnection.DEFAULT_PORT;

        int ldapVersion = LDAPConnection.LDAP_V3;

        String ldapHost = args[0];

        String loginDN = args[1];

        String password = args[2];

        String objectDN = args[3];

        String testPassword = args[4];

        LDAPConnection lc = new LDAPConnection();



        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort );



            // authenticate to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );



            LDAPAttribute attr = new LDAPAttribute(

                                            "userPassword", testPassword );

            boolean correct = lc.compare( objectDN, attr );



            System.out.println( correct ? "The password is correct.":

                                          "The password is incorrect.\n");



            // disconnect with the server

            lc.disconnect();

        }

        catch( LDAPException e ) {

            if ( e.getResultCode() == LDAPException.NO_SUCH_OBJECT ) {

                System.err.println( "Error: No such entry" );

            } else if ( e.getResultCode() == 

                                        LDAPException.NO_SUCH_ATTRIBUTE ) {

                System.err.println( "Error: No such attribute" );

            } else {

                System.err.println( "Error: " + e.toString() );

            }        

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }       

        System.exit(0);

    }

}

