/*******************************************************************************

 * $Novell: Searchas.java,v 1.18 2003/08/21 11:42:04 $

 * Copyright (c) 2000 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         Searchas.java 

 * $description:  The Searchas.java example shows how to do an asynchronous search.

 ******************************************************************************/

import com.novell.ldap.*;

import java.util.Enumeration;

import java.util.Iterator;

import java.io.UnsupportedEncodingException;



public class Searchas 

{

    public static void main( String[] args ) 

    {               

        if (args.length != 5) {

            System.err.println("Usage:   java Searchas <host name> <login dn>"

                                    + " <password> <search base>\n"

                                    + "         <search filter>");

            System.err.println("Example: java Searchas Acme.com"

                                    + " \"cn=admin,o=Acme\"" 

                                    + " secret \"ou=sales,o=Acme\"\n" 

                                    + "         \"objectclass=*\"");

            System.exit(1);

        }

        

        int ldapPort = LDAPConnection.DEFAULT_PORT;

        int ldapVersion = LDAPConnection.LDAP_V3; 

        String attrs[] ={ "cn", "sn" }; 

        LDAPConnection lc = new LDAPConnection();

        String ldapHost = args[0];

        String loginDN = args[1];

        String password = args[2];

        String searchBase = args[3];

        String searchFilter= args[4];

     

        try {

            // connect to the server            

            lc.connect( ldapHost, ldapPort );

            // authenticate to the server

            lc.bind(ldapVersion, loginDN, password.getBytes("UTF8") );

            

            // asynchronous search            

            LDAPSearchQueue queue = 



            lc.search(  searchBase,      // container to search

                        LDAPConnection.SCOPE_ONE,// search container only 

                        searchFilter,    // search filter

                        attrs,           // return cn and sn

                        false,           // return attrs and values                                      

                        (LDAPSearchQueue)null,

                                         // use default search queue

                        (LDAPSearchConstraints)null);

                                         // use default search constraints

           

            LDAPMessage message; 

           

            while (( message = queue.getResponse()) != null ) {

                // the message is a search result reference

                if ( message instanceof LDAPSearchResultReference ) {                    

                    String urls[] =

                        ((LDAPSearchResultReference)message).getReferrals();

                    System.out.println("Search result references:");                        

                        for ( int i = 0; i < urls.length; i++ )

                            System.out.println(urls[i]); 

                } 

                // the message is a search result

                else if ( message instanceof LDAPSearchResult ) {

                    LDAPEntry entry = ((LDAPSearchResult)message).getEntry();

                       

                    System.out.println("\n" + entry.getDN());

                    System.out.println("\tAttributes: ");



                    LDAPAttributeSet attributeSet = entry.getAttributeSet();

                    Iterator allAttributes = attributeSet.iterator();

  

                    while(allAttributes.hasNext()) {

                        LDAPAttribute attribute =

                                (LDAPAttribute)allAttributes.next();

                        String attributeName = attribute.getName();

     

                        System.out.println("\t\t" + attributeName);



                        Enumeration allValues = attribute.getStringValues();

     

                        if( allValues != null) {

                            while(allValues.hasMoreElements()) {

                               String Value = 

                                    (String) allValues.nextElement();

                               System.out.println("\t\t\t" + Value);

                            }

                        }

                    }       

                }                

                // the message is a search response

                else {

                    LDAPResponse response = (LDAPResponse)message;

                    int status = response.getResultCode();

                    // the return code is LDAP success

                    if ( status == LDAPException.SUCCESS ) {

                        System.out.println("Asynchronous search succeeded.");

                    }

                    // the reutrn code is referral exception

                    else if ( status == LDAPException.REFERRAL ) {                        

                        String urls[]=((LDAPResponse)message).getReferrals();

                        System.out.println("Referrals:");                        

                        for ( int i = 0; i < urls.length; i++ )

                            System.out.println(urls[i]);                    

                    }                    

                    else {                        

                        System.out.println("Asynchronous search failed.");

                        throw new LDAPException( response.getErrorMessage(),

                                                 status,

                                                 response.getMatchedDN());

                    }

                }                                

            }

            // disconnect with the server

            lc.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }               

        System.exit(0);

    }

}



