/*******************************************************************************

 * Novell:$ Copyright (c) 2001 Novell, Inc. All Rights Reserved.

 * 

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.

 * USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT

 * ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.

 * PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A

 * ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS

 * PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,

 * DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S

 * PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S

 * CUSTOMERS WITH RESPECT TO THIS CODE.

 * 

 * $name: EffectivePrivilegesControlSample.java $description: 

 * EffectivePrivilegesControlSample.java demonstrates how to

 * use the Effective Privileges server side control with Synchronous search 

 * requests.

 *  

 * Note that this Server control is supported only in Novell Virtual Directory

 * Services(NVDS) right now.

 ******************************************************************************/



import java.util.ArrayList;

import java.util.Enumeration;

import java.util.Iterator;

import com.novell.ldap.*;

import com.novell.ldap.controls.*;

import java.io.UnsupportedEncodingException;



public class EffectivePrivilegesControlSample {



	public static void main(String[] args) {



		if (args.length != 4) {

			System.err.println("Usage:   java EffectivePrivilegesControlSample <host name> "

					+ "<login dn> <password> <container>");

			System.err.println("Example: java EffectivePrivilegesControlSample Acme.com \"cn=admin,"

					+ "o=Acme\" secret \"ou=Sales,o=Acme\"");

			System.exit(1);

		}



		// Read command line arguments

		String ldapHost = args[0];

		String loginDN = args[1];

		String password = args[2];

		String searchBase = args[3];

		int ldapPort = LDAPConnection.DEFAULT_PORT;

		int ldapVersion = LDAPConnection.LDAP_V3;

		String searchFilter = "(objectclass=*)";

		LDAPConnection lc = new LDAPConnection();



		try {

			// connect to the server

			lc.connect(ldapHost, ldapPort);

			// bind to the server

			lc.bind(ldapVersion, loginDN, password.getBytes("UTF8"));

			

			/* 

		     * Create the LDAPEffectivePrivilegesControl for sending search 

		     * request to server  

		     */			

			LDAPEffectivePrivilegesSelection selection1, selection2;

			ArrayList selections = new ArrayList();

			selection1 = new LDAPEffectivePrivilegesSelection("cn", null);

			selection2 = new LDAPEffectivePrivilegesSelection(null, "inetorgperson");

			selections.add(selection1);

			selections.add(selection2);

			

			LDAPEffectivePrivilegesControl effControl = 

				new LDAPEffectivePrivilegesControl(

						true, 	//Critical

						false, 	//includeAllLegalAttributes is not selected

						selections); //selections sequence

			

			

			// Set the control to be sent as part of search request

			LDAPSearchConstraints cons = lc.getSearchConstraints();

			cons.setControls(effControl);

			lc.setConstraints(cons);



			// Perform the search - SYNCHRONOUS SEARCH USED HERE

			System.out.println("\nCalling search request...");

			

			LDAPSearchResults res = lc.search(searchBase,

					LDAPConnection.SCOPE_SUB, searchFilter, null, 

					false, cons);

			// Loop on results until finished

			while (res.hasMore()) {

				// Get next directory entry - this next object can

				// be an LDAPException if something went wrong

				LDAPEntry nextEntry;

				try {

					nextEntry = res.next();

				} catch (LDAPException e) {

					if(e.getResultCode() == 12)

						System.out.println("This critical control is not supported..");

					if (e instanceof LDAPReferralException)

						continue;

					else

						break;

				}



				// Print out the entry DN

				System.out.println();

				System.out.println("Entry dn: " + nextEntry.getDN());



				// Get the attributes of the entry

				LDAPAttributeSet findAttrs = nextEntry.getAttributeSet();



				Iterator enumAttrs = findAttrs.iterator();

				System.out.println("Attribute(s):");



				// Loop on attributes

				while (enumAttrs.hasNext()) {

					LDAPAttribute anAttr = (LDAPAttribute) enumAttrs.next();



					// get attribute name

					String attrName = anAttr.getName();



					// get attribute value

					Enumeration enumVals = anAttr.getStringValues();

					while (enumVals.hasMoreElements()) {

						String aVal = (String) enumVals.nextElement();

						// print out attribute name and value

						System.out.println("    " + attrName + ": " + aVal);

					}

				}

			}



			// All done - disconnect

			if (lc.isConnected())

				lc.disconnect();



		} catch (LDAPException e) {

			System.out.println(e.toString());

		} catch (UnsupportedEncodingException e) {

			System.out.println("Error: " + e.toString());

		}

	}

}