/*

 * $OpenLDAP$

 *

 * Copyright (C) 2003 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE, MODIFICATION, AND REDISTRIBUTION OF THIS WORK IS SUBJECT

 * TO VERSION 2.0.1 OF THE OPENLDAP PUBLIC LICENSE, A COPY OF WHICH IS

 * AVAILABLE AT HTTP://WWW.OPENLDAP.ORG/LICENSE.HTML OR IN THE FILE "LICENSE"

 * IN THE TOP-LEVEL DIRECTORY OF THE DISTRIBUTION. ANY USE OR EXPLOITATION

 * OF THIS WORK OTHER THAN AS AUTHORIZED IN VERSION 2.0.1 OF THE OPENLDAP

 * PUBLIC LICENSE, OR OTHER PRIOR WRITTEN CONSENT FROM NOVELL, COULD SUBJECT

 * THE PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.

 */



package sample_consumers;



import javax.xml.rpc.Stub;

import javax.naming.InitialContext;

import org.w3c.dom.*;



import javax.xml.parsers.DocumentBuilderFactory;

import javax.xml.parsers.DocumentBuilder;

import javax.xml.parsers.ParserConfigurationException;

import java.util.Iterator;





public class DomClient {

    private static int iden; // XML identation

    private static String idenChars = "  ";



    public static void main(String[] args) throws Exception

    {



        if (args.length != 4){

            System.out.println("Usage: Client dsmlFile [URL to service - "+

                    "defaults to http://localhost/novell-dsml/jbroker] loginDN password");

            System.exit(0);

        }



        String dsmlFile = args[0];

        String dsmlUrl = args[1];

        String loginDN = args[2];

        String password = args[3];



        // get the initial context

        InitialContext ctx = new InitialContext();



        // lookup the service for Hello

        DsmlClientService svc = (DsmlClientService)

            ctx.lookup("xmlrpc:soap:sample_consumers.DsmlClientService");



        // get the hello stub

        DsmlClient dsml = (DsmlClient) svc.getDsmlClientPort();



        // set the end point address

        ((Stub)dsml)._setProperty("javax.xml.rpc.service.endpoint.address",

                args.length > 1 ? dsmlUrl :"http://localhost/novell-dsml/jbroker");



        ((Stub)dsml)._setProperty("javax.xml.rpc.security.auth.username", loginDN);

        ((Stub)dsml)._setProperty("javax.xml.rpc.security.auth.password", password);



        // Load DSML document

        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

        DocumentBuilder builder = factory.newDocumentBuilder();

        Document doc = builder.parse(dsmlFile);

        Element request = doc.getDocumentElement();



        // invoke the service

        Element response = dsml.batchRequest(request);

        displayElement(response);

    }



    public static void displayElement(Element element) {



        // prepare element text (starting tag and attributes)

        String eText = new String("<" + element.getNodeName());

        NamedNodeMap nodeMap = element.getAttributes();

        int attrNum = nodeMap.getLength();



        for (int i=0; i<attrNum; i++) {

            Attr attr = (Attr)nodeMap.item(i);

            eText += " "+attr.getNodeName()+"=\"" + attr.getNodeValue() + "\"";

        }



        // print element text

        System.out.println(eText + ">");



        // go through any child node

        for ( Node cNode = element.getFirstChild();

              cNode != null;

              cNode = cNode.getNextSibling()) {



            int nodeType = cNode.getNodeType();



            if (nodeType != Node.TEXT_NODE)

                iden++;



            for(int i=0;i<iden;i++)

                System.out.print(idenChars);







            if (nodeType == Node.ELEMENT_NODE) {

                // cNode is an element, recursive call

                displayElement((Element)cNode);

            }

            else if (nodeType == Node.TEXT_NODE) {

                // prepare text node text

                String nText = cNode.getNodeValue().trim();

                // print text node text

                if(nText.length() > 0) {

                    System.out.println("  " + nText);

                }

            }

        }



        // print element text (ending tag)

        for(int i=0;i<iden;i++)

                System.out.print(idenChars);

        System.out.println("</" + element.getNodeName() + ">");

        iden--;

    }

}

