/**************************************************************************

 * $Novell: LDAPOperation.java,v 1.2 2003/02/18 17:41:57 $

 *

 * Copyright (C) 2003 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE, MODIFICATION, AND REDISTRIBUTION OF THIS WORK IS SUBJECT

 * TO VERSION 2.0.1 OF THE OPENLDAP PUBLIC LICENSE, A COPY OF WHICH IS

 * AVAILABLE AT HTTP://WWW.OPENLDAP.ORG/LICENSE.HTML OR IN THE FILE "LICENSE"

 * IN THE TOP-LEVEL DIRECTORY OF THE DISTRIBUTION. ANY USE OR EXPLOITATION

 * OF THIS WORK OTHER THAN AS AUTHORIZED IN VERSION 2.0.1 OF THE OPENLDAP

 * PUBLIC LICENSE, OR OTHER PRIOR WRITTEN CONSENT FROM NOVELL, COULD SUBJECT

 * THE PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.

 ***************************************************************************/ 

package sample_consumers;



import javax.servlet.http.HttpServletRequest;

import java.util.Vector;

import java.util.Enumeration;

import javax.naming.InitialContext;

import javax.xml.rpc.Stub;

import javax.xml.parsers.DocumentBuilderFactory;

import javax.xml.parsers.DocumentBuilder;

import org.w3c.dom.Attr;

import org.w3c.dom.Document;

import org.w3c.dom.Element;

import org.w3c.dom.Node;

import org.w3c.dom.NamedNodeMap;

import org.w3c.dom.NodeList;

import java.io.FileOutputStream;



public class LDAPOperation extends DomClientObj {

    

    String submit    = null;

    String operation = null;

    String loginDN   = null;

    String password  = null;

    String idenChars = "";

    Vector v         = new Vector();    

    String dsmlFile = "webapps//novell-dsml//xml//";

    

    private void createLDAPOpRequest() {



        try {                                                                        

            // set authentication property

            setAuthProperties(loginDN, password);            

            

            doc = getBuilder().parse(dsmlFile);

            Element req = doc.getDocumentElement();

            

            // submit dsml request

            Element resp = dsml.batchRequest(req);

                        

            // save dsml response

            saveElement(resp);                    

        }

        catch(Exception e) {

            saveMessage("Error: " + e.toString());

        }

    }   



    public void viewLDAPOpRequest() {

        

        try {                                           

            doc = getBuilder().parse(dsmlFile);

            Element req = doc.getDocumentElement();

            saveElement( req );

        }

        catch(Exception e) {

            saveMessage("Error: " + e.toString());

        }

    }                



    public String[] getDsmlLines() {	      

	return getDSMLLines();

    }



    public void processRequest(HttpServletRequest request) {

	

	if (submit != null) { 

        

        

            if (operation.equalsIgnoreCase("GetDSE")) {                

                dsmlFile += "getdse.xml";

            }                                   

    	

            if (submit.equals("Submit Request")) {        

    	        createLDAPOpRequest();	

            }

            else if(submit.equals("View Request")) {

                viewLDAPOpRequest();

            }

        }

	

	// reset at the end of the request

	reset();

    }   

    

    // reset

    private void reset() {

	submit = null;

	operation = null;

    }

        

    public void setSubmit(String s) {

        submit = s;

    }



    public void setOperation(String opName) {

	operation = opName;

    }



    public void setLoginDN(String logName) {

	loginDN = logName;

    }



    public void setPassword(String pwd) {

	password = pwd;

    }

}

