/**************************************************************************

 * $Novell: PartitionOperation.java,v 1.2 2003/02/18 17:43:47 $

 *

 * Copyright (C) 2003 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE, MODIFICATION, AND REDISTRIBUTION OF THIS WORK IS SUBJECT

 * TO VERSION 2.0.1 OF THE OPENLDAP PUBLIC LICENSE, A COPY OF WHICH IS

 * AVAILABLE AT HTTP://WWW.OPENLDAP.ORG/LICENSE.HTML OR IN THE FILE "LICENSE"

 * IN THE TOP-LEVEL DIRECTORY OF THE DISTRIBUTION. ANY USE OR EXPLOITATION

 * OF THIS WORK OTHER THAN AS AUTHORIZED IN VERSION 2.0.1 OF THE OPENLDAP

 * PUBLIC LICENSE, OR OTHER PRIOR WRITTEN CONSENT FROM NOVELL, COULD SUBJECT

 * THE PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.

 ***************************************************************************/ 

package sample_consumers;



import javax.servlet.http.HttpServletRequest;

import javax.xml.rpc.Stub;

import org.w3c.dom.Element;

import com.novell.ldap.LDAPExtendedOperation;

import com.novell.ldap.extensions.SplitPartitionRequest;

import com.novell.ldap.extensions.ReplicationConstants;

import com.novell.ldap.util.Base64;





public class PartitionOperation extends DomClientObj {



    

    String submit        = null;

    String operation     = null;

    String loginDN       = null;

    String password      = null;

    String partitionRoot = null;

    String splitOID      = "2.16.840.1.113719.1.27.100.3";

    String mergeOID      = "2.16.840.1.113719.1.27.100.5";

    String entryCountOID = "2.16.840.1.113719.1.27.100.13";

    String abortOID      = "2.16.840.1.113719.1.27.100.29";              



    private void createPartitionOpRequest(String operation) {



        try {            

            // set authentication property

            setAuthProperties(loginDN, password);



            LDAPExtendedOperation request = new SplitPartitionRequest(

                                partitionRoot,

                                ReplicationConstants.LDAP_ENSURE_SERVERS_UP);

            String value = Base64.encode(request.getValue());

            

            Element bReq = doc.createElementNS(

                        "urn:oasis:names:tc:DSML:2:0:core", "batchRequest");



            Element extReq   = doc.createElement("extendedRequest");

            Element extName  = doc.createElement("requestName");

            Element extValue = doc.createElement("requestValue");

            

            if(operation.equalsIgnoreCase("mergePartition")) {            

                extName.appendChild(doc.createTextNode(mergeOID));

            }

            else if(operation.equalsIgnoreCase("splitPartition")) {            

                extName.appendChild(doc.createTextNode(splitOID));

            }

            else if(operation.equalsIgnoreCase("abortPartitionOperation")) {            

                extName.appendChild(doc.createTextNode(abortOID));

            }

            else if(operation.equalsIgnoreCase("PartitionEntryCount")) {            

                extName.appendChild(doc.createTextNode(entryCountOID));

            }

            

            extValue.appendChild(doc.createTextNode(value));



            extReq.appendChild(extName);

            extReq.appendChild(extValue);            

            bReq.appendChild(extReq);           

            

            // submit dsml request

            Element bResp = dsml.batchRequest(bReq);           

            // save dsml response

            saveElement(bResp);

        }

        catch(Exception e) {

            saveMessage("Error: " + e.toString());

        }

    }                 

    

    public String[] getDsmlLines() {	       

	return getDSMLLines();

    }

       

    public void processRequest(HttpServletRequest request) {

	

	if (partitionRoot == null) {

            saveMessage("Partition root can not be null!");

        }



        if (submit != null) {         

	    createPartitionOpRequest(operation);	        

        }

	

	// reset at the end of the request

	reset();

    }   

        

    private void reset() {

	submit = null;

    }



    public void setOperation(String opName) {

	operation = opName;

    }

        

    public void setSubmit(String s) {

        submit = s;

    }   



    public void setLoginDN(String logName) {

	loginDN = logName;

    }



    public void setPassword(String pwd) {

	password = pwd;

    }    



    public void setPartitionRoot(String root) {

	partitionRoot = root;

    }   

}

