/*******************************************************************************

 * $Novell: Ldif2Dsml.java,v 1.1 2003/11/18 11:24:18 $

 * Copyright (c) 2003 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         Ldif2Dsml.java

 * $description:  Ldif2Dsml.java reads an LDIF file and converts the LDIF

 *                Records into corresponding DSML requests and writes

 *                back the output in a Data file.

 ******************************************************************************/



import java.util.Enumeration;

import java.util.Iterator;

import java.io.FileInputStream;

import java.io.FileOutputStream;

import java.io.IOException;

import java.io.FileNotFoundException;

import java.io.UnsupportedEncodingException;

import com.novell.ldap.LDAPMessage;

import com.novell.ldap.LDAPLocalException;

import com.novell.ldap.util.*;



public class Ldif2Dsml {

    public static void main( String[] args ) {



        if (args.length != 2) {

            usage();

        }



        int  version = 1;

        String fileName = args[0];

        String ofileName = args[1];

        LDIFReader reader = null;

        LDAPMessage msg;



        try {

            FileInputStream fis = new FileInputStream( fileName);

            reader = new LDIFReader(fis, version);

        }

        catch (Exception e) {

            System.err.println("\nFailed to read LDIF file " + fileName +

                               ", " + e.toString());

            System.exit (1);

        }





        try

        {

	        DSMLWriter out;

            FileOutputStream outFileStream = null;

            if (ofileName == null){

                out = new DSMLWriter(System.out);

            } else {

                outFileStream = new FileOutputStream(ofileName);

                out = new DSMLWriter(outFileStream);

            }

            out.useIndent(true);

            out.setIndent(4);

            while ( (msg = reader.readMessage()) != null ) {

	            out.writeMessage( msg);

            }

	        out.finish();

        }catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }catch (FileNotFoundException e) {

            System.out.println( "Error: could not find input DSML file:" + e );

        } catch (IOException e) {

            System.out.println( "Error reading or writing to file:" + e);

        } catch (LDAPLocalException e) {

            System.out.println(

                    "The following error occured handling a DSML file:" + e);

        } catch (Exception e) {

            System.out.println(

                    "The following error occured :" + e);

        }



        System.exit (0);

    }



    public static void usage() {

        System.err.println("Usage:   java Ldif2Dsml <in file name> "

                + "<out file name>");

        System.err.println("Example: java Ldif2Dsml inFile outfile ");

        System.exit(1);

    }



}