/*******************************************************************************

 * $Novell: Ldif2Ldap.java,v 1.9 2003/08/21 11:49:21 $

 * Copyright (c) 2003 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         Ldif2Ldap.java

 * $description:  Ldif2Ldap.java reads an LDIF file.

 *                Data from a change file is used to make modifications

 *                to the directory, and data from a content file

 *                is displayed.

 ******************************************************************************/



import java.util.Enumeration;

import java.util.Iterator;

import java.io.FileInputStream;

import java.io.IOException;

import java.io.UnsupportedEncodingException;



import com.novell.ldap.LDAPAttribute;

import com.novell.ldap.LDAPAttributeSet;

import com.novell.ldap.LDAPConnection;

import com.novell.ldap.LDAPEntry;

import com.novell.ldap.LDAPException;

import com.novell.ldap.LDAPResponse;

import com.novell.ldap.LDAPSearchResult;

import com.novell.ldap.LDAPAddRequest;

import com.novell.ldap.LDAPDeleteRequest;

import com.novell.ldap.LDAPModifyDNRequest;

import com.novell.ldap.LDAPModifyRequest;

import com.novell.ldap.util.LDIFReader;

import com.novell.ldap.LDAPMessage;

import com.novell.ldap.LDAPMessageQueue;





public class Ldif2Ldap {

    public static void main( String[] args ) {



        if (args.length != 4) {

            usage();

        }



        int  version = 1;

        int ldapPort = LDAPConnection.DEFAULT_PORT;

        int ldapVersion  = LDAPConnection.LDAP_V3;

        String fileName = args[0];

        String ldapHost = args[1];

        String loginDN  = args[2];

        String password = args[3];

        LDIFReader reader = null;

        LDAPEntry entry;

        LDAPMessage msg, retMsg;

        Ldif2Ldap readerTest = new Ldif2Ldap();

        LDAPConnection lc = new LDAPConnection();



        try {

            FileInputStream fis = new FileInputStream( fileName);

            reader = new LDIFReader(fis, version);

        }

        catch (Exception e) {

            System.err.println("\nFailed to read LDIF file " + fileName +

                               ", " + e.toString());

            System.exit (1);

        }



        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort );

            // bind to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );



            if (!reader.isRequest()) {

                System.out.println("\nLDIF content file\n");



                while ( (msg = reader.readMessage()) != null) {

                    entry = ((LDAPSearchResult)msg).getEntry();

                    System.out.println("\nEntry DN:" + entry.getDN());

                    readerTest.showAttributes(entry);

                }

            }

            else {

                System.out.println("\nLDIF change file\n");



                while ( (msg = reader.readMessage()) != null) {

                    if (msg instanceof LDAPAddRequest) {

                       System.out.println("Adding entry...");

                    }

                    else if (msg instanceof LDAPDeleteRequest) {

                        System.out.println("Deleting entry...");

                    }

                    else if (msg instanceof LDAPModifyDNRequest) {

                        System.out.println("Modifying entry's RDN...");

                    }

                    else if (msg instanceof LDAPModifyRequest) {

                        System.out.println("Modifying entry's attribute(s)...");

                    }



                    LDAPMessageQueue queue = lc.sendRequest(msg, null, null);

                    if ((retMsg = queue.getResponse()) != null) {

                        LDAPResponse response = (LDAPResponse)retMsg;

                        int status = response.getResultCode();



                        // the return code is LDAP success

                        if ( status == LDAPException.SUCCESS ) {

                            System.out.println("Directory information has been"

                                                               + " modified.");

                        }

                        // the reutrn code is referral exception

                        else if ( status == LDAPException.REFERRAL ) {

                            String urls[]=((LDAPResponse)retMsg).getReferrals();

                            System.out.println("Referrals:");

                            for ( int i = 0; i < urls.length; i++ )

                                System.out.println("    " + urls[i]);

                        }

                        // general error

                        else {

                            System.out.println( response.getErrorMessage());

                        }

                    }

                    System.out.println();

                }

            }

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        catch ( IOException ioe ) {

            System.out.println("Error: " + ioe.toString() );

            System.exit( 1 );

        }

        catch ( LDAPException le ) {

            System.out.println("Error: " + le.toString() );

            System.exit( 1 );

        }

        



        System.exit (0);

    }



    public static void usage() {

        System.err.println("Usage:   java Lidf2Ldap <in file name> "

                + "<host name> <login dn> <password>");

        System.err.println("Example: java Lidf2Ldap inFile Acme.com "

                                    + " \"cn=admin,o=Acme\" secret");

        System.exit(1);

    }



    public void showAttributes(LDAPEntry entry) {



        String value;

        LDAPAttributeSet as = null;

        LDAPAttribute[]  attrs = null;

        LDAPAttribute attr = null;

        Iterator allAttrs;

        Enumeration allAttrValues;



        as = entry.getAttributeSet();

        allAttrs = as.iterator();

        System.out.println("    Attributes:");

        while(allAttrs.hasNext()) {

            attr = (LDAPAttribute)allAttrs.next();

            System.out.println("        " + attr.getName());

            allAttrValues = attr.getStringValues();

            if( allAttrValues != null) {

                while(allAttrValues.hasMoreElements()) {

                    value = (String) allAttrValues.nextElement();

                    System.out.println("            " + value);

                }

            }

        }

    }

}