/* **************************************************************************

 * $Novell: GetReplicationFilter.java,v 1.12 2003/08/21 11:53:13 $

 *

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 * 

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE. 

 ***************************************************************************/

import com.novell.ldap.LDAPConnection;

import com.novell.ldap.LDAPException;

import com.novell.ldap.LDAPExtendedOperation;

import com.novell.ldap.LDAPExtendedResponse;

import com.novell.ldap.extensions.GetReplicationFilterRequest;

import com.novell.ldap.extensions.GetReplicationFilterResponse;

import java.io.UnsupportedEncodingException;

/**

 *  The following sample demonstrates how to set the replication 

 *  filter on a LDAP server using LDAP extensions.

 *

 */

public class GetReplicationFilter {



    public static void main( String[] args ) {



        if (args.length != 5) {

            System.err.println("Usage:   java GetReplicationFilter <host Name> "

                              + "<port number> <login dn> <password>" 

                              + "\n         <server ND>");

            System.err.println("Example: java GetReplicationFilter Acme.com 389 "

                              + "\"cn=Admin,o=Acme\" secret" 

                              + "\n         \"cn=myServer,o=Acme\"");

            System.exit(1);

        }



        int    ldapVersion = LDAPConnection.LDAP_V3;

        String ldapHost    = args[0];

        int    ldapPort    = Integer.parseInt(args[1]);

        String loginDN     = args[2];

        String password    = args[3];

        String serverDN    = args[4];

        LDAPConnection ld  = new LDAPConnection();



        try {

            // connect to the server

            ld.connect( ldapHost, ldapPort);

            // bind to the server

            ld.bind( ldapVersion, loginDN, password.getBytes("UTF8") );

            System.out.println( "\nLogin succeeded");



            LDAPExtendedOperation request = 

                new GetReplicationFilterRequest(serverDN);



            LDAPExtendedResponse response = ld.extendedOperation(request);

            

            int i, j;

            

            if ( response.getResultCode() != LDAPException.SUCCESS ) {//&&

                System.out.println("Get Replication Filter Request Failed");

                throw new LDAPException( response.getErrorMessage(),

                                         response.getResultCode(),

                                         (String)null);

            }

            else {

                if ( response instanceof GetReplicationFilterResponse ) {

                    System.out.println("Get Replication Filter Request succeeded\n");

                    String filter[][] = ((GetReplicationFilterResponse)response).

                                                         getReplicationFilter();



                    if ( (filter == null) || 

                         ( (filter != null) && (filter.length == 0) ))

                        System.out.println("No filter returned");

                    else {

                        System.out.println("The filter returned is shown below:");

                   

                        for(i=0;i < filter.length; i++) {

                            System.out.println("Class Name: " + filter[i][0]);



                            if (filter[i].length == 1) {

                                System.out.println("    Attribute :" 

                                    + " (no attributes specified)");

                            }

                            else {                        

                                for (j=1; j<filter[i].length; j++ ) {

                                    if ((filter[i].length==2)&&

                                        (filter[i][j]).startsWith("*")) {

                                       System.out.println("    Attribute :" 

                                           + " (All the attributes of the" 

                                               + " object class)");

                                       break;

                                    }

                                    else {

                                        System.out.println("    Attribute :" 

                                            + filter[i][j]);

                                    }

                                }

                            }

                        }

                    }                    

                }

            }

            



            /* Done, so disconnect */

            if ( ld.isConnected() )

                ld.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        System.exit(0);

    }

}

