/* **************************************************************************

 * $Novell: LburpDemo.java,v 1.2 2004/01/21 05:38:09 $

 *

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 * 

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE. 

 ***************************************************************************/



import com.novell.ldap.*;

import com.novell.ldap.extensions.*;

import java.util.ArrayList;

import java.util.Date;

import java.io.UnsupportedEncodingException;

import com.novell.ldap.util.LDIFReader;

import java.io.FileInputStream;

import java.io.IOException;

import java.io.UnsupportedEncodingException;





public class LburpDemo{



    public static void main( String[] args ) 

    {

        if (args.length != 5) {

            System.err.println("Usage:   java LburpDemo <host Name> " 

                              + "<port number> <login dn> <password> <ldif>\n");



            System.err.println("Example: java LburpDemo Acme.com 389 "

                              + "\"cn=Admin,o=Acme\" secret user.ldif ");



            System.exit(1);

        }



        LDAPConnection ld;

        int    ldapVersion = LDAPConnection.LDAP_V3;

        LburpClient lburpc;

        String ldapHost    = args[0];

        int    ldapPort    = Integer.parseInt(args[1]);

        String loginDN     = args[2];

        String password    = args[3];

        String ldifFie     = args[4];

        

        ld  = new LDAPConnection();

        try {

            FileInputStream fis = new FileInputStream( ldifFie );

            ld.connect( ldapHost, ldapPort);

            // bind to the server

            ld.bind( ldapVersion, loginDN, password.getBytes("UTF8") );

            lburpc= new LburpClient();

            System.out.println("\t\t Starting LburpOperation \n");

            lburpc.StartLburpOperation(ld,fis);    

            System.out.println("\n");

        }

        catch (Exception e) {

            System.err.println("Exception:" + e.toString());

            System.exit (1);

        }

        return;        

    }    

    

}