/*******************************************************************************

 * $Novell: ListAttributeSchema.java,v 1.6 2003/01/23 16:27:28 $

 * Copyright (c) 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         ListAttributeSchema.java

 * $description:  ListAttributeSchema.java lists all the attribute names and

 *                the properties of each atttibute.

 ******************************************************************************/

package schema;



import com.novell.ldap.LDAPAttributeSchema;

import com.novell.ldap.LDAPConnection;

import com.novell.ldap.LDAPSchema;



import java.util.Arrays;

import java.util.ArrayList;

import java.util.Enumeration;



import java.awt.BorderLayout;

import java.awt.Button;

import java.awt.event.ActionEvent;

import java.awt.event.ActionListener;

import java.awt.List;

import java.awt.Panel;

import java.awt.TextArea;



public class ListAttributeSchema extends Panel implements ActionListener

{

    private String    attrName ;

    private String    attrNames[];

    private ArrayList al = new ArrayList();

    private Button    exit, properties;

    private List      attrList;

    private TextArea  textarea;

    private LDAPConnection connection;

    private LDAPSchema schema;

    private static final int USER_APPLICATIONS      = 0x00;

    private static final int DIRECTORY_OPERATION    = 0x01;

    private static final int DISTRIBUTED_OPERATION  = 0x02;

    private static final int DSA_OPERATION          = 0x03;





    public ListAttributeSchema( LDAPConnection conn ) {

        connection = conn;

    }



    public void init() {

        int i;

        LDAPAttributeSchema nextItem;



        try {

            // get schema



            schema = connection.fetchSchema( connection.getSchemaDN() );

            // get enumeration of attribute schema definitions

            Enumeration AttributeSchema = schema.getAttributeSchemas();

            // get all the attirbute names

            while (AttributeSchema.hasMoreElements()) {

                nextItem = (LDAPAttributeSchema)AttributeSchema.nextElement();

                String[] names = nextItem.getNames();

                for (i=0; i< names.length; i++)

                    al.add(names[i]);

            }

        }

        catch(Exception e ) {

            System.out.println( "\nError: " + e.toString() );

        }



        // check if al is empty

        if ( al.isEmpty() ) {

            System.out.println("\nError in ListAttributeSchema.java: "

                                 + "failed to get attribute schema.");

            System.exit(1);

        }



        // sort attribute names into order of A-Z, a-z

        attrNames = new String[al.size()];

        for ( i = 0; i < al.size(); i++ )

            attrNames[i] = (String)al.get(i);

        Arrays.sort(attrNames);



        // create a list with 30 items visible,

        // allow only single selection

        attrList = new List( 31, false );

        // add all attribute names to the list

        for ( i = 0; i < attrNames.length; i++ )

            attrList.add( attrNames[i] );

        add( attrList, BorderLayout.WEST );



        // create 'exit' button

        exit =  new Button ( "Exit" );

        exit.addActionListener( this );

        add( exit );



        // create 'Submit' button

        properties =  new Button ( "List>" );

        properties.addActionListener( this );

        add( properties );



        // create a text area of 30 lines and 68 colums,

        // users are not be able to edit attribute properties.

        textarea = new TextArea( 30, 68 );

        textarea.setEditable( false );

        add( textarea, BorderLayout.EAST );

    }



    public void actionPerformed( ActionEvent e ) {



        int i;



        if ( e.getSource() == exit )

            System.exit( 0 );



        // get the selected attribute name, or use default selection in case

        // users click 'Submit' button befor selecting an attribute name

        if ( (attrName = attrList.getSelectedItem() ) == null)

            attrName = attrNames[ 0 ]; // default selection;



        // get the attribute schema

        LDAPAttributeSchema attrSchema = schema.getAttributeSchema( attrName );

        if ( attrSchema == null ) {

            System.err.println("There is no such attribute: " + attrName );

            System.exit( 1 );

        }



        // display the attribute properties

        String[] names = attrSchema.getNames();

        textarea.append("name: ");

        if (names != null && names.length > 0){

            textarea.append(names[0]);

        }

        for (i=1; i<names.length; i++){

            textarea.append(", " + names[i]);

        }

        textarea.append("\n");



        textarea.append("properties:\n");

        // attribute ID

        textarea.append("    ID:\n");

        textarea.append("        " + attrSchema.getID() + "\n");

        // attribute value

        textarea.append("    value:\n");

        String value = attrSchema.toString();

        // breakup the line if it's too long

        int len = value.length();

        for ( i = 0; i < len; i += 70) {

            int lastIndex = ( i + 70 ) > len ? len : ( i + 70 );

            textarea.append("        " + value.substring(i, lastIndex) + "\n");

        }

        // attribute description

        textarea.append("    description:\n");

        textarea.append("        " + attrSchema.getDescription() + "\n");

        // attribute qualifiers

        Enumeration qnames = attrSchema.getQualifierNames();

        String qualifierName;

        String qualifierValues[];

        textarea.append("    qualifier names and values:\n" );

        if (qnames.hasMoreElements()) {

            while (qnames.hasMoreElements()) {

                qualifierName = ( String )qnames.nextElement();

                qualifierValues = attrSchema.getQualifier( qualifierName );

                for ( i=0; i<qualifierValues.length; i++ ) {

                    textarea.append("        " + qualifierName + ": "

                                                  + qualifierValues[i] + "\n");

                }

            }

        }

        else

            textarea.append("        no\n");

        // attribute syntax

        textarea.append("    syntax string:\n");

        textarea.append("        " + attrSchema.getSyntaxString() + "\n");

        // attribute usage

        textarea.append("    usage: \n");

        int usage = attrSchema.getUsage();

        switch( usage ) {

            case USER_APPLICATIONS:

                    textarea.append("        USER_APPLICATIONS\n");

                    break;

            case DIRECTORY_OPERATION:

                    textarea.append("        DIRECTORY_OPERATION\n");

                    break;

            case DISTRIBUTED_OPERATION:

                    textarea.append("        DISTRIBUTED_OPERATION\n");

                    break;

            case DSA_OPERATION:

                    textarea.append("        DSA_OPERATION\n");

                    break;

            default:

        }

        // has super attributes ?

        textarea.append("    has superior attribute?\n");

        textarea.append( (attrSchema.getSuperior() != null)?

                         "        yes\n": "        no\n");

        // has equality matching rule ?

        textarea.append("    has equality matching rule?\n");

        textarea.append(

            (attrSchema.getEqualityMatchingRule() != null)?

                         "        yes\n": "        no\n");

        // has ordering matching rule ?

        textarea.append("    has ordering matching rule?\n");

        textarea.append( (attrSchema.getOrderingMatchingRule()

                           != null)? "        yes\n": "        no\n");

        // has substring matching rule ?

        textarea.append("    has substring matching rule?\n");

        textarea.append( (attrSchema.getSubstringMatchingRule()

                           != null)? "        yes\n": "        no\n");

        // is a collective attribute ?

        textarea.append("    is a collective attribute?\n");

        textarea.append(attrSchema.isCollective()?

                        "        yes\n": "        no\n");

        // is a single valued attribute ?

        textarea.append("    is a single valued attribute?\n");

        textarea.append(attrSchema.isSingleValued()?

                        "        yes\n": "        no\n");

        // is a modifiabale attribute ?

        textarea.append("    is a modifiable attribute?\n");

        textarea.append(attrSchema.isUserModifiable()?

                        "        yes\n": "        no\n");



        textarea.append("\n");

    }

}





