/*******************************************************************************

 * $Novell: ListObjectClassSchema.java,v 1.4 2002/12/06 19:29:45 $

 * Copyright (c) 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         ListObjectClassSchema.java

 * $description:  ListObjectClassSchema.java lists all the object class names

 *                and the properties of each object class.

 ******************************************************************************/

package schema;



import com.novell.ldap.LDAPConnection;

import com.novell.ldap.LDAPObjectClassSchema;

import com.novell.ldap.LDAPSchema;



import java.util.Arrays;

import java.util.ArrayList;

import java.util.Enumeration;



import java.awt.BorderLayout;

import java.awt.Button;

import java.awt.event.ActionEvent;

import java.awt.event.ActionListener;

import java.awt.Panel;

import java.awt.List;

import java.awt.TextArea;



public class ListObjectClassSchema extends Panel implements ActionListener

{

    private String    objClassName ;

    private String    objClassNames[];

    private Button    submit, exit;

    private List      objClassList;

    private TextArea  textarea;

    private ArrayList al = new ArrayList();

    private LDAPConnection c;

    private LDAPSchema schema;

    private static final int ABSTRACT   = 0x00;

    private static final int STRUCTURAL = 0x01;

    private static final int AUXILIARY  = 0x02;



    public ListObjectClassSchema( LDAPConnection conn ) {

        c = conn;

    }



    public void init() {

        int i;

        LDAPObjectClassSchema nextItem = null;



        try {

            schema = c.fetchSchema(c.getSchemaDN());

            Enumeration OCSchema = schema.getObjectClassSchemas();

            while (OCSchema.hasMoreElements()) {

                nextItem = (LDAPObjectClassSchema)OCSchema.nextElement();

                String[] names = nextItem.getNames();

                for (i=0; i< names.length; i++)

                    al.add(names[i]);

            }

        }

        catch(Exception e ) {

            System.out.println( "Error: " + e.toString() );

        }



        // check if al is empty

        if ( al.isEmpty() ) {

            System.out.println("\nError in ListObjectClassSchema.java: "

                                + "failed to get object class schema.");

            System.exit(1);

        }



        // sort object class names

        objClassNames = new String [al.size()];

        for ( i = 0; i < al.size(); i++ )

            objClassNames[i] = (String) al.get(i);

        Arrays.sort( objClassNames );



        // create a list with 30 items visible

        // allow single selection

        objClassList = new List( 31, false );

        // add all object class names to the list

        for ( i = 0; i < objClassNames.length; i++ )

            objClassList.add( objClassNames[ i ] );

        add( objClassList, BorderLayout.WEST );



        // create 'exit' button

        exit =  new Button ( "Exit" );

        exit.addActionListener( this );

        add( exit );



        // create 'Submit' button

        submit =  new Button ( "List>" );

        submit.addActionListener( this );

        add( submit );



        // create a text area of 30 lines and 68 colums,

        // users are unable to edit object class properties

        textarea = new TextArea(  30, 68 );

        textarea.setEditable( false );

        add( textarea, BorderLayout.EAST );

    }



    public void actionPerformed( ActionEvent e)

    {

        int i;



        if ( e.getSource() == exit )

            System.exit( 0 );



        // get the selected object class name, or use default selection in case

        // users click 'Properties' button befor select an object class name

        if ( (objClassName = objClassList.getSelectedItem()) == null)

            objClassName = objClassNames[ 0 ];



        // get the object class name's schema

        LDAPObjectClassSchema objClassSchema =

                                schema.getObjectClassSchema( objClassName );

        if ( objClassSchema == null ) {

            System.err.println("There is no such object class: "+objClassName );

            System.exit( 1 );

        }



        // display the attribute properties

        String[] names = objClassSchema.getNames();

        textarea.append("name: ");

        if (names != null && names.length > 0){

            textarea.append(names[0]);

        }

        for (i=1; i<names.length; i++){

            textarea.append(", " + names[i]);

        }

        textarea.append("\n");



        textarea.append("properties:\n");

        // object class Id

        textarea.append("    ID:\n");

        textarea.append("        " + objClassSchema.getID() + "\n");

        // object class value

        textarea.append("    value:\n");

        String value = objClassSchema.toString();

        // breakup the line if it's too long

        int len = value.length();

        for ( i = 0; i < len; i += 70) {

            int lastIndex = ( i + 70 ) > len ? len : i + 70;

            textarea.append("        " + value.substring(i, lastIndex) + "\n");

        }

        // object class description

        textarea.append("    description:\n");

        textarea.append("        " + objClassSchema.getDescription() + "\n");

        // object class qualifiers

        Enumeration qnames = objClassSchema.getQualifierNames();

        String qualifierName;

        String qualifierValues[];

        textarea.append("    qualifier names and values:\n" );

        if ( qnames.hasMoreElements()) {

            while (qnames.hasMoreElements()) {

                qualifierName = ( String )qnames.nextElement();

                qualifierValues = objClassSchema.getQualifier( qualifierName );

                for ( i = 0; i < qualifierValues.length; i++ )

                    textarea.append("        " + qualifierName + ": "

                                                  + qualifierValues[i] + "\n");

            }

        }

        else

            textarea.append("        no\n");

        // object class' super classes

        textarea.append("    super class(es):\n");

        String supClasses[] = objClassSchema.getSuperiors();

        if ( supClasses != null ) {

            Arrays.sort( supClasses );

            for ( i = 0; i < supClasses.length; i++)

                textarea.append("        " + supClasses[i] + "\n");

        }

        else

            textarea.append("        no\n");

        // object class' type

        textarea.append("    Type:\n");

        int usage = objClassSchema.getType();

        switch( usage ) {

           case ABSTRACT  : textarea.append("        ABSTRACT\n");

                            break;

           case STRUCTURAL: textarea.append("        STRUCTURAL\n");

                            break;

           case AUXILIARY : textarea.append("        AUXILIARY\n");

                            break;

           default:

        }

        // object class' required attribute(s)

        String requiredAttrs[] = objClassSchema.getRequiredAttributes();

        textarea.append("    required attribute(s):");

            textarea.append("\n");

        if ( requiredAttrs != null ) {

            Arrays.sort( requiredAttrs );

            for ( i = 0; i < requiredAttrs.length; i++) {

                textarea.append("        " + requiredAttrs[i]);

                    textarea.append("\n");

            }

        }

        else

            textarea.append("        no\n");

        // object class' optional attribute(s)

        String optionalAttrs[] = objClassSchema.getOptionalAttributes();

        textarea.append("    optional attribute(s):");

        textarea.append("\n");

        if ( optionalAttrs != null ) {

            Arrays.sort( optionalAttrs );

            for ( i = 0; i < optionalAttrs.length; i++) {

                textarea.append("        " + optionalAttrs[i]);

                    textarea.append("\n");

            }

        }

        else

            textarea.append("        no\n");



        textarea.append("\n");

    }

}

