/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.DataAttribute;
import com.novell.sql.ISAMUtil;
import com.novell.sql.ValueChar;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;

class DataAttr_ObjectAcl
extends DataAttribute {
    protected static final int SPLIT_ID_WHOLE = 0;
    protected static final int SPLIT_ID_ATTRIBUTE = 1;
    protected static final int SPLIT_ID_TRUSTEE = 2;
    protected static final int SPLIT_ID_PRIVILEGES = 3;
    protected static final int SPLIT_ID_SUPERVISOR = 4;
    protected static final int SPLIT_ID_BROWSE = 5;
    protected static final int SPLIT_ID_CREATE = 6;
    protected static final int SPLIT_ID_DELETE = 7;
    protected static final int SPLIT_ID_RENAME = 8;
    protected static final int SPLIT_ID_COMPARE = 9;
    protected static final int SPLIT_ID_READ = 10;
    protected static final int SPLIT_ID_WRITE = 11;
    protected static final int SPLIT_ID_ADDSELF = 12;
    protected static final int SPLIT_ID_SCOPE = 13;
    protected static final int PRIV_ENTRY_BROWSE = 1;
    protected static final int PRIV_ENTRY_ADD = 2;
    protected static final int PRIV_ENTRY_DELETE = 4;
    protected static final int PRIV_ENTRY_RENAME = 8;
    protected static final int PRIV_ENTRY_SUPERVISOR = 16;
    protected static final int PRIV_ATTR_COMPARE = 1;
    protected static final int PRIV_ATTR_READ = 2;
    protected static final int PRIV_ATTR_WRITE = 4;
    protected static final int PRIV_ATTR_ADDSELF = 8;
    protected static final int PRIV_ATTR_SUPERVISOR = 32;

    protected DataAttr_ObjectAcl(Attribute attribute) {
        if (attribute != null) {
            try {
                this.m_valueCount = attribute.size();
                this.m_values = new Object[this.m_valueCount];
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                int n = 0;
                while (namingEnumeration.hasMore() && n < this.m_valueCount) {
                    this.m_values[n] = new AclValue((String)namingEnumeration.next());
                    ++n;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private String getStringValue(int n, int n2) {
        String string;
        AclValue aclValue = (AclValue)this.m_values[this.m_currentValue];
        switch (n) {
            case 0: {
                string = aclValue.m_value;
                break;
            }
            case 1: {
                string = aclValue.m_value.substring(aclValue.m_separator3Idx + 1);
                break;
            }
            case 2: {
                string = aclValue.m_value.substring(aclValue.m_separator2Idx + 1, aclValue.m_separator3Idx);
                break;
            }
            case 3: {
                string = aclValue.m_value.substring(0, aclValue.m_separator1Idx);
                break;
            }
            case 4: {
                if (aclValue.m_entryRightsFlag) {
                    if ((aclValue.m_privileges & 0x10) == 16) {
                        string = "true";
                        break;
                    }
                    string = "false";
                    break;
                }
                if ((aclValue.m_privileges & 0x20) == 32) {
                    string = "true";
                    break;
                }
                string = "false";
                break;
            }
            case 5: {
                if (aclValue.m_entryRightsFlag && (aclValue.m_privileges & 1) == 1) {
                    string = "true";
                    break;
                }
                string = "false";
                break;
            }
            case 6: {
                if (aclValue.m_entryRightsFlag && (aclValue.m_privileges & 2) == 2) {
                    string = "true";
                    break;
                }
                string = "false";
                break;
            }
            case 7: {
                if (aclValue.m_entryRightsFlag && (aclValue.m_privileges & 4) == 4) {
                    string = "true";
                    break;
                }
                string = "false";
                break;
            }
            case 8: {
                if (aclValue.m_entryRightsFlag && (aclValue.m_privileges & 8) == 8) {
                    string = "true";
                    break;
                }
                string = "false";
                break;
            }
            case 9: {
                if (!aclValue.m_entryRightsFlag && (aclValue.m_privileges & 1) == 1) {
                    string = "true";
                    break;
                }
                string = "false";
                break;
            }
            case 10: {
                if (!aclValue.m_entryRightsFlag && (aclValue.m_privileges & 2) == 2) {
                    string = "true";
                    break;
                }
                string = "false";
                break;
            }
            case 11: {
                if (!aclValue.m_entryRightsFlag && (aclValue.m_privileges & 4) == 4) {
                    string = "true";
                    break;
                }
                string = "false";
                break;
            }
            case 12: {
                if (!aclValue.m_entryRightsFlag && (aclValue.m_privileges & 8) == 8) {
                    string = "true";
                    break;
                }
                string = "false";
                break;
            }
            case 13: {
                string = aclValue.m_value.substring(aclValue.m_separator1Idx + 1, aclValue.m_separator2Idx);
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    protected Object getData(int n, int n2) {
        return new ValueChar(this.getStringValue(n, n2));
    }

    protected Object getData(int n) {
        return this.getData(n, this.m_currentValue);
    }

    protected int Compare(int n, int n2, DataAttribute dataAttribute, int n3, int n4) {
        String string = this.getStringValue(n2, n);
        String string2 = ((DataAttr_ObjectAcl)dataAttribute).getStringValue(n4, n3);
        return ISAMUtil.compareIgnoreCase(string, string2);
    }

    class AclValue {
        int m_privileges;
        int m_separator1Idx;
        int m_separator2Idx;
        int m_separator3Idx;
        boolean m_entryRightsFlag;
        String m_value;

        AclValue(String string) {
            this.m_value = string;
            this.m_separator1Idx = string.indexOf(35);
            this.m_separator2Idx = string.indexOf(35, this.m_separator1Idx + 1);
            this.m_separator3Idx = string.lastIndexOf(35);
            this.m_privileges = Integer.parseInt(string.substring(0, this.m_separator1Idx));
            this.m_entryRightsFlag = string.substring(this.m_separator3Idx + 1).equalsIgnoreCase("[Entry Rights]");
        }
    }
}

