/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.ISAMUtil;
import com.novell.sql.ValueChar;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;

class DataAttribute {
    int m_valueCount;
    int m_currentValue;
    int m_placeValue;
    Object[] m_values;

    protected DataAttribute() {
        this.m_valueCount = 0;
        this.m_currentValue = 0;
        this.m_placeValue = 0;
        this.m_values = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DataAttribute(Attribute attribute) {
        if (attribute == null) {
            this.m_valueCount = 0;
            this.m_currentValue = 0;
            this.m_values = null;
            return;
        }
        try {
            this.m_valueCount = attribute.size();
            this.m_currentValue = 0;
            this.m_values = new Object[this.m_valueCount];
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            int n = 0;
            while (namingEnumeration.hasMore()) {
                if (n >= this.m_valueCount) {
                    return;
                }
                Object obj = namingEnumeration.next();
                try {
                    this.m_values[n] = new ValueChar((String)obj);
                }
                catch (ClassCastException classCastException) {
                    this.m_values[n] = new ValueChar(obj.toString());
                }
                ++n;
            }
            return;
        }
        catch (NamingException namingException) {
            this.m_valueCount = 0;
            this.m_currentValue = 0;
            this.m_values = null;
            return;
        }
    }

    protected int Compare(int n, int n2, DataAttribute dataAttribute, int n3, int n4) {
        String string = ((ValueChar)this.getData(n2, n)).getString();
        String string2 = ((ValueChar)dataAttribute.getData(n4, n3)).getString();
        return ISAMUtil.compareIgnoreCase(string, string2);
    }

    protected boolean incrementRowCounter() {
        ++this.m_currentValue;
        if (this.m_currentValue >= this.m_valueCount) {
            this.m_currentValue = 0;
            return false;
        }
        return true;
    }

    protected void resetRowCounter() {
        this.m_currentValue = 0;
    }

    protected int setRowCounter(int n) {
        int n2;
        if (this.m_placeValue == 0) {
            n2 = n;
            this.m_currentValue = 0;
        } else {
            this.m_currentValue = n / this.m_placeValue;
            n2 = n % this.m_placeValue;
        }
        return n2;
    }

    protected int setPlaceValue(int n) {
        int n2;
        if (this.m_valueCount < 2) {
            this.m_placeValue = 0;
            n2 = n;
        } else {
            this.m_placeValue = n;
            n2 = n * this.m_valueCount;
        }
        return n2;
    }

    protected Object getData(int n) {
        return this.m_values[this.m_currentValue];
    }

    protected Object getData(int n, int n2) {
        return this.m_values[n2];
    }

    protected int getCurrentValueIndex() {
        return this.m_currentValue;
    }

    protected int getValueCount() {
        return this.m_valueCount;
    }
}

