/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.service.ndssdk.jndi.ldap.ext.GetEffectiveRightsRequest;
import com.novell.service.ndssdk.jndi.ldap.ext.GetEffectiveRightsResponse;
import com.novell.service.ndssdk.jndi.ldap.ext.LdapRights;
import com.novell.sql.ColumnInfo;
import com.novell.sql.DRDBConstants;
import com.novell.sql.DataColumn;
import com.novell.sql.DataTable;
import com.novell.sql.Errors;
import com.novell.sql.ISAMColumnDef;
import com.novell.sql.ISAMUtil;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.LdapIsam;
import com.novell.sql.NDSAttrName;
import com.novell.sql.NDSEntry;
import com.novell.sql.NDSRestriction;
import com.novell.sql.SortedHashtable;
import com.novell.sql.StringRef;
import com.novell.sql.TableInfo;
import com.novell.sql.Value;
import com.novell.sql.ValueBit;
import com.novell.sql.ValueChar;
import com.novell.sql.ValueInteger;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.LdapContext;

class EffectiveRightsDataTable
extends DataTable
implements LDAPSQLExceptionCodes,
DRDBConstants {
    private static final int ENTRY_RIGHTS_FLAG = Integer.MIN_VALUE;
    Vector m_objectNameRestrictions = null;
    Vector m_objectContextRestrictions = null;
    Vector m_objectClassRestrictions = null;
    Vector m_trusteeNameRestrictions = null;
    Vector m_trusteeContextRestrictions = null;
    Vector m_trusteeClassRestrictions = null;
    Vector m_attributeNameRestrictions = null;
    Hashtable m_attrNameLists = new Hashtable(10);
    int m_trusteeCount = 0;
    NDSEntry[] m_trustees = null;
    int m_objectCount = 0;
    NDSEntry[] m_objects = null;
    int m_totalAttributeCount = 0;
    int m_currentEntry;
    int m_currentObject;
    int m_currentTrustee;
    int m_currentAttribute;

    protected EffectiveRightsDataTable(String string, TableInfo tableInfo) {
        super(string, tableInfo);
        this.m_currentPosition = -1;
        this.m_currentObject = 0;
        this.m_currentTrustee = 0;
        this.m_currentAttribute = 0;
    }

    protected void rewind() {
        this.m_currentPosition = -1;
    }

    public int getPosition() {
        return this.m_currentPosition;
    }

    protected boolean nextRecord() {
        boolean bl = true;
        if (this.m_currentPosition == -1) {
            if (this.m_objectCount == 0 || this.m_trusteeCount == 0 || this.m_totalAttributeCount == 0) {
                bl = false;
            } else {
                this.m_currentObject = 0;
                this.m_currentTrustee = 0;
                this.m_currentAttribute = 0;
            }
        } else {
            ++this.m_currentAttribute;
            if (this.m_currentAttribute >= this.m_objects[this.m_currentObject].getAttributeCount()) {
                this.m_currentAttribute = 0;
                ++this.m_currentTrustee;
                if (this.m_currentTrustee >= this.m_trusteeCount) {
                    this.m_currentTrustee = 0;
                    ++this.m_currentObject;
                    if (this.m_currentObject >= this.m_objectCount) {
                        bl = false;
                    }
                }
            }
        }
        this.m_currentPosition = bl ? ++this.m_currentPosition : -1;
        return bl;
    }

    public boolean position(int n) {
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.m_objectCount) {
            if (n <= this.m_objects[n2].lastRowPosition) break;
            ++n2;
        }
        if (n2 >= this.m_objectCount) {
            bl = false;
        } else {
            this.m_currentObject = n2;
            int n3 = n2 > 0 ? n - this.m_objects[n2 - 1].lastRowPosition : n;
            this.m_currentTrustee = n3 / this.m_objects[n2].getAttributeCount();
            this.m_currentAttribute = n3 % this.m_objects[n2].getAttributeCount();
            this.m_currentPosition = n;
        }
        return bl;
    }

    protected Object getData(DataColumn dataColumn) {
        Value value = null;
        int n = this.m_objects[this.m_currentObject].rights[this.m_currentTrustee][this.m_currentAttribute];
        switch (dataColumn.getSplitIndex()) {
            case 0: {
                value = new ValueChar(this.m_objects[this.m_currentObject].getName());
                break;
            }
            case 1: {
                value = new ValueChar(this.m_objects[this.m_currentObject].getFullName());
                break;
            }
            case 2: {
                value = new ValueChar(this.m_objects[this.m_currentObject].getContextName());
                break;
            }
            case 3: {
                value = new ValueChar(this.m_objects[this.m_currentObject].getClassName());
                break;
            }
            case 4: {
                value = new ValueChar(this.m_trustees[this.m_currentTrustee].getName());
                break;
            }
            case 5: {
                value = new ValueChar(this.m_trustees[this.m_currentTrustee].getFullName());
                break;
            }
            case 6: {
                value = new ValueChar(this.m_trustees[this.m_currentTrustee].getContextName());
                break;
            }
            case 7: {
                value = new ValueChar(this.m_trustees[this.m_currentTrustee].getClassName());
                break;
            }
            case 8: {
                value = new ValueChar(this.m_objects[this.m_currentObject].getAttributeName(this.m_currentAttribute));
                break;
            }
            case 9: {
                value = new ValueInteger(n & Integer.MAX_VALUE);
                break;
            }
            case 10: {
                int n2 = (n & Integer.MIN_VALUE) == Integer.MIN_VALUE ? n & Integer.MAX_VALUE & 0x10 : n & 0x20;
                if (n2 != 0) {
                    value = new ValueBit(1);
                    break;
                }
                value = new ValueBit(0);
                break;
            }
            case 11: {
                int n3 = (n & Integer.MIN_VALUE) == Integer.MIN_VALUE ? n & Integer.MAX_VALUE & 1 : 0;
                if (n3 != 0) {
                    value = new ValueBit(1);
                    break;
                }
                value = new ValueBit(0);
                break;
            }
            case 12: {
                int n4 = (n & Integer.MIN_VALUE) == Integer.MIN_VALUE ? n & Integer.MAX_VALUE & 2 : 0;
                if (n4 != 0) {
                    value = new ValueBit(1);
                    break;
                }
                value = new ValueBit(0);
                break;
            }
            case 13: {
                int n5 = (n & Integer.MIN_VALUE) == Integer.MIN_VALUE ? n & 4 : 0;
                if (n5 != 0) {
                    value = new ValueBit(1);
                    break;
                }
                value = new ValueBit(0);
                break;
            }
            case 14: {
                int n6 = (n & Integer.MIN_VALUE) == Integer.MIN_VALUE ? n & Integer.MAX_VALUE & 8 : 0;
                if (n6 != 0) {
                    value = new ValueBit(1);
                    break;
                }
                value = new ValueBit(0);
                break;
            }
            case 15: {
                int n7 = (n & Integer.MIN_VALUE) != Integer.MIN_VALUE ? n & 1 : 0;
                if (n7 != 0) {
                    value = new ValueBit(1);
                    break;
                }
                value = new ValueBit(0);
                break;
            }
            case 16: {
                int n8 = (n & Integer.MIN_VALUE) != Integer.MIN_VALUE ? n & 2 : 0;
                if (n8 != 0) {
                    value = new ValueBit(1);
                    break;
                }
                value = new ValueBit(0);
                break;
            }
            case 17: {
                int n9 = (n & Integer.MIN_VALUE) != Integer.MIN_VALUE ? n & 4 : 0;
                if (n9 != 0) {
                    value = new ValueBit(1);
                    break;
                }
                value = new ValueBit(0);
                break;
            }
            case 18: {
                int n10 = (n & Integer.MIN_VALUE) != Integer.MIN_VALUE ? n & 8 : 0;
                if (n10 != 0) {
                    value = new ValueBit(1);
                    break;
                }
                value = new ValueBit(0);
                break;
            }
        }
        return value;
    }

    private String fixWildCards(String string) {
        string = string.replace('?', '*');
        string = string.replace('%', '*');
        char[] cArray = new char[string.length()];
        int n = 0;
        char c = ' ';
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 != '*') {
                cArray[n] = c2;
                ++n;
                c = c2;
            } else if (c != c2) {
                cArray[n] = c2;
                ++n;
                c = c2;
            }
            ++n2;
        }
        string = new String(cArray, 0, n);
        return string;
    }

    private String getFilterClassComponent(String string) {
        String string2 = this.fixWildCards(string);
        string2 = "objectClass=" + string2;
        return string2;
    }

    private String getFilterNameComponent(String string) {
        int n = string.indexOf(44);
        String string2 = n != -1 ? string.substring(0, n) : string;
        string2 = this.fixWildCards(string2);
        return string2;
    }

    protected String buildFilter(Vector vector, Vector vector2) {
        NDSRestriction nDSRestriction;
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = vector.size();
        n = 0;
        int n3 = 0;
        while (n3 < n2) {
            nDSRestriction = (NDSRestriction)vector.elementAt(n3);
            if (nDSRestriction.getOpCode() == 1 || nDSRestriction.getOpCode() == 9) {
                string = string + "(" + this.getFilterNameComponent(nDSRestriction.getValue()) + ")";
                ++n;
            }
            ++n3;
        }
        if (n > 1) {
            string = "|" + string;
        }
        n2 = vector2.size();
        n = 0;
        n3 = 0;
        while (n3 < n2) {
            nDSRestriction = (NDSRestriction)vector2.elementAt(n3);
            if (nDSRestriction.getOpCode() == 1 || nDSRestriction.getOpCode() == 9) {
                string2 = string2 + this.getFilterClassComponent(nDSRestriction.getValue()) + ")";
                if (n == 0 && string.length() != 0) {
                    string = "&(" + string + ")";
                }
                ++n;
            }
            ++n3;
        }
        if (n > 1) {
            string2 = "|" + string2;
            if (string.length() != 0) {
                string2 = "(" + string2 + ")";
            }
        }
        if (string2.length() == 0 && string.length() == 0) {
            return "objectClass=*";
        }
        return string + string2;
    }

    private void getRestrictions() {
        TableInfo tableInfo = this.getTableInfo();
        int n = tableInfo.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            ISAMColumnDef iSAMColumnDef = tableInfo.getColumnDef(n2);
            Vector vector = iSAMColumnDef.getRestrictions();
            if (iSAMColumnDef.getColumnName().equalsIgnoreCase("ObjectName")) {
                this.m_objectNameRestrictions = iSAMColumnDef.getRestrictions();
            } else if (iSAMColumnDef.getColumnName().equalsIgnoreCase("ObjectContext")) {
                this.m_objectContextRestrictions = iSAMColumnDef.getRestrictions();
            } else if (iSAMColumnDef.getColumnName().equalsIgnoreCase("ObjectClass")) {
                this.m_objectClassRestrictions = iSAMColumnDef.getRestrictions();
            } else if (iSAMColumnDef.getColumnName().equalsIgnoreCase("TrusteeName")) {
                this.m_trusteeNameRestrictions = iSAMColumnDef.getRestrictions();
            } else if (iSAMColumnDef.getColumnName().equalsIgnoreCase("TrusteeContext")) {
                this.m_trusteeContextRestrictions = iSAMColumnDef.getRestrictions();
            } else if (iSAMColumnDef.getColumnName().equalsIgnoreCase("TrusteeClass")) {
                this.m_trusteeClassRestrictions = iSAMColumnDef.getRestrictions();
            } else if (iSAMColumnDef.getColumnName().equalsIgnoreCase("Attribute")) {
                this.m_attributeNameRestrictions = iSAMColumnDef.getRestrictions();
            }
            ++n2;
        }
    }

    private int getContext(String string, StringRef stringRef) {
        int n;
        int n2 = (string = this.fixWildCards(string)).lastIndexOf(42);
        if (n2 == 0 && string.charAt(1) != ',') {
            stringRef.value = string.substring(1);
            n = 2;
        } else if (n2 != -1) {
            String string2 = string.substring(n2 + 1);
            stringRef.value = (n2 = string2.indexOf(44)) != -1 ? string2.substring(n2 + 1) : "";
            n = 2;
        } else {
            stringRef.value = string;
            n = 1;
        }
        return n;
    }

    private boolean checkAttributeName(String string) {
        boolean bl;
        int n = this.m_attributeNameRestrictions.size();
        if (string.equalsIgnoreCase("NDS")) {
            bl = false;
        } else if (n == 0) {
            bl = true;
        } else {
            bl = false;
            int n2 = 0;
            while (n2 < n) {
                NDSRestriction nDSRestriction = (NDSRestriction)this.m_attributeNameRestrictions.elementAt(n2);
                if (ISAMUtil.PatternMatch(false, string, nDSRestriction.getValue(), false)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    private NDSEntry checkAndCreateEntry(SearchResult searchResult, String string, NDSRestriction nDSRestriction, Vector vector, Vector vector2) throws NamingException {
        String string2 = "";
        NDSEntry nDSEntry = null;
        String string3 = searchResult.getName();
        if (string3.length() != 0) {
            boolean bl;
            boolean bl2;
            NDSRestriction nDSRestriction2;
            int n;
            int n2;
            String string4 = string.length() != 0 ? string3 + "," + string : string3;
            int n3 = string4.indexOf(44);
            if (n3 == -1) {
                string = null;
                string3 = string4;
            } else {
                string = string4.substring(n3 + 1);
                string3 = string4.substring(0, n3);
            }
            NamingEnumeration<?> namingEnumeration = searchResult.getAttributes().get("objectClass").getAll();
            boolean bl3 = false;
            block0: while (namingEnumeration.hasMore()) {
                string2 = (String)namingEnumeration.next();
                n2 = vector2.size();
                if (n2 == 0) {
                    bl3 = true;
                    break;
                }
                n = 0;
                while (n < n2) {
                    nDSRestriction2 = (NDSRestriction)vector2.elementAt(n);
                    if (ISAMUtil.PatternMatch(false, string2, nDSRestriction2.getValue(), false)) {
                        bl3 = true;
                        break block0;
                    }
                    ++n;
                }
            }
            if (!bl3) {
                return null;
            }
            n2 = vector.size();
            if (n2 == 0) {
                bl2 = true;
            } else {
                bl2 = false;
                n = 0;
                while (n < n2) {
                    nDSRestriction2 = (NDSRestriction)vector.elementAt(n);
                    if (ISAMUtil.PatternMatch(false, string3, nDSRestriction2.getValue(), false)) {
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl2) {
                return null;
            }
            if (nDSRestriction == null) {
                bl = true;
            } else {
                bl = false;
                if (ISAMUtil.PatternMatch(false, string, nDSRestriction.getValue(), false)) {
                    bl = true;
                }
            }
            if (!bl) {
                return null;
            }
            nDSEntry = new NDSEntry(string3, string, string2);
        }
        return nDSEntry;
    }

    protected void getTrustees(LdapContext ldapContext) throws NamingException {
        int n;
        NDSEntry nDSEntry;
        SearchResult searchResult;
        NamingEnumeration<SearchResult> namingEnumeration;
        String[] stringArray = new String[]{"objectClass"};
        SearchControls searchControls = new SearchControls();
        NDSEntry nDSEntry2 = null;
        NDSEntry nDSEntry3 = null;
        StringRef stringRef = new StringRef();
        this.m_trusteeCount = 0;
        searchControls.setCountLimit(0L);
        searchControls.setReturningAttributes(stringArray);
        String string = this.buildFilter(this.m_trusteeNameRestrictions, this.m_trusteeClassRestrictions);
        int n2 = this.m_trusteeContextRestrictions.size();
        if (n2 == 0) {
            searchControls.setSearchScope(2);
            namingEnumeration = ldapContext.search("", string, searchControls);
            while (namingEnumeration.hasMore()) {
                searchResult = namingEnumeration.next();
                nDSEntry = this.checkAndCreateEntry(searchResult, stringRef.value, null, this.m_trusteeNameRestrictions, this.m_trusteeClassRestrictions);
                if (nDSEntry == null) continue;
                if (nDSEntry3 == null) {
                    nDSEntry3 = nDSEntry2 = nDSEntry;
                } else {
                    nDSEntry2.setNext(nDSEntry);
                    nDSEntry2 = nDSEntry;
                }
                ++this.m_trusteeCount;
            }
        } else {
            n = 0;
            while (n < n2) {
                NDSRestriction nDSRestriction = (NDSRestriction)this.m_trusteeContextRestrictions.elementAt(n);
                int n3 = this.getContext(nDSRestriction.getValue(), stringRef);
                searchControls.setSearchScope(n3);
                namingEnumeration = ldapContext.search(stringRef.value, string, searchControls);
                while (namingEnumeration.hasMore()) {
                    searchResult = namingEnumeration.next();
                    nDSEntry = this.checkAndCreateEntry(searchResult, stringRef.value, nDSRestriction, this.m_trusteeNameRestrictions, this.m_trusteeClassRestrictions);
                    if (nDSEntry == null) continue;
                    if (nDSEntry3 == null) {
                        nDSEntry3 = nDSEntry2 = nDSEntry;
                    } else {
                        nDSEntry2.setNext(nDSEntry);
                        nDSEntry2 = nDSEntry;
                    }
                    ++this.m_trusteeCount;
                }
                ++n;
            }
        }
        this.m_trustees = new NDSEntry[this.m_trusteeCount];
        nDSEntry = nDSEntry3;
        n = 0;
        while (nDSEntry != null) {
            this.m_trustees[n] = nDSEntry;
            ++n;
            nDSEntry = nDSEntry.getNext();
        }
    }

    NDSAttrName[] getClassAttributes(LdapIsam ldapIsam, String string) {
        NDSAttrName nDSAttrName = null;
        NDSAttrName nDSAttrName2 = null;
        int n = 0;
        NDSAttrName[] nDSAttrNameArray = (NDSAttrName[])this.m_attrNameLists.get(string.toLowerCase());
        if (nDSAttrNameArray == null) {
            String string2;
            SortedHashtable sortedHashtable = ldapIsam.getTables();
            TableInfo tableInfo = (TableInfo)sortedHashtable.get(string.toLowerCase());
            int n2 = tableInfo.getColumnCount();
            int n3 = 0;
            while (n3 < n2) {
                ColumnInfo columnInfo = tableInfo.getColumnInfo(n3);
                string2 = columnInfo.getAttributeInfo().getName();
                if (this.checkAttributeName(string2)) {
                    if (nDSAttrName == null) {
                        nDSAttrName2 = nDSAttrName = new NDSAttrName(string2);
                    } else {
                        nDSAttrName2.setNext(new NDSAttrName(string2));
                        nDSAttrName2 = nDSAttrName2.getNext();
                    }
                    ++n;
                }
                n3 += columnInfo.getAttributeInfo().getColumnCount() - 1;
                ++n3;
            }
            string2 = "[All Attributes Rights]";
            if (this.checkAttributeName(string2)) {
                if (nDSAttrName == null) {
                    nDSAttrName2 = nDSAttrName = new NDSAttrName(string2);
                } else {
                    nDSAttrName2.setNext(new NDSAttrName(string2));
                    nDSAttrName2 = nDSAttrName2.getNext();
                }
                ++n;
            }
            if (this.checkAttributeName(string2 = "[Entry Rights]")) {
                if (nDSAttrName == null) {
                    nDSAttrName2 = nDSAttrName = new NDSAttrName(string2);
                } else {
                    nDSAttrName2.setNext(new NDSAttrName(string2));
                    nDSAttrName2 = nDSAttrName2.getNext();
                }
                ++n;
            }
            nDSAttrNameArray = new NDSAttrName[n];
            this.m_totalAttributeCount += n;
            n3 = 0;
            while (n3 < n) {
                nDSAttrNameArray[n3] = nDSAttrName;
                nDSAttrName = nDSAttrName.getNext();
                ++n3;
            }
            this.m_attrNameLists.put(string.toLowerCase(), nDSAttrNameArray);
        }
        return nDSAttrNameArray;
    }

    protected void createObjectEntries(LdapIsam ldapIsam) throws NamingException {
        int n;
        NDSEntry nDSEntry;
        SearchResult searchResult;
        NamingEnumeration<SearchResult> namingEnumeration;
        String[] stringArray = new String[]{"objectClass"};
        SearchControls searchControls = new SearchControls();
        NDSEntry nDSEntry2 = null;
        NDSEntry nDSEntry3 = null;
        StringRef stringRef = new StringRef();
        this.getRestrictions();
        this.getTrustees(ldapIsam.getRootContext());
        this.m_objectCount = 0;
        searchControls.setCountLimit(0L);
        searchControls.setReturningAttributes(stringArray);
        String string = this.buildFilter(this.m_objectNameRestrictions, this.m_objectClassRestrictions);
        int n2 = this.m_objectContextRestrictions.size();
        if (n2 == 0) {
            searchControls.setSearchScope(2);
            namingEnumeration = ldapIsam.getBaseContext().search("", string, searchControls);
            while (namingEnumeration.hasMore()) {
                searchResult = namingEnumeration.next();
                nDSEntry = this.checkAndCreateEntry(searchResult, ldapIsam.getBaseDN(), null, this.m_objectNameRestrictions, this.m_objectClassRestrictions);
                if (nDSEntry == null) continue;
                if (nDSEntry3 == null) {
                    nDSEntry3 = nDSEntry2 = nDSEntry;
                } else {
                    nDSEntry2.setNext(nDSEntry);
                    nDSEntry2 = nDSEntry;
                }
                ++this.m_objectCount;
            }
        } else {
            n = 0;
            while (n < n2) {
                NDSRestriction nDSRestriction = (NDSRestriction)this.m_objectContextRestrictions.elementAt(n);
                int n3 = this.getContext(nDSRestriction.getValue(), stringRef);
                searchControls.setSearchScope(n3);
                String string2 = stringRef.value.endsWith(ldapIsam.getBaseDN()) ? stringRef.value : ldapIsam.getBaseDN();
                namingEnumeration = ldapIsam.getRootContext().search(string2, string, searchControls);
                while (namingEnumeration.hasMore()) {
                    searchResult = namingEnumeration.next();
                    nDSEntry = this.checkAndCreateEntry(searchResult, string2, nDSRestriction, this.m_objectNameRestrictions, this.m_objectClassRestrictions);
                    if (nDSEntry == null) continue;
                    if (nDSEntry3 == null) {
                        nDSEntry3 = nDSEntry2 = nDSEntry;
                    } else {
                        nDSEntry2.setNext(nDSEntry);
                        nDSEntry2 = nDSEntry;
                    }
                    ++this.m_objectCount;
                }
                ++n;
            }
        }
        this.m_objects = new NDSEntry[this.m_objectCount];
        nDSEntry = nDSEntry3;
        n = 0;
        int n4 = -1;
        while (nDSEntry != null) {
            nDSEntry.setAttrNames(this.getClassAttributes(ldapIsam, nDSEntry.getClassName()));
            n4 = nDSEntry.lastRowPosition = n4 + this.m_trusteeCount * nDSEntry.getAttributeCount();
            nDSEntry.rights = new int[this.m_trusteeCount][nDSEntry.getAttributeCount()];
            this.readObjectRights(ldapIsam.getRootContext(), nDSEntry);
            this.m_objects[n] = nDSEntry;
            ++n;
            nDSEntry = nDSEntry.getNext();
        }
    }

    private void readObjectRights(LdapContext ldapContext, NDSEntry nDSEntry) {
        GetEffectiveRightsRequest getEffectiveRightsRequest = new GetEffectiveRightsRequest();
        getEffectiveRightsRequest.setEntryDN(nDSEntry.getFullName());
        int n = 0;
        while (n < this.m_trusteeCount) {
            getEffectiveRightsRequest.setTrusteeDN(this.m_trustees[n].getFullName());
            int n2 = nDSEntry.getAttributeCount();
            int n3 = 0;
            while (n3 < n2) {
                getEffectiveRightsRequest.setAttrName(nDSEntry.getAttributeName(n3));
                try {
                    GetEffectiveRightsResponse getEffectiveRightsResponse = (GetEffectiveRightsResponse)ldapContext.extendedOperation((ExtendedRequest)getEffectiveRightsRequest);
                    LdapRights ldapRights = getEffectiveRightsResponse.getRights();
                    nDSEntry.rights[n][n3] = ldapRights.getRights();
                    if (getEffectiveRightsRequest.getAttrName().equalsIgnoreCase("[Entry Rights]")) {
                        int[] nArray = nDSEntry.rights[n];
                        int n4 = n3;
                        nArray[n4] = nArray[n4] | Integer.MIN_VALUE;
                    }
                }
                catch (NamingException namingException) {
                    System.out.println(namingException);
                    System.out.println("Warning:[Novell][LDAP JDBC Driver] Could not get rights for attribute: " + getEffectiveRightsRequest.getAttrName());
                }
                catch (IOException iOException) {
                    System.out.print(iOException);
                    System.out.print("Warning:[Novell][LDAP JDBC Driver] Could not get rights for attribute: " + getEffectiveRightsRequest.getAttrName());
                }
                ++n3;
            }
            ++n;
        }
    }

    protected void createDataEntries(LdapIsam ldapIsam) throws SQLException {
        if (this.getDataEntries() == null) {
            this.createDataAttributeInfo();
            this.m_rowCount = 0;
            try {
                this.createObjectEntries(ldapIsam);
            }
            catch (NamingException namingException) {
                throw Errors.NamingtoSQLException(namingException, 21);
            }
        }
    }
}

