/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.LDAPDriverProperties;
import com.novell.sql.LDAPSQLConnection;
import com.novell.sql.LDAPSQLExceptionCodes;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;

public class LDAPDriver
implements Driver,
LDAPDriverProperties,
LDAPSQLExceptionCodes {
    protected static final int MAJOR_VERSION = 1;
    protected static final int MINOR_VERSION = 2;
    protected static final int SUB_RELEASE_VERSION = 1;
    private static final String JDBC_PROTOCOL_NAME = "JDBC";
    private static final String LDAP_PROTOCOL_NAME = "LDAP";
    private static LDAPDriver s_driverInst = new LDAPDriver();

    public Connection connect(String string, Properties properties) throws SQLException {
        Hashtable hashtable = this.parseURL(string, properties);
        if (null == hashtable) {
            throw Errors.sqlException(5);
        }
        return new LDAPSQLConnection(string, hashtable);
    }

    public boolean acceptsURL(String string) throws SQLException {
        return string.toUpperCase().startsWith("JDBC:LDAP");
    }

    public static void setLoggingDevice(PrintStream printStream) {
        DriverManager.setLogStream(printStream);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[3];
        Hashtable hashtable = this.parseURL(string, properties);
        driverPropertyInfoArray[0] = new DriverPropertyInfo("user", null);
        driverPropertyInfoArray[1] = new DriverPropertyInfo("password", null);
        driverPropertyInfoArray[2] = new DriverPropertyInfo("baseDN", null);
        if (hashtable != null) {
            String string2;
            driverPropertyInfoArray[0].value = string2 = (String)hashtable.get("user");
            driverPropertyInfoArray[2].value = string2 = (String)hashtable.get("baseDN");
        }
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 2;
    }

    public int getSubReleaseVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    Hashtable parseURL(String string, Properties properties) {
        String string2;
        String string3;
        Hashtable<String, String> hashtable = null;
        String string4 = string.substring(0, JDBC_PROTOCOL_NAME.length() + LDAP_PROTOCOL_NAME.length() + 2);
        if (!string4.equalsIgnoreCase("JDBC:LDAP:")) {
            return null;
        }
        int n = string.indexOf(";");
        String string5 = -1 == n ? string.substring(JDBC_PROTOCOL_NAME.length() + LDAP_PROTOCOL_NAME.length() + 2) : string.substring(JDBC_PROTOCOL_NAME.length() + LDAP_PROTOCOL_NAME.length() + 2, n);
        if (!string5.startsWith("//")) {
            return null;
        }
        int n2 = string5.indexOf(58);
        if (-1 == n2) {
            string3 = "DEFAULT";
            string2 = string5.substring(2);
        } else {
            string3 = string5.substring(n2 + 1);
            string2 = string5.substring(2, n2);
        }
        hashtable = new Hashtable<String, String>(10);
        hashtable.put("port", string3.trim());
        hashtable.put("host", string2.trim());
        while (-1 != n) {
            int n3 = string.indexOf(59, n + 1);
            String string6 = -1 != n3 ? string.substring(n + 1, n3) : string.substring(n + 1);
            int n4 = string6.indexOf(61);
            if (-1 != n4) {
                hashtable.put(string6.substring(0, n4).trim(), string6.substring(n4 + 1).trim());
            }
            n = n3;
        }
        if (properties != null) {
            String string7 = properties.getProperty("user");
            if (string7 != null && null == hashtable.get("user")) {
                hashtable.put("user", string7);
            }
            if ((string7 = properties.getProperty("password")) != null && null == hashtable.get("password")) {
                hashtable.put("password", string7);
            }
        }
        return hashtable;
    }

    static {
        DriverManager.setLogStream(null);
        try {
            DriverManager.registerDriver(s_driverInst);
        }
        catch (SQLException sQLException) {
            System.out.println("   " + sQLException.toString());
        }
    }
}

