/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.LDAPStatement;
import com.novell.sql.ObjectRef;
import com.novell.sql.SQLNodeSelect;
import com.novell.sql.SortTableRow;
import com.novell.sql.Value;
import java.sql.SQLException;

class SortTable {
    protected static final Value[] SENTINEL_MARKER = null;
    protected static final int A_BEFORE_B = -1;
    protected static final int B_BEFORE_A = 1;
    private LDAPStatement m_statement;
    private SQLNodeSelect m_sqlNodeSelect;
    protected int m_rowCount;
    protected SortTableRow sentinelRow;
    protected SortTableRow currentRow;
    protected SortTableRow rows;
    protected int tableCount;
    protected int keyCount;
    protected boolean[] descendingSortFlags;
    protected int aggregateCount;

    protected SortTable(LDAPStatement lDAPStatement, SQLNodeSelect sQLNodeSelect) {
        this.m_statement = lDAPStatement;
        this.m_sqlNodeSelect = sQLNodeSelect;
        this.rows = null;
        this.currentRow = null;
        this.m_rowCount = 0;
    }

    protected SortTableRow addRow() {
        if (this.rows == null) {
            this.rows = this.currentRow = new SortTableRow(this.keyCount, this.aggregateCount, this.tableCount);
        } else {
            this.currentRow = this.currentRow.next = new SortTableRow(this.keyCount, this.aggregateCount, this.tableCount);
        }
        ++this.m_rowCount;
        return this.currentRow;
    }

    protected void addSentinelRow() {
        this.currentRow.next = this.sentinelRow = new SortTableRow();
        this.currentRow = null;
    }

    protected void sort() throws SQLException {
        this.MergeSort();
    }

    private void MergeSort() throws SQLException {
        ObjectRef objectRef = new ObjectRef();
        SortTableRow sortTableRow = new SortTableRow();
        sortTableRow.next = this.rows;
        SortTableRow sortTableRow2 = this.sentinelRow;
        int n = 1;
        while (sortTableRow2 != sortTableRow.next) {
            SortTableRow sortTableRow3 = sortTableRow.next;
            SortTableRow sortTableRow4 = sortTableRow;
            while (sortTableRow3 != this.sentinelRow) {
                SortTableRow sortTableRow5 = sortTableRow2 = sortTableRow3;
                int n2 = 1;
                while (n2 < n) {
                    sortTableRow5 = sortTableRow5.next;
                    ++n2;
                }
                SortTableRow sortTableRow6 = sortTableRow5.next;
                sortTableRow5.next = this.sentinelRow;
                sortTableRow5 = sortTableRow6;
                n2 = 1;
                while (n2 < n) {
                    sortTableRow5 = sortTableRow5.next;
                    ++n2;
                }
                sortTableRow3 = sortTableRow5.next;
                sortTableRow5.next = this.sentinelRow;
                sortTableRow4.next = this.Merge(sortTableRow2, sortTableRow6, objectRef);
                sortTableRow4 = (SortTableRow)objectRef.object;
            }
            n += n;
        }
        this.rows = sortTableRow.next;
    }

    protected SortTableRow Merge(SortTableRow sortTableRow, SortTableRow sortTableRow2, ObjectRef objectRef) throws SQLException {
        SortTableRow sortTableRow3;
        SortTableRow sortTableRow4 = sortTableRow3 = new SortTableRow();
        while (true) {
            if (this.Compare(sortTableRow.keys, sortTableRow2.keys) == -1) {
                sortTableRow4.next = sortTableRow;
                sortTableRow4 = sortTableRow;
                sortTableRow = sortTableRow.next;
                if (sortTableRow2 != this.sentinelRow) continue;
                break;
            }
            sortTableRow4.next = sortTableRow2;
            sortTableRow4 = sortTableRow2;
            sortTableRow2 = sortTableRow2.next;
            if (sortTableRow == this.sentinelRow) break;
        }
        while (sortTableRow4.next != this.sentinelRow) {
            sortTableRow4 = sortTableRow4.next;
        }
        objectRef.object = sortTableRow4;
        return sortTableRow3.next;
    }

    private int Compare(Value[] valueArray, Value[] valueArray2) throws SQLException {
        int n;
        if (valueArray == SENTINEL_MARKER) {
            n = valueArray2 == SENTINEL_MARKER ? -1 : 1;
        } else if (valueArray2 == SENTINEL_MARKER) {
            n = -1;
        } else {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.keyCount) {
                Value value = valueArray[n3];
                Value value2 = valueArray2[n3];
                n2 = value == null && value2 == null ? 0 : (value == null ? 1 : (value2 == null ? -1 : value.compare(value2)));
                if (n2 != 0) break;
                ++n3;
            }
            n = n2 == 0 ? -1 : (!this.descendingSortFlags[n3] ? (n2 < 0 ? -1 : 1) : (n2 > 0 ? -1 : 1));
        }
        return n;
    }

    protected boolean nextRow() {
        boolean bl = true;
        if (this.currentRow == null) {
            this.currentRow = this.rows;
            if (this.currentRow == null) {
                bl = false;
            }
        } else {
            this.currentRow = this.currentRow.next;
            if (this.currentRow == this.sentinelRow) {
                bl = false;
            }
        }
        return bl;
    }

    protected boolean firstRow() {
        this.currentRow = this.rows;
        return this.currentRow != null;
    }

    protected Value getAggregateValue(int n) {
        return this.currentRow.getAggregateValue(n);
    }

    protected int[] getBookmarks() {
        boolean bl = true;
        if (this.currentRow == null) {
            return null;
        }
        return this.currentRow.getBookmarks();
    }

    protected void rewind() {
        this.currentRow = null;
    }

    protected SortTableRow getCurrentRow() {
        return this.currentRow;
    }
}

