/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.AttributeInfo;
import com.novell.sql.ColumnInfo;
import com.novell.sql.ColumnRef;
import com.novell.sql.ColumnRefVector;
import com.novell.sql.DataColumn;
import com.novell.sql.DataTable;
import com.novell.sql.Errors;
import com.novell.sql.ISAMColumnDef;
import com.novell.sql.ISAMTableDef;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.LdapIsam;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

class TableInfo
implements ISAMTableDef,
LDAPSQLExceptionCodes {
    private static final int INITIAL_COLUMN_VECTOR_SIZE = 50;
    private static final int CLASS_TYPE_STRUCTURAL = 1;
    private static final int CLASS_TYPE_ABSTRACT = 2;
    private static final int CLASS_TYPE_AUXILIARY = 3;
    private static final int CLASS_TYPE_NUMERICOID = 4;
    String m_name;
    String m_ldapClass;
    String m_description;
    ColumnRefVector m_columnRefs = new ColumnRefVector(50);
    Vector m_superClasses;
    int m_classType;
    boolean m_hasExpandedColumns;
    DataTable m_dataTable;

    protected TableInfo(DirContext dirContext, Hashtable hashtable) throws SQLException {
        this.m_superClasses = new Vector(10);
        this.m_hasExpandedColumns = false;
        this.m_dataTable = null;
        try {
            NamingEnumeration<?> namingEnumeration;
            Attributes attributes = dirContext.getAttributes("");
            this.m_ldapClass = (String)attributes.get("NAME").get();
            this.m_name = LdapIsam.translateTableName(this.m_ldapClass);
            Attribute attribute = attributes.get("DESC");
            this.m_description = attribute != null ? (String)attribute.get() : "";
            if (null != attributes.get("ABSTRACT")) {
                this.m_classType = 2;
            } else if (null != attributes.get("STRUCTURAL")) {
                this.m_classType = 1;
            } else if (null != attributes.get("AUXILIARY")) {
                this.m_classType = 3;
            } else if (null != attributes.get("NUMERICOID")) {
                this.m_classType = 4;
            } else {
                throw Errors.sqlException(16);
            }
            attribute = attributes.get("MUST");
            if (attribute != null) {
                namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMore()) {
                    this.addColumn((String)namingEnumeration.next(), hashtable, false);
                }
            }
            if ((attribute = attributes.get("MAY")) != null) {
                namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMore()) {
                    this.addColumn((String)namingEnumeration.next(), hashtable, true);
                }
            }
            if ((attribute = attributes.get("SUP")) != null) {
                namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMore()) {
                    this.m_superClasses.addElement(namingEnumeration.next());
                }
            }
        }
        catch (NamingException namingException) {
            throw Errors.NamingtoSQLException(namingException, 16);
        }
    }

    protected TableInfo(String string, String[] stringArray, Hashtable hashtable) {
        this.m_superClasses = null;
        this.m_hasExpandedColumns = false;
        this.m_dataTable = null;
        this.m_ldapClass = null;
        this.m_name = string;
        this.m_description = string;
        this.m_classType = 1;
        int n = 0;
        while (n < stringArray.length) {
            this.addColumn(stringArray[n], hashtable, false);
            ++n;
        }
    }

    private String removeOptions(String string) {
        int n = string.indexOf(59);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    protected void addColumn(String string, Hashtable hashtable, boolean bl) {
        AttributeInfo attributeInfo = (AttributeInfo)hashtable.get((string = this.removeOptions(string)).toLowerCase());
        if (attributeInfo == null) {
            return;
        }
        int n = attributeInfo.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            this.m_columnRefs.addColumnRef(new ColumnRef(attributeInfo.getColumnInfo(n2), this.m_columnRefs.size(), bl));
            ++n2;
        }
        if (attributeInfo.canConcatenateValues() && (attributeInfo = (AttributeInfo)hashtable.get((string = string + "_S").toLowerCase())) != null) {
            this.m_columnRefs.addColumnRef(new ColumnRef(attributeInfo.getColumnInfo(0), this.m_columnRefs.size(), bl));
        }
    }

    protected boolean hasColumn(String string) {
        int n = this.m_columnRefs.size();
        int n2 = 0;
        while (n2 < n) {
            ColumnRef columnRef = (ColumnRef)this.m_columnRefs.elementAt(n2);
            if (columnRef.getColumnName().equalsIgnoreCase(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void addColumns(TableInfo tableInfo) {
        int n = tableInfo.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            ColumnInfo columnInfo = tableInfo.getColumnInfo(n2);
            if (!this.hasColumn(columnInfo.getName())) {
                boolean bl = tableInfo.getColumnDef(n2).getNullable();
                this.m_columnRefs.addColumnRef(new ColumnRef(columnInfo, this.m_columnRefs.size(), bl));
            }
            ++n2;
        }
        this.m_hasExpandedColumns = true;
    }

    public String getName() {
        return this.m_name;
    }

    protected DataTable getDataTable() {
        return this.m_dataTable;
    }

    protected void setDataTable(DataTable dataTable) {
        this.m_dataTable = dataTable;
    }

    public String getLDAPClass() {
        return this.m_ldapClass;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getColumnCount() {
        return this.m_columnRefs.size();
    }

    public ISAMColumnDef getColumnDef(int n) {
        return (ISAMColumnDef)this.m_columnRefs.elementAt(n);
    }

    protected ColumnInfo getColumnInfo(int n) {
        return ((ColumnRef)this.m_columnRefs.elementAt(n)).getColumnInfo();
    }

    protected Object getData(int n) {
        Object object = null;
        DataColumn dataColumn = ((ColumnRef)this.m_columnRefs.elementAt(n)).getDataColumn();
        if (this.m_dataTable != null) {
            object = this.m_dataTable.getData(dataColumn);
        }
        return object;
    }

    protected boolean getHasExpandedColumns() {
        return this.m_hasExpandedColumns;
    }

    protected Enumeration getSuperClassesEnum() {
        return this.m_superClasses.elements();
    }

    protected ColumnRefVector getColumnRefs() {
        return this.m_columnRefs;
    }

    protected void rewind() {
        if (this.m_dataTable != null) {
            this.m_dataTable.rewind();
        }
    }

    protected boolean nextRecord() {
        boolean bl = false;
        if (this.m_dataTable != null) {
            bl = this.m_dataTable.nextRecord();
        }
        return bl;
    }

    public boolean position(int n) {
        return this.m_dataTable.position(n);
    }

    public int getPosition() {
        return this.m_dataTable.getPosition();
    }
}

